/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.compendium;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import org.apache.felix.utils.json.JSONWriter;
import org.apache.felix.webconsole.internal.servlet.AbstractOsgiManagerPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogReaderService;

public class LogServlet
extends AbstractOsgiManagerPlugin {
    private static final String LABEL = "logs";
    private static final String TITLE = "%logs.pluginTitle";
    private static final String[] CSS = new String[]{"/res/ui/logs.css"};
    private static final int MAX_LOGS = 200;
    private final String TEMPLATE = this.readTemplateFile("/templates/logs.html");

    @Override
    protected String getCategory() {
        return "OSGi";
    }

    @Override
    protected String getLabel() {
        return LABEL;
    }

    @Override
    protected String getTitle() {
        return TITLE;
    }

    @Override
    protected String[] getCssReferences() {
        return CSS;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        int minLevel = this.getParameterInt(req, "minLevel", 4);
        resp.setContentType("application/json");
        resp.setCharacterEncoding("utf-8");
        this.renderJSON(resp.getWriter(), minLevel, this.trasesEnabled(req));
    }

    private boolean trasesEnabled(HttpServletRequest req) {
        String traces = req.getParameter("traces");
        return null == traces ? false : Boolean.valueOf(traces);
    }

    private final void renderJSON(PrintWriter pw, int minLogLevel, boolean traces) throws IOException {
        LogReaderService logReaderService = (LogReaderService)this.getService(LogReaderService.class.getName());
        JSONWriter jw = new JSONWriter(pw);
        jw.object();
        jw.key("status");
        jw.value(logReaderService == null ? Boolean.FALSE : Boolean.TRUE);
        jw.key("data");
        jw.array();
        if (logReaderService != null) {
            int index = 0;
            Enumeration logEntries = logReaderService.getLog();
            while (logEntries.hasMoreElements() && index < 200) {
                LogEntry nextLog = (LogEntry)logEntries.nextElement();
                if (nextLog.getLevel() > minLogLevel) continue;
                this.logJson(jw, nextLog, index++, traces);
            }
        }
        jw.endArray();
        jw.endObject();
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int minLevel = this.getParameterInt(request, "minLevel", 4);
        String info = request.getPathInfo();
        if (info.endsWith(".json")) {
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            PrintWriter pw = response.getWriter();
            this.renderJSON(pw, minLevel, this.trasesEnabled(request));
            return;
        }
        super.doGet(request, response);
    }

    @Override
    public void renderContent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.getWriter().print(this.TEMPLATE);
    }

    private final void logJson(JSONWriter jw, LogEntry info, int index, boolean traces) throws IOException {
        jw.object();
        jw.key("id");
        jw.value(String.valueOf(index));
        jw.key("received");
        jw.value(info.getTime());
        jw.key("level");
        jw.value(this.logLevel(info.getLevel()));
        jw.key("raw_level");
        jw.value(info.getLevel());
        jw.key("message");
        jw.value(info.getMessage());
        jw.key("service");
        jw.value(this.serviceDescription(info.getServiceReference()));
        jw.key("exception");
        jw.value(this.exceptionMessage(info.getException(), traces));
        Bundle bundle = info.getBundle();
        if (null != bundle) {
            jw.key("bundleId");
            jw.value(bundle.getBundleId());
            String name = (String)bundle.getHeaders().get("Bundle-Name");
            if (null == name) {
                name = bundle.getSymbolicName();
            }
            if (null == name) {
                name = bundle.getLocation();
            }
            jw.key("bundleName");
            jw.value(name);
        }
        jw.endObject();
    }

    private final String serviceDescription(ServiceReference<?> serviceReference) {
        if (serviceReference == null) {
            return "";
        }
        return serviceReference.toString();
    }

    private final String logLevel(int level) {
        switch (level) {
            case 3: {
                return "INFO";
            }
            case 2: {
                return "WARNING";
            }
            case 1: {
                return "ERROR";
            }
        }
        return "DEBUG";
    }

    private final String exceptionMessage(Throwable e, boolean traces) {
        if (e == null) {
            return "";
        }
        if (traces) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(baos);
            e.printStackTrace(printStream);
            return baos.toString();
        }
        return e.getClass().getName() + ": " + e.getMessage();
    }
}

