/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.Index;

public abstract class AbstractIndex<K, E>
implements Index<K, E> {
    protected String attributeId;
    protected AttributeType attributeType;
    protected int cacheSize = 100;
    protected boolean initialized;
    protected boolean withReverse;
    protected AtomicInteger commitNumber;

    protected AbstractIndex() {
        this(null, true);
    }

    protected AbstractIndex(boolean withReverse) {
        this(null, withReverse);
    }

    protected AbstractIndex(String attributeId, boolean withReverse) {
        this.attributeId = attributeId;
        this.withReverse = withReverse;
        this.commitNumber = new AtomicInteger(0);
    }

    @Override
    public String getAttributeId() {
        return this.attributeId;
    }

    @Override
    public AttributeType getAttribute() {
        return this.attributeType;
    }

    @Override
    public void setAttributeId(String attributeId) {
        this.protect("attributeId");
        this.attributeId = attributeId;
    }

    @Override
    public boolean isDupsEnabled() {
        return !this.attributeType.isSingleValued();
    }

    @Override
    public int getCacheSize() {
        return this.cacheSize;
    }

    @Override
    public void setCacheSize(int cacheSize) {
        this.protect("cacheSize");
        this.cacheSize = cacheSize;
    }

    protected void protect(String property) {
        if (this.initialized) {
            throw new IllegalStateException(I18n.err(I18n.ERR_575, property));
        }
    }

    @Override
    public boolean hasReverse() {
        return this.withReverse;
    }
}

