/*
 * Camel ApiMethod Enumeration generated by camel-api-component-maven-plugin
 */
package org.apache.camel.component.box.internal;

import java.lang.reflect.Method;
import java.util.List;

import org.apache.camel.component.box.api.BoxTasksManager;

import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodArg;
import org.apache.camel.support.component.ApiMethodImpl;

import static org.apache.camel.support.component.ApiMethodArg.arg;

/**
 * Camel {@link ApiMethod} Enumeration for org.apache.camel.component.box.api.BoxTasksManager
 */
public enum BoxTasksManagerApiMethod implements ApiMethod {

    ADD_ASSIGNMENT_TO_TASK(
        com.box.sdk.BoxTask.class,
        "addAssignmentToTask",
        arg("taskId", String.class),
        arg("assignTo", com.box.sdk.BoxUser.class)),

    ADD_FILE_TASK(
        com.box.sdk.BoxTask.class,
        "addFileTask",
        arg("fileId", String.class),
        arg("action", com.box.sdk.BoxTask.Action.class),
        arg("dueAt", java.util.Date.class),
        arg("message", String.class)),

    DELETE_TASK(
        void.class,
        "deleteTask",
        arg("taskId", String.class)),

    DELETE_TASK_ASSIGNMENT(
        void.class,
        "deleteTaskAssignment",
        arg("taskAssignmentId", String.class)),

    GET_FILE_TASKS(
        java.util.List.class,
        "getFileTasks",
        arg("fileId", String.class)),

    GET_TASK_ASSIGNMENT_INFO(
        com.box.sdk.BoxTaskAssignment.Info.class,
        "getTaskAssignmentInfo",
        arg("taskAssignmentId", String.class)),

    GET_TASK_ASSIGNMENTS(
        java.util.List.class,
        "getTaskAssignments",
        arg("taskId", String.class)),

    GET_TASK_INFO(
        com.box.sdk.BoxTask.Info.class,
        "getTaskInfo",
        arg("taskId", String.class)),

    UPDATE_TASK_INFO(
        com.box.sdk.BoxTask.class,
        "updateTaskInfo",
        arg("taskId", String.class),
        arg("info", com.box.sdk.BoxTask.Info.class));

    private final ApiMethod apiMethod;

    private BoxTasksManagerApiMethod(Class<?> resultType, String name, ApiMethodArg... args) {
        this.apiMethod = new ApiMethodImpl(BoxTasksManager.class, resultType, name, args);
    }

    @Override
    public String getName() { return apiMethod.getName(); }

    @Override
    public Class<?> getResultType() { return apiMethod.getResultType(); }

    @Override
    public List<String> getArgNames() { return apiMethod.getArgNames(); }

    @Override
    public List<Class<?>> getArgTypes() { return apiMethod.getArgTypes(); }

    @Override
    public Method getMethod() { return apiMethod.getMethod(); }
}
