/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.vfs2.CacheStrategy;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileContentInfoFactory;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FilesCache;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.operations.FileOperationProvider;

public interface FileSystemManager {
    public FileObject getBaseFile() throws FileSystemException;

    public FileObject resolveFile(String var1) throws FileSystemException;

    public FileObject resolveFile(String var1, FileSystemOptions var2) throws FileSystemException;

    public FileObject resolveFile(FileObject var1, String var2) throws FileSystemException;

    public FileObject resolveFile(File var1, String var2) throws FileSystemException;

    public FileName resolveName(FileName var1, String var2) throws FileSystemException;

    public FileName resolveName(FileName var1, String var2, NameScope var3) throws FileSystemException;

    public FileObject toFileObject(File var1) throws FileSystemException;

    public FileObject createFileSystem(String var1, FileObject var2) throws FileSystemException;

    public void closeFileSystem(FileSystem var1);

    public FileObject createFileSystem(FileObject var1) throws FileSystemException;

    public FileObject createVirtualFileSystem(String var1) throws FileSystemException;

    public FileObject createVirtualFileSystem(FileObject var1) throws FileSystemException;

    public URLStreamHandlerFactory getURLStreamHandlerFactory();

    public boolean canCreateFileSystem(FileObject var1) throws FileSystemException;

    public FilesCache getFilesCache();

    public CacheStrategy getCacheStrategy();

    public Class<?> getFileObjectDecorator();

    public Constructor<?> getFileObjectDecoratorConst();

    public FileContentInfoFactory getFileContentInfoFactory();

    public boolean hasProvider(String var1);

    public String[] getSchemes();

    public Collection<Capability> getProviderCapabilities(String var1) throws FileSystemException;

    public void setLogger(Log var1);

    public FileSystemConfigBuilder getFileSystemConfigBuilder(String var1) throws FileSystemException;

    public FileName resolveURI(String var1) throws FileSystemException;

    public void addOperationProvider(String var1, FileOperationProvider var2) throws FileSystemException;

    public void addOperationProvider(String[] var1, FileOperationProvider var2) throws FileSystemException;

    public FileOperationProvider[] getOperationProviders(String var1) throws FileSystemException;

    public FileObject resolveFile(URI var1) throws FileSystemException;

    public FileObject resolveFile(URL var1) throws FileSystemException;
}

