/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,transformation")
@XmlRootElement(name="convertHeaderTo")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ConvertHeaderDefinition
extends NoOutputDefinition<ConvertHeaderDefinition> {
    @XmlTransient
    private Class<?> typeClass;
    @XmlAttribute(required=true)
    private String name;
    @XmlAttribute(required=true)
    private String type;
    @XmlAttribute
    private String toName;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean", defaultValue="true")
    private String mandatory;
    @XmlAttribute
    @Metadata(label="advanced")
    private String charset;

    public ConvertHeaderDefinition() {
    }

    protected ConvertHeaderDefinition(ConvertHeaderDefinition source) {
        super(source);
        this.typeClass = source.typeClass;
        this.name = source.name;
        this.type = source.type;
        this.toName = source.toName;
        this.mandatory = source.mandatory;
        this.charset = source.charset;
    }

    @Override
    public ConvertHeaderDefinition copyDefinition() {
        return new ConvertHeaderDefinition(this);
    }

    public ConvertHeaderDefinition(String name, String type) {
        this.setName(name);
        this.setType(type);
    }

    public ConvertHeaderDefinition(String name, Class<?> typeClass) {
        this.setName(name);
        this.setTypeClass(typeClass);
        this.setType(typeClass.getCanonicalName());
    }

    public ConvertHeaderDefinition(String name, String toName, Class<?> typeClass) {
        this.setName(name);
        this.setToName(toName);
        this.setTypeClass(typeClass);
        this.setType(typeClass.getCanonicalName());
    }

    public ConvertHeaderDefinition(String name, Class<?> typeClass, boolean mandatory) {
        this.setName(name);
        this.setTypeClass(typeClass);
        this.setType(typeClass.getCanonicalName());
        this.setMandatory(mandatory ? "true" : "false");
    }

    public ConvertHeaderDefinition(String name, Class<?> typeClass, String charset) {
        this.setName(name);
        this.setTypeClass(typeClass);
        this.setType(typeClass.getCanonicalName());
        this.setCharset(charset);
    }

    public String toString() {
        return "ConvertHeaderTo[" + this.getName() + ": " + this.getType() + "]";
    }

    public String getShortName() {
        return "convertHeaderTo";
    }

    @Override
    public String getLabel() {
        return "convertHeaderTo[" + this.getType() + "]";
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getToName() {
        return this.toName;
    }

    public void setToName(String toName) {
        this.toName = toName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Class<?> getTypeClass() {
        return this.typeClass;
    }

    public void setTypeClass(Class<?> typeClass) {
        this.typeClass = typeClass;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getMandatory() {
        return this.mandatory;
    }

    public void setMandatory(String mandatory) {
        this.mandatory = mandatory;
    }
}

