"
******************************************************************************
Application : HALObjectFiler Extensions
Date        : 12/18/94
Time        : 00:16:00 AM

Introduction
============

NAME            HALObjectFiler Extensions
AUTHOR          rayhorn@mercury.interpath.net
FUNCTION        Loads objects very quickly
ST-VERSIONS     VWin32s v2.0
PREREQUISITES   Envy/Developer R1.42 + WB-Pro/VWin32s
CONFLICTS       N/A
DISTRIBUTION    world
VERSION         12/17/94 00:16:00 AM
DATE            12/18/94

SUMMARY HALObjectFiler Extensions

This file-in provides a very fast ObjectFiler extension that
bypasses the normal ObjectLoadDialog and defaults the actions
of the ObjectLoadDialog to the 'Ok' action - this effectively
loads any/all objects in a very fast quiet manner. The initial
application of this ObjectFiler extension is to reload
WindowBuilder-Pro artifacts during initialization activities
in a very fast manner. Normally when WB-Pro loads/reloads in
Envy it reloads the scrap book objects and causes a number of
pop-up dialogs to appear, each of which could be defaulted 
in a faster manner.

Ray Horn



Invoked By:
===========

WindowBuilder class>>scrapbookLoadFile:

WindowBuilder>>scrapbookMerge

Description
===========

Classes :
    QuietObjectLoadDialog

Methods :
ObjectFiler class>>loadQuietlyFromPathName:
ObjectFiler class>>loadQuietlyFromPathName:loadMaps:
ObjectFiler>>loadBehaviorDescriptorsQuietly:
ObjectFiler>>loadClassQuietlyFor:rep:filedInstVarNames:dllName:changeMap:isMetaClass:
ObjectFiler>>loadQuietlyFrom:loadMaps:
WindowBuilder class>>scrapbookLoadFile:
WindowBuilder>>scrapbookMerge

******************************************************************************
"!

"Initialize"

    Transcript cr; show: 'HALObjectFiler Extensions...'.


!

SubApplication subclass: #HALObjectFilerExtensions
  instanceVariableNames: ''
  classVariableNames: ''
  poolDictionaries: ''!

HALObjectFilerExtensions class instanceVariableNames: ''! 

ObjectLoadDialog subclass: #QuietObjectLoadDialog
  instanceVariableNames: ''
  classVariableNames: ''
  poolDictionaries: ''!
 
QuietObjectLoadDialog class instanceVariableNames: ''!


!HALObjectFilerExtensions class methods !   !


!HALObjectFilerExtensions methods !  !


!ObjectFiler class methods !
 
loadQuietlyFromPathName: aPathName
        " Answer the first object stored in the file
        specified by aPathName. "
    ^self loadQuietlyFromPathName: aPathName loadMaps: #()
!
  
loadQuietlyFromPathName: aPathName loadMaps: loadMaps
        " Answer the first object stored in the file
        specified by aPathName.  The loadMaps collection
        defines mappings for loading classes
        whose shape has changed. "
    | fileStream anObject |
    (File exists: aPathName) ifFalse: [^nil].
    CursorManager execute change.
    [fileStream := File pathNameReadOnly: aPathName.
        [anObject := self new
            loadQuietlyFrom: fileStream
            loadMaps: loadMaps]
            ensure: [ fileStream close ] ]
        ensure: [ CursorManager execute change ].
    ^anObject
!  !


!ObjectFiler methods !
   
loadBehaviorDescriptorsQuietly: loadMaps
         " Private - (Quiet Version) Read the <behavior descriptors section>
        of the objectStream to find referenced classes and
        MetaClasses and put pointers to them in objects list
        at their dump id.  Where there is a size mismatch,
        record an instVar map in the behaviors list.
        Answer whether all classes can be loaded. "
    | hasDllName loadMapsDict
      tag classId name rep
      numNamedInstVars filedInstVarNames dllName
      loadClassInfo behavior aChangeMap |

    hasDllName := self class versionHasDllInfo: objectVersion.
    loadMapsDict := self loadMapsDictFrom: loadMaps.

    [(tag := objectStream next) ~= NUL] whileTrue: [
        classId := objectStream getInteger.
        name := objectStream upTo: NUL.
        rep := objectStream next.
        numNamedInstVars := objectStream getInteger.
        filedInstVarNames := Array new: numNamedInstVars.
        1 to: numNamedInstVars do: [ :i |
            filedInstVarNames at: i put: (objectStream upTo: NUL)].
        dllName := (hasDllName
            ifTrue: [objectStream upTo: NUL]
            ifFalse: [nil]).
        aChangeMap := loadMapsDict at: name ifAbsent: [nil].
        loadClassInfo := self
            loadClassQuietlyFor: name
            rep: rep
            filedInstVarNames: filedInstVarNames
            dllName: dllName
            changeMap: aChangeMap
            isMetaClass: (tag = TagMetaClass).
        loadClassInfo isNil
            ifTrue: [^false].
        behavior := loadClassInfo at: 1.
        aChangeMap := loadClassInfo at: 2.
        objects at: classId put: behavior.
        aChangeMap notNil
            ifTrue: [behaviors at: classId put: aChangeMap].
        " track shape changes only if loading blocks "
        (remappedObjects isNil
        and: [behavior == HomeContext])
            ifTrue: [remappedObjects := self allocateSmallIdentityDictionary].
        ].
    ^true
!

loadClassQuietlyFor: name
    rep: rep
    filedInstVarNames: filedInstVarNames
    dllName: dllName
    changeMap: predefinedChangeMap
    isMetaClass: isMetaClass
        " Private - determine the class into which to load
        filed instances of class <name>.  Do shape and
        representation checking.  Attempt DLL bind if
        appropriate.  Answer an array with the load class
        and the change map, if any, if the class can be loaded.
        Answer nil if name can't be loaded. "

    | behavior loadName loadRep loadInstVarNames
      aChangeMap loadDescription |

    aChangeMap := predefinedChangeMap.

    " determine the class to load into "
    aChangeMap notNil
        ifTrue: [  " override normal loading "
            loadName := aChangeMap destinationClassName.
            (Smalltalk includesKey: loadName asSymbol) ifFalse: [
                self recordWarningMessage:
                    self warningLoadCancelled,
                    ' - class ', loadName, ' not found in this system',
                    ' (specified by load map as new class of filed ',
                    name, ' instances).'.
                ^nil ] ]
        ifFalse: [  " allow user to specify load class if class is not present "
            loadName := name.
            ((dllName size > 0)   " automatically bind DLL "
            and: [(Smalltalk includesKey: loadName asSymbol) not])
                ifTrue: [
                    self recordInfoMessage:
                        'Attempting to bind DLL ', dllName,
                        ' to locate class ', loadName.
                    ((Smalltalk at: #ObjectLibraryBind) attemptBindTo: dllName)
                       ifTrue: [self recordInfoMessage: '    ...done']
                       ifFalse: [self recordInfoMessage: '   (unable to open or wrong version)'].
                    ].
            [Smalltalk includesKey: loadName asSymbol] whileFalse: [
                loadName := Prompter
                    prompt: 'Class ', name, ' is not in target system, enter new name:'
                    default: loadName.
                (loadName isNil) ifTrue: [   " bail if user cancelled "
                    self recordWarningMessage:
                        self warningLoadCancelled,
                        ' - class ', name, ' not found in this system.'.
                    ^nil ] ].
            ].

    behavior := Smalltalk at: loadName asSymbol.
    behavior isClass
        ifFalse: [
            self recordWarningMessage:
                self warningLoadCancelled,
                ' - class ', name, ' is not a class in this system.'.
            ^nil ].
    isMetaClass  " no further checking needed "
        ifTrue: [^Array with: behavior class with: nil].

    " check for representation mismatch "
    loadRep := self repOf: behavior.
    (self rep: rep canBeLoadedInto: loadRep filedClass: name)
        ifFalse: [
            self recordWarningMessage:
                self warningLoadCancelled,
                ' -  cannot load filed ',
                (self repDescription: rep), ' class ', name,
                ' into ', (self repDescription: loadRep), ' class ', loadName.
            ^nil ].

    " build load map for shape change or per loadMapsDict "
    loadInstVarNames := behavior allInstVarNames.
    aChangeMap notNil
        ifTrue: [  " validate the prespecified load map "
            ( self
                    loadMapIsValid: aChangeMap
                    sourceVariables: filedInstVarNames
                    destinationVariables: loadInstVarNames )
                ifFalse: [  " invalid mapping "
                    self recordWarningMessage:
                         self warningLoadCancelled,
                         ' - load map supplied for changed class ',
                         name, ' is unusable.'.
                    ^nil ] ]
        ifFalse: [   " check for shape changes "
            ( (filedInstVarNames size ~= behavior instSize)
            or: [filedInstVarNames ~= loadInstVarNames] )
                ifTrue: [
                    " need to get mapping for shape change "
                    loadDescription := 'Loading class ', name.
                    (loadName ~= name)
                        ifTrue: [loadDescription := loadDescription, ' into ', loadName].
                    aChangeMap := QuietObjectLoadDialog new
                        openOn: ( ObjectChangeMap new
                            sourceClassName: name;
                            destinationClassName: loadName;
                            sourceVariables: filedInstVarNames;
                            destinationVariables: loadInstVarNames;
                            yourself )
                        sourceTitle: 'Filed:'
                        destinationTitle: 'Loading:'
                        description: loadDescription.
                    aChangeMap isNil
                        ifTrue: [  " user cancelled "
                            self recordWarningMessage:
                                 self warningLoadCancelled,
                                 ' - instance variable remapping for changed class ',
                                 name, ' cancelled.'.
                            ^nil ].
                    ]
                ifFalse: [  " no shape change or mapping override "
                    aChangeMap := nil].
                ].
    ( aChangeMap notNil
    and: [aChangeMap layoutIsChanging not] )
        ifTrue: [aChangeMap := nil].  " got what we needed from it "
    ^Array with: behavior with: aChangeMap

!
 
loadQuietlyFrom: aStream loadMaps: loadMaps
        "(Quiet Version) Answer the object encoded on aStream at
        aStream's current position.  The loadMaps
        define mappings for loading classes whose
        shape has changed.  The loadMaps is a
        collection containing ObjectChangeMap
        elements.  Each object change map describes
        the mapping from a source filed class to
        a destination class in the loading image, which
        can have a different name or instance variable
        layout than the filed object.  A destination instance
        variable is loaded with nil if there no mapping from
        a source variable defined for it in the change map.
        (For compatibility, loadMaps can also be a dictionary
        of associations defining the destination class name
        and the slot array map of the destination variables.) "

    | operationDescription initialPosition rootObjectId |

    operationDescription := 'object loading'.
    self initializeForOperationOn: aStream.
    initialPosition := objectStream position.  " for failure backout "

    " read the <header section> "
    rootObjectId := self loadHeader: 'load'
        acceptVersionAction: [ :filedVersion |
            self class versionCanBeLoaded: filedVersion ].
    rootObjectId isNil
        ifTrue: [
            objectStream position: initialPosition.  " back out "
            self recordSummaryMessage: operationDescription.
            ^nil ].
    self allocateLoadCollections.

    " remappedObjects maps slot-shuffled objects to source info
        when loading blocks only valid during the load operation "
    remappedObjects := nil.
    (self loadBehaviorDescriptorsQuietly: loadMaps)
        ifFalse: [   " unable to satisify class bindings in load environment "
            objectStream position: initialPosition.  " back out "
            self recordSummaryMessage: operationDescription.
            ^nil ].
    self
        loadObjectDescriptors;
        restoreInstanceVariables;
        restoreLoadedObjects: rootObjectId.
    operationAborted
        ifFalse: [self restoreLoadedHashStructures].
    remappedObjects := nil.

    self recordSummaryMessage: operationDescription.
    ^operationAborted
        ifTrue: [nil]
        ifFalse: [ (rootObjectId < idCharacterZero)
            ifTrue: [objects at: rootObjectId]
            ifFalse: [self computedObjectFromId: rootObjectId] ]
! !


!QuietObjectLoadDialog class methods !   !


!QuietObjectLoadDialog methods !
 
openOn: aChangeMap
    sourceTitle: sourceTitleString
    destinationTitle: destTitleString
    description: descriptionString
        "Process ObjectLoadDialog quietly, assuming the
        default Ok was selected."

    aChangeMap slotIndexArray: (ListConnectionPane new
                                    leftList: (aChangeMap sourceVariables);
                                    rightList: (aChangeMap destinationVariables);
                                    leftToRightConnections).
    ^aChangeMap
!   !


!WindowBuilder class methods !

scrapbookLoadFile: aFileName

    (Smalltalk includesKey: #ObjectFiler) ifTrue: [
        self scrapbook: ((Smalltalk at: #ObjectFiler) loadQuietlyFromPathName: aFileName)
    ].
!   !

!WindowBuilder methods !

scrapbookMerge
    | fileName scrapbook mergeScrapbook overWrite |
    (Smalltalk includesKey: #ObjectFiler) ifFalse: [
        ^MessageBox message: 'Merging a Scrapbook requires the ObjectFiler. File in ''\EXTRAS\OBJFILER\VWOBJFLR.ST''.'
    ].
    fileName := (FileDialog new
                            openTitle: 'Merge Scrapbook'
                            fileSpec: '*.SBK'
                            showFileInButton: false) file.
    fileName isNil ifFalse: [
        mergeScrapbook := (Smalltalk at: #ObjectFiler) loadQuietlyFromPathName: fileName.
        scrapbook := self class scrapbook.
        overWrite := nil.
        mergeScrapbook keysDo: [ :chapter |
            (scrapbook includesKey: chapter) ifFalse: [
                scrapbook at: chapter put: (mergeScrapbook at: chapter).
            ] ifTrue: [
                (mergeScrapbook at: chapter) keysDo: [ :page |
                    (overWrite isNil and: [ (scrapbook at: chapter) includesKey: page ]) ifTrue: [
                        overWrite := MessageBox confirm: 'Overwrite existing pages with the same names?'
                    ].
                    (overWrite == false and: [ ((scrapbook at: chapter) includesKey: page) ]) ifTrue: [
                        (scrapbook at: chapter) at: (page,'.2') put: ((mergeScrapbook at: chapter) at: page)
                    ] ifFalse: [
                        (scrapbook at: chapter) at: page put: ((mergeScrapbook at: chapter) at: page)
                    ].
                ].
            ].
        self updateQuickReferenceMenu.
        ].
    ].
!  !
