

!OdbcStatement methods!
 
setParameter: ipar value: parmValue
        "(public) - sets the iparth parameter in a statement to a value - can handle single or array
of values"

    | fSqlType aByteArray aByteArray2 numParms values start maxSize
        odbcValue |

    paramBuffer isNil | paramHeader isNil
        ifTrue: [ ^self error: 'ODBTalk: parameters must be bound first' ].

    fSqlType :=  paramHeader types at: ipar.
    maxSize := paramHeader sizes at: ipar.

   (crowParamset isNil or: [crowParamset < 1])
          ifTrue: [ numParms := 1 ]
          ifFalse: [ numParms := crowParamset].

    numParms = 1
        ifTrue: [ 
            (parmValue isMemberOf: Array) 
            ifTrue:  [ values := parmValue ]
            ifFalse: [ values := OrderedCollection with: parmValue ]  ]
        ifFalse: [ values :=  parmValue ].

    aByteArray := ByteArray new:  maxSize * numParms.
    aByteArray2 := ByteArray new: (4 * numParms).

    1 to: numParms do: [ :idx |
        start := idx - 1 .
        (values at: idx) isNil
            ifTrue: [ aByteArray2 replaceFrom: start * 4 + 1 to: start * 4 + 4
                    with: (ExternalLong fromInteger: SQLNULLDATA ) contents
                                    startingAt: 1
                        ]
            ifFalse:
                        [
                            odbcValue := ( values at: idx ) asOdbcParameter.
                            aByteArray replaceFrom: start * maxSize + 1 to: (start * maxSize +(maxSize min: odbcValue size) )
                                with: odbcValue
                                startingAt: 1.
                             aByteArray2 replaceFrom: start * 4 + 1 to: start * 4 + 4
                                    with: (ExternalLong fromInteger: ( maxSize min: odbcValue size )) contents
                                    startingAt: 1
                        ]
    ].


     (paramBuffer at: ipar)  replaceBytes: aByteArray size with: aByteArray.
    (cbParamBuffer at: ipar)  replaceBytes: aByteArray2 size with: aByteArray2.! !

!PARTSLPCLoadingSQLs methods!

initializeParts

    (self partNamed: 'Window1') setLabel: ('Loading SQLs for type: ',lpcType typeName).
    self displayComboBox.
    (self partNamed: 'CBloadingSQLs')  when: #changed: send: #displaySQL to: self.
    (self partNamed: 'PBsave')  when: #clicked send: #saveSQL to: self.
    (self partNamed: 'PBdelete')  when: #clicked send: #deleteSQL to: self.
! !

!PARTSLPCModels methods!
   
driverConnect

    |connectString connectionHandle aString model |
aString := (self partNamed: 'LPModels') selectedItem.
aString isNil ifTrue: [ ^ self ].
model := LPCModel getName: aString.
model isNil ifTrue: [ ^ self ].
model orb disconnect.

    CursorManager execute change.

    connectionHandle := OdbcConnection open.
    connectionHandle hasError
        ifFalse: [
          connectString :=
                connectionHandle driverConnect: model orb connectionString window: 
                        (self partNamed: 'PartsLPCModels' ) driverCompletion: 2.
        ].

    connectionHandle hasError
        ifFalse:
            [
            connectionHandle hasSQLNODATAFOUND
                ifFalse:
                    [
                      model orb session: connectionHandle.
                      model orb connectionString: connectString.
                      MessageBox message: 'Connection established !!'.
                        ]
            ]
        ifTrue:
            [
                         PARTSOWError  new openOn: connectionHandle
            ].

       CursorManager normal change.
self enableButtons.
! !

!PARTSLPCModels methods!
   
initializeParts

    self displayModels.

    (self partNamed: 'LPModels')  when: #changed: send: #checkButtons to: self.
    (self partNamed: 'PartsLPCModels' )  when: #aboutToClose send: #imageSave to: self.
    (self partNamed: 'PBnewModelOk')  when: #clicked send: #newModel to: self.
    (self partNamed: 'PBdelete')  when: #clicked send: #removeModel to: self.
    (self partNamed: 'PBdriverConnect')  when: #clicked send: #driverConnect to: self.
    (self partNamed: 'PBcoreConnect')  when: #clicked send: #coreConnect to: self.
    (self partNamed: 'PBdriverDisconnect')  when: #clicked send: #driverDisconnect to: self.
    (self partNamed: 'PBdatabase')  when: #clicked send: #openTables to: self.
    (self partNamed: 'PBobjectTypes')  when: #clicked send: #objectTypes to: self.    
    self prepareImageSave.
    self disableButtons.! !

!PARTSLPCRelationship methods!

initializeParts
"self inspect.
"
    (self partNamed: 'TypeDefinition' ) setLabel:
        ('Relationship: ',lpcRelationship objectType typeName,
        ' with: ',lpcRelationship relatedObjectType typeName,' attribute: ',lpcAttribute).
    self initializeRelationshipTypes.
    self displayObjectTypes.
 
    (self partNamed: 'PBaddMatch')  when: #clicked send: #addMatch to: self.
    (self partNamed: 'PBremoveMatch')  when: #clicked send: #removeMatch to: self.
    (self partNamed: 'PBsave')  when: #clicked send: #saveRelationship to: self.
    (self partNamed: 'DDLrelationshipType')  when: #changed: send: #changeRelationshipType to: self.
! !

!PARTSLPCRelationship methods!

saveRelationship

lpcRelationship matchDict size = 0 ifTrue: [ ^ MessageBox message: 'No matching attributes selected !!'].
lpcRelationship objectType relationships at: lpcAttribute put: lpcRelationship.
(self partNamed: 'TypeDefinition' )  close.
openFromWindow displayAttributeDetail.
! !

!PARTSLPCTables methods!

close
       (self partNamed: 'Tables' )  close.! !

!PARTSLPCTables methods!
   
initializeParts
      "Before opening the windows
          - set up the display"
| resultDisplay temp |

        (self partNamed: 'Tables' ) setLabel: ('Tables for model: ',lpcModel modelName).
"    self displayTables.
"    self displayObjectTypes.
    (self partNamed: 'TPresults')  when: #rightClicked send: #setRow     to: self.
    (self partNamed: 'VHselectedRow')  when: #changed: send: #displayFields to: self.
    (self partNamed: 'PBcreateObjectType')  when: #clicked send: #createObjectType to: self.
    (self partNamed: 'PBmodifyObjectType')  when: #clicked send: #modifyObjectType to: self.
    (self partNamed: 'PBremoveObjectType')  when: #clicked send: #removeObjectType to: self.
   (self partNamed: 'MiRefresh') when: #clicked send: #displayTables to: self.

    self enableButtons.! !

!PARTSLPCType methods!
  
initializeParts
      "Before opening the windows
          - set up the display"
| resultDisplay temp |

    (self partNamed: 'TypeDefinition' ) setLabel: ('Object type: ',lpcType typeName).
    self displayType.
    self displayAttributeDetail.
    (self partNamed: 'LPattributes')  when: #changed: send: #displayAttributeDetail to: self.
    (self partNamed: 'PBrenameAttribute')  when: #clicked send: #renameAttribute to: self.
    (self partNamed: 'PBremoveAttribute')  when: #clicked send: #removeAttribute to: self.
    (self partNamed: 'PBaddAttribute')  when: #clicked send: #addAttribute to: self.
    (self partNamed: 'PBaddKeyOk')  when: #clicked send: #addKey to: self.
    (self partNamed: 'PBremoveKey')  when: #clicked send: #removeKey to: self.
    (self partNamed: 'PBclearFieldMap') when: #clicked send: #clearFieldMap to: self.
    (self partNamed: 'PBchangeFieldMap') when: #clicked send: #changeFieldMap to: self.
    (self partNamed: 'PBchangeRelationship') when: #clicked send: #changeRelationship to: self.
    (self partNamed: 'PBchangeBlock') when: #clicked send: #saveBlock to: self.
    (self partNamed: 'PBclearRelationship') when: #clicked send: #clearRelationship to: self.
    (self partNamed: 'PBclearBlock') when: #clicked send: #clearBlock to: self.
    (self partNamed: 'PBgenerateClass') when: #clicked send: #generateClass to: self.
    (self partNamed: 'PBloadingSQLs') when: #clicked send: #openLoadingSQLs to: self.
    (self partNamed: 'RBmappedField') when: #clicked: send: #showMappedField to: self.
    (self partNamed: 'RBrelationship') when: #clicked: send: #showRelationship to: self.
    (self partNamed: 'RBblock') when: #clicked: send: #showBlock to: self.


    (self partNamed: 'PBrenameAttribute') hideWindow.! !

!PARTSOWBrowser methods!
 
displayResults: aTablePart
    "(OBSOLETE) replaced by displayResults:onWindow:"

            | aCursorName numCols resultDisplay resultHeader columnHeaders columnWidths
               aHeader aRow aRowHeader answerSet defaultSize |

    
    defaultSize := self defaultMaxColumnSize.
    resultDisplay := aTablePart.
    
    numCols := statementHandle numberOfColumns.
    statementHandle hasError
       ifTrue:
            [
                ^self close
            ].

     columnHeaders := Array new: numCols.

    statementHandle bindColumns.
    statementHandle hasError
       ifTrue:
            [
               ^ self handleError: statementHandle.
            ].

   aRowHeader := statementHandle rowHeader.

     answerSet := OrderedCollection new.

    statementHandle fetch.
    [statementHandle hasSuccess]
        whileTrue:
        [
            aRow := statementHandle row.
            answerSet add: aRow.
            statementHandle fetch
        ].

    statementHandle hasError
    ifTrue:
    [
               ^ self handleError: statementHandle.
    ].

    1 to: numCols  do:
      [ :colIndex |
        columnHeaders at: colIndex put: ( statementHandle colName: colIndex )
    ].

    resultDisplay setNumberOfColumns: numCols.
    resultDisplay setNumberOfRows: answerSet size.
    columnWidths := Array new: numCols.
    1 to: numCols do: [ :idx |
        columnWidths at: idx put: ( ((aRowHeader columnDisplaySizes at: idx) max: (columnHeaders at: idx) size) + 2
                                        min: defaultSize) ].

    resultDisplay enable.
    resultDisplay setColumnLabels:  columnHeaders.
    resultDisplay setValue: answerSet.
    resultDisplay setColumnWidths: columnWidths. 

    aCursorName := statementHandle getCursorName.
    statementHandle hasError
    ifTrue: [ aCursorName := 'Statement' ].
    self application mainObject setLabel: ('ODBC ',aCursorName).


! !

!PARTSOWBrowser methods!
   
displayResults: aTablePart onWindow: aWindow

            | aCursorName numCols resultDisplay resultHeader columnHeaders columnWidths
               aHeader aRow aRowHeader answerSet defaultSize |

    
    defaultSize := self defaultMaxColumnSize.
    resultDisplay := aTablePart.
    
    numCols := statementHandle numberOfColumns.
    statementHandle hasError
       ifTrue:
            [
                ^self close
            ].

     columnHeaders := Array new: numCols.

    statementHandle bindColumns.
    statementHandle hasError
       ifTrue:
            [
               ^ self handleError: statementHandle.
            ].

   aRowHeader := statementHandle rowHeader.

     answerSet := OrderedCollection new.

    statementHandle fetch.
    [statementHandle hasSuccess]
        whileTrue:
        [
            aRow := statementHandle row.
            answerSet add: aRow.
            statementHandle fetch
        ].

    statementHandle hasError
    ifTrue:
    [
               ^ self handleError: statementHandle.
    ].

    1 to: numCols  do:
      [ :colIndex |
        columnHeaders at: colIndex put: ( statementHandle colName: colIndex )
    ].

    resultDisplay setNumberOfColumns: numCols.
    resultDisplay setNumberOfRows: answerSet size.
    columnWidths := Array new: numCols.
    1 to: numCols do: [ :idx |
        columnWidths at: idx put: ( ((aRowHeader columnDisplaySizes at: idx) max: (columnHeaders at: idx) size) + 2
                                        min: defaultSize) ].

    resultDisplay enable.
    resultDisplay setColumnLabels:  columnHeaders.
    resultDisplay setValue: answerSet.
    resultDisplay setColumnWidths: columnWidths. 

    aCursorName := statementHandle getCursorName.
    statementHandle hasError
    ifTrue: [ aCursorName := 'Statement' ].
   aWindow setLabel: ('ODBC ',aCursorName).


! !

!PARTSOWColumnBrowser methods!

columns

   |  resultDisplay  tableQualifier tableOwner tableName columnName |

  CursorManager execute change.

    resultDisplay := self partNamed: 'TPresults'.

    tableQualifier:= ( self partNamed: 'CBtableQualifier') value.
    tableOwner:=  ( self partNamed: 'CBtableOwner') value.
    tableName :=  ( self partNamed: 'CBtableName') value.
    columnName:= (self partNamed: 'EFcolumnName') value.

    tableQualifier = '<null pointer>'
        ifTrue: [ tableQualifier := nil ].
    tableOwner = '<null pointer>'
        ifTrue: [ tableOwner := nil ].
   tableName = '<null pointer>'
        ifTrue: [ tableName := nil ].
    tableQualifier = '<empty string>'
        ifTrue: [ tableQualifier := '' ].
    tableOwner = '<empty string>'
        ifTrue: [ tableOwner := '' ].
   tableName = '<empty string>'
        ifTrue: [ tableName := '' ].

   statementHandle columns:tableQualifier
                    tableOwnerQualifier: tableOwner
                    tableNameQualifier: tableName
                    columnNameQualifier: columnName.


  statementHandle hasError
       ifTrue:
            [
                   self handleError.
                ^CursorManager normal change.
            ].

    self displayResults: resultDisplay onWindow: ( self partNamed: 'WOdbcColumnBrowser' ).
    self cleanup.

    CursorManager normal change.


! !

!PARTSOWConnection methods!
   
setLabel

     "get the data source name and update the window label "
     | aLabel |
    aLabel := connectionHandle getInfo: DATASOURCENAME.
    connectionHandle hasError
           ifFalse: [     (self partNamed: 'WOdbcConnection' ) setLabel: ('ODBC Connection to: ',aLabel) ]
            ifTrue: [     (self partNamed: 'WOdbcConnection' )  setLabel: ('ODBC Connection',aLabel) ].


! !

!PARTSOWManager methods!
   
driverConnect

    |connectString connectionHandle|
    CursorManager execute change.

    connectionHandle := OdbcConnection open.
    connectionHandle hasError
        ifFalse: [ 
          connectString :=
                connectionHandle driverConnect: '' window:
                                 (self partNamed: 'WOdbcManger' ) driverCompletion:2.
        ].

    connectionHandle hasError
        ifFalse:
            [
            connectionHandle hasSQLNODATAFOUND
                ifFalse:
                    [
                        PARTSOWConnection new openOn: connectionHandle
                    ]
            ]
        ifTrue:
            [
                PARTSOWError  new openOn: connectionHandle
            ].

       CursorManager normal change.

! !

!PARTSOWProcedureBrowser methods!
 
procedures

   | resultDisplay  tableQualifier tableOwner tableName  |


  CursorManager execute change.

    resultDisplay := self partNamed: 'TPresults'.

    tableQualifier:= ( self partNamed: 'CBtableQualifier') value.
    tableOwner:=  ( self partNamed: 'CBtableOwner') value.
    tableName :=  ( self partNamed: 'CBtableName') value.

    tableQualifier = '<null pointer>'
        ifTrue: [ tableQualifier := nil ].
    tableOwner = '<null pointer>'
        ifTrue: [ tableOwner := nil ].
    tableName = '<null pointer>'
        ifTrue: [ tableName := nil ].
    tableQualifier = '<empty string>'
        ifTrue: [ tableQualifier := '' ].
    tableOwner = '<empty string>'
        ifTrue: [ tableOwner := '' ].
    tableName = '<empty string>'
        ifTrue: [ tableName := '' ].

   statementHandle procedures: tableQualifier
                    procOwnerQualifier: tableOwner
                    procNameQualifier: tableName.

  statementHandle hasError
       ifTrue:
            [
                   self handleError.
                ^CursorManager normal change.
            ].

    self displayResults: resultDisplay onWindow: (  self partNamed: 'WOdbcProcedureBrowser' ).
    self cleanup.

    CursorManager normal change.


! !

!PARTSOWResult methods!
  
initializeParts
      "Before opening the windows
          - set up the display"

            | aCursorName numCols resultDisplay resultHeader columnHeaders columnHeadersVH
               aHeader aRow aRowHeader answerSet columnWidths defaultSize |

    defaultSize := self defaultMaxColumnSize.
    resultDisplay := self partNamed: 'TPresults'.
    columnHeadersVH := self partNamed: 'VHcolumnHeaders'.

    numCols := statementHandle numberOfColumns.
    statementHandle hasError
       ifTrue:
            [
                ^self close
            ].

     columnHeaders := Array new: numCols.

    statementHandle bindColumns.
    statementHandle hasError
       ifTrue:
            [
                ^ self handleError: statementHandle.
            ].

   aRowHeader := statementHandle rowHeader.

     answerSet := OrderedCollection new.

    statementHandle fetch.
    [statementHandle hasSuccess]
        whileTrue:
        [
            aRow := statementHandle row.
            answerSet add: aRow.
            statementHandle fetch
        ].

    statementHandle hasError
    ifTrue:
    [
                ^ self handleError: statementHandle.
    ].

    1 to: numCols  do:
      [ :colIndex |
        columnHeaders at: colIndex put: ( statementHandle colName: colIndex )
    ].

    resultDisplay setNumberOfColumns: numCols.
    resultDisplay setNumberOfRows: answerSet size.
    columnWidths := Array new: numCols.
    1 to: numCols do: [ :idx |
        columnWidths at: idx put: ( ((aRowHeader columnDisplaySizes at: idx) max: (columnHeaders at: idx) size) + 2
                                        min: defaultSize) ].
    resultDisplay setValue: answerSet.
    columnHeadersVH setValue: columnHeaders.
    resultDisplay setColumnWidths: columnWidths. 

    aCursorName := statementHandle getCursorName.
    statementHandle hasError
    ifTrue: [ aCursorName := 'Statement' ].
    (self partNamed: 'WOdbcResult' )  setLabel: ('ODBC ',aCursorName).


! !

!PARTSOWTableBrowser methods!

tables

   | resultDisplay  tableQualifier tableOwner tableName tableType |
 
  CursorManager execute change.

    
    resultDisplay := self partNamed: 'TPresults'.

    tableQualifier:= ( self partNamed: 'CBtableQualifier') value.
    tableOwner:=  ( self partNamed: 'CBtableOwner') value.
    tableName :=  ( self partNamed: 'CBtableName') value.
    tableType:= (self partNamed: 'DLtableType') value.

    tableQualifier = '<null pointer>'
        ifTrue: [ tableQualifier := nil ].
    tableOwner = '<null pointer>'
        ifTrue: [ tableOwner := nil ].
    tableName = '<null pointer>'
        ifTrue: [ tableName := nil ].
    tableQualifier = '<empty string>'
        ifTrue: [ tableQualifier := '' ].
    tableOwner = '<empty string>'
        ifTrue: [ tableOwner := '' ].
    tableName = '<empty string>'
        ifTrue: [ tableName := '' ].
    tableType = '<ALL>'
        ifTrue: [tableType := ''].

    
    statementHandle tables: tableQualifier
                    tableOwnerQualifier: tableOwner
                    tableNameQualifier: tableName
                    tableType: tableType.

  statementHandle hasError
       ifTrue:
            [
                   self handleError.
               ^CursorManager normal change.
            ].

    self displayResults: resultDisplay onWindow: (self partNamed: 'WOdbcTableBrowser').

    self cleanup.

    CursorManager normal change.


! !
!SessionModel methods !

aboutToSaveImage
        "Private - the image is about to be saved; notify anyone
        who needs to know when this happens."
    self triggerEvent: #aboutToSaveImage.
    SystemWeakRegistries current aboutToSaveImage.
    Notifier aboutToSaveImage.
    SelfInitializingObject aboutToSaveImage.
    Bitmap aboutToSaveImage.
    Icon aboutToSaveImage.
    OperatingSystemInformation aboutToSaveImage.
    Screen aboutToSaveImage.
    Window aboutToSaveImage.

    "ODBTalk "
    OdbcObject aboutToSaveImage.

    "this will be removed in a future release, maintained for compatibility."
    ViewManager withAllSubclasses do: [ :c | c aboutToSaveImage ]

! !


