 1   Oberon10.Scn.Fnt           	     (* ETH Oberon, Copyright 2001 ETH Zuerich Institut fuer Computersysteme, ETH Zentrum, CH-8092 Zuerich.
Refer to the "General ETH Oberon System Source License" contract available at: http://www.oberon.ethz.ch/ *)

 MODULE FileDir;	(* pjm *)

(* Native-compatible FileDir module based on OFS *)

IMPORT OFS;

TYPE
	FileName* = OFS.FileName;
	
	EntryHandler* = PROCEDURE (name: ARRAY OF CHAR; time, date, size: LONGINT; VAR continue: BOOLEAN);

VAR
	PathChar*: CHAR;
	handler: EntryHandler;

PROCEDURE Handler(name: ARRAY OF CHAR; time, date, size: LONGINT; VAR flags: SET);
VAR b: BOOLEAN;
BEGIN
	IF ~(OFS.EnumSize IN flags) THEN size := MIN(LONGINT) END;
	b := TRUE; handler(name, time, date, size, b);
	IF ~b THEN INCL(flags, OFS.EnumStop) END
END Handler;

(** Enumerate files matching the mask.  proc is upcalled for every file.  Iff detail is TRUE, the time, date and size parameters will be valid.  Recursive calls to Enumerate are not allocated in proc. *)
PROCEDURE Enumerate*(mask: ARRAY OF CHAR; detail: BOOLEAN; proc: EntryHandler);
VAR flags: SET;
BEGIN
	IF detail THEN flags := {OFS.EnumSize, OFS.EnumTime} ELSE flags := {} END;
	handler := proc;
	OFS.Enumerate(mask, flags, Handler)
END Enumerate;

BEGIN
	PathChar := "/"
END FileDir.
BIERK  f   #    "        d      d
     C  TextGadgets.NewStyleProc  