MODULE Const;

IMPORT
  FIO,
  IO,
  Lib;

CONST
  MaxCode = 500;

VAR
  Buffer : ARRAY [0..MaxCode-1] OF SHORTCARD;
  mod : ARRAY [0..20] OF CHAR;

PROCEDURE Dump(
                o : FIO.File;
                Size : CARDINAL);
VAR
  x : CARDINAL;

BEGIN
  FIO.WrStr(o, "DEFINITION MODULE ");  FIO.WrStr(o, mod);
  FIO.WrChar(o, ";");  FIO.WrLn(o);
  FIO.WrStr(o, "(* Code generated by const.exe, do not edit *)");  FIO.WrLn(o);
  FIO.WrStr(o, "TYPE CodeType = ARRAY [0..");
  FIO.WrCard(o, Size-1, 1);
  FIO.WrStr(o, "] OF SHORTCARD;");  FIO.WrLn(o);
  FIO.WrStr(o, "CONST Code = CodeType(");
  FOR x := 0 TO Size-1 DO
    IF x MOD 10 = 0 THEN
      FIO.WrLn(o)
    END;
    FIO.WrShtCard(o, Buffer[x], 4);
    IF x # Size-1 THEN
      FIO.WrStr(o, ",")
    END
  END;
  FIO.WrStr(o, ");");  FIO.WrLn(o);
  FIO.WrStr(o, "END ");  FIO.WrStr(o, mod);  FIO.WrChar(o, ".");  FIO.WrLn(o);
END Dump;

VAR
  o, f : FIO.File;
  size : CARDINAL;
  temp : ARRAY [0..100] OF CHAR;

BEGIN
  Lib.SetReturnCode(1);
  IF Lib.ParamCount() < 2 THEN
    HALT
  END;
  Lib.ParamStr(temp, 1);
  f := FIO.Open(temp);
  Lib.ParamStr(temp, 2);
  o := FIO.Create(temp);
  Lib.ParamStr(mod, 3);
  IF mod[0] = 0C THEN mod := "Boot" END;
  size := FIO.RdBin(f, Buffer, SIZE(Buffer));
  IF size = 0 THEN
    IO.WrStr("Const: Read error");  IO.WrLn;
    HALT
  END;
  Dump(o, size);
  FIO.Close(f);
  FIO.Close(o);
  Lib.SetReturnCode(0)
END Const.


