(**************************************************************************

Name:           GadUtil
Purpose:        Gadget Utilities
Version:	1.1
Predecessor:    1.0
Changes:        SetColor, context, ToFront, SetColor, SetString
Target platform:PC>=386
Compiler:	Oberon 3
Date:           February 1996
Author:		Frank Hrebabetzky

***************************************************************************)

MODULE GadUtil;

IMPORT Objects, Display, Gadgets, BasicGadgets, Out, Strings;

VAR
  context*	: Objects.Object;
  (* Can be set freely. Is automatically initialized to Gadgets.context.
     All Get... procedures beyond will search in this context. *)


PROCEDURE GetBool* (name:ARRAY OF CHAR): BasicGadgets.Boolean;
VAR obj: Objects.Object;
BEGIN
  obj:= Gadgets.FindObj (context, name);
  IF (obj # NIL) & (obj IS BasicGadgets.Boolean) THEN
    RETURN obj(BasicGadgets.Boolean)
  ELSE RETURN NIL
  END
END GetBool;


PROCEDURE GetInt* (name:ARRAY OF CHAR): BasicGadgets.Integer;
VAR obj: Objects.Object;
BEGIN
  obj:= Gadgets.FindObj (context, name);
  IF (obj # NIL) & (obj IS BasicGadgets.Integer) THEN
    RETURN obj(BasicGadgets.Integer)
  ELSE RETURN NIL
  END;
END GetInt;


	
PROCEDURE GetReal* (name:ARRAY OF CHAR): BasicGadgets.Real;
VAR obj: Objects.Object;
BEGIN
  obj:= Gadgets.FindObj (context, name);
  IF (obj # NIL) & (obj IS BasicGadgets.Real) THEN
    RETURN obj(BasicGadgets.Real)
  ELSE RETURN NIL
  END
END GetReal;


	
PROCEDURE GetString* (name:ARRAY OF CHAR): BasicGadgets.String;
VAR obj: Objects.Object;
BEGIN
  obj:= Gadgets.FindObj (context, name);
  IF (obj # NIL) & (obj IS BasicGadgets.String) THEN
    RETURN obj(BasicGadgets.String)
  ELSE RETURN NIL
  END
END GetString;


PROCEDURE GetVisual* (name:ARRAY OF CHAR): Gadgets.Frame;
(* Get visual gadget *)
VAR obj: Objects.Object;
BEGIN
  obj:= Gadgets.FindObj (context, name);
  IF (obj#NIL) & (obj IS Gadgets.Frame) THEN
    RETURN obj(Gadgets.Frame)
  ELSE RETURN NIL
  END;
END GetVisual;


PROCEDURE ListGadgets* (root:Gadgets.Frame);
VAR numbers: ARRAY 32 OF CHAR;

PROCEDURE ListGad (b:INTEGER; frame:Display.Frame);
VAR name	: ARRAY 32 OF CHAR;
BEGIN
  IF (frame=NIL) THEN RETURN END;
  WITH frame:Gadgets.Frame DO
    Gadgets.GetObjName (frame, name);
    Out.String(numbers);   Out.Int(b,2);   Out.String(". ");
    Out.String(name);
    IF frame.obj#NIL THEN
      Gadgets.GetObjName (frame.obj, name);
      Out.String("  model:");   Out.String(name);
    END;
  END;
  Out.Ln;
  ListGad (b+1, frame.next);
  Strings.IntToStr (b, 2, name);
  Strings.Append (numbers, name);
  name[0]:=".";   name[1]:=0X;   Strings.Append (numbers, name);
  ListGad (0, frame.dsc);
END ListGad;

BEGIN (* ListGadgets*)
  Out.String("ListGadgets:");   Out.Ln;
  numbers:= "";
  ListGad (0, root);
  Out.Ln;
END ListGadgets;


PROCEDURE SetColor* (f:Gadgets.Frame; col:INTEGER);
VAR msg: Objects.AttrMsg;
BEGIN
  msg.id	:= Objects.set;
  COPY ("Color", msg.name);
  msg.class	:= Objects.Int;
  msg.i		:= col;
  msg.res	:= -1;
  f.handle (f, msg);
  Gadgets.Update (f);
END SetColor;


PROCEDURE SetString* (f:Gadgets.Frame; str:ARRAY OF CHAR);
(* The class of the "Value" attribute fo f must be Objects.String (Caption,
   NamePlate, TextField). In this case, the value is set to str. *)
VAR msg	: Objects.AttrMsg;
BEGIN
  msg.id	:= Objects.set;
  COPY ("Value", msg.name);
  msg.class	:= Objects.String;
  COPY (str, msg.s);
  msg.res	:=-1;
  f.handle (f, msg);
END SetString;


PROCEDURE ToFront* (F:Display.Frame);
VAR pmsg: Gadgets.PriorityMsg;
BEGIN
  pmsg.id:= Gadgets.top;
  pmsg.passon:= FALSE;	(*?*)
  pmsg.F:= F;
  Display.Broadcast (pmsg);
END ToFront;


BEGIN
  context:= Gadgets.context;
END GadUtil.
