TextDocs.NewDoc     TF   CColor     Flat  Locked  Controls  Org 	   BIER`   b        3    Syntax10.Scn.Fnt     Syntax12.Scn.Fnt      9        9        B                                l                 
  MODULE TBoxTestLeftist;
	
	IMPORT
		
		A:= TBoxAlea, L:= TBoxLeftist, Out;
	
	TYPE
		
		Elem= POINTER TO RECORD (L.Elem)
			suivant: Elem;
			n: LONGINT;
		END;
		
		ObjetV= POINTER TO RECORD (L.Elem)
			val: LONGINT;
		END;
		
		ObjetF= POINTER TO RECORD (L.Elem)
			fin: LONGINT;
			v: ObjetV;
		END;
	
	PROCEDURE (e1: Elem) Comp (e2: L.Elem): SHORTINT;
		
		BEGIN (*Comp*)
			WITH e2: Elem DO
				IF e1.n< e2.n THEN
					RETURN L.first;
				ELSIF e1.n> e2.n THEN
					RETURN L.last;
				ELSE
					RETURN L.equiv;
				END;
			END;
		END Comp;
	
	PROCEDURE (e1: ObjetV) Comp (e2: L.Elem): SHORTINT;
		
		BEGIN (*Comp*)
			WITH e2: ObjetV DO
				IF e1.val< e2.val THEN
					RETURN L.first;
				ELSIF e1.val> e2.val THEN
					RETURN L.last;
				ELSE
					RETURN L.equiv;
				END;
			END;
		END Comp;
	
	PROCEDURE (e1: ObjetF) Comp (e2: L.Elem): SHORTINT;
		
		BEGIN (*Comp*)
			WITH e2: ObjetF DO
				IF e1.fin< e2.fin THEN
					RETURN L.first;
				ELSIF e1.fin> e2.fin THEN
					RETURN L.last;
				ELSE
					RETURN L.equiv;
				END;
			END;
		END Comp;
	
	PROCEDURE Do1*;
		
		VAR
			
			t: L.Tree;
			i: LONGINT;
			el: Elem;
			e: L.Elem;
		
		BEGIN (*Do1*)
			A.Randomize(1);
			L.New(t);
			FOR i:= 1 TO 1000 DO
				NEW(el);
				el.n:= SHORT(ENTIER(A.Random()*1000));
				t.Insert(el);
			END;
			e:= t.First();
			WHILE e# NIL DO
				Out.Int(e(Elem).n, 0); Out.Ln;
				t.Erase(e);
				e:= t.First();
			END;
		END Do1;
	
	PROCEDURE Do2*;
		
		VAR
			
			t: L.Tree;
			i: LONGINT;
			e1, e2: Elem;
		
		BEGIN (*Do2*)
			A.Randomize(1);
			L.New(t);
			e1:= NIL;
			FOR i:= 1 TO 1000 DO
				NEW(e2);
				e2.n:= SHORT(ENTIER(A.Random()*1000));
				t.Insert(e2);
				e2.suivant:= e1;
				e1:= e2;
			END;
			i:= 0;
			WHILE e1# NIL DO
				INC(i);
				Out.Int(e1.n, 0); Out.Ln;
				t.Erase(e1);
				e1:= e1.suivant;
			END;
			ASSERT(i= 1000, 30);
		END Do2;
	
	PROCEDURE Do3*;
		
		CONST
			
			nbElems= 1000;
			dureeMin= 100;
			dureeMax= 500;
			valMin= 0;
			valMax= 10000;
		
		VAR
			
			n: LONGINT;
			e: L.Elem;
			eV: ObjetV;
			eF: ObjetF;
			tV, tF: L.Tree;
		
		BEGIN (*Do3*)
			A.Randomize(1);
			L.New(tV); L.New(tF);
			n:= 0;
			e:= tF.First();
			WHILE (n< nbElems) OR (e# NIL) DO
				INC(n);
				IF n< nbElems THEN
					NEW(eV);
					eV.val:= valMin+ SHORT(ENTIER((valMax- valMin+ 1)* A.Random()));
					tV.Insert(eV);
					NEW(eF);
					eF.fin:= n+ dureeMin+ SHORT(ENTIER((dureeMax- dureeMin+ 1)* A.Random()));
					eF.v:= eV;
					tF.Insert(eF);
					e:= tF.First();
				END;
				WHILE (e# NIL) & (e(ObjetF).fin= n) DO
					Out.Int(e(ObjetF).v.val, 0); Out.Ln;
					tV.Erase(e(ObjetF).v);
					tF.Erase(e);
					e:= tF.First();
				END;
			END;
			ASSERT(tV.First()= NIL, 30);
		END Do3;
	
	END TBoxTestLeftist.

TBoxTestLeftist.Do1;
TBoxTestLeftist.Do2;
TBoxTestLeftist.Do3;
