TextDocs.NewDoc     F   CColor     Flat  Locked  Controls  Org (   BIER`   b        3 #   Syntax14.Scn.Fnt  H*   H*  MODULE TBoxTestBArbre;
	
	IMPORT
		
		A:= TBoxAlea, B:= TBoxBArbre, OB:= TBoxOBArbre, L:= TBoxLeftist, Strings, Out;
	
	TYPE
		
		Integer= POINTER TO RECORD (B.Data)
			i: LONGINT;
		END;
		
		IntegerFab= POINTER TO RECORD (B.DataFab)
		END;
		
		GesClesI= POINTER TO RECORD (B.GesCles)
		END;
		
		Real= POINTER TO RECORD (B.Data)
			r: REAL;
		END;
		
		RealFab= POINTER TO RECORD (B.DataFab)
		END;
		
		GesClesR= POINTER TO RECORD (B.GesCles)
		END;
		
		Elem= POINTER TO RECORD (L.Elem)
			fin,
			ta,
			page: LONGINT;
		END;
		
		ElemCle= POINTER TO RECORD (L.Elem)
			fin: LONGINT;
			cle: B.Cha;
		END;
		
		Data= POINTER TO RECORD (B.Data)
		END;
		
		DataFab= POINTER TO RECORD (B.DataFab)
		END;
	
	PROCEDURE (i: Integer) Write (VAR w: B.Writer);
		
		BEGIN (*Write*)
			w.OutInt(i.i);
		END Write;
	
	PROCEDURE (i: Integer) Read (VAR r: B.Reader);
		
		BEGIN (*Read*)
			i.i:= r.InInt();
		END Read;
	
	PROCEDURE (f: IntegerFab) New (ta: LONGINT): B.Data;
		
		VAR
			
			i: Integer;
		
		BEGIN (*New*)
			ASSERT((ta= 0) OR (ta= SIZE(LONGINT)));
			NEW(i);
			RETURN i;
		END New;
	
	PROCEDURE (g: GesClesI) CompP (s1, s2: B.Data): B.Comp;
		
		BEGIN (*CompP*)
			WITH s1: Integer DO
				WITH s2: Integer DO
					IF s1.i< s2.i THEN
						RETURN B.inf;
					ELSIF s1.i> s2.i THEN
						RETURN B.sup;
					ELSE
						RETURN B.ega;
					END;
				END;
			END
		END CompP;
	
	PROCEDURE (r: Real) Write (VAR w: B.Writer);
		
		BEGIN (*Write*)
			w.OutReal(r.r);
		END Write;
	
	PROCEDURE (r: Real) Read (VAR re: B.Reader);
		
		BEGIN (*Read*)
			r.r:= re.InReal();
		END Read;
	
	PROCEDURE (f: RealFab) New (ta: LONGINT): B.Data;
		
		VAR
			
			r: Real;
		
		BEGIN (*New*)
			ASSERT((ta= 0) OR (ta= SIZE(REAL)));
			NEW(r);
			RETURN r;
		END New;
	
	PROCEDURE (g: GesClesR) CompP (s1, s2: B.Data): B.Comp;
		
		BEGIN (*CompP*)
			WITH s1: Real DO
				WITH s2: Real DO
					IF s1.r< s2.r THEN
						RETURN B.inf;
					ELSIF s1.r> s2.r THEN
						RETURN B.sup;
					ELSE
						RETURN B.ega;
					END;
				END;
			END
		END CompP;
	
	PROCEDURE (e1: Elem) Comp (e2: L.Elem): SHORTINT;
		
		BEGIN (*Comp*)
			WITH e2: Elem DO
				IF e1.fin< e2.fin THEN
					RETURN L.first;
				ELSIF e1.fin> e2.fin THEN
					RETURN L.last;
				ELSE
					RETURN L.equiv;
				END;
			END;
		END Comp;
	
	PROCEDURE (e1: ElemCle) Comp (e2: L.Elem): SHORTINT;
		
		BEGIN (*Comp*)
			WITH e2: ElemCle DO
				IF e1.fin< e2.fin THEN
					RETURN L.first;
				ELSIF e1.fin> e2.fin THEN
					RETURN L.last;
				ELSE
					RETURN L.equiv;
				END;
			END;
		END Comp;
	
	PROCEDURE (p: Data) Read (VAR r: B.Reader);
		
		BEGIN (*Read*)
		END Read;
	
	PROCEDURE (p: Data) Write (VAR w: B.Writer);
		
		BEGIN (*Write*)
		END Write;
	
	PROCEDURE (f: DataFab) New (ta: LONGINT): B.Data;
		
		VAR
			
			p: Data;
		
		BEGIN (*New*)
			NEW(p);
			RETURN p;
		END New;
	
	PROCEDURE Do1*;
		
		CONST
			
			nomBase= "BaseC.dat";
			nbPages= 1024;
			
			maxCles= 100;
			nbCles= 2000;
		
		VAR
			
			b: B.BaseDon;
			rI, i, j, n, m, x: LONGINT;
			ind: B.Index;
			g: B.GesClesString;
			f: B.StringFab;
			ok: BOOLEAN;
			cle: B.String;
			d: B.Data;
		
		BEGIN (*Do1*)
			(*A.Randomize(10);*)
			OB.fab.CreeBase(nomBase, 1);
			b:= OB.fab.OuvreBase(nomBase, nbPages);
			rI:= b.IndCree(0);
			b.EcrisPlace(0, rI);
			NEW(g); NEW(f);
			ind:= b.IndOuvre(rI, g, f);
			FOR i:= 1 TO nbCles DO
				n:= ENTIER((maxCles- 1)*A.Random())+ 1;
				NEW(cle); NEW(cle.c, n+ 1);
				FOR j:= 0 TO n- 1 DO
					cle.c[j]:= CHR(ENTIER((ORD(7EX)- ORD(21X)+ 1)* A.Random())+ ORD(21X));
				END;
				cle.c[n]:= 0X;
				ok:= ind.RechIns(cle);
			END;
			b.FermeBase;
			b:= OB.fab.OuvreBase(nomBase, nbPages);
			ind:= b.IndOuvre(b.LisPlace(0), g, f);
			
			i:= ENTIER(nbCles* A.Random());
			REPEAT
				j:= ENTIER(nbCles* A.Random());
			UNTIL j# i;
			ind.InitCour;
			IF i< j THEN
				x:= i;
			ELSE
				x:= j;
			END;
			FOR m:= 1 TO ABS(i- j) DO
				FOR n:= 0 TO x DO
					ind.Suivant;
				END;
				d:= ind.CleCour();
				cle:= d(B.String);
				ind.Efface(cle);
			END;
			
			ind.InitCour;
			ind.Suivant;
			WHILE ind.YACour() DO
				d:= ind.CleCour();
				cle:= d(B.String);
				Out.String(cle.c^); Out.Ln;
				ind.Suivant;
			END;
			Out.Ln;
			ind.Ferme;
			b.IndDetruit(rI);
			b.FermeBase;
		END Do1;
	
	PROCEDURE Do2*;
		
		CONST
			
			nomBase= "BaseI.dat";
			nbPages= 1024;
			
			nbCles= 10000;
		
		VAR
			
			b: B.BaseDon;
			rI, i, m: LONGINT;
			ind: B.Index;
			g: GesClesI;
			f: IntegerFab;
			ok: BOOLEAN;
			cle: Integer;
			d: B.Data;
		
		BEGIN (*Do2*)
			(*A.Randomize(10);*)
			OB.fab.CreeBase(nomBase, 1);
			b:= OB.fab.OuvreBase(nomBase, nbPages);
			rI:= b.IndCree(SIZE(LONGINT));
			b.EcrisPlace(0, rI);
			NEW(g); NEW(f);
			ind:= b.IndOuvre(rI, g, f);
			FOR i:= 1 TO nbCles DO
				NEW(cle);
				cle.i:= ENTIER(MAX(LONGINT)* A.Random());
				ok:= ind.RechIns(cle);
			END;
			b.FermeBase;
			b:= OB.fab.OuvreBase(nomBase, nbPages);
			ind:= b.IndOuvre(b.LisPlace(0), g, f);
			
			i:= ENTIER(nbCles* A.Random());
			ind.InitCour;
			FOR m:= 1 TO i DO
				ind.Suivant;
				d:= ind.CleCour();
				cle:= d(Integer);
				ind.Efface(cle);
			END;
			
			ind.InitCour;
			ind.Suivant;
			WHILE ind.YACour() DO
				d:= ind.CleCour();
				cle:= d(Integer);
				Out.Int(cle.i, 10); Out.Ln;
				ind.Suivant;
			END;
			Out.Ln;
			ind.Ferme;
			b.IndDetruit(rI);
			b.FermeBase;
		END Do2;
	
	PROCEDURE Do3*;
		
		CONST
			
			nbElems= 10000;
			dureeMin= 100;
			dureeMax= 2000;
			taMin= 1000;
			taMax= 10000;
			
			nomBase= "BaseL.dat";
			nbPages= 4096;
		
		VAR
			
			n: LONGINT;
			e: L.Elem;
			eF: Elem;
			t: L.Tree;
			b: B.BaseDon;
			f: DataFab;
			g: B.GesData;
		
		BEGIN (*Do3*)
			(*A.Randomize(1);*)
			L.New(t);
			OB.fab.CreeBase(nomBase, 0);
			b:= OB.fab.OuvreBase(nomBase, nbPages);
			NEW(f);
			g:= b.GesDataCree(f);
			n:= 0;
			e:= t.First();
			WHILE (n< nbElems) OR (e# NIL) DO
				INC(n);
				Out.Int(n, 4); Out.Ln;
				IF n< nbElems THEN
					NEW(eF);
					eF.ta:= taMin+ ENTIER((taMax- taMin+ 1)* A.Random());
					Out.Int(eF.ta, 10);
					eF.page:= g.ReserveDon(eF.ta);
					eF.fin:= n+ dureeMin+ ENTIER((dureeMax- dureeMin+ 1)* A.Random());
					t.Insert(eF);
					Out.Int(b.fin, 16); Out.Ln;
					e:= t.First();
				END;
				WHILE (e# NIL) & (e(Elem).fin= n) DO
					Out.Int(e(Elem).ta, 16);
					g.EffaceDon(e(Elem).page);
					t.Erase(e);
					Out.Int(b.fin, 10); Out.Ln;
					e:= t.First();
				END;
			END;
			b.FermeBase;
		END Do3;
	
	PROCEDURE Do4*;
		
		CONST
			
			nbElems= 10000;
			dureeMin= 100;
			dureeMax= 2000;
			taMin= 1;
			taMax= 100;
			
			nomBase= "BaseL.dat";
			nbPages= 32768;
		
		VAR
			
			n, rI, ta, i: LONGINT;
			e: L.Elem;
			eF: ElemCle;
			t: L.Tree;
			b: B.BaseDon;
			f: DataFab;
			ff: B.StringFab;
			g: B.GesClesString;
			ind: B.Index;
			cle: B.String;
		
		BEGIN (*Do4*)
			(*A.Randomize(2);*)
			L.New(t);
			OB.fab.CreeBase(nomBase, 1);
			b:= OB.fab.OuvreBase(nomBase, nbPages);
			rI:= b.IndCree(0);
			b.EcrisPlace(0, rI);
			NEW(g); NEW(ff);
			ind:= b.IndOuvre(rI, g, ff);
			n:= 0;
			e:= t.First();
			WHILE (n< nbElems) OR (e# NIL) DO
				INC(n);
				Out.Int(n, 5); Out.Ln;
				IF n< nbElems THEN
					NEW(eF);
					ta:= taMin+ ENTIER((taMax- taMin+ 1)* A.Random());
					NEW(eF.cle, ta+ 1);
					FOR i:= 0 TO ta- 1 DO
						eF.cle[i]:= CHR(ENTIER((ORD('Z')- ORD('A')+ 1)* A.Random())+ ORD('A'));
					END;
					eF.cle[ta]:= 0X;
					NEW(cle); cle.c:= eF.cle;
					IF ~ind.RechIns(cle) THEN
						Out.String("      "); Out.String(eF.cle^); Out.Ln;
						eF.fin:= n+ dureeMin+ ENTIER((dureeMax- dureeMin+ 1)* A.Random());
						t.Insert(eF);
						e:= t.First();
					END;
				END;
				WHILE (e# NIL) & (e(ElemCle).fin= n) DO
					Out.String("                 "); Out.String(e(ElemCle).cle^); Out.Ln;
					NEW(cle); cle.c:= e(ElemCle).cle;
					ind.Efface(cle);
					t.Erase(e);
					e:= t.First();
				END;
			END;
			ind.Ferme;
			Out.String("Taille = "); Out.Int(b.fin, 0); Out.Ln;
			b.IndDetruit(rI);
			Out.String("Taille = "); Out.Int(b.fin, 0); Out.Ln;
			b.FermeBase;
		END Do4;
	
	PROCEDURE Do5*;
		
		CONST
			
			nbElems= 10000;
			dureeMin= 100;
			dureeMax= 2000;
			taMin= 1;
			taMax= 100;
			
			nomBase= "BaseL.dat";
			nbPages= 32768;
		
		VAR
			
			n, rI, ta, i: LONGINT;
			e: L.Elem;
			eF: ElemCle;
			t: L.Tree;
			b: B.BaseDon;
			f: DataFab;
			ff: B.StringFab;
			g: B.GesClesString;
			ind: B.Index;
			cle: B.String;
			d: B.Data;
		
		BEGIN (*Do5*)
			(*A.Randomize(2);*)
			L.New(t);
			OB.fab.CreeBase(nomBase, 1);
			b:= OB.fab.OuvreBase(nomBase, nbPages);
			rI:= b.IndCree(0);
			b.EcrisPlace(0, rI);
			NEW(g); NEW(ff);
			ind:= b.IndOuvre(rI, g, ff);
			n:= 0;
			e:= t.First();
			WHILE n< nbElems DO
				INC(n);
				IF n< nbElems THEN
					NEW(eF);
					ta:= taMin+ ENTIER((taMax- taMin+ 1)* A.Random());
					NEW(eF.cle, ta+ 1);
					FOR i:= 0 TO ta- 1 DO
						eF.cle[i]:= CHR(ENTIER((ORD('z')- ORD('a')+ 1)* A.Random())+ ORD('a'));
					END;
					eF.cle[ta]:= 0X;
					NEW(cle); cle.c:= eF.cle;
					IF ~ind.RechIns(cle) THEN
						eF.fin:= n+ dureeMin+ ENTIER((dureeMax- dureeMin+ 1)* A.Random());
						t.Insert(eF);
						e:= t.First();
					END;
				END;
				WHILE (e# NIL) & (e(ElemCle).fin= n) DO
					NEW(cle); cle.c:= e(ElemCle).cle;
					ind.Efface(cle);
					t.Erase(e);
					e:= t.First();
				END;
			END;
			ind.InitCour;
			ind.Suivant;
			WHILE ind.YACour() DO
				d:= ind.CleCour();
				cle:= d(B.String);
				Out.String(cle.c^); Out.Ln; Out.Ln;
				ind.Suivant;
			END;
			ind.Ferme;
			b.IndDetruit(rI);
			Out.String("Taille = "); Out.Int(b.fin, 0); Out.Ln;
			b.FermeBase;
		END Do5;
	
	PROCEDURE Do6*;
		
		CONST
			
			nomBase= "BaseI.dat";
			nbPages= 1024;
			
			nbCles= 10000;
		
		VAR
			
			b: B.BaseDon;
			rI, i, m: LONGINT;
			ind: B.Index;
			g: GesClesR;
			f: RealFab;
			ok: BOOLEAN;
			cle: Real;
			clef: B.Data;
			d: B.Data;
		
		BEGIN (*Do6*)
			(*A.Randomize(10);*)
			OB.fab.CreeBase(nomBase, 1);
			b:= OB.fab.OuvreBase(nomBase, nbPages);
			rI:= b.IndCree(SIZE(REAL));
			b.EcrisPlace(0, rI);
			NEW(g); NEW(f);
			ind:= b.IndOuvre(rI, g, f);
			FOR i:= 1 TO nbCles DO
				NEW(cle);
				cle.r:= A.Random();
				ok:= ind.RechIns(cle);
			END;
			b.FermeBase;
			b:= OB.fab.OuvreBase(nomBase, nbPages);
			ind:= b.IndOuvre(b.LisPlace(0), g, f);
			
			i:= ENTIER(nbCles* A.Random());
			ind.InitCour;
			FOR m:= 1 TO i DO
				ind.Suivant;
				clef:= ind.CleCour();
				ind.Efface(clef);
			END;
			
			ind.InitCour;
			ind.Suivant;
			WHILE ind.YACour() DO
				d:= ind.CleCour();
				cle:= d(Real);
				Out.Real(cle.r, 13); Out.Ln;
				ind.Suivant;
			END;
			Out.Ln;
			ind.Ferme;
			b.IndDetruit(rI);
			b.FermeBase;
		END Do6;
	
	END TBoxTestBArbre.

TBoxTestBArbre.Do1;
TBoxTestBArbre.Do2;
TBoxTestBArbre.Do3;
TBoxTestBArbre.Do4;
TBoxTestBArbre.Do5;
TBoxTestBArbre.Do6;
