TextDocs.NewDoc      F   CColor     Flat  Locked  Controls  Org    BIER`   b        3 z   Oberon12.Scn.Fnt  {   Oberon14.Scn.Fnt              J       	               #   ]  MODULE TBoxTestAvl;
	
	IMPORT
		
		A:= TBoxAvl, Out, Alea:= TBoxAlea;
	
	TYPE
		
		Elem= POINTER TO RECORD (A.Elem);
			i: LONGINT;
		END;
	
	PROCEDURE (e: Elem) Copy (): A.Elem;
		
		VAR
			
			f: Elem;
		
		BEGIN (*Copy*)
			NEW(f);
			f.i:= e.i;
			RETURN f;
		END Copy;
	
	PROCEDURE (e: Elem) Compare (el: A.Elem): SHORTINT;
		
		BEGIN (*Compare*)
			WITH el: Elem DO
				IF e.i< el.i THEN
					RETURN A.inf;
				ELSIF e.i> el.i THEN
					RETURN A.sup;
				ELSE
					RETURN A.ega;
				END;
			END;
		END Compare;
	
	PROCEDURE Print1 (u: A.Tree);
		
		VAR
			
			f: A.Elem;
		
		BEGIN (*Print1*)
			f:= u.Next(NIL);
			WHILE f# NIL DO
				Out.Int(f(Elem).i, 10); Out.Ln;
				f:= u.Next(f);
			END;
			Out.Ln;
			f:= u.Previous(NIL);
			WHILE f# NIL DO
				Out.Int(f(Elem).i, 10); Out.Ln;
				f:= u.Previous(f);
			END;
			Out.Ln;
		END Print1;
	
	PROCEDURE Print2 (u: A.Tree);
		
		VAR
			
			f: A.Elem;
			i: LONGINT;
		
		BEGIN (*Print2*)
			FOR i := 1 TO u.NumberOfElems() DO
				u.Find(i, f);
				Out.Int(f(Elem).i, 10); Out.Ln;
			END;
			Out.Ln;
		END Print2;
	
	PROCEDURE Do*;
		
		CONST
			
			nbCles= 1000;
		
		VAR
			
			t: A.Tree;
			el: Elem;
			e: A.Elem;
			n, m, i: LONGINT;
			ok: BOOLEAN;
		
		BEGIN (*Do*)
			Alea.Randomize(10);
			A.New(t);
			FOR n:= 1 TO nbCles DO
				NEW(el);
				el.i:= SHORT(ENTIER(MAX(LONGINT)* Alea.Random()));
				e:= el;
				ok:= t.SearchIns(e, n);
			END;
			Print1(t);
			
			n:= ENTIER(nbCles* Alea.Random());
			m:= t.NumberOfElems();
			IF n> m THEN
				n:= m;
			END;
			FOR i:= 1 TO n DO
				t.Erase(1);
			END;
			Print2(t);
		END Do;
	
	END TBoxTestAvl.

TBoxTestAvl.Do;
