TextDocs.NewDoc     F   CColor     Flat  Locked  Controls  Org    BIER`   b        3     Oberon10.Scn.Fnt     Oberon12.Scn.Fnt                      J   Oberon12i.Scn.Fnt                              q             (*
TBox: Set of tools.

Copyright (C) 2001 Grard Meunier

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License  for more details.

You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*)

MODULE TBoxStrings;
	
	 
	
	(** Additional strings utilities. *)
	
	(** Extracts, from the string src, the substring s beginning at position p and of length l. *)
	PROCEDURE Extract*(VAR src: ARRAY OF CHAR; p, l: LONGINT; VAR s: ARRAY OF CHAR);
		
		VAR
			
			i, m: LONGINT;
		
		BEGIN (*Extract*)
			ASSERT(p>= 0);
			IF l>= LEN(s) THEN
				l:= LEN(s)- 1;
			END;
			m:= LEN(src);
			i:= 0;
			WHILE (i< l) & (p< m) & (src[p]# 0X) DO
				s[i]:= src[p];
				INC(i); INC(p);
			END;
			s[i]:= 0X;
		END Extract;
	
	(** Same as Extract. *)
	PROCEDURE ExtractCon*(src: ARRAY OF CHAR; p, l: LONGINT; VAR s: ARRAY OF CHAR);
		
		BEGIN (*ExtractCon*)
			Extract(src, p, l, s);
		END ExtractCon;
	
	END TBoxStrings.
BIER  ,       :       g 
     C  Oberon10.Scn.Fnt 13.06.02  16:00:19  TimeStamps.New  