TextDocs.NewDoc     TF   CColor     Flat  Locked  Controls  Org    BIER`   b        3  1   Syntax12.Scn.Fnt          V   T  (*
TBox: Set of tools.

Copyright (C) 2001 Grard Meunier

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License  for more details.

You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*)

MODULE TBoxOBArbre;
	
	 
	
	(** Implementation of BArbre for Oberon. For use in Oberon, this module should be imported in place of TBoxBArbre. *)
	
	IMPORT
		
		B:= TBoxBArbre, Files, Strings, SYSTEM;
	
	CONST
		
		bNil*= B.bNil;
		inf*= B.inf;
		ega*= B.ega;
		sup*= B.sup;
		
		TSR= SIZE(REAL);
		TSLR= SIZE(LONGREAL);
	
	TYPE
		
		Fabrique= POINTER TO RECORD (B.Fabrique)
		END;
		
		RealArray= ARRAY TSR OF SHORTINT;
		
		LRealArray= ARRAY TSLR OF SHORTINT;
		
		Fichier= POINTER TO RECORD (B.Fichier)
			fin: LONGINT;
			f: Files.File;
			r, w: Files.Rider;
		END;
		
		Cha*= B.Cha;
		
		GesCles*= B.GesCles;
		
		String*= B.String;
		
		StringFab*= B.StringFab;
		
		GesClesString*= B.GesClesString;
		
		Comp*= B.Comp;
		
		BaseDon*= B.BaseDon;
		
		Index*= B.Index;
		
		Data*= B.Data;
		
		DataFab*= B.DataFab;
		
		GesData*= B.GesData;
		
		Reader*= B.Reader;
		
		Writer*=B.Writer;
	
	VAR
		
		fab-: B.Fabrique;
	
	PROCEDURE (fab: Fabrique) Cree (nF: ARRAY OF CHAR);
		
		VAR
			
			f: Files.File;
			w: Files.Rider;
			res: LONGINT;
		
		BEGIN (*Cree*)
			f:= Files.New(nF);
			Files.Set(w, f, 0);
			Files.WriteLInt(w, 0);
			Files.Register(f);
		END Cree;
	
	PROCEDURE (fab: Fabrique) Ouvre (nF: ARRAY OF CHAR): B.Fichier;
		
		VAR
			
			f: Fichier;
		
		BEGIN (*Ouvre*)
			NEW(f);
			f.f:= Files.Old(nF);
			IF f.f= NIL THEN
				RETURN NIL;
			END;
			Files.Set(f.r, f.f, 0);
			Files.ReadLInt(f.r, f.fin);
			Files.Set(f.w, f.f, SIZE(LONGINT));
			RETURN f;
		END Ouvre;
	
	PROCEDURE (ref: Fichier) Ferme;
		
		BEGIN (*Ferme*)
			Files.Set(ref.w, ref.f, 0);
			Files.WriteLInt(ref.w, ref.fin);
			Files.Close(ref.f);
		END Ferme;
	
	PROCEDURE (ref: Fichier) Flush;
		
		BEGIN (*Flush*)
			Files.Set(ref.w, ref.f, 0);
			Files.WriteLInt(ref.w, ref.fin);
			Files.Close(ref.f);
		END Flush;
	
	PROCEDURE (ref: Fichier) PosLis (pos: LONGINT);
		
		BEGIN (*PosLis*)
			Files.Set(ref.r, ref.f, pos+ 4);
		END PosLis;
	
	PROCEDURE (ref: Fichier) Lis (VAR a: ARRAY OF SHORTINT);
		
		VAR
			
			i: LONGINT;
		
		BEGIN (*Lis*)
			FOR i:= 0 TO LEN(a)- 1 DO
				Files.ReadBytes(ref.r, a[i], SIZE(SHORTINT));
			END;
			ASSERT(ref.r.res= 0);
		END Lis;
	
	PROCEDURE (ref: Fichier) PosEcris (pos: LONGINT);
		
		VAR
			
			i, n: LONGINT;
			b: SYSTEM.BYTE;
		
		BEGIN (*PosEcris*)
			INC(pos, 4);
			n:= Files.Length(ref.f);
			IF pos> n THEN
				Files.Set(ref.w, ref.f, n);
				FOR i:= 1 TO pos- n DO
					Files.Write(ref.w, b);
				END;
			ELSE
				Files.Set(ref.w, ref.f, pos);
			END;
		END PosEcris;
	
	PROCEDURE (ref: Fichier) Ecris (VAR a: ARRAY OF SHORTINT);
		
		VAR
			
			n: LONGINT;
		
		BEGIN (*Ecris*)
			FOR n:= 0 TO LEN(a)- 1 DO
				Files.WriteBytes(ref.w, a[n], SIZE(SHORTINT));
			END;
			n:= Files.Pos(ref.w)- 4;
			IF ref.fin< n THEN
				ref.fin:= n;
			END;
		END Ecris;
	
	PROCEDURE (ref: Fichier) Fin (VAR fin: LONGINT);
		
		BEGIN (*Fin*)
			fin:= ref.fin;
		END Fin;
	
	PROCEDURE (ref: Fichier) Tronque (fin: LONGINT);
		
		BEGIN (*Tronque*)
			ref.fin:= fin;
		END Tronque;
	
	PROCEDURE (ref: Fichier) BytesToReal (VAR a: ARRAY OF SHORTINT; VAR pos: LONGINT): REAL;
		
		VAR
			
			i: LONGINT;
			r: RealArray;
		
		BEGIN (*BytesToReal*)
			ASSERT(pos+ SIZE(REAL)<= LEN(a), 20);
			FOR i:= 0 TO SIZE(REAL)- 1 DO
				r[i]:= a[pos];
				INC(pos);
			END;
			RETURN SYSTEM.VAL(REAL, r);
		END BytesToReal;
	
	PROCEDURE (ref: Fichier) BytesToLReal (VAR a: ARRAY OF SHORTINT; VAR pos: LONGINT): LONGREAL;
		
		VAR
			
			i: LONGINT;
			r: LRealArray;
		
		BEGIN (*BytesToLReal*)
			ASSERT(pos+ SIZE(LONGREAL)<= LEN(a), 20);
			FOR i:= 0 TO SIZE(LONGREAL)- 1 DO
				r[i]:= a[pos];
				INC(pos);
			END;
			RETURN SYSTEM.VAL(LONGREAL, r);
		END BytesToLReal;
	
	PROCEDURE (ref: Fichier) RealToBytes (r: REAL): B.PSHORTINT;
		
		VAR
			
			i: LONGINT;
			a: B.PSHORTINT;
			ra: RealArray;
		
		BEGIN (*RealToBytes*)
			ra:= SYSTEM.VAL(RealArray, r);
			NEW(a, SIZE(REAL));
			FOR i:= 0 TO SIZE(REAL)- 1 DO
				a[i]:= ra[i];
			END;
			RETURN a;
		END RealToBytes;
	
	PROCEDURE (ref: Fichier) LRealToBytes (r: LONGREAL): B.PSHORTINT;
		
		VAR
			
			i: LONGINT;
			a: B.PSHORTINT;
			ra: LRealArray;
		
		BEGIN (*LRealToBytes*)
			ra:= SYSTEM.VAL(LRealArray, r);
			NEW(a, SIZE(LONGREAL));
			FOR i:= 0 TO SIZE(LONGREAL)- 1 DO
				a[i]:= ra[i];
			END;
			RETURN a;
		END LRealToBytes;
	
	PROCEDURE Init;
		
		VAR
			
			f: Fabrique;
		
		BEGIN (*Init*)
			NEW(f);
			fab:= f;
		END Init;
	
	BEGIN (*TBoxOBArbre*)
		Init;
	END TBoxOBArbre.
BIER@  Q       <       g 
     C  Syntax10.Scn.Fnt 30.03.2002  22:20:24  TimeStamps.New  