TextDocs.NewDoc     F   CColor     Flat  Locked  Controls  Org    BIER`   b        3  L       Syntax10.Scn.Fnt     Syntax12.Scn.Fnt     Oberon12.Scn.Fnt                                 U                 ,                           D               	  Oberon12i.Scn.Fnt                     u               	       (*
TBox: Set of tools.

Copyright (C) 2001 Grard Meunier

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License  for more details.

You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*)

MODULE TBoxMapping;
	
	
	
	(** Implements a mapping between keys and lengthier strings. *)
	
	IMPORT
		
		C:= BabelCompil, Files, Out, Strings, Texts;
	
	CONST
		
		suffixe= ".Str";
	
	TYPE
		
		Compilation= POINTER TO RECORD (C.Compilation)
			t: Texts.Text;
			r: Texts.Reader;
			rac: Dico;
		END;
		
		Directory= POINTER TO RECORD (C.Directory)
			r: Files.Rider;
		END;
		
		Chaine*= POINTER TO ARRAY OF CHAR;
		
		DicoGen= POINTER TO RECORD
			suivant: DicoGen;
			cle: Chaine;
		END;
		
		Dico= POINTER TO RECORD (DicoGen)
			valeur: Chaine;
		END;
		
		Dicos= POINTER TO RECORD (DicoGen)
			valeur: Dico;
		END;
	
	VAR
		
		dicos: Dicos;
	
	PROCEDURE (c: Compilation) Error (pos, line, col: LONGINT; msg: ARRAY OF CHAR);
		
		BEGIN (*Error*)
			Out.String("TBoxMapping: error at ");
			Out.Int(pos- 1, 0);
			Out.Ln;
			Out.String(msg);
			Out.Ln;
		END Error;
	
	PROCEDURE (c: Compilation) Read (VAR ch: CHAR);
		
		BEGIN (*Read*)
			Texts.Read(c.r, ch);
		END Read;
	
	PROCEDURE (c: Compilation) Pos (): LONGINT;
		
		BEGIN (*Pos*)
			RETURN Texts.Pos(c.r);
		END Pos;
	
	PROCEDURE (c: Compilation) SetPos (pos: LONGINT);
		
		BEGIN (*SetPos*)
			Texts.OpenReader(c.r, c.t, pos);
		END SetPos;
	
	PROCEDURE (rac: DicoGen) Insere (d: DicoGen);
		
		BEGIN (*Insere*)
			d.suivant:= rac.suivant;
			rac.suivant:= d;
		END Insere;
	
	PROCEDURE (c : Compilation) Execution (fNum, parsNb: LONGINT; pars: C.ObjectsList; VAR objPos: C.Object; VAR res: C.ANYPTR): BOOLEAN;	
		
		VAR
			
			d: Dico;
		
		BEGIN (*Execution*)
			NEW(d);
			objPos:= C.Parameter(pars, 2);
			NEW(d.valeur, objPos.ObjStringLen()+ 1);
			objPos.ObjString(d.valeur^);
			objPos:= C.Parameter(pars, 1);
			NEW(d.cle, objPos.ObjStringLen()+ 1);
			objPos.ObjString(d.cle^);
			c.rac.Insere(d);
			RETURN TRUE;
		END Execution;
	
	PROCEDURE (d: Directory) ReadInt (VAR i: LONGINT);
		
		BEGIN (*ReadInt*)
			Files.ReadLInt(d.r, i);
		END ReadInt;
	
	PROCEDURE (rac: DicoGen) Cherche (cle: ARRAY OF CHAR): DicoGen;
		
		BEGIN (*Cherche*)
			REPEAT
				rac:= rac.suivant;
			UNTIL (rac= NIL) OR (rac.cle^= cle);
			RETURN rac;
		END Cherche;
	
	PROCEDURE Init (base: ARRAY OF CHAR): BOOLEAN;
		
		VAR
			
			nom: ARRAY 64 OF CHAR;
			i: LONGINT;
			fd: Files.File;
			dir: Directory;
			c: C.Compiler;
			co: Compilation;
			d: Dicos;
			t: Texts.Text;
		
		BEGIN (*Init*)
			FOR i:= 0 TO Strings.Length(base)- 3 DO
				nom[i]:= base[i+ 1];
			END;
			Strings.Append(nom, suffixe);
			NEW(t);
			Texts.Open(t, nom);
			IF t.len= 0 THEN
				RETURN FALSE;
			END;
			fd:= Files.Old("TBoxMapping.Tbl");
			ASSERT(fd# NIL, 100);
			NEW(dir);
			Files.Set(dir.r, fd, 0);
			c:= dir.ReadCompiler();
			NEW(co);
			co.t:= t;
			Texts.OpenReader(co.r, t, 0);
			NEW(co.rac);
			IF ~co.Compile(c, TRUE) THEN
				Out.String("TBoxMapping: file "); Out.String(nom); Out.String(" incorrect."); Out.Ln;
				RETURN FALSE;
			END;
			NEW(d);
			NEW(d.cle, Strings.Length(base)+ 1);
			COPY(base, d.cle^);
			d.valeur:= co.rac;
			dicos.Insere(d);
			RETURN TRUE;
		END Init;
	
	(** Translates string cle into the result. Strings of the form "#Subsystem:message" are translated if there is a corresponding Subsystem.Str resource file for this subsystem. Otherwise, the "#Subsystem:" prefix is stripped away, if there is no resource file.
As an example, "#System:Cancel" may be translated to "Cancel" in the USA, and to "Abbrechen" in Germany; or to "Cancel" if the resource file or the appropriate entry is missing.
Three additional input parameters can be spliced into the cle parameter. These parameters are inserted where "^0", "^1", or "^2" occur in the reulting string. The parameters are not mapped, but merely substituted.
Map allows to remove country- and language-specific strings from a program source text, while at the same time providing a default string in the program source text such that the program always works, even if string resources are missing. *)
	PROCEDURE Map*(cle, p0, p1, p2: ARRAY OF CHAR): Chaine;
		
		VAR
			
			clef: Chaine;
			pos, p, i, n: LONGINT;
			g: DicoGen;
			d: Dico;
		
		BEGIN (*Map*)
			ASSERT(cle[0]= '#', 100);
			pos:= 1;
			Strings.Search(':', cle, pos);
			ASSERT(pos>= 0, 101);
			INC(pos);
			n:= Strings.Length(cle)- pos;
			NEW(clef, n+ 1);
			FOR i:= 0 TO n- 1 DO
				clef[i]:= cle[pos+ i];
			END;
			clef[n]:= 0X;
			cle[pos]:= 0X;
			g:= dicos.Cherche(cle);
			IF g= NIL THEN
				IF ~Init(cle) THEN
					RETURN clef;
				END;
				g:= dicos.suivant;
			END;
			g:= g(Dicos).valeur.Cherche(clef^);
			IF g= NIL THEN
				RETURN clef;
			END;
			d:= g(Dico);
			n:= Strings.Length(d.valeur^);
			pos:= 0;
			LOOP
				REPEAT
					Strings.Search('^', d.valeur^, pos);
				UNTIL (pos< 0) OR (d.valeur[pos+ 1]>= '0') & (d.valeur[pos+ 1]<= '2');
				IF (pos< 0) THEN
					EXIT;
				END;
				INC(pos);
				CASE d.valeur[pos] OF
					|'0':
						INC(n, Strings.Length(p0)- 2);
					|'1':
						INC(n, Strings.Length(p1)- 2);
					|'2':
						INC(n, Strings.Length(p2)- 2);
				END;
			END;
			NEW(clef, n+ 1);
			pos:= 0; p:= 0;
			WHILE d.valeur[p]# 0X DO
				IF (d.valeur[p]='^') & (d.valeur[p+ 1]>= '0') & (d.valeur[p+ 1]<= '2') THEN
					CASE d.valeur[p+ 1] OF
						|'0':
							n:= Strings.Length(p0);
							FOR i:= 0 TO n- 1 DO
								clef[pos]:= p0[i];
								INC(pos);
							END;
						|'1':
							n:= Strings.Length(p1);
							FOR i:= 0 TO n- 1 DO
								clef[pos]:= p1[i];
								INC(pos);
							END;
						|'2':
							n:= Strings.Length(p2);
							FOR i:= 0 TO n- 1 DO
								clef[pos]:= p2[i];
								INC(pos);
							END;
					END;
					INC(p, 2);
				ELSE
					clef[pos]:= d.valeur[p];
					INC(p); INC(pos);
				END;
			END;
			clef[pos]:= 0X;
			RETURN clef;
		END Map;
	
	(** Flushes the contents of the .Str files from main memory. *)
	PROCEDURE Reinit*;
		
		BEGIN (*Reinit*)
			NEW(dicos);
		END Reinit;
	
	BEGIN (*TBoxMapping*)
		Reinit;
	END TBoxMapping.
BIER8  y       <  s          "         d      d
     C  <       g 
     C  Syntax10.Scn.Fnt 30.03.2002  23:56:02  1       
 
     CCmd Watson.Goto Compilation   $       
 
     CName Execution   1       
 
     CCmd Watson.Goto ObjectsList   ,       
 
     CCmd Watson.Goto Object   ,       
 
     CCmd Watson.Goto ANYPTR   TextGadgets.NewStyleProc TimeStamps.New TextGadgets.NewControl  