TextDocs.NewDoc     TF   CColor     Flat  Locked  Controls  Org 
   BIER`   b        3  1   Syntax12.Scn.Fnt               (*
TBox: Set of tools.

Copyright (C) 2001 Grard Meunier

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License  for more details.

You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*)

MODULE TBoxLeftist;
	
	 
	
	(** Implements leftist trees, which may be used for priority queues. Cf. Knuth, The art of computer programming, vol. 3, ch. 5.2.3 and exercises 32 & 35. *)
	
	CONST
		
		(** Results of comparison. *)
		first*= -1; (** Comes first. *)
		equiv*= 0; (** Same level. *)
		last*= +1; (** Comes after. *)
	
	TYPE
		
		Elem*= POINTER TO RECORD (** Element of a leftist tree. *)
			dist: INTEGER; (* Defined recursively by e.dist= e.right.dist+ 1 and e.dist= 1 if e.right= NIL; moreover, e.right.dist<= e.left.dist for all e. *)
			left, right, up: Elem; (* left son, right son and father. *)
		END;
		
		Tree*= POINTER TO RECORD (** Leftist tree. *)
			root: Elem;
		END;
	
	(** Compare e1 to e2; returns first if e1 comes before e2, equiv if e1 and e2 are at the same level, or last if e1 comes after e2. *)
	PROCEDURE (e1: Elem) Comp-(e2: Elem): SHORTINT;
		
		BEGIN (*Comp*)
			HALT(100);
		END Comp;
	
	PROCEDURE Merge (VAR p: Elem; q: Elem);
		
		VAR
			
			r: Elem;
			d, l: INTEGER;
		
		BEGIN (*Merge*)
			r:= NIL;
			WHILE (p# NIL) & (q# NIL) DO
				IF p.Comp(q)<= equiv THEN
					p.up:= r;
					r:= p;
					p:= p.right;
				ELSE
					q.up:= r;
					r:= q;
					q:= q.right;
				END;
			END;
			IF q= NIL THEN
				IF p= NIL THEN
					d:= 0;
				ELSE
					d:= p.dist;
					p.up:= r;
				END;
			ELSE
				p:= q;
				d:= p.dist;
				p.up:= r;
			END;
			WHILE r# NIL DO
				q:= r.left;
				IF q= NIL THEN
					l:= 0;
				ELSE
					l:= q.dist;
				END;
				IF l< d THEN
					d:= l; INC(d);
					r.right:= q;
					r.left:= p;
				ELSE
					INC(d);
					r.right:= p;
				END;
				r.dist:= d;
				p:= r;
				r:= p.up;
			END;
		END Merge;
	
	(** Inserts the element e in the tree t. *)
	PROCEDURE (t: Tree) Insert*(e: Elem);
		
		BEGIN (*Insert*)
			ASSERT(e# NIL, 20);
			e.dist:= 1;
			e.left:= NIL;
			e.right:= NIL;
			e.up:= NIL;
			Merge(t.root, e);
		END Insert;
	
	(** Returns one of the first elements of the tree t. *)
	PROCEDURE (t: Tree) First*(): Elem;
		
		BEGIN (*First*)
			RETURN t.root;
		END First;
	
	(** Deletes the element e of the tree t. *)
	PROCEDURE (t: Tree) Erase*(e: Elem);
		
		VAR
			
			p: Elem;
			d, l: INTEGER;
		
		BEGIN (*Erase*)
			ASSERT(e# NIL, 20);
			Merge(e.left, e.right);
			p:= e.up;
			IF e.left# NIL THEN
				e.left.up:= p;
			END;
			IF p= NIL THEN
				t.root:= e.left;
			ELSE
				ASSERT((e= p.left) OR (e= p.right));
				IF e= p.left THEN
					p.left:= e.left;
				ELSE
					p.right:= e.left;
				END;
				REPEAT
					d:= p.dist;
					IF (p.right# NIL) & ((p.left= NIL) OR (p.left.dist< p.right.dist)) THEN
						e:= p.left;
						p.left:= p.right;
						p.right:= e;
					END;
					IF p.right= NIL THEN
						l:= 1;
					ELSE
						l:= p.right.dist; INC(l);
					END;
					p.dist:= l;
					p:= p.up;
				UNTIL (p= NIL) OR (l= d);
			END;
		END Erase;
	
	(** Empties the tree t. *)
	PROCEDURE (t: Tree) Empty*;
		
		BEGIN (*Empty*)
			t.root:= NIL;
		END Empty;
	
	(** Creates a new empty tree t. *)
	PROCEDURE New*(VAR t: Tree);
		
		BEGIN (*New*)
			NEW(t);
			t.Empty;
		END New;
	
	END TBoxLeftist.

BIER         <       g 
     C  Syntax10.Scn.Fnt 07.03.2002  01:42:44  TimeStamps.New  