TextDocs.NewDoc     UF   CColor     Flat  Locked  Controls  Org    BIER`   b        3  :  Oberon12.Scn.Fnt     Syntax12.Scn.Fnt                      c        j       K                               	                              K                             o                                      I                       N                                      /        `                                                 ,  (*
TBox: Set of tools.

Copyright (C) 2001 Grard Meunier

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License  for more details.

You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*)

MODULE TBoxExtStrings;
	
	 
	
	(** Defines an abstract type of  extensible strings and implements it. *)
	
	IMPORT
		
		Avl:= TBoxAvl, Strings;
	
	CONST
		
		eOS= 0X;
	
	TYPE
		
		String*= POINTER TO RECORD (** String of characters. *)
		END;
		
		Reader*= POINTER TO RECORD (** Reader of string. *)
			eos-: BOOLEAN; (** Indicates when end of string has been read. *)
			char-: CHAR; (* Last character read. *)
		END;
		
		Writer*= POINTER TO RECORD (** Writer of string. *)
		END;
		
		Directory*= POINTER TO RECORD (** Factory for strings. *)
		END;
		
		Char= POINTER TO RECORD (Avl.Elem)
			c: CHAR;
		END;
		
		StdString= POINTER TO RECORD (String)
			chars: Avl.Tree;
		END;
		
		StdReader= POINTER TO RECORD (Reader)
			s: StdString;
			p: LONGINT;
		END;
		
		StdWriter= POINTER TO RECORD (Writer)
			s: StdString;
			p: LONGINT;
		END;
		
		StdDirectory= POINTER TO RECORD (Directory)
		END;
	
	VAR
		
		dir-,	(** Current directory. *)
		stdDir-: Directory;	(** Standard directory. *)
	
	PROCEDURE (c: Char) Copy (): Avl.Elem;
		
		VAR
			
			cc: Char;
		
		BEGIN (*Copy*)
			NEW(cc);
			cc.c:= c.c;
			RETURN cc;
		END Copy;
	
	(** Creates and returns a new reader of the string s, positionned at 0. *)
	PROCEDURE (s: String) NewReader*(): Reader;
		
		BEGIN (*NewReader*)
			HALT(100);
		END NewReader;
	
	(** Creates and returns a new writer of the string s, positionned at 0. *)
	PROCEDURE (s: String) NewWriter*(): Writer;

		BEGIN (*NewWriter*)
			HALT(100);
		END NewWriter;
	
	(** Returns the length of s. *)
	PROCEDURE (s: String) Length*(): LONGINT;

		BEGIN (*Length*)
			HALT(100);
		END Length;
	
	(** Returns the position of the first occurrence of target in s, after the position beg. Returns -1 if not found. *)
	PROCEDURE (s: String) Pos*(beg: LONGINT; target: ARRAY OF CHAR): LONGINT;

		BEGIN (*Pos*)
			HALT(100);
		END Pos;
	
	(** Sets the value of s to st. *)
	PROCEDURE (s: String) Set*(st: ARRAY OF CHAR);

		BEGIN (*Set*)
			HALT(100);
		END Set;
	
	(** Returns the concatenation of s1 and s2. *)
	PROCEDURE (s1: String) Cat*(s2: String): String;
	

		BEGIN (*Cat*)
			HALT(100);
		END Cat;
	(** Returns the string s with src inserted at position pos. s is not modified, nor src. If pos< 0, pos= 0 is assumed; if pos> s.Length(), pos= s.Length() is assumed. *)
	PROCEDURE (s: String) Insert*(pos: LONGINT; src: String): String;

		BEGIN (*Insert*)
			HALT(100);
		END Insert;
	
	(** Extracts and returns the substring of s beginning at position pos anf of length len. *)
	PROCEDURE (s: String) Extract*(pos, len: LONGINT): String;

		BEGIN (*Extract*)
			HALT(100);
		END Extract;
	
	(** Converts the string s into the array of char st. At most LEN(st)- 1 characters are converted. *)
	PROCEDURE (s: String) Convert*(VAR st: ARRAY OF CHAR);

		BEGIN (*Convert*)
			HALT(100);
		END Convert;
	
	(** Returns the string r is reading. *)
	PROCEDURE (r: Reader) Base*(): String;

		BEGIN (*Base*)
			HALT(100);
		END Base;
	
	(** Returns the position of r. *)
	PROCEDURE (r: Reader) Pos*(): LONGINT;

		BEGIN (*Pos*)
			HALT(100);
		END Pos;
	
	(** Sets the position of r at pos. pos must verify 0<= pos <= r.Base().Length(). *)
	PROCEDURE (r: Reader) SetPos*(pos: LONGINT);

		BEGIN (*SetPos*)
			HALT(100);
		END SetPos;
	
	(** Reads a character at the position of the reader r and advances r to the next position. If  the end of the string has been reached, r.eos is set to TRUE and r.char to eOS. *)
	PROCEDURE (r: Reader) Read*;

		BEGIN (*Read*)
			HALT(100);
		END Read;
	
	(** Does just as r.Read but returns the character read. *)
	PROCEDURE (r: Reader) ReadChar*(VAR c: CHAR);

		BEGIN (*ReadChar*)
			HALT(100);
		END ReadChar;
	
	(** Reads at most MIN(len, LEN(s)- 1) characters by repetition of r.Read. *)
	PROCEDURE (r: Reader) ReadString*(len: LONGINT; VAR s: ARRAY OF CHAR);

		BEGIN (*ReadString*)
			HALT(100);
		END ReadString;
	
	(** Returns the string w is writing. *)
	PROCEDURE (w: Writer) Base*(): String;

		BEGIN (*Base*)
			HALT(100);
		END Base;
	
	(** Returns the position of w. *)
	PROCEDURE (w: Writer) Pos*(): LONGINT;

		BEGIN (*Pos*)
			HALT(100);
		END Pos;
	
	(** Sets the position of w at pos. pos must verify 0<= pos <= w.Base().Length(). *)
	PROCEDURE (w: Writer) SetPos*(pos: LONGINT);

		BEGIN (*SetPos*)
			HALT(100);
		END SetPos;
	
	(** Writes the character c at the position of the writer w and advances w to the next position. If  the end of the string has been reached, c is appended to the string. *)
	PROCEDURE (w: Writer) WriteChar*(c: CHAR);

		BEGIN (*WriteChar*)
			HALT(100);
		END WriteChar;
	
	(** Writes the array of char s by repetition of w.WriteChar. *)
	PROCEDURE (w: Writer) WriteString*(s: ARRAY OF CHAR);

		BEGIN (*WriteString*)
			HALT(100);
		END WriteString;
	
	(** Creates a new empty string. *)	
	PROCEDURE (d: Directory) New*(): String;

		BEGIN (*New*)
			HALT(100);
		END New;
	
	PROCEDURE (s: StdString) NewReader (): Reader;
		
		VAR
			
			r: StdReader;
		
		BEGIN (*NewReader*)
			NEW(r);
			r.s:= s;
			r.p:= 0;
			RETURN r;
		END NewReader;
	
	PROCEDURE (s: StdString) NewWriter (): Writer;
		
		VAR
			
			w: StdWriter;
		
		BEGIN (*NewWriter*)
			NEW(w);
			w.s:= s;
			w.p:= s.Length();
			RETURN w;
		END NewWriter;
	
	PROCEDURE (s: StdString) Length (): LONGINT;
		
		BEGIN (*Length*)
			RETURN s.chars.NumberOfElems();
		END Length;
	
	PROCEDURE (s: StdString) Pos (beg: LONGINT; target: ARRAY OF CHAR): LONGINT;
		
		VAR
			
			n, m, j: LONGINT;
			e: Avl.Elem;
		
		BEGIN (*Pos*)
			m:= Strings.Length(target);
			n:= s.chars.NumberOfElems()- m+ 1;
			j:= 0;
			WHILE (j< m) & (beg< n) DO
				INC(beg);
				s.chars.Find(beg, e);
				j:= 0;
				WHILE (j< m) & (e(Char).c= target[j]) DO
					e:= s.chars.Next(e);
					INC(j);
				END;
			END;
			IF j< m THEN
				beg:= 0;
			END;
			RETURN beg- 1;
		END Pos;
	
	PROCEDURE (s: StdString) Set (st: ARRAY OF CHAR);
		
		VAR
			
			i, l: LONGINT;
			c: Char;
		
		BEGIN (*Set*)
			Avl.New(s.chars);
			i:= 0; l:= Strings.Length(st);
			WHILE i< l DO
				NEW(c);
				s.chars.Append(c);
				c.c:= st[i];
				INC(i);
			END;
		END Set;
	
	PROCEDURE (s1: StdString) Cat (s2: String): String;
		
		VAR
			
			c1, c2: Avl.Tree;
			s: StdString;
		
		BEGIN (*Cat*)
			ASSERT(s2 IS StdString, 20);
			c1:= s1.chars.Copy();
			c2:= s2(StdString).chars.Copy();
			c1.Cat(c2);
			NEW(s);
			s.chars:= c1;
			RETURN s;
		END Cat;
	
	PROCEDURE (s: StdString) Insert (pos: LONGINT; src: String): String;
		
		VAR
			
			c1, c2, d: Avl.Tree;
		
		BEGIN (*Insert*)
			ASSERT(src IS StdString, 20);
			c1:= s.chars.Copy();
			c2:= src(StdString).chars.Copy();
			c1.Split(pos, d);
			c1.Cat(c2);
			c1.Cat(d);
			NEW(s);
			s.chars:= c1;
			RETURN s;
		END Insert;
	
	PROCEDURE (s: StdString) Extract (pos, len: LONGINT): String;
		
		VAR
			
			t, u: Avl.Tree;
		
		BEGIN (*Extract*)
			t:= s.chars.Copy();
			IF len< 0 THEN
				len:= 0;
			END;
			IF pos<= MAX(LONGINT)- len THEN
				t.Split(pos+ len, u);
			END;
			t.Split(pos, u);
			NEW(s);
			s.chars:= u;
			RETURN s;
		END Extract;
	
	PROCEDURE (s: StdString) Convert (VAR st: ARRAY OF CHAR);
		
		VAR
			
			e: Avl.Elem;
			i, n: LONGINT;
		
		BEGIN (*Convert*)
			e:= s.chars.Next(NIL);
			i:= 0; n:= LEN(st)- 1;
			WHILE (e# NIL) & (i< n) DO
				st[i]:= e(Char).c;
				e:= s.chars.Next(e);
				INC(i);
			END;
			st[i]:= eOS;
		END Convert;
	
	PROCEDURE (r: StdReader) Base (): String;
		
		BEGIN (*Base*)
			RETURN r.s;
		END Base;
	
	PROCEDURE (r: StdReader) Pos (): LONGINT;
		
		VAR
			
			l: LONGINT;
		
		BEGIN (* Pos*)
			l:= r.s.Length();
			IF r.p> l THEN
				r.p:= l;
			END;
			RETURN r.p;
		END  Pos;
	
	PROCEDURE (r: StdReader) SetPos (pos: LONGINT);
		
		BEGIN (*SetPos*)
			ASSERT(pos>= 0, 20);
			ASSERT(pos<= r.s.Length(), 21);
			r.p:= pos;
		END SetPos;
	
	PROCEDURE (r: StdReader) Read;
		
		VAR
			
			l: LONGINT;
			c: Avl.Elem;
		
		BEGIN (*Read*)
			l:= r.s.Length();
			IF r.p> l THEN
				r.p:= l;
			END;
			r.eos:= r.p= l;
			IF r.eos THEN
				r.char:= eOS;
			ELSE
				r.s.chars.Find(r.p+ 1, c);
				ASSERT(c# NIL);
				r.char:= c(Char).c;
				INC(r.p);
			END;
		END Read;
	
	PROCEDURE (r: StdReader) ReadChar (VAR c: CHAR);
		
		BEGIN (*ReadChar*)
			r.Read;
			c:= r.char;
		END ReadChar;
	
	PROCEDURE (r: StdReader) ReadString (len: LONGINT; VAR s: ARRAY OF CHAR);
		
		VAR
			
			i, l: LONGINT;
			c: Avl.Elem;
		
		BEGIN (*ReadString*)
			i:= 0;
			IF len>= LEN(s) THEN
				len:= LEN(s)- 1;
			END;
			IF len> 0 THEN
				l:= r.s.Length();
				IF r.p> l THEN
					r.p:= l;
				END;
				r.s.chars.Find(r.p+ 1, c);
				WHILE (c# NIL) & (i< len) DO
					s[i]:= c(Char).c;
					c:= r.s.chars.Next(c);
					INC(r.p);
					INC(i);
				END;
				r.eos:= r.p= l;
				IF r.eos THEN
					r.char:= eOS;
				ELSE
					r.char:= s[i- 1];
				END;
			END;
			s[i]:= eOS;
		END ReadString;
	
	PROCEDURE (w: StdWriter) Base (): String;
		
		BEGIN (*Base*)
			RETURN w.s;
		END Base;
	
	PROCEDURE (w: StdWriter) Pos (): LONGINT;
		
		VAR
			
			l: LONGINT;
		
		BEGIN (*Pos*)
			l:= w.s.Length();
			IF w.p> l THEN
				w.p:= l;
			END;
			RETURN w.p;
		END Pos;
	
	PROCEDURE (w: StdWriter) SetPos (pos: LONGINT);
		
		BEGIN (*SetPos*)
			ASSERT(pos>=0, 20);
			ASSERT(pos<= w.s.Length(), 21);
			w.p:= pos;
		END SetPos;
	
	PROCEDURE (w: StdWriter) WriteChar (c: CHAR);
		
		VAR
			
			l: LONGINT;
			ch: Char;
			e: Avl.Elem;
		
		BEGIN (*WriteChar*)
			l:= w.s.Length();
			IF w.p> l THEN
				w.p:= l;
			END;
			IF w.p= l THEN
				NEW(ch);
				w.s.chars.Append(ch);
			ELSE
				w.s.chars.Find(w.p+ 1, e);
				ASSERT(e# NIL);
				ch:= e(Char);
			END;
			ch.c:= c;
			INC(w.p);
		END WriteChar;
	
	PROCEDURE (w: StdWriter) WriteString (s: ARRAY OF CHAR);
		
		VAR
			
			i, l: LONGINT;
			c: Char;
			e: Avl.Elem;
		
		BEGIN (*WriteString*)
			l:= w.s.Length();
			IF w.p> l THEN
				w.p:= l;
			END;
			i:= 0; l:= Strings.Length(s);
			w.s.chars.Find(w.p+ 1, e);
			WHILE i< l DO
				IF e= NIL THEN
					NEW(c);
					w.s.chars.Append(c);
				ELSE
					c:= e(Char);
				END;
				c.c:= s[i];
				INC(i);
				e:= w.s.chars.Next(c);
				INC(w.p);
			END;
		END WriteString;
	
	PROCEDURE (d: StdDirectory) New (): String;
		
		VAR
			
			s: StdString;
		
		BEGIN (*New*)
			NEW(s);
			Avl.New(s.chars);
			RETURN s;
		END New;
	
	(** Sets the dir global variable. *)
	PROCEDURE SetDir*(d: Directory);
		
		BEGIN (*SetDir*)
			dir:= d;
		END SetDir;
	
	PROCEDURE Init;
		
		VAR
			
			d: StdDirectory;
		
		BEGIN (*Init*)
			NEW(d);
			dir:= d;
			stdDir:= d;
		END Init;
	
	BEGIN (*TBoxExtStrings*)
		Init;
	END TBoxExtStrings.
BIER
/  /   .    <       g 
     C  Syntax10.Scn.Fnt 08.03.2002  23:55:20  TimeStamps.New  