TextDocs.NewDoc     :F   CColor     Flat  Locked  Controls  Org 
   BIER`   b        3     Syntax10.Scn.Fnt     Syntax12.Scn.Fnt     Oberon12.Scn.Fnt              T    
    	    P   
    )   1    6    ,            =             (*
TBox: Set of tools.

Copyright (C) 2001 Grard Meunier

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License  for more details.

You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*)

MODULE TBoxDir;
	
	 
	
	(** Directory utilities. *)
	
	IMPORT
				
		Display, Fonts, NPTBoxDir, Oberon, TextFrames, Texts;
	
	PROCEDURE OpenText(title: ARRAY OF CHAR; T: Texts.Text; system: BOOLEAN);
		
		VAR
			
			w: INTEGER;
		
		BEGIN	
			IF system THEN w := Display.Width DIV 8*3 ELSE w := 400 END;
			Oberon.OpenText(title, T, w, 240)
		END OpenText;
	
	PROCEDURE WriteK(VAR w: Texts.Writer;  k: LONGINT);
		
		VAR
			
			suffix: CHAR;
		
		BEGIN
			IF k < 100*1024 THEN suffix := "K"
			ELSIF k < 100*1024*1024 THEN suffix := "M"; k := k DIV 1024
			ELSE suffix := "G"; k := k DIV (1024*1024)
			END;
			Texts.WriteInt(w, k, 1);  Texts.Write(w, suffix);  Texts.Write(w, "B")
		END WriteK;
	
	(** List the files which match the mask parameter. *)
	PROCEDURE Directory*;
		
		VAR
			
			par: Oberon.ParList;
			R: Texts.Reader;
			T, t: Texts.Text;
			beg, end, time, count, total: LONGINT;
			i: INTEGER;
			ch: CHAR;
			pat: ARRAY 64 OF CHAR;
			flags: SET;
			f: NPTBoxDir.FileInfo;
			w: Texts.Writer;
		
		BEGIN (*Directory*)
			par:= Oberon.Par;
			Texts.OpenReader(R, par.text, par.pos);
			Texts.Read(R, ch);
			WHILE (ch<= " ") & (ch# 0DX) DO Texts.Read(R, ch) END;
			IF (ch = "^") OR (ch = 0DX) THEN
				Oberon.GetSelection(T, beg, end, time);
				IF time # -1 THEN
					Texts.OpenReader(R, T, beg); Texts.Read(R, ch);
					WHILE ch <= " " DO Texts.Read(R, ch) END
				END
			END;
			i := 0;
			WHILE ch > " " DO
				pat[i] := ch; INC(i); Texts.Read(R, ch)
			END;
			pat[i] := 0X;
			t := TextFrames.Text("");
			f:= NPTBoxDir.FileList(pat);
			Texts.OpenWriter(w);
			Texts.SetFont(w, Fonts.This("Courier10.Scn.Fnt"));
			count:= 0; total:= 0;
			WHILE f# NIL DO
				INC(count);
				Texts.WriteDate(w, f.time, f.date);
				Texts.Write(w, " ");
				Texts.WriteInt(w, f.size, 7);
				Texts.Write(w, " ");
				Texts.WriteString(w, f.name);
				INC(total, f.size);
				Texts.WriteLn(w);
				f:= f.next;
			END;
			Texts.SetFont(w, Fonts.Default);
			IF count > 1 THEN
				Texts.WriteLn(w);  Texts.WriteInt(w, count, 1); Texts.WriteString(w, " files");
				Texts.WriteString(w, " use "); WriteK(w, (total+1023) DIV 1024);
			END;
			Texts.WriteLn(w); Texts.Append(t, w.buf);
			OpenText("Directory", t, TRUE)
		END Directory;
	
	END TBoxDir.

TBoxDir.Directory ^;
*.ModBIERN
  _
   
    <       g 
     C  Syntax10.Scn.Fnt 30.03.2002  22:10:32  TimeStamps.New  