TextDocs.NewDoc     F   CColor     Flat  Locked  Controls  Org -(   BIER`   b        3  1   Oberon12.Scn.Fnt          Z   ]  (*
TBox: Set of tools.

Copyright (C) 2001 Grard Meunier

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License  for more details.

You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*)

MODULE TBoxAvl;
	
	(* *)
	
	(** This module implements balanced and threaded trees. *)
	
	CONST
		
		(** Results of comparison. *)
		inf*= -1; (** less than *)
		ega*= 0; (** equal *)
		sup*= +1; (** greater than *)
	
	TYPE
		
		ANYPTR*= POINTER TO RECORD
		END;
		
		Elem*= POINTER TO RECORD (** Element of a tree. *)
			left, right: Elem; (* Left and right links. *)
			lTag, rTag: BOOLEAN; (* Indicate if the corresponding links point to a child or to the next element. *)
			bal: SHORTINT; (* AVL balance (inf, ega or sup). *)
			rank: LONGINT; (* Rank in the tree. *)
			cop: Elem; (* Used to copy. *)
		END;
		
		Tree*= POINTER TO RECORD (** An AVL tree. *)
			root: Elem;
		END;
		
		VoidElem= POINTER TO RECORD (Elem)
		END;
	
	(** Compare e to el; returns inf if e< el, ega if e= el and sup if e> el. *)
	PROCEDURE (e: Elem) Compare-(el: Elem): SHORTINT;
		
		BEGIN (*Compare*)
			HALT(100);
			RETURN ega;
		END Compare;
	
	(** Used in Tree.WalkThrough; action on an element e, with parameter p, while traversing a tree in inorder. *)
	PROCEDURE (e:Elem) Do-(p: ANYPTR);
		
		BEGIN (*Do*)
			HALT(101);
		END Do;
	
	(** Copies and returns the element e. *)
	PROCEDURE (e: Elem) Copy-(): Elem;
		
		BEGIN (*Copy*)
			HALT(102);
			RETURN NIL;
		END Copy;
	
	(** Empties the tree t. *)
	PROCEDURE (t: Tree) Empty*;
		
		VAR
			
			e: VoidElem;
		
		BEGIN (*Empty*)
			NEW(e);
			e.left:= e;
			e.lTag:= FALSE;
			e.right:= e;
			e.rTag:= TRUE;
			t.root:= e;
		END Empty;
	
	(** Creates a new empty tree t. *)
	PROCEDURE New*(VAR t: Tree);
		
		BEGIN (*New*)
			NEW(t);
			t.Empty;
		END New;
	
	(** Tests if the tree t is valid. *)
	PROCEDURE (t: Tree) Valid*(): BOOLEAN;
		
		BEGIN (*Valid*)
			RETURN t.root# NIL;
		END Valid;
	
	(** Copies the tree t; the method Elem.Copy must be instantiated. *)
	PROCEDURE (t: Tree) Copy*(): Tree;
		
		VAR
			
			u: Tree;
		
		PROCEDURE Copie1 (e: Elem; t: BOOLEAN);
			
			BEGIN (*Copie1*)
				IF t THEN
					e.cop:= e.Copy();
					Copie1(e.left, e.lTag);
					Copie1(e.right, e.rTag);
				END;
			END Copie1;
		
		PROCEDURE Copie2 (e: Elem; t: BOOLEAN): Elem;
			
			VAR
				
				f: Elem;
			
			BEGIN (*Copie2*)
				f:= e.cop;
				IF t THEN
					f.lTag:= e.lTag;
					f.rTag:= e.rTag;
					f.bal:= e.bal;
					f.rank:= e.rank;
					f.left:= Copie2(e.left, e.lTag);
					f.right:= Copie2(e.right, e.rTag);
				END;
				RETURN f;
			END Copie2;
		
		BEGIN (*Copy*)
			ASSERT(t.root# NIL, 100);
			New(u);
			t.root.cop:= u.root;
			Copie1(t.root.left, t.root.lTag);
			u.root.left:= Copie2(t.root.left, t.root.lTag);
			u.root.lTag:= t.root.lTag;
			RETURN u;
		END Copy;
	
	PROCEDURE BalGI (VAR p: Elem; VAR h: BOOLEAN);
		
		VAR
			
			p1, p2: Elem;
		
		BEGIN (*BalGI*)
			CASE p.bal OF
				|sup:
					p.bal:= ega;
					h:= FALSE;
				|ega:
					p.bal:= inf;
				|inf:
					p1:= p.left;
					IF p1.bal= inf THEN
						IF p1.rTag THEN
							p.left:= p1.right;
						ELSE
							p.left:= p1;
						END;
						p.lTag:= p1.rTag;
						p1.right:= p;
						p1.rTag:= TRUE;
						p.bal:= ega;
						p1.bal:= ega;
						DEC(p.rank, p1.rank);
						p:= p1;
					ELSE
						p2:= p1.right;
						IF p2.lTag THEN
							p1.right:= p2.left;
						ELSE
							p1.right:= p2;
						END;
						p1.rTag:= p2.lTag;
						p2.left:= p1;
						p2.lTag:= TRUE;
						IF p2.rTag THEN
							p.left:= p2.right;
						ELSE
							p.left:= p2;
						END;
						p.lTag:= p2.rTag;
						p2.right:= p;
						p2.rTag:= TRUE;
						IF p2.bal= inf THEN
							p.bal:= sup;
						ELSE
							p.bal:= ega;
						END;
						IF p2.bal= sup THEN
							p1.bal:= inf;
						ELSE
							p1.bal:= ega;
						END;
						p2.bal:= ega;
						INC(p2.rank, p1.rank);
						DEC(p.rank, p2.rank);
						p:= p2;
					END;
					h:= FALSE;
			END;
		END BalGI;
	
	PROCEDURE BalDI (VAR p: Elem; VAR h: BOOLEAN);
		
		VAR
			
			p1, p2: Elem;
		
		BEGIN (*BalDI*)
			CASE p.bal OF
				|inf:
					p.bal:= ega;
					h:= FALSE;
				|ega:
					p.bal:= sup;
				|sup:
					p1:= p.right;
					IF p1.bal= sup THEN
						IF p1.lTag THEN
							p.right:= p1.left;
						ELSE
							p.right:= p1;
						END;
						p.rTag:= p1.lTag;
						p1.left:= p;
						p1.lTag:= TRUE;
						p.bal:= ega;
						p1.bal:= ega;
						INC(p1.rank, p.rank);
						p:= p1;
					ELSE
						p2:= p1.left;
						IF p2.rTag THEN
							p1.left:= p2.right;
						ELSE
							p1.left:= p2;
						END;
						p1.lTag:= p2.rTag;
						p2.right:= p1;
						p2.rTag:= TRUE;
						IF p2.lTag THEN
							p.right:= p2.left;
						ELSE
							p.right:= p2;
						END;
						p.rTag:= p2.lTag;
						p2.left:= p;
						p2.lTag:= TRUE;
						IF p2.bal= sup THEN
							p.bal:= inf;
						ELSE
							p.bal:= ega;
						END;
						IF p2.bal= inf THEN
							p1.bal:= sup;
						ELSE
							p1.bal:= ega;
						END;
						p2.bal:= ega;
						DEC(p1.rank, p2.rank);
						INC(p2.rank, p.rank);
						p:= p2;
					END;
					h:= FALSE;
			END;
		END BalDI;
	
	PROCEDURE BalGE (VAR p: Elem; VAR h: BOOLEAN);
		
		VAR
			
			p1, p2: Elem;
		
		BEGIN (*BalGE*)
			CASE p.bal OF
				|inf:
					p.bal:= ega;
				|ega:
					p.bal:= sup;
					h:= FALSE;
				|sup:
					p1:= p.right;
					IF p1.bal= inf THEN
						p2:= p1.left;
						IF p2.rTag THEN
							p1.left:= p2.right;
						ELSE
							p1.left:= p2;
						END;
						p1.lTag:= p2.rTag;
						p2.right:= p1;
						p2.rTag:= TRUE;
						IF p2.lTag THEN
							p.right:= p2.left;
						ELSE
							p.right:= p2;
						END;
						p.rTag:= p2.lTag;
						p2.left:= p;
						p2.lTag:= TRUE;
						IF p2.bal= sup THEN
							p.bal:= inf;
						ELSE
							p.bal:= ega;
						END;
						IF p2.bal= inf THEN
							p1.bal:= sup;
						ELSE
							p1.bal:= ega;
						END;
						p2.bal:= ega;
						DEC(p1.rank, p2.rank);
						INC(p2.rank, p.rank);
						p:= p2;
					ELSE
						IF p1.lTag THEN
							p.right:= p1.left;
						ELSE
							p.right:= p1;
						END;
						p.rTag:= p1.lTag;
						p1.left:= p;
						p1.lTag:= TRUE;
						IF p1.bal= ega THEN
							p.bal:= sup;
							p1.bal:= inf;
							h:= FALSE;
						ELSE
							p.bal:= ega;
							p1.bal:= ega;
						END;
						INC(p1.rank, p.rank);
						p:= p1;
					END;
			END;
		END BalGE;
	
	PROCEDURE BalDE (VAR p: Elem; VAR h: BOOLEAN);
		
		VAR
			
			p1, p2:Elem;
		
		BEGIN (*BalDE*)
			CASE p.bal OF
				|sup:
					p.bal:= ega;
				|ega:
					p.bal:= inf;
					h:= FALSE;
				|inf:
					p1:= p.left;
					IF p1.bal= sup THEN
						p2:= p1.right;
						IF p2.lTag THEN
							p1.right:= p2.left;
						ELSE
							p1.right:= p2;
						END;
						p1.rTag:= p2.lTag;
						p2.left:= p1;
						p2.lTag:= TRUE;
						IF p2.rTag THEN
							p.left:= p2.right;
						ELSE
							p.left:= p2;
						END;
						p.lTag:= p2.rTag;
						p2.right:= p;
						p2.rTag:= TRUE;
						IF p2.bal= inf THEN
							p.bal:= sup;
						ELSE
							p.bal:= ega;
						END;
						IF p2.bal= sup THEN
							p1.bal:= inf;
						ELSE
							p1.bal:= ega;
						END;
						p2.bal:= ega;
						INC(p2.rank, p1.rank);
						DEC(p.rank, p2.rank);
						p:= p2;
					ELSE
						IF p1.rTag THEN
							p.left:= p1.right;
						ELSE
							p.left:= p1;
						END;
						p.lTag:= p1.rTag;
						p1.right:= p;
						p1.rTag:= TRUE;
						IF p1.bal= ega THEN
							p.bal:= inf;
							p1.bal:= sup;
							h:= FALSE;
						ELSE
							p.bal:= ega;
							p1.bal:= ega;
						END;
						DEC(p.rank, p1.rank);
						p:= p1;
					END;
			END;
		END BalDE;
	
	PROCEDURE SupG (first: BOOLEAN; VAR r: Elem; VAR t: BOOLEAN; VAR s: Elem; VAR h: BOOLEAN);
		
		BEGIN (*SupG*)
			IF ~r.rTag THEN
				s:= r;
				t:= r.lTag;
				IF t OR first THEN
					r:= r.left;
				END;
				h:= TRUE;
			ELSE
				SupG(FALSE, r.right, r.rTag, s, h);
				IF h THEN
					BalDE(r, h);
				END;
			END;
		END SupG;
	
	PROCEDURE SupD (first: BOOLEAN; VAR r: Elem; VAR t: BOOLEAN; VAR s: Elem; VAR h: BOOLEAN);
		
		BEGIN (*SupD*)
			IF ~r.lTag THEN
				s:= r;
				t:= r.rTag;
				IF t OR first THEN
					r:= r.right;
				END;
				h:= TRUE;
			ELSE
				SupD(FALSE, r.left, r.lTag, s, h);
				DEC(r.rank);
				IF h THEN
					BalGE(r, h);
				END;
			END;
		END SupD;
	
	(** Searches the element key in the sorted tree t; if key is found, returns TRUE, else key is inserted in the tree; rank returns the rank of key in the tree; Elem.Compare must be instantiated. *)
	PROCEDURE (t: Tree) SearchIns*(VAR key: Elem; VAR rank: LONGINT): BOOLEAN;
		
		VAR
			
			h, found: BOOLEAN;
		
		PROCEDURE Ins (q: Elem; l: BOOLEAN; VAR p: Elem; VAR t: BOOLEAN);
			
			VAR
				
				p1, p2: Elem;
			
			BEGIN (*Ins*)
				IF ~t THEN
					found:= FALSE;
					h:= TRUE;
					t:= TRUE;
					IF l THEN
						key.left:= p;
						key.right:= q;
					ELSE
						key.right:= p;
						key.left:= q;
					END;
					p:= key;
					p.lTag:= FALSE;
					p.rTag:= FALSE;
					p.bal:= ega;
					p.rank:= 1;
					rank:= 1;
				ELSE
					CASE key.Compare(p) OF
						|inf:
							Ins(p, TRUE, p.left, p.lTag);
							IF ~found THEN
								INC(p.rank);
							END;
							IF h THEN
								BalGI(p, h);
							END;
						|sup:
							Ins(p, FALSE, p.right, p.rTag);
							INC(rank, p.rank);
							IF h THEN
								BalDI(p, h);
							END;
						|ega:
							h:= FALSE;
							found:= TRUE;
							key:= p;
							rank:= p.rank;
					END;
				END;
			END Ins;
		
		BEGIN (*SearchIns*)
			ASSERT(t.root# NIL, 100);
			Ins(t. root, TRUE, t.root.left, t.root.lTag);
			RETURN found;
		END SearchIns;
	
	(** Searches the element key in the sorted tree t; if key is found, returns TRUE; rank returns the rank of key in the tree, or 0 if not found; Elem.Compare must be instantiated. *)
	PROCEDURE (t: Tree) Search*(VAR key: Elem; VAR rank: LONGINT): BOOLEAN;
		
		VAR
			
			tag: BOOLEAN;
			val: Elem;
		
		BEGIN (*Search*)
			ASSERT(t.root# NIL, 100);
			tag:= t.root.lTag;
			val:= t.root.left;
			rank:= 0;
			LOOP
				IF ~tag THEN
					rank:= 0;
					RETURN FALSE;
				ELSE
					CASE key.Compare(val) OF
						|inf:
							tag:= val.lTag;
							val:= val.left;
						|ega:
							INC(rank, val.rank);
							key:= val;
							RETURN TRUE;
						|sup:
							INC(rank, val.rank);
							tag:= val.rTag;
							val:= val.right;
					END;
				END;
			END;
		END Search;
	
	PROCEDURE FixThreadL (p, q: Elem);
		
		BEGIN (*FixThreadL*)
			WHILE p.lTag DO
				p:= p.left;
			END;
			p.left:= q;
		END FixThreadL;
	
	PROCEDURE FixThreadR (p, q: Elem);
		
		BEGIN (*FixThreadR*)
			WHILE p.rTag DO
				p:= p.right;
			END;
			p.right:= q;
		END FixThreadR;
	
	(** Erases the element key in the sorted tree t; returns TRUE if key is found, else does nothing; Elem.Compare must be instantiated. *)
	PROCEDURE (t: Tree) Delete*(key: Elem): BOOLEAN;
		
		VAR
			
			h, found: BOOLEAN;
		
		PROCEDURE Supprime (l: BOOLEAN; VAR p: Elem; VAR t: BOOLEAN);
			
			VAR
				
				s: Elem;
			
			BEGIN (*Supprime*)
				IF ~t THEN
					found:= FALSE;
					h:= FALSE;
				ELSE
					CASE key.Compare(p) OF
						|inf:
							Supprime(TRUE, p.left, p.lTag);
							IF found THEN
								DEC(p.rank);
							END;
							IF h THEN
								BalGE(p, h);
							END;
						|sup:
							Supprime(FALSE, p.right, p.rTag);
							IF h THEN
								BalDE(p, h);
							END;
						|ega:
							found:= TRUE;
							IF ~p.lTag THEN
								IF p.rTag THEN
									FixThreadL(p.right, p.left);
									p:= p.right;
								ELSE
									IF l THEN
										p:= p.left;
									ELSE
										p:= p.right;
									END;
									t:= FALSE;
								END;
								h:= TRUE;
							ELSIF ~p.rTag THEN
								FixThreadR(p.left, p.right);
								p:= p.left;
								h:= TRUE;
							ELSE
								s:= p;
								SupG(TRUE, s.left, s.lTag, p, h);
								p.left:= s.left;
								p.lTag:= s.lTag;
								p.right:= s.right;
								p.rTag:= s.rTag;
								p.bal:= s.bal;
								p.rank:= s.rank- 1;
								FixThreadL(p.right, p);
								IF h THEN
									BalGE(p, h);
								END;
							END;
					END;
				END;
			END Supprime;
		
		BEGIN (*Delete*)
			ASSERT(t.root# NIL, 100);
			Supprime(TRUE, t.root.left, t.root.lTag);
			RETURN found;
		END Delete;
	
	PROCEDURE NOE (p: Elem; tag: BOOLEAN): LONGINT;
		
		VAR
			
			n: LONGINT;
		
		BEGIN (*NOE*)
			n:= 0;
			WHILE tag DO
				INC(n, p.rank);
				tag:= p.rTag;
				p:= p.right;
			END;
			RETURN n;
		END NOE;
	
	(** Returns the number of elements in the tree t. *)
	PROCEDURE (t: Tree) NumberOfElems*(): LONGINT;
		
		BEGIN (*NumberOfElems*)
			ASSERT(t.root# NIL, 100);
			RETURN NOE(t.root.left, t.root.lTag);
		END NumberOfElems;
	
	PROCEDURE Ins (pos: LONGINT; key, q: Elem; l: BOOLEAN; VAR p: Elem; VAR t: BOOLEAN; VAR h: BOOLEAN);
		
		BEGIN (*Ins*)
			IF ~t THEN
				h:= TRUE;
				t:= TRUE;
				IF l THEN
					key.left:= p;
					key.right:= q;
				ELSE
					key.right:= p;
					key.left:= q;
				END;
				p:= key;
				p.lTag:= FALSE;
				p.rTag:= FALSE;
				p.bal:= ega;
				p.rank:= 1;
			ELSIF pos<= p.rank THEN
				Ins(pos, key, p, TRUE, p.left, p.lTag, h);
				INC(p.rank);
				IF h THEN
					BalGI(p, h);
				END;
			ELSE
				DEC(pos, p.rank);
				Ins(pos, key, p, FALSE, p.right, p.rTag, h);
				IF h THEN
					BalDI(p, h);
				END;
			END;
		END Ins;
	
	(** Inserts the element key at the position rank in the tree t; the first rank of the tree is 1. *)
	PROCEDURE (t: Tree) Insert*(key: Elem; rank: LONGINT);
		
		VAR
			
			h: BOOLEAN;
		
		BEGIN (*Insert*)
			ASSERT(t.root# NIL, 100);
			Ins(rank, key, t.root, TRUE, t.root.left, t.root.lTag, h);
		END Insert;
	
	(** Inserts the element key at the beginning of the tree t. *)
	PROCEDURE (t: Tree) Prepend*(key: Elem);
		
		BEGIN (*Prepend*)
			t.Insert(key, 0);
		END Prepend;
	
	(** Inserts the element key at the end of the tree t. *)
	PROCEDURE (t: Tree) Append*(key: Elem);
		
		BEGIN (*Append*)
			t.Insert(key, MAX(LONGINT));
		END Append;
	
	(** Erases the element of position rank in the tree t; rank must verify 1<= rank<= t.NumberOfElems(), otherwise a trap 101 happens. *)
	PROCEDURE (t:  Tree) Erase*(rank: LONGINT);
		
		VAR
			
			h: BOOLEAN;
		
		PROCEDURE Supprime (l: BOOLEAN; VAR p: Elem; VAR t: BOOLEAN);
			
			VAR
				
				s: Elem;
			
			BEGIN (*Supprime*)
				IF ~t THEN
					HALT(101);
				ELSIF rank< p.rank THEN
					Supprime(TRUE, p.left, p.lTag);
					DEC(p.rank);
					IF h THEN
						BalGE(p, h);
					END;
				ELSIF rank> p.rank THEN
					DEC(rank, p.rank);
					Supprime(FALSE, p.right, p.rTag);
					IF h THEN
						BalDE(p, h);
					END;
				ELSIF ~p.lTag THEN
					IF p.rTag THEN
						FixThreadL(p.right, p.left);
						p:= p.right;
					ELSE
						IF l THEN
							p:= p.left;
						ELSE
							p:= p.right;
						END;
						t:= FALSE;
					END;
					h:= TRUE;
				ELSIF ~p.rTag THEN
					FixThreadR(p.left, p.right);
					p:= p.left;
					h:= TRUE;
				ELSE
					s:= p;
					SupG(TRUE, s.left, s.lTag, p, h);
					p.left:= s.left;
					p.lTag:= s.lTag;
					p.right:= s.right;
					p.rTag:= s.rTag;
					p.bal:= s.bal;
					p.rank:= s.rank- 1;
					FixThreadL(p.right, p);
					IF h THEN
						BalGE(p, h);
					END;
				END;
			END Supprime;
		
		BEGIN (*Erase*)
			ASSERT(t.root# NIL, 100);
			Supprime(TRUE, t.root.left, t.root.lTag);
		END Erase;
	
	(** Finds and returns in val the element of position rank in the tree t; if the element does not exist, val returns NIL. *)
	PROCEDURE (t: Tree) Find*(rank: LONGINT; VAR val: Elem);
		
		VAR
			
			tag: BOOLEAN;
		
		BEGIN (*Find*)
			ASSERT(t.root# NIL, 100);
			tag:= t.root.lTag;
			val:= t.root.left;
			LOOP
				IF ~tag THEN
					val:= NIL;
					EXIT;
				ELSIF rank< val.rank THEN
					tag:= val.lTag;
					val:= val.left;
				ELSIF rank> val.rank THEN
					DEC(rank, val.rank);
					tag:= val.rTag;
					val:= val.right;
				ELSE
					EXIT;
				END;
			END;
		END Find;
	
	PROCEDURE FixRootL (root: Elem);
		
		BEGIN (*FixRootL*)
			FixThreadL(root, root);
		END FixRootL;
	
	PROCEDURE FixRootR (root: Elem);
		
		BEGIN (*FixRootR*)
			IF root.lTag THEN
				FixThreadR(root.left, root);
			ELSE
				root.left:= root;
			END;
		END FixRootR;
	
	PROCEDURE Height (e: Elem; t: BOOLEAN): LONGINT;
		
		VAR
			
			h: LONGINT;
			j: Elem;
		
		BEGIN (*Height*)
			h:= 0;
			WHILE t DO
				INC(h);
				CASE e.bal OF
					|inf, ega:
						t:= e.lTag;
						e:= e.left;
					|sup:
						t:= e.rTag;
						e:= e.right;
				END;
			END;
			RETURN h;
		END Height;
	
	PROCEDURE AttacheG (q1, p1: Elem; t1: BOOLEAN; h1: LONGINT; j: Elem; VAR p2: Elem; VAR t2: BOOLEAN; h2: LONGINT; q2: Elem; VAR h: BOOLEAN);
		
		BEGIN (*AttacheG*)
			ASSERT((t1= (h1> 0)) & (t2= (h2> 0)));
			IF h2> h1+ 1 THEN
				IF p2.bal= sup THEN
					DEC(h2);
				END;
				AttacheG(q1, p1, t1, h1, j, p2.left, p2.lTag, h2- 1, p2, h);
				INC(p2.rank, j.rank);
				IF h THEN
					BalGI(p2, h);
				END;
			ELSE
				h:= TRUE;
				IF t2 THEN
					j.right:= p2;
				ELSE
					j.right:= q2;
				END;
				j.rTag:= t2;
				IF t1 THEN
					j.left:= p1;
				ELSE
					j.left:= q1;
				END;
				j.lTag:= t1;
				IF h1= h2 THEN
					j.bal:= ega;
				ELSE
					j.bal:= sup;
				END;
				j.rank:= NOE(p1, t1)+ 1;
				IF t1 THEN 
					FixThreadR(p1, j);
				END;
				IF t2 THEN
					FixThreadL(p2, j);
				END;
				p2:= j;
				t2:= TRUE;
			END;
		END AttacheG;
	
	PROCEDURE AttacheD (q1: Elem; VAR p1: Elem; VAR t1: BOOLEAN; h1: LONGINT; j: Elem; p2: Elem; t2: BOOLEAN; h2: LONGINT; q2: Elem; VAR h: BOOLEAN);
		
		BEGIN (*AttacheD*)
			ASSERT((t1= (h1> 0)) & (t2= (h2> 0)));
			IF h1> h2+ 1 THEN
				IF p1.bal= inf THEN
					DEC(h1);
				END;
				AttacheD(p1, p1.right, p1.rTag, h1- 1, j, p2, t2, h2, q2, h);
				IF h THEN
					BalDI(p1, h);
				END;
			ELSE
				h:= TRUE;
				IF t1 THEN
					j.left:= p1;
				ELSE
					j.left:= q1;
				END ;
				j.lTag:= t1;
				IF t2 THEN
					j.right:= p2;
				ELSE
					j.right:= q2;
				END;
				j.rTag:= t2;
				IF h1= h2 THEN
					j.bal:= ega;
				ELSE
					j.bal:= inf;
				END;
				j.rank:= NOE(p1, t1)+ 1;
				IF t1 THEN 
					FixThreadR(p1, j);
				END;
				IF t2 THEN 
					FixThreadL(p2, j);
				END;
				p1:= j;
				t1:= TRUE;
			END;
		END AttacheD;
	
	(** Concatenates the trees t1 and t2; on output returns the result in t1, and t2 is no more valid. *)
	PROCEDURE (t1: Tree) Cat*(t2: Tree);
		
		VAR
			
			h: BOOLEAN;
			j: Elem;
			h1, h2: LONGINT;
		
		PROCEDURE EffaceG (VAR p: Elem; VAR t: BOOLEAN);
			
			BEGIN (*EffaceG*)
				IF p.lTag THEN
					EffaceG(p.left, p.lTag);
					DEC(p.rank);
					IF h THEN
						BalGE(p, h);
					END;
				ELSE
					j:= p;
					IF p.rTag THEN
						FixThreadL(p.right, p.left);
						p:= p.right;
					ELSE
						p:= p.left;
						t:= FALSE;
					END;
					h:= TRUE;
				END;
			END EffaceG;
		
		PROCEDURE EffaceD (VAR p: Elem; VAR t: BOOLEAN);
			
			BEGIN (*EffaceD*)
				IF p.rTag THEN
					EffaceD(p.right, p.rTag);
					IF h THEN
						BalDE(p, h);
					END;
				ELSE
					j:= p;
					IF p.lTag THEN
						FixThreadR(p.left, p.right);
						p:= p.left;
					ELSE
						p:= p.right;
						t:= FALSE;
					END;
					h:= TRUE;
				END;
			END EffaceD;
		
		BEGIN (*Cat*)
			ASSERT(t1.root# NIL, 100); ASSERT(t2.root# NIL, 101); ASSERT(t1# t2, 102);
			IF t2.root.lTag THEN
				IF ~t1.root.lTag THEN
					t1.root:= t2.root;
				ELSE
					h1:= Height(t1.root.left, t1.root.lTag);
					h2:= Height(t2.root.left, t2.root.lTag);
					IF h1< h2 THEN
						EffaceD(t1.root.left, t1.root.lTag);
						IF h THEN
							DEC(h1);
						END;
						AttacheG(t2.root, t1.root.left, t1.root.lTag, h1, j, t2.root.left, t2.root.lTag, h2, t2.root, h);
						t1.root:= t2.root;
						FixRootL(t1.root);
					ELSE
						EffaceG(t2.root.left, t2.root.lTag);
						IF h THEN
							DEC(h2);
						END;
						AttacheD(t1.root, t1.root.left, t1.root.lTag, h1, j, t2.root.left, t2.root.lTag, h2, t1.root, h);
						FixRootR(t1.root);
					END;
				END;
			END;
			t2.root:= NIL;
		END Cat;
	
	(** Splits the tree t1 after the element of rank after; the result is returned in t1 and t2. *)
	PROCEDURE (t1: Tree) Split*(after: LONGINT; VAR t2: Tree);
		
		VAR
			
			e1, e2: Elem;
			tag1, tag2: BOOLEAN;
			h1, h2, hh: LONGINT;
		
		PROCEDURE DoSplit (p: Elem; t: BOOLEAN);
			
			VAR
				
				h, b: BOOLEAN;
				he: LONGINT;
				s: Elem;
			
			BEGIN (*DoSplit*)
				IF after< p.rank THEN
					DoSplit(p.left, p.lTag);
					INC(hh);
					IF p.bal= sup THEN
						INC(hh);
					END;
					he:= hh- 1;
					IF p.bal= inf THEN
						DEC(he);
					END;
					s:= p.right; b:= p.rTag;
					IF h2< he THEN
						AttacheG(t2.root, e2, tag2, h2, p, s, b, he, t2.root, h);
						e2:= s; tag2:= b; h2:= he;
					ELSE
						AttacheD(t2.root, e2, tag2, h2, p, s, b, he, t2.root, h);
					END;
					IF h THEN
						INC(h2);
					END;
				ELSIF after> p.rank THEN
					DEC(after, p.rank);
					DoSplit(p.right, p.rTag);
					INC(hh);
					IF p.bal= inf THEN
						INC(hh);
					END;
					he:= hh- 1;
					IF p.bal= sup THEN
						DEC(he);
					END;
					s:= p.left; b:= p.lTag;
					IF he< h1 THEN
						AttacheG(t1.root, s, b, he, p, e1, tag1, h1, t1.root, h);
					ELSE
						AttacheD(t1.root, s, b, he, p, e1, tag1, h1, t1.root, h);
						e1:= s; tag1:= b; h1:= he;
					END;
					IF h THEN
						INC(h1);
					END;
				ELSE
					hh:= Height(p, t);
					h1:= hh- 1; h2:= h1;
					CASE p.bal OF
						|inf: DEC(h2);
						|ega:
						|sup: DEC(h1);
					END;
					e1:= p.left; tag1:= p.lTag;
					e2:= p.right; tag2:= p.rTag;
					Ins(MAX(LONGINT), p, t1.root, TRUE, e1, tag1, h);
					IF h THEN
						INC(h1);
					END;
				END;
			END DoSplit;
		
		BEGIN (*Split*)
			ASSERT(t1.root# NIL, 100);
			New(t2);
			IF after< t1.NumberOfElems() THEN
				IF after<= 0 THEN
					t2.root:= t1.root;
					t1.Empty;
				ELSE
					DoSplit(t1.root.left, t1.root.lTag);
					t1.root.left:= e1; t1.root.lTag:= tag1;
					t2.root.left:= e2; t2.root.lTag:= tag2;
					FixRootL(t1.root); FixRootR(t1.root);
					FixRootL(t2.root); FixRootR(t2.root);
				END;
			END;
		END Split;
	
	(** Traverses the tree t in inorder and calls the method Elem.Do, with p as parameter, on each element; the method Elem.Do must be instantiated. *)
	PROCEDURE (t: Tree) WalkThrough*(p: ANYPTR);
		
		PROCEDURE Avance (e: Elem; t: BOOLEAN);
			
			BEGIN (*Avance*)
				IF t THEN
					Avance(e.left, e.lTag);
					e.Do(p);
					Avance(e.right, e.rTag);
				END;
			END Avance;
		
		BEGIN (*WalkThrough*)
			ASSERT(t.root# NIL, 100);
			Avance(t.root.left, t.root.lTag);
		END WalkThrough;
	
	(** Returns the element following e in the tree t; if e= NIL, the first element is returned; if e is the last element of the tree, NIL is returned. *)
	PROCEDURE (t: Tree) Next*(e: Elem): Elem;
		
		VAR
			
			tag: BOOLEAN;
		
		BEGIN (*Next*)
			ASSERT(t.root# NIL, 100);
			IF e= NIL THEN
				e:= t.root;
			END;
			tag:= e.rTag;
			e:= e.right;
			IF tag THEN
				WHILE e.lTag DO
					e:= e.left;
				END;
			END;
			IF e= t.root THEN
				RETURN NIL;
			END;
			RETURN e;
		END Next;
	
	(** Returns the element preceding e in the tree t; if e= NIL, the last element is returned; if e is the first element of the tree, NIL is returned. *)
	PROCEDURE (t: Tree) Previous*(e: Elem): Elem;
		
		VAR
			
			tag: BOOLEAN;
		
		BEGIN (*Previous*)
			ASSERT(t.root# NIL, 100);
			IF e= NIL THEN
				e:= t.root;
			END;
			tag:= e.lTag;
			e:= e.left;
			IF tag THEN
				WHILE e.rTag DO
					e:= e.right;
				END;
			END;
			IF e= t.root THEN
				RETURN NIL;
			END;
			RETURN e;
		END Previous;
	
	END TBoxAvl.
BIER^  ^   @^    :       f 
     C  Oberon10.Scn.Fnt 13.06.02  13:25:12  TimeStamps.New  