TextDocs.NewDoc     TF   CColor     Flat  Locked  Controls  Org      BIER`   b        3  h   Syntax10.Scn.Fnt     Syntax12.Scn.Fnt     Oberon12.Scn.Fnt                 {  (*
TBox: Set of tools.

Copyright (C) 2001 Grard Meunier

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License  for more details.

You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*)

MODULE TBoxAlea;
	
	 
	
	(** Pseudo-random number generator. *)
	
	IMPORT
		
		Oberon;
	
	CONST
		
		rLong= 97;
		m1= 259200; ia1= 7141; ic1= 54773; rm1= 1./ m1;
		m2= 134456; ia2= 8121; ic2= 28411; rm2= 1./ m2;
		m3= 243000; ia3= 4561; ic3= 51349;
	
	TYPE
		
		R= ARRAY rLong OF REAL;
	
	VAR
		
		ix1, ix2, ix3: LONGINT;
		r: R;
	
	(** Generates a new pseudo-random real number x such that 0<= x< 1, with a uniforme deviate. *)
	PROCEDURE Random*(): REAL;
		
		VAR
			
			res: REAL;
			j: LONGINT;
		
		BEGIN (*Random*)
			ix1:= (ia1* ix1+ ic1) MOD m1;
			ix2:= (ia2* ix2+ ic2) MOD m2;
			ix3:= (ia3* ix3+ ic3) MOD m3;
			j:= (rLong* ix3) DIV m3;
			ASSERT((j>= 0) & (j< rLong));
			res:= r[j];
			r[j]:= (ix1+ ix2* rm2)* rm1;
			RETURN res;
		END Random;
	
	(** Initializes the pseudo-random number generator with seed. *)
	PROCEDURE Randomize*(seed: LONGINT);
		
		VAR
			
			j: LONGINT;
		
		BEGIN (*Randomize*)
			ix1:= (ic1- seed) MOD m1;
			ix1:= (ia1* ix1+ ic1) MOD m1;
			ix2:= ix1 MOD m2;
			ix1:= (ia1* ix1+ ic1) MOD m1;
			ix3:= ix1 MOD m3;
			FOR j:= 0 TO rLong- 1 DO
				ix1:= (ia1* ix1+ ic1) MOD m1;
				ix2:= (ia2* ix2+ ic2) MOD m2;
				r[j]:= (ix1+ ix2* rm2)* rm1;
			END;
		END Randomize;
	
	(* Initializes the generator with a random seed. *)
	PROCEDURE Init;
		
		VAR
			
			t, d: LONGINT;
		
		BEGIN (*Init*)
			Oberon.GetClock(t, d);
			Randomize(t);
		END Init;
	
	BEGIN (*TBoxAlea*)
		Init;
	END TBoxAlea.BIER	  	   \	    <       g 
     C  Syntax10.Scn.Fnt 08.03.2002  23:18:52  TimeStamps.New  