TextDocs.NewDoc     F   CColor     Flat  Locked  Controls  Org B   BIER`   b        3         Oberon14.Scn.Fnt             Oberon14i.Scn.Fnt                      $        *        
            
                    H            
        	           	                H                            	            9        '        d       _    	    $                                        =    
        	    j                =    
        	      Oberon12.Scn.Fnt              )                      *            
                                	           1    	    d        )                |    
    9    	            [        (        _               	                4            E   (*
Regul: a lexical analyzer.

 c Grard MEUNIER 1990

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

MODULE RegulFindApi;
	
	
	
	(** CpcRegulFindApi implements the Find type, which provides the possibility to search a regular expression in a text.
To do so, you first implement the abstract, extensible and/or empty methods of an extension of InOut; then, you allocate an object (say io) of this extension type and you create a Find object (say f) with New(io, f). With f, you can repeatedly call f.Init to initialize or change the regular expression you are looking for and f.Next to search this expression in the text. *)
	
	IMPORT
		
		B:= BabelCompil, I:= BabelInterface, Strings; 

	CONST

		eOS= 0X;
		eOT*= B.eOF1; (** The character that must be returned by the InOut.Read method to indicate the end of the text processed. *)
	
	TYPE
		
		Ints= POINTER TO ARRAY OF LONGINT;
		
		Chaine*= POINTER TO ARRAY OF CHAR; (** A pointer to a string, that must be returned by the InOut.Map method. *)
		
		Directory1= POINTER TO RECORD (B.Directory)
			io: InOut;
		END;
		
		Compilation1= POINTER TO RECORD (B.Compilation)
			io: InOut;
			exp: Chaine;
			cur: LONGINT;
			n: ARRAY 2 OF LONGINT;
			c: ARRAY 2 OF Chaine;
			noCase: BOOLEAN;
		END;
		
		Face= POINTER TO RECORD (I.Face)
			num: LONGINT;
			c: Ints;
			n: LONGINT;
			s: Chaine;
		END;
		
		Directory2= POINTER TO RECORD (B.Directory)
			c: Ints;
			n: LONGINT;
		END;
		
		Compilation2= POINTER TO RECORD (B.Compilation)
			io: InOut;
			begin, len: LONGINT;
			co: B.Compiler;
			stop, pasPref: BOOLEAN;
		END;
		
		InOut*= POINTER TO RECORD (** Must be extended by the user. Contains a set of input/output methods that must or may be implemented by the user. For an example of implementation of these methods you can look at the file Regul/Mod/Find.odc. *)
			deb, eot, intBeg, intEnd: LONGINT;
		END;
		
		Find*= POINTER TO RECORD (** With an object f of type Find, you can repeatedly call f.Init to initialize or change the regular expression you are looking for and f.Next to search this expression in the text. *)
			io: InOut;
			co1,
			co2: B.Compiler;
			c2: Compilation2;
		END;
	
	(** Reads sequentially the integers contained in the file "Regul/Rsrc/Find.tbl" (tables of the compiler used by Regul). *)
	PROCEDURE (io: InOut) ReadInt-(VAR i: LONGINT);
		
		BEGIN (*ReadInt*)
			HALT(20);
		END ReadInt;
	
	(** Writes a message for a syntax error found in the regular expression contained in the exp parameter of the Find.Init method. Optional. pos is the position of the error (1 is the first position). src is the text of the regular expession. msg is the error message. *)
	PROCEDURE (io: InOut) Error-(pos: LONGINT;  src, msg: ARRAY OF CHAR);
		
		BEGIN (*Error*)
		END Error;
	
	(** Reads sequentially the characters of the scanned text. *)
	PROCEDURE (io: InOut) Read-(VAR ch: CHAR);
		
		BEGIN (*Read*)
			HALT(20);
		END Read;
	
	(** Returns the current reading position in the scanned text. *)
	PROCEDURE (io: InOut) Pos-(): LONGINT;
		
		BEGIN (*Pos*)
			HALT(20);
		END Pos;
	
	(** Sets the reading position in the scanned text. *)
	PROCEDURE (io: InOut) SetPos-(pos: LONGINT);
		
		BEGIN (*SetPos*)
			HALT(20);
		END SetPos;
	
	(** Maps the code in index to a more explicit text returned in the function result. The code should be found in the file Babel.Str, and translated with the procedure TBoxMapping.Map. The original Map method merely makes a copy of index. *)
	PROCEDURE (io: InOut) Map-(index: ARRAY OF CHAR): Chaine;
		
		VAR
			
			ch: Chaine;
		
		BEGIN (*Map*)
			NEW(ch, Strings.Length(index)+ 1);
			COPY(index, ch^);
			RETURN ch;
		END Map;
	
	(** Replaces c by its lowercase character if c is alphabetical. Must be implemented if you want to use the ignoreCase option of the Find.Next method. *)
	PROCEDURE (io: InOut) Lower-(VAR c: CHAR);
		
		BEGIN (*Lower*)
		END Lower;
	
	(** Replaces c by its uppercase character if c is alphabetical. Must be implemented if you want to use the ignoreCase option of the Find.Next method. *)
	PROCEDURE (io: InOut) Upper-(VAR c: CHAR);
		
		BEGIN (*Upper*)
		END Upper;
	
	PROCEDURE (d: Directory1) ReadInt (VAR i: LONGINT);
		
		BEGIN (*ReadInt*)
			d.io.ReadInt(i);
		END ReadInt;
	
	PROCEDURE (c: Compilation1) Read (VAR ch: CHAR);
		
		BEGIN (*Read*)
			ch:= c.exp[c.cur];
			IF ch= eOS THEN
				ch:= B.eOF1;
			END;
			INC(c.cur);
		END Read;
	
	PROCEDURE (c: Compilation1) Pos (): LONGINT;
		
		BEGIN (*Pos*)
			RETURN c.cur;
		END Pos;
	
	PROCEDURE (c: Compilation1) SetPos (pos: LONGINT);
		
		BEGIN (*SetPos*)
			c.cur:= pos;
		END SetPos;
	
	PROCEDURE (c: Compilation1) Map (index: ARRAY OF CHAR): B.Chaine;
		
		VAR
			
			c1: Chaine;
			c2: B.Chaine;
		
		BEGIN (*Map*)
			c1:= c.io.Map(index);
			NEW(c2, Strings.Length(c1^)+ 1);
			COPY(c1^, c2^);
			RETURN c2;
		END Map;

	PROCEDURE (c: Compilation1) Execution (n, nb: LONGINT; l: B.ObjectsList; VAR o: B.Object; VAR a: B.ANYPTR): BOOLEAN;
		
		CONST
			
			Return= 1;
			Value= 2;
			
			String= 1;
			Or= 2;
			Cat= 3;
			Star= 4;
			Plus= 5;
			Question= 6;
			Rep= 7;
			Set= 8;
			EOL= 9;
			Diff= 10;
			Union0= 11;
			Union1= 12;
			Union2= 13;
			Empty= 14;
			All= 15;
			Inter= 16;
			Letter= 17;
			Digit= 18;
			Chr= 19;
			Other= 20;
			Number= 21;
			Char= 22;
		
		TYPE
			
			Int= POINTER TO RECORD (B.ANYPTR)
				i: LONGINT;
			END;
		
		VAR
			
			o1, o2: B.Object;
			num: LONGINT;
			int: Int;
			s: Chaine;
		
		PROCEDURE Write (s: ARRAY OF CHAR);
			
			VAR
				
				l, i: LONGINT;
				b: BOOLEAN;
			
			BEGIN (*Write*)
				l:= Strings.Length(s); b:= c.c[num]# NIL;
				FOR i:= 0 TO l-1 DO
					IF b THEN
						c.c[num, c.n[num]]:= s[i];
					END;
					INC(c.n[num]);
				END;
			END Write;
		
		PROCEDURE Eval (o: B.Object);
			
			VAR
				
				s: Chaine;
				n1, n2: LONGINT;
				o1, o2: B.Object;
				b: BOOLEAN;
				a1, a2: B.ANYPTR;
			
			PROCEDURE Ecris (s: ARRAY OF CHAR; outSet: BOOLEAN);
				
				VAR
					
					i, n: LONGINT;
					ch: ARRAY 2 OF CHAR;
					cha: ARRAY 12 OF CHAR;
				
				PROCEDURE Cases (ch: CHAR; VAR cha: ARRAY OF CHAR);
					
					VAR
						
						cc: CHAR;
					
					BEGIN (*Cases*)
						cc:= ch;
						c.io.Lower(ch);
						c.io.Upper(cc);
						IF ch= cc THEN
							cha[0]:= ch; cha[1]:= eOS;
						ELSE
							IF outSet THEN
								COPY('"[" "," "]"', cha);
								cha[3]:= ch; cha[7]:= cc;
							ELSE
								COPY(' "," ', cha);
								cha[0]:= ch; cha[4]:= cc;
							END;
						END;
					END Cases;
				
				BEGIN (*Ecris*)
					IF s= '"' THEN
						Write("'");
						Write('"');
						Write("'");
					ELSE
						ch[1]:= eOS;
						Write('"');
						i:= 0; n:= Strings.Length(s);
						WHILE i< n DO
							IF s[i]= '"' THEN
								Write('"');
								Write("'");
								Write('"');
								Write("'");
								Write('"');
							ELSIF s[i]= "\" THEN
								INC(i); ASSERT(i< n);
								ch[0]:= s[i];
								Write(ch);
							ELSIF c.noCase THEN
								Cases(s[i], cha);
								Write(cha);
							ELSE
								ch[0]:= s[i];
								Write(ch);
							END;
							INC(i);
						END;
						Write('"');
					END;
				END Ecris;
			
			BEGIN (*Eval*)
				CASE o.ObjFunc() OF
					|String:
						o1:= o.ObjTermSon(1);
						NEW(s, o1.ObjStringLen()+ 1);
						o1.ObjString(s^);
						Ecris(s^, TRUE);
					|Or:
						Write("(");
						Eval(o.ObjTermSon(1));
						Write(")|(");
						Eval(o.ObjTermSon(2));
						Write(")");
					|Cat:
						Write("(");
						Eval(o.ObjTermSon(1));
						Write(")(");
						Eval(o.ObjTermSon(2));
						Write(")");
					|Star:
						Write("(");
						Eval(o.ObjTermSon(1));
						Write(")*");
					|Plus:
						Write("(");
						Eval(o.ObjTermSon(1));
						Write(")+");
					|Question:
						Write("(");
						Eval(o.ObjTermSon(1));
						Write(")?");
					|Rep:
						o1:= o.ObjTermSon(2); a1:= o1.ObjUser();
						o2:= o.ObjTermSon(3); a2:= o2.ObjUser();
						b:= a1(Int).i<= a2(Int).i;
						Write("(");
						Eval(o.ObjTermSon(1));
						Write(")<");
						IF b THEN
							Eval(o.ObjTermSon(4));
						ELSE
							Eval(o.ObjTermSon(5));
						END;
						Write(",");
						IF b THEN
							Eval(o.ObjTermSon(5));
						ELSE
							Eval(o.ObjTermSon(4));
						END;
						Write(">");
					|Set:
						Write("[");
						Eval(o.ObjTermSon(1));
						Write("]");
					|EOL:
						Write("$");
					|Diff:
						Eval(o.ObjTermSon(1));
						Write("^");
						Eval(o.ObjTermSon(2));
					|Union0:
						Eval(o.ObjTermSon(1));
						Eval(o.ObjTermSon(2));
					|Union1:
						Write(",");
						Eval(o.ObjTermSon(1));
						Eval(o.ObjTermSon(2));
					|Union2:
						Eval(o.ObjTermSon(1));
						Write(",");
						Eval(o.ObjTermSon(2));
					|Empty:
					|All:
						Write(".");
					|Inter:
						Eval(o.ObjTermSon(1));
						Write("-");
						Eval(o.ObjTermSon(2));
					|Letter:
						Write('"A"-"Z","a"-"z",""-""');
					|Digit:
						Write('"0"-"9"');
					|Chr:
						o1:= o.ObjTermSon(1); a1:= o1.ObjUser();
						IF a1(Int).i> ORD(MAX(CHAR)) THEN
							s:= c.io.Map("ATwoBig");
							c.io.Error(o1.Position(), c.exp^, s^);
							c.StopCompil;
						END;
						Write("#");
						Eval(o.ObjTermSon(2));
					|Other:
						Write('o');
					|Number:
						o1:= o.ObjTermSon(1);
						NEW(s, o1.ObjStringLen()+ 1);
						o1.ObjString(s^);
						Write(s^);
					|Char:
						o1:= o.ObjTermSon(1);
						NEW(s, o1.ObjStringLen()+ 1);
						o1.ObjString(s^);
						Ecris(s^, FALSE);
				END;
			END Eval;
		
		PROCEDURE Debut;
			
			VAR
				
				s: Chaine;
			
			BEGIN (*Debut*)
				s:= c.io.Map("BABEL"); Write(s^);
				Write(" A;");
				s:= c.io.Map("DEFINITION"); Write(s^);
				Write(' o=[.,#0,#26^"A"-"Z","a"-"z",""-"","0"-"9", "_"]|$;');
				s:= c.io.Map("LEXICON"); Write(s^);
				Write(" t=");
			END Debut;
		
		PROCEDURE Fin;
			
			VAR
				
				s: Chaine;
			
			BEGIN (*Fin*)
				Write(";c=.|$;");
				s:= c.io.Map("DECLARATION"); Write(s^);
				Write(" _t(v);S=^1;");
				s:= c.io.Map("GRAMMAR"); Write(s^);
				Write(" _t=;_t=_t t:$0.v=S($2);");
				s:= c.io.Map("AXIOM"); Write(s^);
				Write(" _t.");
			END Fin;
		
		PROCEDURE StrToInt (s: ARRAY OF CHAR; VAR n: LONGINT): BOOLEAN;
			
			VAR
				
				i: LONGINT;
			
			BEGIN (*StrToInt*)
				i:= 0; n:= 0;
				WHILE (s[i]# eOS) & (n<= (MAX(LONGINT)- ORD(s[i])+ ORD('0')) DIV 10) DO
					n:= n* 10+ (ORD(s[i])- ORD('0'));
					INC(i);
				END;
				RETURN s[i]= eOS;
			END StrToInt;

		BEGIN (*Execution*)
			o:= B.Parameter(l, 1);
			CASE n OF
				|Return:
					o1:= B.Parameter(l, 2);
					o2:= B.Parameter(l, 3);
					c.n[0]:= 0; c.n[1]:= 0;
					num:= 0;
					Debut;
					IF o1.ObjFunc()# Empty THEN
						Write("(");
						Eval(o1);
						Write(")");
					END;
					Write("(");
					Eval(o);
					Write(")");
					IF o2.ObjFunc()# Empty THEN
						Write("/");
						Eval(o2);
					END;
					Fin;
					IF o1.ObjFunc()# Empty THEN
						num:= 1;
						Debut;
						Eval(o1);
						Write("/");
						Write("(");
						Eval(o);
						Write(")");
						IF o2.ObjFunc()# Empty THEN
							Write("(");
							Eval(o2);
							Write(")");
						END;
						Fin;
					END;
				|Value:
					NEW(s, o.ObjStringLen()+ 1);
					o.ObjString(s^);
					NEW(int);
					IF ~StrToInt(s^, int.i) THEN
						s:= c.io.Map("ATwoBig");
						c.io.Error(o.Position(), c.exp^, s^);
						c.StopCompil;
					END;
					a:= int;
			END;
			RETURN TRUE;
		END Execution;

	PROCEDURE (c: Compilation1) Error (p, li, co: LONGINT;mes: ARRAY OF CHAR);

		BEGIN (*Error*)
			c.io.Error(p, c.exp^, mes);
		END Error;
		
	PROCEDURE (f: Face) BinInt (i: LONGINT);
		
		BEGIN (*BinInt*)
			IF f.c# NIL THEN
				f.c[f.num]:= i;
			END;
			INC(f.num);
		END BinInt;
	
	PROCEDURE (f: Face) Pos (): LONGINT;
		
		BEGIN (*Pos*)
			RETURN f.n;
		END Pos;
	
	PROCEDURE (f: Face) SetPos (pos: LONGINT);
		
		BEGIN (*SetPos*)
			f.n:= pos;
		END SetPos;
	
	PROCEDURE (f: Face) Read (VAR ch: CHAR);
		
		BEGIN (*Read*)
			IF f.n>= LEN(f.s) THEN
				ch:= I.eOF1;
			ELSE
				ch:= f.s[f.n];
				INC(f.n);
			END;
		END Read;
	
	PROCEDURE (d: Directory2) ReadInt (VAR i: LONGINT);
		
		BEGIN (*ReadInt*)
			i:= d.c[d.n];
			INC(d.n);
		END ReadInt;

	PROCEDURE (c: Compilation2) Read (VAR ch: CHAR);

		BEGIN (*Read*)
			c.io.Read(ch);
			IF (c.io.eot= MAX(LONGINT)) & ((ch= B.eOF1) OR (ch= B.eOF2)) THEN
				c.io.eot:= c.io.Pos();
			END;
		END Read;
	
	PROCEDURE (c: Compilation2) Pos (): LONGINT;
		
		BEGIN (*Pos*)
			RETURN c.io.Pos();
		END Pos;
	
	PROCEDURE (c: Compilation2) SetPos (pos: LONGINT);
		
		BEGIN (*SetPos*)
			c.io.SetPos(pos);
		END SetPos;

	PROCEDURE (c: Compilation2) Execution (n, nb: LONGINT; l: B.ObjectsList; VAR o: B.Object; VAR a: B.ANYPTR): BOOLEAN;
		
		VAR
			
			i, j, k, p: LONGINT;
			cc: Compilation2;
			res: BOOLEAN;
		
		PROCEDURE Select (i, j: LONGINT);
			
			BEGIN (*Select*)
				IF c.io.eot< j THEN
					j:= c.io.eot;
				END;
				IF j< i THEN
					i:=  j;
				END;
				c.io.intBeg:= i; c.io.intEnd:= j;
			END Select;

		BEGIN (*Execution*)
			c.StopCompil;
			o:= B.Parameter(l, 1);
			i:= o.Position()- 1+ c.begin;
			k:= o.ObjStringLen();
			IF c.len< 0 THEN
				c.begin:= i+ 1;
				IF c.co=NIL THEN
					c.stop:= i>= c.io.deb;
					IF c.stop THEN
						j:= i+ k;
						Select(i, j);
					END;
				ELSE
					p:= c.io.Pos();
					NEW(cc);
					cc.io:= c.io;
					cc.begin:= i;
					cc.io.SetPos(i);
					cc.len:= k;
					cc.stop:= TRUE;
					cc.pasPref:= TRUE;
					res:= cc.Compile(c.co, FALSE);
					c.io.SetPos(p);
					IF cc.stop THEN
						c.stop:= cc.pasPref;
						IF c.stop THEN
							j:= i+ k;
							Select(i, j);
						END;
					END;
				END;
			ELSE
				c.pasPref:= FALSE;
				IF i# c.begin THEN
					i:= c.begin;
					k:= 0;
				END;
				j:= i+ c.len;
				IF i+ k< j THEN
					i:= i+ k;
				ELSE
					i:= j;
				END;
				IF (i>= c.io.deb) & (i# j) THEN
					Select(i, j);
					c.stop:= FALSE;
				END;
			END;
			RETURN TRUE;
		END Execution;

	PROCEDURE (c: Compilation2) Error (p, li, co: LONGINT; mes: ARRAY OF CHAR);

		BEGIN (*Error*)
			HALT(20);
		END Error;
	
	(** Initialize f with the regular expression contained in exp. If ignoreCase is TRUE and if the methods Inout.Lower and Inout.Upper have been implemented, the case of the characters are ignored during the search; otherwise the search is case sensitive. Later, you can change the regular expression of f by calling Find.Init again. *)
	PROCEDURE (f: Find) Init*(exp: ARRAY OF CHAR; ignoreCase: BOOLEAN): BOOLEAN;
		
		TYPE
			
			Ints= POINTER TO ARRAY OF LONGINT;

		VAR

			c1: Compilation1;
			d2: Directory2;
			b: SHORTINT;
			res: BOOLEAN;
			fa: Face;
			nom: I.Chaine;

		BEGIN (*Init*)
			NEW(c1);
			c1.io:= f.io;
			c1.noCase:= ignoreCase;
			NEW(c1.exp, Strings.Length(exp)+ 1);
			COPY(exp, c1.exp^);
			c1.cur:= 0;
			IF ~c1.Compile(f.co1, FALSE) THEN
				f.c2:= NIL;
				RETURN FALSE;
			END;
			NEW(c1.c[0], c1.n[0]+ 1);
			IF c1.n[1]> 0 THEN
				NEW(c1.c[1], c1.n[1]+ 1);
			END;
			c1.cur:= 0;
			res:= c1.Compile(f.co1, FALSE);
			NEW(fa);
			fa.s:= c1.c[0]; fa.n:= 0;
			b:= fa.CompComp(nom);
			ASSERT(b= I.withoutDisp);
			fa.num:= 0;
			fa.OutComp;
			NEW(fa.c, fa.num);
			fa.num:= 0;
			fa.OutComp;
			NEW(d2);
			d2.c:= fa.c; d2.n:= 0;
			f.co2:=d2.ReadCompiler();
			NEW(f.c2);
			f.c2.io:= f.io;
			f.c2.begin:= 0;
			IF c1.n[1]> 0 THEN
				NEW(fa);
				fa.s:= c1.c[1]; fa.n:= 0;
				b:= fa.CompComp(nom);
				ASSERT(b= I.withoutDisp);
				fa.num:= 0;
				fa.OutComp;
				NEW(fa.c, fa.num);
				fa.num:= 0;
				fa.OutComp;
				d2.c:= fa.c;
				d2.n:= 0;
				f.c2.co:=d2.ReadCompiler();
			END;
			RETURN TRUE;
		END Init;
	
	(** Once f has been initialized to a regular expression by Find.Init, this method can be called one or several times to search the next occurrence in the scanned text. start is the starting position of the search. iBeg and iEnd are respectively the position of the first character of the next occurrence and the position of its last character plus 1; iBeg= iEnd iff the search is unsuccessful. The search is faster if newSearch is FALSE; but, in this case, the scanned text may not have been modified since the last search and start must be strictly greater than the last iBeg returned, otherwise the result is unpredictable; in all the other cases, call the method with newSearch= TRUE. *)
	PROCEDURE (f: Find) Next*(start: LONGINT; newSearch: BOOLEAN; VAR iBeg, iEnd: LONGINT);
		
		TYPE
			
			Ints= POINTER TO ARRAY OF LONGINT;

		VAR

			res: BOOLEAN;

		BEGIN (*Next*)
			ASSERT(f.c2# NIL, 20);
			f.io.eot:= MAX(LONGINT);
			f.io.deb:= start;
			f.io.intBeg:= 0; f.io.intEnd:= 0;
			IF f.c2.co= NIL THEN
				f.c2.begin:=f.io.deb;
			ELSIF newSearch THEN
				f.c2.begin:= 0;
			END;
			f.c2.len:= -1;
			REPEAT
				f.c2.stop:= TRUE;
				f.io.SetPos(f.c2.begin);
				res:= f.c2.Compile(f.co2, FALSE);
			UNTIL f.c2.stop;
			iBeg:= f.io.intBeg; iEnd:= f.io.intEnd;
			IF iBeg= iEnd THEN
				f.c2.begin:= 0;
			END;
		END Next;
	
	(** Creates a new object f of type Find. io is an instance of a user defined extension of type InOut. *)
	PROCEDURE New*(io: InOut; VAR f: Find);
		
		VAR
		
			d1: Directory1;
		
		BEGIN (*New*)
			NEW(d1);
			d1.io:= io;
			NEW(f);
			f.io:= io;
			f.co1:= d1.ReadCompiler();
		END New;
	
	END RegulFindApi.
BIER$J  NJ   I  I    "         d      d
     C  <       f 
     C  Oberon10.Scn.Fnt 30.03.2002  23:37:10  TextGadgets.NewStyleProc TimeStamps.New  