TextDocs.NewDoc     TF   CColor     Flat  Locked  Controls  Org    BIER`   b        3  X        Oberon12.Scn.Fnt          ,   Oberon12i.Scn.Fnt      (   ,,   (*
Regul: a lexical analyzer.

 c Grard MEUNIER 1990

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

MODULE RegulFind;
	
	
	
	(* User interface. Works with the panel Regul.Panel. *)
	
	IMPORT
		
		Attributes, Documents, Files, Fonts, Gadgets, M:= TBoxMapping, Oberon, Objects, Out, A:= RegulFindApi, Strings, TextFields, TextGadgets, TextGadgets0, Texts, S:= TBoxStrings;
	
	CONST
		
		viewCode= 2X;
	
	TYPE
		
		InOut= POINTER TO RECORD (A.InOut)
			rd: Files.Rider;
			r: Texts.Reader;
			t: Texts.Text;
		END;
	
	VAR
		
		f: A.Find;
		io: InOut;
	
	PROCEDURE (io: InOut) ReadInt (VAR i: LONGINT);
		
		BEGIN (*ReadInt*)
			Files.ReadLInt(io.rd, i);
		END ReadInt;
	
	PROCEDURE (io: InOut) Error (pos: LONGINT; src, msg: ARRAY OF CHAR);

		VAR

			s, ss: M.Chaine;
		
		BEGIN (*Error*)
			Out.Ln;
			Out.String('Regul ');
			s:= M.Map("#Regul:error", "", "", "");
			Out.String(s^); Out.String('...'); Out.Ln;
			NEW(ss, Strings.Length(src)+ 1);
			S.Extract(src, 0, pos-1, ss^);
			Out.String(ss^); Out.Ln;
			Out.String('...');
			s:= M.Map("#Regul:here", "", "", "");
			Out.String(s^); Out.String('----> ');
			S.Extract(src, pos-1, MAX(LONGINT), ss^);
			Out.String(ss^); Out.Ln;
			Out.String(msg);
			Out.Ln;
		END Error;
	
	PROCEDURE (io: InOut) Read (VAR ch: CHAR);
		
		BEGIN (*Read*)
			Texts.Read(io.r, ch);
			IF io.r.eot THEN
				ch:= A.eOT;
			ELSIF ~(io.r.lib IS Fonts.Font) THEN
				ch:= viewCode;
			END;
		END Read;
	
	PROCEDURE (io: InOut) Pos (): LONGINT;
		
		BEGIN (*Pos*)
			RETURN Texts.Pos(io.r);
		END Pos;
	
	PROCEDURE (io: InOut) SetPos (pos: LONGINT);
		
		BEGIN (*SetPos*)
			IF pos<= io.t.len THEN
				Texts.OpenReader(io.r, io.t, pos);
			END;
		END SetPos;
	
	PROCEDURE (io: InOut) Map (index: ARRAY OF CHAR): A.Chaine;
		
		VAR
			
			s: M.Chaine;
			ch: A.Chaine;
		
		BEGIN (*Map*)
			NEW(s, Strings.Length(index)+ 8);
			COPY("#Babel:", s^);
			Strings.Append(s^, index);
			s:= M.Map(s^, "", "", "");
			NEW(ch, Strings.Length(s^)+ 1);
			COPY(s^, ch^);
			RETURN ch;
		END Map;
	
	PROCEDURE (io: InOut) Lower (VAR c: CHAR);
		
		BEGIN (*Lower*)
			c:= Strings.LowerCh(c);
		END Lower;
	
	PROCEDURE (io: InOut) Upper (VAR c: CHAR);
		
		BEGIN (*Upper*)
			c:= Strings.UpperCh(c);
		END Upper;
	
	PROCEDURE NextI (): BOOLEAN;
		
		VAR
			
			beg, end: LONGINT;
			doc: Documents.Document;
			tF: TextGadgets.Frame;
		
		BEGIN (*NextI*)
			doc:= Documents.MarkedDoc();
			IF (doc# NIL) & (doc.dsc IS TextGadgets.Frame) THEN
				tF := doc.dsc(TextGadgets.Frame);
				IF tF.car THEN
					end:= tF.carpos.pos;
				ELSE
					end:= 0;
				END;
				io.t:= tF.text;
				f.Next(end, TRUE, beg, end);
				IF beg= end THEN
					TextGadgets0.RemoveSelection(tF); TextGadgets0.RemoveCaret(tF);
					RETURN FALSE;
				ELSE
					Oberon.Defocus;
					TextGadgets0.Locate(tF, end);
					TextGadgets0.SetSelection(tF, beg, end);
					RETURN TRUE;
				END;
			END;
		END NextI;
	
	PROCEDURE PreviousI (): BOOLEAN;

		VAR

			deb, beg, end, i, j: LONGINT;
			doc: Documents.Document;
			tF: TextGadgets.Frame;

		BEGIN (*PreviousI*)
			doc:= Documents.MarkedDoc();
			IF (doc# NIL) & (doc.dsc IS TextGadgets.Frame) THEN
				tF := doc.dsc(TextGadgets.Frame);
				IF tF.car THEN
					deb:= tF.carpos.pos;
				ELSE
					deb:= MAX(LONGINT);
				END;
				beg:= 0; end:= 0;
				i:= 0;
				io.t:= tF.text;
				f.Next(i, TRUE, i, j);
				WHILE (i< deb) & (i# j) DO
					beg:= i; end:= j;
					i:= j;
					f.Next(i, FALSE, i, j);
				END;
				IF beg= end THEN
					TextGadgets0.RemoveSelection(tF); TextGadgets0.RemoveCaret(tF);
					RETURN FALSE;
				ELSE
					Oberon.Defocus;
					TextGadgets0.Locate(tF, beg);
					TextGadgets0.SetSelection(tF, beg, end);
					RETURN TRUE;
				END;
			END;
		END PreviousI;
	
	PROCEDURE Suivant (reverse: BOOLEAN): BOOLEAN;
		
		BEGIN (*Suivant*)
			IF reverse THEN
				RETURN PreviousI();
			ELSE
				RETURN NextI();
			END;
		END Suivant;
	
	PROCEDURE SetExp(repl: BOOLEAN; VAR reverse: BOOLEAN; VAR replExp: ARRAY OF CHAR): BOOLEAN;
		
		VAR
			
			s: Texts.Scanner;
			ignoreCase: BOOLEAN;
			c: M.Chaine;
			o: Objects.Object;
			exp: ARRAY 64 OF CHAR;
		
		BEGIN (*SetExp*)
			reverse:= FALSE; ignoreCase:= FALSE;
			Texts.OpenScanner(s, Oberon.Par.text, Oberon.Par.pos);  Texts.Scan(s);
			WHILE (s.class= Texts.Char) & (s.c= "\") DO
				CASE CAP(s.nextCh) OF
					 "R":
						reverse:= TRUE;
					|"C":
						ignoreCase:= TRUE;
				END;
				WHILE s.nextCh>" " DO
					Texts.Read(s, s.nextCh);
				END;
				Texts.Scan(s);
			END;
			IF (s.class= Texts.Char) & (s.c= "=") THEN
				o:= Gadgets.FindObj(Gadgets.context, "Find");
				IF (o# NIL) & (o IS TextFields.TextField) THEN
					Attributes.GetString(o, "Value", exp);
					IF exp# "" THEN
						IF f.Init(exp, ignoreCase) THEN
							IF repl THEN
								o:= Gadgets.FindObj(Gadgets.context, "Repl");
								IF (o# NIL) & (o IS TextFields.TextField) THEN
									Attributes.GetString(o, "Value", replExp);
									RETURN TRUE;
								END;
								HALT(101);
							END;
							RETURN TRUE;
						END;
						c:= M.Map("#Regul:SyntaxError", "", "", "");
						Out.String(c^); Out.Ln;
					END;
					RETURN FALSE;
				END;
				HALT(100);
			ELSIF (s.class IN {Texts.Name, Texts.String}) & (s.s# "") THEN
				IF f.Init(s.s, ignoreCase) THEN
					IF repl THEN
						Texts.Scan(s);
						IF s.class IN {Texts.Name, Texts.String} THEN
							COPY(s.s, replExp);
							RETURN TRUE;
						END;
						RETURN FALSE;
					END;
					RETURN TRUE;
				END;
				c:= M.Map("#Regul:SyntaxError", "", "", "");
				Out.String(c^); Out.Ln;
			END;
			RETURN FALSE;
		END SetExp;
	
	PROCEDURE Next*;
		
		VAR
			
			b, reverse: BOOLEAN;
			s: ARRAY 1 OF CHAR;
		
		BEGIN (*Next*)
			b:= SetExp(FALSE, reverse, s) & Suivant(reverse);
		END Next;
	
	PROCEDURE Match (reverse: BOOLEAN): BOOLEAN;

		VAR

			i, j: LONGINT;
			doc: Documents.Document;
			tF: TextGadgets.Frame;
		
		BEGIN (*Match*)
			doc:= Documents.MarkedDoc();
			tF := doc.dsc(TextGadgets.Frame);
			IF ~(tF.car & tF.sel & (reverse & (tF.carpos.pos= tF.selbeg.pos) OR ~reverse & (tF.carpos.pos= tF.selend.pos))) THEN
				RETURN FALSE;
			END;
			f.Next(tF.selbeg.pos, TRUE, i, j);
			RETURN (i= tF.selbeg.pos) & (j= tF.selend.pos);
		END Match;
	
	PROCEDURE Remplace (replExp: ARRAY OF CHAR; reverse: BOOLEAN);
		
		VAR
			
			doc: Documents.Document;
			tF: TextGadgets.Frame;
			beg, end: LONGINT;
			r: Texts.Reader;
			w: Texts.Writer;
			c: CHAR;
		
		BEGIN (*Remplace*)
			doc:= Documents.MarkedDoc();
			tF := doc.dsc(TextGadgets.Frame);
			Texts.OpenReader(r, tF.text, tF.selbeg.pos);
			REPEAT
				Texts.Read(r, c);
			UNTIL r.eot OR (r.lib IS Fonts.Font);
			Texts.OpenWriter(w);
			IF ~r.eot THEN
				Texts.SetFont(w, r.lib(Fonts.Font));
				Texts.SetColor(w, r.col);
				Texts.SetOffset(w, r.voff);
			END;
			Texts.WriteString(w, replExp);
			Texts.Replace(tF.text, tF.selbeg.pos, tF.selend.pos, w.buf);
			beg:= tF.selbeg.pos;
			end:= beg+ Strings.Length(replExp);
			Gadgets.Update(tF);
			IF end> beg THEN
				TextGadgets0.SetSelection(tF, beg, end);
			END;
			IF reverse THEN
				TextGadgets0.Locate(tF, beg);
			ELSE
				TextGadgets0.Locate(tF, end);
			END;
		END Remplace;
	
	PROCEDURE Repl*;
		
		VAR
			
			reverse: BOOLEAN;
			replExp: ARRAY 64 OF CHAR;
			c: M.Chaine;
		
		BEGIN (*Repl*)
			IF SetExp(TRUE, reverse, replExp) THEN
				IF Match(reverse) THEN
					Remplace(replExp, reverse);
				ELSE
					c:= M.Map("#Regul:NoMatch", "", "", "");
					Out.String(c^); Out.Ln;
				END;
			END;
		END Repl;
	
	PROCEDURE ReplFd*;
		
		VAR
			
			reverse: BOOLEAN;
			replExp: ARRAY 64 OF CHAR;
			c: M.Chaine;
			b: BOOLEAN;
		
		BEGIN (*ReplFd*)
			IF SetExp(TRUE, reverse, replExp) THEN
				IF Match(reverse) THEN
					Remplace(replExp, reverse);
					b:= Suivant(reverse);
				ELSE
					c:= M.Map("#Regul:NoMatch", "", "", "");
					Out.String(c^); Out.Ln;
				END;
			END;
		END ReplFd;
	
	PROCEDURE ReplAll*;
		
		VAR
			
			reverse: BOOLEAN;
			replExp: ARRAY 64 OF CHAR;
			c: M.Chaine;
		
		BEGIN (*ReplAll*)
			IF SetExp(TRUE, reverse, replExp) THEN
				IF Match(reverse) THEN
					REPEAT
						Remplace(replExp, reverse);
					UNTIL ~Suivant(reverse);
				ELSE
					c:= M.Map("#Regul:NoMatch", "", "", "");
					Out.String(c^); Out.Ln;
				END;
			END;
		END ReplAll;
	
	PROCEDURE Beg*;
		
		VAR
			
			o: Objects.Object;
			exp1, exp2: ARRAY 64 OF CHAR;
		
		BEGIN (*Beg*)
			o:= Gadgets.FindObj(Gadgets.context, "Find");
			IF (o# NIL) & (o IS TextFields.TextField) THEN
				Attributes.GetString(o, "Value", exp1);
				exp2:= '[_]';
				Strings.Append(exp2, exp1);
				Attributes.SetString(o, "Value", exp2);
				Gadgets.Update(o);
			END;
		END Beg;
	
	PROCEDURE End*;
		
		VAR
			
			o: Objects.Object;
			exp: ARRAY 64 OF CHAR;
		
		BEGIN (*End*)
			o:= Gadgets.FindObj(Gadgets.context, "Find");
			IF (o# NIL) & (o IS TextFields.TextField) THEN
				Attributes.GetString(o, "Value", exp);
				Strings.Append(exp, '[_]');
				Attributes.SetString(o, "Value", exp);
				Gadgets.Update(o);
			END;
		END End;
	
	PROCEDURE InitFind*;

		VAR

			r: Texts.Reader;
			ch: CHAR;
			t: Texts.Text;
			beg, end, time, i, j: LONGINT;
			o: Objects.Object;
			s: A.Chaine;
		
		BEGIN (*InitFind*)
			Oberon.GetSelection(t, beg, end, time);
			IF time< 0 THEN
				RETURN;
			END;
			o:= Gadgets.FindObj(Gadgets.context, "Find");
			ASSERT((o# NIL) & (o IS TextFields.TextField), 100);
			Texts.OpenReader(r, t, beg);
			j:= 1;
			FOR i:= 0 TO end- beg- 1 DO
				Texts.Read(r, ch);
				CASE ch OF
					|viewCode:
					|'\',
					' ',
					'-',
					'^',
					'.',
					'#',
					'|',
					'*',
					'+',
					'?',
					'<',
					'>',
					'$',
					',',
					'(',
					')',
					'@',
					'%',
					'_',
					'[',
					']':
						INC(j, 2);
					|9X:
						INC(j, 3);
					ELSE
						INC(j);
				END;
			END;
			NEW(s, j);
			Texts.OpenReader(r, t, beg);
			j:= 0;
			FOR i:= 0 TO end- beg- 1 DO
				Texts.Read(r, ch);
				CASE ch OF
					|viewCode:
					|'\',
					' ',
					'-',
					'^',
					'.',
					'#',
					'|',
					'*',
					'+',
					'?',
					'<',
					'>',
					'$',
					',',
					'(',
					')',
					'@',
					'%',
					'_',
					'[',
					']':
						s[j]:= '\'; INC(j);
						s[j]:= ch; INC(j);
					|9X:
						s[j]:= '#'; INC(j);
						s[j]:= '9'; INC(j);
						s[j]:= ' '; INC(j);
					ELSE
						s[j]:= ch; INC(j);
				END;
			END;
			s[j]:= 0X;
			Attributes.SetString(o, "Value", s^);
			Gadgets.Update(o);
		END InitFind;
	
	PROCEDURE Init;
		
		VAR
		
			fi: Files.File;
		
		BEGIN (*Init*)
			fi:= Files.Old("RegulFind.Tbl");
			ASSERT(fi# NIL, 100);
			NEW(io);
			Files.Set(io.rd, fi, 0);
			A.New(io, f);
		END Init;
	
	BEGIN (*RegulFind*)
		Init;
	END RegulFind.
BIERk-  -   -  )-    "         d      d
     C  <       f 
     C  Oberon10.Scn.Fnt 30.03.2002  22:29:56  TextGadgets.NewStyleProc TimeStamps.New  