TextDocs.NewDoc     lF   CColor     Flat  Locked  Controls  Org    BIER`   b        3  T       Oberon8b.Scn.Fnt 	         Oberon10.Scn.Fnt     Oberon20b.Scn.Fnt         	 	                     Oberon12b.Scn.Fnt               D            Oberon10b.Scn.Fnt  	    ^    
    F    
                
            $                 6               M                       ~    
       
        
                       	       
    4       &           
             @         7        m               Syntax Regul Semantics

What is a regular expression?

A regular expression is recursively defined by the following rules:

-	A character is a regular expression; it corresponds to the string built with this character only.

-	The empty word is a regular expression; it corresponds to the empty string.

-	The "concatenation" of two regular expressions is a regular expression; it corresponds to the strings built with the concatenation of the strings corresponding to the two expressions.

-	The "union" of two regular expressions is a regular expression; it corresponds to the strings corresponding to one or the other of the two expressions.

-	The "repetition" of a regular expression is a regular expression; it corresponds to the concatenation, any times, and, may be, zero time, of strings corresponding to the initial expression; in particular, the repetition of any regular expression corresponds, among other things, to the empty string.

Regul uses the following notation:

-	A string of characters is a sequence of characters. The characters used in a string must be passive; if you want to use an active character in a string, you must first passivate it by adding "\" as a prefix: e.g. "\ " stands for a space (" ") and "\\" stands for "\". The list of active characters is given below.
A string corresponds to the concatenation of the characters it contains. A string containing only one character corresponds to this character. A character can be written too with a sharp (#) followed by an integer less than or equal to ORD(MAX(CHAR)) (=65535), i.e. the decimal ascii code of this character.
Example: "The\ quick\,\ bro#119 n\,\ and\ smart\ fox\." matches "The quick, brown, and smart fox.". Note the use of an active space after #119 (w), to separate the number and the string placed after it.

-	A period (.) corresponds to the union of all characters, but those which could be in an end of line (#13 and #14) or an end of text (#0 and #26).

-	Similarly, an at-sign (@) stands for all letters (equivalent to "A-Z, a-z, A-, O-, o-y"); and a percent sign (%) stands for all digits (equivalent to "0-9").
Examples: "@@,%*" stands for all words beginning with a letter and containing letters and/or digits.

-	A sequence of strings containing one and only one character, or of periods, at-signs or percent signs, separated by commas (,) corresponds to the union of these characters, i.e. to a set of characters. Variations are allowed. Some characters may be replaced by two characters separated by a dash (-); they correspond to the union of all characters belonging to the interval. One, and only one, comma may be replaced by a circumflex (^): the sequence of characters then corresponds to the set difference between, on one hand, the union of the characters placed before the circumflex and, on the other hand, the union of the characters placed after it.
Examples: "A-Z" stands for all ascii upper case letters. ".^ A-Z, a-z" stands for all characters, but ascii letters and end of line or end of text characters.

-	An underscore ( _ ) stands for all characters except a letter, a digit or an underscore character; equivalent to ". , #0, #26^ @, %, '_' | $". Can be used only as a string and not in character sets.

-	The simple juxtaposition of two regular expressions corresponds to the concatenation of these expressions. You can separate two expressions by spaces, which are active characters and are not included in strings.
Example: "MODULE" and "MOD	ULE" give the same result.

-	Two regular expressions separated by a vertical bar ( | ) corresponds to the union of these expressions.
Example: "CHAR | SHORTCHAR" matches "CHAR" or "SHORTCHAR".

-	A regular expression followed by an asterisk (*) corresponds to the repetition of this expression, possibly zero time.
Example: "n 0-9*" matches "n" or "n" followed by any sequence of digits.

-	A regular expression followed by a plus sign (+) corresponds to the repetition, at least once, of this expression, i.e. the concatenation of the expression and of the repetition of the expression.
Example: "a c+ e.*" matches, among other things, "ace" or "access", but not "aerobics".

-	A regular expression followed by a question mark (?) corresponds to the union of this expression and of the empty string.
Example: "string s?" matches "string" or "strings", and "A \ long?\ string" corresponds either to "A long string" or to "A string".

-	A regular expression followed by two integers n1 and n2 separated by a comma and surrounded by two chevrons (< and >) corresponds to the union of the repetitions from n1 to n2 times of this expression. The order of n1 and n2 is unimportant. If n1 or n2 equals zero, the expression corresponds, among other things, to the empty string.
Example: "foo\ <2, 3>" matches "foo foo " or "foo foo foo ".

-	A dollar sign ($) corresponds to a complex regular expression associated with an end of line (#13 | #14 | #13 #14).

-	The decreasing set of priorities of operators is:

* ; + ; ? ; <n1,n2>

concatenation by juxtaposition

| (union)
	
-	The set of priorities may be modified by the use of parentheses.

-	The complete regular expression can be preceded or followed, or both, by an expression bracketed by two square brackets ("[" and "]"). In this case, the match occurs only if the matching string is preceded and/or followed by the bracketed expressions.
BIER    
   !  e        $  L  t      "         e      e
     C  >       
 
     CCmd Desktops.ReplaceDoc RegulSyntax.Tool   A       
 
     CCmd Desktops.ReplaceDoc RegulSemantics.Tool    "         f      f
     C   "        ]      h
     C   "        R      h
     C   "        ]      h
     C   "        R      h
     C   "       * >      h
     C   "        R      h
     C  TextGadgets.NewStyleProc TextGadgets.NewControl  