TextDocs.NewDoc     TF   CColor     Flat  Locked  Controls  Org      BIER`   b        3    Syntax10.Scn.Fnt     Syntax12.Scn.Fnt     Oberon12.Scn.Fnt  =    6  Syntax12i.Scn.Fnt                  D  (*
NPTBox: Non-portable set of tools. Version for Oberon for Windows.

Copyright (C) 2002 Grard Meunier

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License  for more details.

You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*)

MODULE NPTBoxDir;
	
	(** Directories utilities. *)
	
	IMPORT
		
		FileDir;
	
	TYPE
		
		FileName*= ARRAY 260 OF CHAR;
		
		FileInfo*= POINTER TO RECORD (** List of files names and properties. *)
			next*: FileInfo;
			name*: FileName;
			time*, date*, size*: LONGINT;
		END;
	
	VAR
		
		list: FileInfo;
	
	PROCEDURE Enum (path, name: ARRAY OF CHAR; time, date, size: LONGINT; attrs: SET);
		
		VAR
			
			l: FileInfo;
		
		BEGIN (*Enum*)
			NEW(l);
			l.next:= list;
			COPY(name, l.name);
			l.time:= time;
			l.date:= time;
			l.size:= size;
			list:= l;
		END Enum;
	
	(** Returns the list of all files matching mask. *)
	PROCEDURE FileList*(mask: ARRAY OF CHAR): FileInfo;
		
		BEGIN (*FileList*)
			list:= NIL;
			FileDir.EnumerateFiles("", mask, TRUE, Enum);
			RETURN list;
		END FileList;
	
	END NPTBoxDir.
