TextDocs.NewDoc     TF   CColor     Flat  Locked  Controls  Org      BIER`   b        3 [   Oberon10.Scn.Fnt     Oberon12.Scn.Fnt  p  Oberon12i.Scn.Fnt          r  (*
NPTBox: Non-portable set of tools. Version for Native Oberon.

Copyright (C) 2002 Grard Meunier

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License  for more details.

You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*)

MODULE NPTBoxDir;
	
	(** Directories utilities. *)
	
	IMPORT
		
		OFS;
	
	TYPE
		
		FileName*= ARRAY 260 OF CHAR;
		
		FileInfo*= POINTER TO RECORD (** List of files names and properties. *)
			next*: FileInfo;
			name*: FileName;
			time*, date*, size*: LONGINT;
		END;
	
	VAR
		
		list: FileInfo;
	
	PROCEDURE Enum (name: ARRAY OF CHAR; time, date, size: LONGINT; VAR flags: SET);
		
		VAR
			
			l: FileInfo;
		
		BEGIN (*Enum*)
			NEW(l);
			l.next:= list;
			COPY(name, l.name);
			l.time:= time;
			l.date:= time;
			l.size:= size;
			list:= l;
		END Enum;
	
	(** Returns the list of all files matching mask. *)
	PROCEDURE FileList*(mask: ARRAY OF CHAR): FileInfo;
		
		VAR
			
			flags: SET;
		
		BEGIN (*FileList*)
			list:= NIL;
			flags:= {OFS.EnumTime, OFS.EnumSize};
			OFS.Enumerate(mask, flags, Enum);
			RETURN list;
		END FileList;
	
	END NPTBoxDir.
