TextDocs.NewDoc      F   CColor     Flat  Locked  Controls  Org      BIER`   b        3  8        Oberon12.Scn.Fnt          F   I   (*
Index: Cross reference builder and pretty printer.

Copyright (C) 2001 Grard Meunier

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License  for more details.

You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*)

MODULE IndexCrossRef;
	
	
	
	IMPORT
		
		Attributes, B:= BabelCompil, Display, Documents, EditTools, Files, Fonts, Gadgets, M:= TBoxMapping, Oberon, Objects, Strings, TextFrames, TextGadgets, Texts, Out, A:= TBoxAvl;
	
	CONST
		
		ext= ".Tbl";
		extLen= 4;
		
		headerGap= 14;
		
		Index= 1;
		Uppercase= 2;
		Bold= 3;
		Italic= 4;
		Name= 5;
		InIndexToo= 1;
		
		viewCode= 2X;
		
		linkColor= 9;
	
	TYPE
		
		Chaine= POINTER TO ARRAY OF CHAR;
		
		Directory= POINTER TO RECORD (B. Directory)
			r: Files.Rider;
		END;
		
		Compilation= POINTER TO RECORD (B.Compilation)
			t: Texts.Text;
			r: Texts.Reader;
			tInd, tMark: A.Tree;
			orgLigne: LONGINT;
			name: ARRAY 128 OF CHAR;
		END;
		
		ElemInd= POINTER TO RECORD (A.Elem)
			ident: Chaine;
			tLines: A.Tree;
		END;
		
		ElemLine= POINTER TO RECORD (A.Elem)
			num: LONGINT;
			att: SET;
		END;
		
		ElemMark= POINTER TO RECORD (A.Elem)
			len, end: LONGINT;
			att: SET;
			nom: Chaine;
		END;
	
	VAR
		
		comp: B.Compiler;
		compName: Chaine;
		doLinks: BOOLEAN;
	
	PROCEDURE (e1: ElemInd) Compare (e2: A.Elem): SHORTINT;
		
		VAR
			
			i1, i2: LONGINT;
			c1, c2: CHAR;
		
		BEGIN (*Compare*)
			WITH e2: ElemInd DO
				i1:= 0; i2:= 0;
				REPEAT
					WHILE (e1.ident[i1]# 0X) & ~((e1.ident[i1]>= 'A') & (e1.ident[i1]<= 'Z') OR (e1.ident[i1]>= 'a') & (e1.ident[i1]<= 'z') OR (e1.ident[i1]>= '0') & (e1.ident[i1]<= '9') OR (e1.ident[i1]>= 'A') & (e1.ident[i1]<= '') OR (e1.ident[i1]>= 'O') & (e1.ident[i1]<= '') OR (e1.ident[i1]>= 'o') & (e1.ident[i1]<= 'y')) DO
						INC(i1);
					END;
					c1:= Strings.UpperCh(e1.ident[i1]);
					WHILE (e2.ident[i2]# 0X) & ~((e2.ident[i2]>= 'A') & (e2.ident[i2]<= 'Z') OR (e2.ident[i2]>= 'a') & (e2.ident[i2]<= 'z') OR (e2.ident[i2]>= '0') & (e2.ident[i2]<= '9') OR (e2.ident[i2]>= 'A') & (e2.ident[i2]<= '') OR (e2.ident[i2]>= 'O') & (e2.ident[i2]<= '') OR (e2.ident[i2]>= 'o') & (e2.ident[i2]<= 'y')) DO
						INC(i2);
					END;
					c2:= Strings.UpperCh(e2.ident[i2]);
					INC(i1); INC(i2);
				UNTIL (c1# c2) OR (c1= 0X);
				IF c1< c2 THEN
					RETURN A.inf;
				ELSIF c1> c2 THEN
					RETURN A.sup;
				ELSIF e1.ident^< e2.ident^ THEN
					RETURN A.inf;
				ELSIF e1.ident^> e2.ident^ THEN
					RETURN A.sup;
				ELSE
					RETURN A.ega;
				END;
			END;
		END Compare;
	
	PROCEDURE (e1: ElemLine) Compare (e2: A.Elem): SHORTINT;
		
		BEGIN (*Compare*)
			WITH e2: ElemLine DO
				IF e1.num< e2.num THEN
					RETURN A.inf;
				ELSIF e1.num> e2.num THEN
					RETURN A.sup;
				ELSE
					RETURN A.ega;
				END;
			END;
		END Compare;
	
	PROCEDURE (e1: ElemMark) Compare (e2: A.Elem): SHORTINT;
		
		BEGIN (*Compare*)
			WITH e2: ElemMark DO
				IF e1.end< e2.end THEN
					RETURN A.inf;
				ELSIF e1.end> e2.end THEN
					RETURN A.sup;
				ELSE
					RETURN A.ega;
				END;
			END;
		END Compare;
	
	PROCEDURE (d: Directory) ReadInt (VAR i: LONGINT);
		
		BEGIN (*ReadInt*)
			Files.ReadLInt(d.r, i);
		END ReadInt;
	
	PROCEDURE (c: Compilation) Read (VAR ch: CHAR);
		
		BEGIN (*Read*)
			Texts.Read(c.r, ch);
			IF c.r.eot THEN
				ch:= B.eOF1;
			ELSIF ~(c.r.lib IS Fonts.Font) THEN
				ch:= viewCode;
			END;
		END Read;
	
	PROCEDURE (c: Compilation) Pos (): LONGINT;
		
		BEGIN (*Pos*)
			RETURN Texts.Pos(c.r);
		END Pos;
	
	PROCEDURE (c: Compilation) SetPos (pos: LONGINT);
		
		BEGIN (*SetPos*)
			IF pos<= c.t.len THEN
				Texts.OpenReader(c.r, c.t, pos);
			END;
		END SetPos;
	
	PROCEDURE (c: Compilation) Execution (fNum, parsNb: LONGINT; pars: B.ObjectsList; VAR objPos: B.Object; VAR res: B.ANYPTR): BOOLEAN;
		
		TYPE
			
			PC= POINTER TO RECORD (B.ANYPTR)
				c: Chaine;
			END;
		
		VAR
			
			s: Chaine;
			e: A.Elem;
			eI: ElemInd;
			eL: ElemLine;
			eM: ElemMark;
			n, m: LONGINT;
			b: BOOLEAN;
			p: PC;
			o: B.Object;
		
		BEGIN (*Execution*)
			objPos:= B.Parameter(pars, 1);
			IF objPos.ObjType()= B.stringObj THEN
				n:= objPos.ObjStringLen();
				NEW(s, n+ 1);
				objPos.ObjString(s^);
			ELSE
				res:= objPos.ObjUser();
				s:= res(PC).c;
				n:= LEN(s)- 1;
			END;
			CASE fNum OF
				|Index:
					NEW(eI);
					eI.ident:= s;
					e:= eI;
					b:= ~c.tInd.SearchIns(e, m);
					eI:= e(ElemInd);
					IF b THEN
						A.New(eI.tLines);
					END;
					NEW(eL);
					eL.num:= objPos.Line()+c.orgLigne;
					eL.att:= {};
					e:= eL;
					b:= eI.tLines.SearchIns(e, m);
					NEW(eM);
					eM.len:= n;
					eM.end:= objPos.Position()+ n- 1;
					eM.att:= {};
					e:= eM;
					b:= c.tMark.SearchIns(e, m);
					eM:= e(ElemMark);
					eM.len:= n;
					INCL(eM.att, fNum);
					eM.nom:= s;
				|Uppercase:
					NEW(p); NEW(p.c, n+ 1);
					Strings.Upper(s^, p.c^);
					res:= p;
				|Bold, Italic:
					NEW(eM);
					eM.end:= objPos.Position()+ n- 1;
					eM.att:= {};
					e:= eM;
					b:= c.tMark.SearchIns(e, m);
					eM:= e(ElemMark);
					eM.len:= n;
					INCL(eM.att, fNum);
					IF parsNb> 1 THEN
						o:= B.Parameter(pars, 2);
						IF (o.ObjType()= B.termObj) & (o.ObjFunc()= InIndexToo) THEN
							NEW(eI);
							eI.ident:= s;
							e:= eI;
							b:= ~c.tInd.SearchIns(e, m);
							eI:= e(ElemInd);
							IF b THEN
								A.New(eI.tLines);
							END;
							NEW(eL);
							eL.num:= objPos.Line()+ c.orgLigne;
							eL.att:= {};
							e:= eL;
							b:= eI.tLines.SearchIns(e, m);
							INCL(e(ElemLine).att, fNum);
						END;
					END;
				|Name:
					COPY(s^, c.name);
			END;
			RETURN TRUE;
		END Execution;
	
	PROCEDURE ShowTarget*;
		
		VAR
			
			s: Texts.Scanner;
			tf: TextGadgets.Frame;
			f: Texts.Finder;
			o: Objects.Object;
			c: ARRAY 64 OF CHAR;
			car: Oberon.CaretMsg;
			pos: LONGINT;
		
		BEGIN (*ShowTarget*)
			Texts.OpenScanner(s, Oberon.Par.text, Oberon.Par.pos);
			Texts.Scan(s);
			ASSERT(s.class= Texts.String);
			tf:= Gadgets.context(TextGadgets.Frame);
			Texts.OpenFinder(f, tf.text, 0);
			LOOP
				pos:= f.pos;
				Texts.FindObj(f, o);
				IF f.eot THEN
					EXIT;
				END;
				Gadgets.GetObjName(o, c);
				IF c= s.s THEN
					EXIT;
				END;
			END;
			ASSERT(~f.eot);
			car.id:= Oberon.set; car.car:= tf; car.text:= tf.text; car.pos:= pos;
			Display.Broadcast(car);
		END ShowTarget;
	
	PROCEDURE WriteLink (VAR f: Texts.Writer; id: ARRAY OF CHAR; n: LONGINT);
		
		VAR
			
			str: Chaine;
			s: ARRAY 12 OF CHAR;
			o: Objects.Object;
			
		BEGIN (*WriteLink*)
			Strings.IntToStr(n, s);
			NEW(str, Strings.Length(id)+ Strings.Length(s)+ 29);
			COPY('IndexCrossRef.ShowTarget "', str^);
			Strings.Append(str^, id);
			Strings.AppendCh(str^, '.');
			Strings.Append(str^, s);
			Strings.AppendCh(str^, '"');
			o:= Gadgets.CreateObject("TextGadgets.NewControl");
			Attributes.SetString(o, "Cmd", str^);
			COPY(s, str^);
			Strings.AppendCh(str^, '.');
			Strings.Append(str^, id);
			Gadgets.NameObj(o, str^);
			Texts.WriteObj(f, o);
		END WriteLink;
	
	PROCEDURE WriteIntLink (VAR f: Texts.Writer; n: LONGINT; id: ARRAY OF CHAR);
		
		VAR
			
			str: Chaine;
			s: ARRAY 12 OF CHAR;
			o: Objects.Object;
			col: SHORTINT;
			
		BEGIN (*WriteIntLink*)
			Strings.IntToStr(n, s);
			IF doLinks THEN
				col:= f.col;
				Texts.SetColor(f, linkColor);
				Texts.WriteString(f, s);
				Texts.SetColor(f, col);
				NEW(str, Strings.Length(id)+ Strings.Length(s)+ 29);
				COPY('IndexCrossRef.ShowTarget "', str^);
				Strings.Append(str^, s);
				Strings.AppendCh(str^, '.');
				Strings.Append(str^, id);
				Strings.Append(str^, '"');
				o:= Gadgets.CreateObject("TextGadgets.NewControl");
				Attributes.SetString(o, "Cmd", str^);
				COPY(id, str^);
				Strings.AppendCh(str^, '.');
				Strings.Append(str^, s);
				Gadgets.NameObj(o, str^);
				Texts.WriteObj(f, o);
			ELSE
				Texts.WriteString(f, s);
			END;
		END WriteIntLink;
	
	PROCEDURE Largeur (fnt: Fonts.Font; s: ARRAY OF CHAR): LONGINT;
		
		VAR
			
			l, i: LONGINT;
			dx, x, y, w, h: INTEGER;
			pat: Display.Pattern;
		
		BEGIN (*Largeur*)
			l:= 0;
			FOR i:= 0 TO Strings.Length(s)- 1 DO
				Fonts.GetChar(fnt, s[i], dx, x, y, w, h, pat);
				INC(l, dx);
			END;
			RETURN l;
		END Largeur;
		
	PROCEDURE (co: Compilation) PrintText (fnt: Fonts.Font; t: Texts.Text; VAR ligne, lenLine: LONGINT);
		
		VAR
			
			f: Texts.Writer;
			l: Texts.Reader;
			pos, etatEOL, nextM, lLine, left, debTxt: LONGINT;
			char, c: CHAR;
			eM: A.Elem;
			a: CHAR;
			o: Objects.Object;
			s: ARRAY 256 OF CHAR;
		
		PROCEDURE AutoEOL (): BOOLEAN;
			
			(* DFA which detects ends of lines *)
			
			VAR
				
				newLine: BOOLEAN;
			
			BEGIN (*AutoEOL*)
				newLine:= FALSE;
				INC(pos);
				LOOP
					CASE etatEOL OF
						|0:
							CASE char OF
								|B.eOL2:
										etatEOL:= 1;
								|B.eOL1:
										etatEOL:= 2;
								ELSE
							END;
							EXIT;
						|1:
							etatEOL:= 0;
							INC(ligne);
							newLine:= TRUE;
						|2:
							IF char= B.eOL2 THEN
								etatEOL:= 1;
								EXIT;
							ELSE
								etatEOL:= 0;
								INC(ligne);
								newLine:= TRUE;
							END;
					END;
				END;
				RETURN newLine;
			END AutoEOL;
		
		BEGIN (*PrintText*)
			debTxt:= t.len;
			Texts.OpenWriter(f);
			Texts.SetFont(f, fnt);
			Texts.OpenReader(co.r, co.t, 0);
			etatEOL:= 1; pos:= 0;
			eM:= co.tMark.Next(NIL);
			IF eM= NIL THEN
				nextM:= -1;
			ELSE
				nextM:= eM(ElemMark).end;
			END;
			Texts.Read(co.r, char);
			WHILE ~co.r.eot DO
				IF ~(co.r.lib IS Fonts.Font) THEN
					co.r.lib.GetObj(co.r.lib, ORD(char), o);
					char:= viewCode;
				END;
				IF AutoEOL() THEN
					Texts.WriteString(f, '(*');
					Strings.IntToStr(ligne, s);
					Texts.WriteString(f, s);
					Texts.WriteString(f, '*)');
					Texts.Write(f, Strings.Tab);
					lLine:= ligne;
				END;
				IF char= viewCode THEN
					Attributes.GetString(o, 'Gen', s);
					IF ~((s= "TextGadgets.NewControl") OR (s= "TextGadgets.NewStyleProc")) THEN
						Texts.WriteObj(f, o);
					END;
				ELSIF (char# B.eOL2) & (char# B.eOF2) THEN
					Texts.Write(f, char);
				END;
				IF pos= nextM THEN
					Texts.Append(t, f.buf);
					WITH eM: ElemMark DO
						IF doLinks & (Index IN eM.att) THEN
							Texts.OpenReader(l, t, t.len- eM.len- 1); Texts.Read(l, c);
							IF ~((l.lib IS Fonts.Font) & (c= ' ')) THEN
								Texts.Write(f, ' '); Texts.Insert(t, t.len- eM.len, f.buf);
							END;
							Texts.ChangeLooks(t, t.len- eM.len, t.len, {1}, NIL, linkColor, 0);
							WriteLink(f, eM.nom^, ligne);
						END;
						a:= '.';
						IF Bold IN eM.att THEN
							a:= 'b';
						ELSIF Italic IN eM.att THEN
							a:= 'i';
						END;
						EditTools.ChangeFontStyle(t, t.len- eM.len, t.len, '?', a);
					END;
					eM:= co.tMark.Next(eM);
					IF eM= NIL THEN
						nextM:= -1;
					ELSE
						nextM:= eM(ElemMark).end;
					END;
				END;
				Texts.Read(co.r, char);
			END;
			Texts.WriteLn(f);
			Texts.Append(t, f.buf);
			Strings.IntToStr(lLine, s);
			Strings.Append(s, '0');
			lenLine:= Largeur(fnt, s);
			o:= Gadgets.CreateObject("TextGadgets.NewStyleProc");
			Attributes.GetInt(o, 'Left', left);
			Strings.IntToStr(left+ lenLine+ Largeur(fnt, '(**)'), s);
			Attributes.SetString(o, 'Tabs', s);
			Attributes.SetBool(o, 'Pagebreak', co.orgLigne# 0);
			Texts.WriteObj(f, o);
			Texts.Insert(t, debTxt, f.buf);
		END PrintText;
		
	PROCEDURE PrintIndex (fnt: Fonts.Font; ind: A.Tree; t: Texts.Text; lenLine: LONGINT);
		
		CONST
			
			maxTabs= 16;
		
		VAR
			
			f: Texts.Writer;
			pos, nbL, n, i, maxL, w, left: LONGINT;
			eI, eL: A.Elem;
			indent, newPar: BOOLEAN;
			a: CHAR;
			o: Objects.Object;
			s: ARRAY 256 OF CHAR;
			ss: ARRAY 12 OF CHAR;
		
		BEGIN (*PrintIndex*)
			Texts.OpenWriter(f);
			Texts.SetFont(f, fnt);
			o:= Gadgets.CreateObject("TextGadgets.NewStyleProc");
			Attributes.GetInt(o, 'Left', left);
			Attributes.GetInt(o, 'Width', w);
			n:= 0;
			eI:= ind.Next(NIL);
			WHILE eI# NIL DO
				i:= Largeur(fnt, eI(ElemInd).ident^);
				IF i> n THEN
					n:= i;
				END;
				eI:= ind.Next(eI);
			END;
			maxL:= (w- n) DIV lenLine;
			IF maxL> maxTabs THEN
				maxL:= maxTabs;
			END;
			lenLine:= (w- n) DIV maxL;
			INC(n, Largeur(fnt, '0'));
			s:= "";
			FOR i:= 1 TO maxL DO
				Strings.IntToStr(left+ n, ss);
				Strings.Append(s, ss);
				IF i< maxL THEN
					Strings.AppendCh(s, ',');
				END;
				INC(n, lenLine);
			END;
			Attributes.SetString(o, 'Tabs', s);
			Attributes.SetBool(o, 'Pagebreak', TRUE);
			Texts.WriteObj(f, o);
			newPar:= FALSE;
			eI:= ind.Next(NIL);
			WHILE eI# NIL DO
				WITH eI: ElemInd DO
					IF newPar THEN
						Texts.WriteLn(f);
					END;
					newPar:= TRUE;
					Texts.WriteString(f, eI.ident^);
					nbL:= 0; indent:= FALSE;
					eL:= eI.tLines.Next(NIL);
					WHILE eL# NIL DO
						IF indent & (nbL= 0) THEN
							Texts.WriteLn(f);
						END;
						indent:= TRUE;
						nbL:= (nbL+ 1) MOD maxL;
						Texts.Write(f, Strings.Tab);
						WITH eL: ElemLine DO
							IF eL.att= {} THEN
								WriteIntLink(f, eL.num, eI.ident^);
							ELSE
								Texts.Append(t, f.buf);
								pos:= t.len;
								WriteIntLink(f, eL.num, eI.ident^);
								Texts.Append(t, f.buf);
								a:= '.';
								IF Bold IN eL.att THEN
									a:= 'b';
								ELSIF Italic IN eL.att THEN
									a:= 'i';
								END;
								EditTools.ChangeFontStyle(t, pos, t.len, '?', a);
							END;
						END;
						eL:= eI.tLines.Next(eL);
					END;
				END;
				eI:= ind.Next(eI);
			END;
			Texts.Append(t, f.buf);
		END PrintIndex;

	PROCEDURE Make (fnt: Fonts.Font; ind: A.Tree; t, ta: Texts.Text; VAR name: ARRAY OF CHAR; VAR lig, l: LONGINT);
		
		VAR
		
			co: Compilation;
		
		BEGIN (*Make*)
			NEW(co);
			co.name:= "";
			co.t:= t; co.orgLigne:= lig;
			Texts.OpenReader(co.r, t, 0);
			co.tInd:= ind; A.New(co.tMark); 
			IF co.Compile(comp, FALSE) THEN
				Out.String("Ok"); Out.Ln;
			ELSE
				Out.Ln; Out.String("Syntax error"); Out.Ln;
			END;
			co.PrintText(fnt, ta, lig, l);
			IF name= "" THEN
				COPY(co.name, name);
			END;
		END Make;
	
	PROCEDURE Pretty*;
		
		VAR
			
			s: Texts.Scanner;
			f: Fonts.Font;
			fn: Objects.Name;
			i, j, l: INTEGER;
			beg, end, time, len, lig: LONGINT;
			t, ta: Texts.Text;
			fi: Files.File;
			ind: A.Tree;
			name: ARRAY 128 OF CHAR;
			ss: Chaine;
			d: Directory;
			doc: Documents.Document;
			o: Objects.Object;
	
	PROCEDURE SplitFontName (fn: ARRAY OF CHAR; VAR i, j, size: INTEGER);
		
		VAR
			
			k: INTEGER;
		
		BEGIN (*SplitFontName*)
			i:= 0; size:= 0;
			WHILE (fn[i] # 0X) & ((fn[i] < "0") OR ("9" < fn[i])) DO
				INC(i);
			END;
			j:= i;
			WHILE ("0" <= fn[j]) & (fn[j] <= "9") DO
				INC(j);
			END;
			k:= i;
			WHILE k < j DO
				size:= size* 10+ ORD(fn[k])- 30H; INC(k);
			END;
		END SplitFontName;
	
	PROCEDURE CombineFontName (prefix, suffix: ARRAY OF CHAR; i, j, size: INTEGER; VAR fn: ARRAY OF CHAR);
		
		VAR
			
			k: INTEGER;
			ch: CHAR;
			dig: ARRAY 10 OF CHAR;
			
		BEGIN (*CombineFontName*)
			COPY(prefix, fn);
			k:= 0;
			IF size< 6 THEN
				size:= 6;
			ELSIF size> 128 THEN
				size:= 128;
			END;
			REPEAT dig[k]:= CHR(size MOD 10+ 30H);
				size:= size DIV 10;
				INC(k);
			UNTIL size= 0;
			REPEAT
				DEC(k);
				fn[i]:= dig[k];
				INC(i);
			UNTIL k = 0;
			REPEAT
				ch:= suffix[j];
				fn[i]:= ch;
				INC(i); INC(j);
			UNTIL ch= 0X;
		END CombineFontName;
		
		BEGIN (*Pretty*)
			doLinks:= FALSE;
			A.New(ind); lig:= 0;
			o:= Gadgets.CreateObject("Texts.New");
			ta:= o(Texts.Text);
			Texts.OpenScanner(s, Oberon.Par.text, Oberon.Par.pos);
			Texts.Scan(s);
			f:= Fonts.Default;
			IF (s.class = Texts.Char) & (s.c = "^") THEN
				Oberon.GetSelection(t, beg, end, time);
				IF time>= 0 THEN
					Texts.OpenScanner(s, t, beg);
					Texts.Scan(s);
				END
			END;
			IF (s.class= Texts.Char) & (s.c= "\") THEN
				IF CAP(s.nextCh)= "L" THEN
					doLinks:= TRUE;
				END;
				WHILE s.nextCh>" " DO
					Texts.Read(s, s.nextCh);
				END;
				Texts.Scan(s);
			END;
			IF s.class= Texts.Int THEN
				SplitFontName(f.name, i, j, l);
				CombineFontName(f.name, f.name, i, j, SHORT(s.i), fn);
				f:= Fonts.This(fn);
				Texts.Scan(s);
			END;
			IF (s.class = Texts.Char) & (s.c = "^") THEN
				Oberon.GetSelection(t, beg, end, time);
				IF time>= 0 THEN
					Texts.OpenScanner(s, t, beg);
					Texts.Scan(s);
				END
			END;
			IF s.class= Texts.Name THEN
				IF (compName= NIL) OR (s.s# compName^) THEN
					NEW(compName, Strings.Length(s.s)+ 1);
					COPY(s.s, compName^);
					NEW(ss, Strings.Length(s.s)+ extLen+ 1);
					COPY(s.s, ss^); Strings.Append(ss^, ext);
					fi:= Files.Old(ss^ );
					IF fi= NIL THEN
						Out.String("File not found: "); Out.String(ss^); Out.Ln;
						RETURN;
					END;
					NEW(d);
					Files.Set(d.r, fi, 0);
					comp:= d.ReadCompiler();
				END;
				Texts.Scan(s);
				IF (s.class = Texts.Char) & (s.c = "*") THEN
					t:= Oberon.MarkedText();
					IF t# NIL THEN
						name:= "";
						Make(f, ind, t, ta, name, lig, len);
						IF name= "" THEN
							doc:= Documents.MarkedDoc();
							COPY(doc.name, name);
						END;
					END;
				ELSE
					IF (s.class = Texts.Char) & (s.c = "^") THEN
						Oberon.GetSelection(t, beg, end, time);
						IF time>= 0 THEN
							Texts.OpenScanner(s, t, beg);
							Texts.Scan(s);
						END
					END;
					name:= "";
					WHILE s.class= Texts.Name DO
						Out.String(s.s); Out.String(": ");
						NEW(t);
						Texts.Open(t, s.s);
						IF t.len= 0 THEN
							Out.String("not found."); Out.Ln;
						ELSE
							Make(f, ind, t, ta, name, lig, len);
						END;
						Texts.Scan(s);
					END;
				END;
			END;
			IF ind.NumberOfElems()> 0 THEN
				PrintIndex(f, ind, ta, len);
				Oberon.OpenText(name, ta, 500, 400);
			END;
		END Pretty;
	
	PROCEDURE (comp: Compilation) Error*(p, li, co: LONGINT; mes: ARRAY OF CHAR);
		
		BEGIN (*Error*)
			Out.Ln;
			Out.String("Position "); Out.Int(p- 1, 0);
			Out.String(" ,line "); Out.Int(li, 0);
			Out.String(", colonne "); Out.Int(co, 0);
			Out.Ln;
			Out.String(mes);
			Out.Ln;
		END Error;
	
	PROCEDURE (c: Compilation) Map (index: ARRAY OF CHAR): B.Chaine;
		
		VAR
			
			s: B.Chaine;
			ch: M.Chaine;
		
		BEGIN (*Map*)
			NEW(s, Strings.Length(index)+ 8);
			COPY("#Babel:", s^);
			Strings.Append(s^, index);
			ch:= M.Map(s^, "", "", "");
			NEW(s, LEN(ch));
			COPY(ch^, s^);
			RETURN s;
		END Map;
	
	BEGIN (*IndexCrossRef*)
		compName:= NIL;
	END IndexCrossRef.

System.Free IndexCrossRef ~BIERK  CK   J  J    "         ?      ?
     C  <       f 
     C  Oberon10.Scn.Fnt 21.03.2002  18:21:22  TextGadgets.NewStyleProc TimeStamps.New  