TextDocs.NewDoc     XF   CColor     Flat  Locked  Controls  Org    BIER`   b        3 Q   Oberon12.Scn.Fnt    Oberon12i.Scn.Fnt      g              (* 
Babel: a compiler compiler.

Copyright (C) 1990 Grard Meunier

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License  for more details.

You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*)

MODULE BabelTestgram;
	
	(** Example of Babel use. Tests the syntax defined by a Bab file on a sample text. *)
	
	IMPORT
		
		B:= BabelCompil, Files, Fonts, M:= TBoxMapping, Oberon, Objects, Strings, Texts;
	
	CONST
		
		ext= ".Tbl";
		extLen= 4;
		viewCode= 2X;
	
	TYPE
		
		Directory= POINTER TO RECORD (B. Directory)
			r: Files.Rider;
		END;
		
		Compilation= POINTER TO RECORD (B.Compilation)
			t: Texts.Text;
			r: Texts.Reader;
		END;
	
	VAR
		
		comp: B.Compiler;
		compName: B.Chaine;
	
	PROCEDURE (d: Directory) ReadInt (VAR i: LONGINT);
		
		BEGIN (*ReadInt*)
			Files.ReadLInt(d.r, i);
		END ReadInt;
	
	PROCEDURE (c: Compilation) Read (VAR ch: CHAR);
		
		BEGIN (*Read*)
			Texts.Read(c.r, ch);
			IF c.r.eot THEN
				ch:= B.eOF1;
			ELSIF ~(c.r.lib IS Fonts.Font) THEN
				ch:= viewCode;
			END;
		END Read;
	
	PROCEDURE (c: Compilation) Pos (): LONGINT;
		
		BEGIN (*Pos*)
			RETURN Texts.Pos(c.r);
		END Pos;
	
	PROCEDURE (c: Compilation) SetPos (pos: LONGINT);
		
		BEGIN (*SetPos*)
			Texts.OpenReader(c.r, c.t, pos);
		END SetPos;
	
	PROCEDURE (c: Compilation) Execution (fNum, parsNb: LONGINT; pars: B.ObjectsList; VAR objPos: B.Object; VAR res: B.ANYPTR): BOOLEAN;
		
		BEGIN (*Execution*)
			RETURN TRUE;
		END Execution;
	
	PROCEDURE (comp: Compilation) Error (p, li, co: LONGINT; mes: ARRAY OF CHAR);
		
		VAR
			
			w: Texts.Writer;
		
		BEGIN (*Error*)
			Texts.OpenWriter(w);
			Texts.WriteString(w, "Position "); Texts.WriteInt(w, p- 1, 0);
			Texts.WriteString(w, ", line "); Texts.WriteInt(w, li, 0);
			Texts.WriteString(w, ", column "); Texts.WriteInt(w, co, 0);
			Texts.WriteLn(w);
			Texts.WriteString(w, mes);
			Texts.WriteLn(w); Texts.WriteLn(w);
			Texts.Append(Oberon.Log, w.buf);
		END Error;
	
	PROCEDURE (c: Compilation) Map (index: ARRAY OF CHAR): B.Chaine;
		
		VAR
			
			s: B.Chaine;
			ch: M.Chaine;
		
		BEGIN (*Map*)
			NEW(s, Strings.Length(index)+ 8);
			COPY("#Babel:", s^);
			Strings.Append(s^, index);
			ch:= M.Map(s^, "", "", "");
			NEW(s, LEN(ch));
			COPY(ch^, s^);
			RETURN s;
		END Map;
	
	PROCEDURE SetGram (name: ARRAY OF CHAR);
		
		VAR
			
			f: Files.File;
			d: Directory;
			w: Texts.Writer;
			ss: B.Chaine;
		
		BEGIN (*SetGram*)
			IF (compName= NIL) OR (name# compName^) THEN
				NEW(compName, Strings.Length(name)+ 1);
				COPY(name, compName^);
				NEW(ss, Strings.Length(name)+ extLen+ 1);
				COPY(name, ss^); Strings.Append(ss^, ext);
				f:= Files.Old(ss^ );
				IF f= NIL THEN
					Texts.OpenWriter(w);
					Texts.WriteString(w, "File not found: "); Texts.WriteString(w, ss^); Texts.WriteLn(w);
					Texts.Append(Oberon.Log, w.buf);
					RETURN;
				END;
				NEW(d);
				Files.Set(d.r, f, 0);
				comp:= d.ReadCompiler();
			END;
		END SetGram;
	
	PROCEDURE Do*;
		
		VAR
			
			co: Compilation;
			w: Texts.Writer;
			s: Texts.Scanner;
			t: Texts.Text;
			beg, end, time: LONGINT;
		
		BEGIN (*Do*)
			Texts.OpenScanner(s, Oberon.Par.text, Oberon.Par.pos);
			Texts.Scan(s);
			IF (s.class = Texts.Char) & (s.c = "^") THEN
				Oberon.GetSelection(t, beg, end, time);
				IF time>= 0 THEN
					Texts.OpenScanner(s, t, beg);
					Texts.Scan(s);
				END
			END;
			IF s.class= Texts.Name THEN
				SetGram(s.s);
				t:= Oberon.MarkedText();
				IF t# NIL THEN
					Texts.OpenWriter(w);
					NEW(co);
					co.t:= t;
					Texts.OpenReader(co.r, t, 0);
					IF co.Compile(comp, FALSE) THEN
						Texts.WriteString(w, "Ok");
					ELSE
						Texts.WriteString(w, "Syntax error");
					END;
					Texts.WriteLn(w);
					Texts.Append(Oberon.Log, w.buf);
				END;
			END;
		END Do;
	
	BEGIN (*BabelTestgram*)
		compName:= NIL;
	END BabelTestgram.

Usage:

	"BabelTestgram.Do" BabFile "~"

with BabFile without extension. The tested text is the marked one.

Example:

BabelTestgram.Do BabelAOS ~