TextDocs.NewDoc     X4F   CColor     Flat  Locked  Controls  Org    BIER`   b        3     Oberon12.Scn.Fnt          x                                                               $    a        '   
               7    9  (*
Where: Indexer of Symbol files.

Copyright (C) 2001 Grard Meunier

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License  for more details.

You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*)

MODULE BabelTestAllGram;
	
	 
	
	IMPORT
		
		(*M:= TBoxMapping,*)
		
		B:= BabelCompil, Files, Fonts, Oberon, Strings, NPTBoxDir, Texts;
	
	CONST
		
		ext= ".Tbl";
		extLen= 4;
		viewCode= 2X;
	
	TYPE
		
		Directory= POINTER TO RECORD (B. Directory)
			r: Files.Rider;
		END;
		
		Compilation= POINTER TO RECORD (B.Compilation)
			t: Texts.Text;
			r: Texts.Reader;
		END;
	
	VAR
		
		comp: B.Compiler;
		compName: B.Chaine;
	
	PROCEDURE (d: Directory) ReadInt (VAR i: LONGINT);
		
		BEGIN (*ReadInt*)
			Files.ReadLInt(d.r, i);
		END ReadInt;
	
	PROCEDURE (c: Compilation) Read (VAR ch: CHAR);
		
		BEGIN (*Read*)
			Texts.Read(c.r, ch);
			IF c.r.eot THEN
				ch:= B.eOF1;
			ELSIF ~(c.r.lib IS Fonts.Font) THEN
				ch:= viewCode;
			END;
		END Read;
	
	PROCEDURE (c: Compilation) Pos (): LONGINT;
		
		BEGIN (*Pos*)
			RETURN Texts.Pos(c.r);
		END Pos;
	
	PROCEDURE (c: Compilation) SetPos (pos: LONGINT);
		
		BEGIN (*SetPos*)
			Texts.OpenReader(c.r, c.t, pos);
		END SetPos;
	
	PROCEDURE (c: Compilation) Execution (fNum, parsNb: LONGINT; pars: B.ObjectsList; VAR o: B.Object; VAR res: B.ANYPTR): BOOLEAN;
		
		BEGIN (*Execution*)
			RETURN TRUE;
		END Execution;
	
	PROCEDURE SetGram (name: ARRAY OF CHAR);
		
		VAR
			
			f: Files.File;
			d: Directory;
			w: Texts.Writer;
			ss: B.Chaine;
		
		BEGIN (*SetGram*)
			IF (compName= NIL) OR (name# compName^) THEN
				NEW(compName, Strings.Length(name)+ 1);
				COPY(name, compName^);
				NEW(ss, Strings.Length(name)+ extLen+ 1);
				COPY(name, ss^); Strings.Append(ss^, ext);
				f:= Files.Old(ss^ );
				IF f= NIL THEN
					Texts.OpenWriter(w);
					Texts.WriteString(w, "File not found: "); Texts.WriteString(w, ss^); Texts.WriteLn(w);
					Texts.Append(Oberon.Log, w.buf);
					RETURN;
				END;
				NEW(d);
				Files.Set(d.r, f, 0);
				comp:= d.ReadCompiler();
			END;
		END SetGram;
	
	PROCEDURE Do*;
		
		VAR
			
			fInf: NPTBoxDir.FileInfo;
			c: Compilation;
			w: Texts.Writer;
			s: Texts.Scanner;
			t: Texts.Text;
			beg, end, time: LONGINT;
		
		BEGIN (*Do*)
			Texts.OpenScanner(s, Oberon.Par.text, Oberon.Par.pos);
			Texts.Scan(s);
			IF (s.class = Texts.Char) & (s.c = "^") THEN
				Oberon.GetSelection(t, beg, end, time);
				IF time>= 0 THEN
					Texts.OpenScanner(s, t, beg);
					Texts.Scan(s);
				END
			END;
			IF s.class= Texts.Name THEN
				SetGram(s.s);
				Texts.OpenWriter(w);
				fInf:= NPTBoxDir.FileList("AOS:*.Mod");
				WHILE fInf# NIL DO
					NEW(c);
					NEW(c.t);
					Texts.Open(c.t, fInf.name);
					Texts.OpenReader(c.r, c.t, 0);
					Texts.WriteString(w, fInf.name);
					Texts.Append(Oberon.Log, w.buf);
					IF ~c.Compile(comp, FALSE) THEN
						Texts.WriteString(w, " Error");
					END;
					Texts.WriteLn(w);
					Texts.Append(Oberon.Log, w.buf);
					fInf:= fInf.next;
				END;
			END;
		END Do;
	
	(*
	PROCEDURE (c: CompilMake) Error (pos, line, col: LONGINT; msg: ARRAY OF CHAR);
		
		VAR
			
			w: Texts.Writer;
		
		BEGIN (*Error*)
			Texts.OpenWriter(w);
			Texts.Write(w, 9X); Texts.WriteInt(w, pos- 1, 0); Texts.WriteString(w, " Erreur."); Texts.WriteLn(w);
			Texts.Write(w, 9X); Texts.WriteString(w, msg); Texts.WriteLn(w);
			Texts.Append(Oberon.Log, w.buf);
		END Error;
	
	PROCEDURE (co: CompilMake) Map (index: ARRAY OF CHAR): B.Chaine;
		
		CONST
			
			base= "#Babel:";
		
		VAR
			
			c: B.Chaine;
			ch: M.Chaine;
		
		BEGIN (*Map*)
			NEW(c, Strings.Length(index)+ 8);
			COPY(base, c^);
			Strings.Append(c^, index);
			ch:= M.Map(c^, "", "", "");
			NEW(c, Strings.Length(ch^)+ 1);
			COPY(ch^, c^);
			RETURN c;
		END Map;
	*)
	
	BEGIN (*BabelTestAllGram*)
		compName:= NIL;
	END BabelTestAllGram.

BabelTestAllGram.Do BabelAOS ~
BIER         :       Z      C  Oberon10.Scn.Fnt 07.05.02  16:48:45  TimeStamps.New  