TextDocs.NewDoc     F   CColor     Flat  Locked  Controls  Org    BIER`   b        3  _   Oberon12.Scn.Fnt          
  Oberon12i.Scn.Fnt  @        	    l      (* 
Babel: a compiler compiler.

Copyright (C) 1990 Grard Meunier

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License  for more details.

You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*)

MODULE BabelTest4;
	
	(* *)
	
	(** Example of Babel use. Reads an integer arithmetical expression and displays its value. Uses an ambiguous grammar. *)
	
	IMPORT
		
		B:= BabelCompil, Files, M:= TBoxMapping, Strings, In, Out;
	
	CONST
		
		eOS= 0X;
	
	TYPE
		
		Directory= POINTER TO RECORD (B.Directory)
			rd: Files.Rider;
		END;
		
		Compilation= POINTER TO RECORD (B.Compilation)
		END;
		
		PC= POINTER TO RECORD (B.ANYPTR)
			v: LONGINT;
		END;
	
	VAR
		
		exp: ARRAY 64 OF CHAR;
		cur: LONGINT;
		c: B.Compiler;
		f: Files.File;
		d: Directory;
	
	PROCEDURE (d: Directory) ReadInt (VAR i: LONGINT);
		
		BEGIN (*ReadInt*)
			Files.ReadLInt(d.rd, i);
		END ReadInt;
	
	PROCEDURE (c: Compilation) Read (VAR ch: CHAR);
		
		BEGIN (*Read*)
			ch:= exp[cur];
			IF ch= eOS THEN
				ch:= B.eOF1;
			END;
			INC(cur);
		END Read;
	
	PROCEDURE (c: Compilation) Pos (): LONGINT;
		
		BEGIN (*Pos*)
			RETURN cur;
		END Pos;
	
	PROCEDURE (c: Compilation) SetPos (pos: LONGINT);
		
		BEGIN (*SetPos*)
			cur:= pos;
		END SetPos;
	
	PROCEDURE (c: Compilation) Map (index: ARRAY OF CHAR): B.Chaine;
		
		VAR
			
			c1: M.Chaine;
			c2: B.Chaine;
		
		BEGIN (*Map*)
			NEW(c2, Strings.Length(index)+ 8);
			COPY("#Babel:", c2^);
			Strings.Append(c2^, index);
			c1:= M.Map(c2^, "", "", "");
			NEW(c2, Strings.Length(c1^)+ 1);
			COPY(c1^, c2^);
			RETURN c2;
		END Map;
	
	PROCEDURE (c: Compilation) Execution (n, nb: LONGINT; l: B.ObjectsList; VAR o: B.Object; VAR a: B.ANYPTR): BOOLEAN;
		
		CONST
			
			display= 1;
			value= 2;
		
		VAR
			
			ok: BOOLEAN;
			
			s: ARRAY 7 OF CHAR;
			i, res: LONGINT;
			p: PC;
		
		PROCEDURE Eval (o: B.Object): LONGINT;
			
			VAR
				
				a: B.ANYPTR;
				p: PC;
				i: LONGINT;
			
			BEGIN (*Eval*)
				IF o.ErrorIn() THEN
					RETURN 0;
				END;
				CASE o.ObjType() OF
					|B.userObj :
						a:= o.ObjUser();
						p:= a(PC);
						RETURN p.v;
					|B.termObj:
						CASE o.ObjFunc() OF
							|1:
								RETURN Eval(o.ObjTermSon(1))+Eval(o.ObjTermSon(2));
							|2:
								RETURN Eval(o.ObjTermSon(1))-Eval(o.ObjTermSon(2));
							|3:
								RETURN Eval(o.ObjTermSon(1))*Eval(o.ObjTermSon(2));
							|4:
								i:= Eval(o.ObjTermSon(2));
								IF i= 0 THEN
									ok:= FALSE;
									RETURN 0;
								ELSE
									RETURN Eval(o.ObjTermSon(1)) DIV i;
								END;
							|5:
								RETURN -Eval(o.ObjTermSon(1));
						END;
				END;
			END Eval;
		
		BEGIN (*Execution*)
			o:= B.Parameter(l, 1);
			ok:= ~o.ErrorIn();
			IF ok THEN
				CASE n OF
					|display:
						Out.Int(Eval(o),1);
						Out.Ln;
					|value:
						o.ObjString(s);
						NEW(p);
						Strings.StrToInt(s, i);
						p.v:= i;
						ok:= res= 0;
						a:= p;
				END;
			END;
			RETURN ok;
		END Execution;
	
	PROCEDURE (comp: Compilation) Error*(p, li, co: LONGINT; mes: ARRAY OF CHAR);
		
		VAR
			
			s: ARRAY 256 OF CHAR;
			i: LONGINT;
		
		BEGIN (*Error*)
			Out.Ln;
			COPY("", s);
			FOR i:= 0 TO p- 2 DO
				Strings.AppendCh(s, exp[i]);
			END;
			Strings.AppendCh(s, "@");
			FOR i:= p- 1 TO Strings.Length(exp)- 1 DO
				Strings.AppendCh(s, exp[i]);
			END;
			Out.String(s); Out.Ln;
			Out.String(mes);
			Out.Ln;
		END Error;
	
	PROCEDURE Do*;
		
		VAR
			
			co: Compilation;
		
		BEGIN (*Do*)
			In.Open;
			ASSERT(In.Done, 22);
			In.String(exp);
			ASSERT(In.Done, 23);
			cur:= 0;
			NEW(co);
			IF co.Compile(c, FALSE) THEN
				Out.String("Ok");
			ELSE
				Out.Ln;
				Out.String("Problems");
			END;
			Out.Ln;
		END Do;
	
	BEGIN (*BabelTest4*)
		f:= Files.Old("BabelTest4.Tbl");
		NEW(d);
		Files.Set(d.rd, f, 0);
		c:= d.ReadCompiler();
	END BabelTest4.

Open BabelTest4.Bab, mark it by pressing F1 and compile it with:

BabelBabel.Compile *

Then try:

BabelTest4.Do "2.5-7/2+1"
BabelTest4.Do "3*(2+3)-1"
BabelTest4.Do "1-8/-2+-*3-2"
System.Free BabelTest4 ~
BIER         <       f 
     C  Oberon10.Scn.Fnt 30.03.2002  20:25:07  TimeStamps.New  