TextDocs.NewDoc     F   CColor     Flat  Locked  Controls  Org    BIER`   b        3  _   Oberon12.Scn.Fnt            Oberon12i.Scn.Fnt  @        	    }      (* 
Babel: a compiler compiler.

Copyright (C) 1990 Grard Meunier

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License  for more details.

You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*)

MODULE BabelTest2;
	
	(* *)
	
	(** Example of Babel use. Reads a list of number sequences and, for each sequence, displays the product of the greatest number of the sequence times the number of its elements. Sequences are splittted by semicolons, numbers are splitted by commas, the list is ended by a period. *)

	IMPORT
	
		B:= BabelCompil, Files, M:= TBoxMapping, Strings, In, Out;

	CONST

		eOS=0X;
	
	TYPE
		
		Directory= POINTER TO RECORD (B.Directory)
			rd: Files.Rider;
		END;
		
		Compilation= POINTER TO RECORD (B.Compilation)
		END;
		
		PC= POINTER TO RECORD (B.ANYPTR)
			v: LONGINT;
		END;

	VAR

		exp:ARRAY 64 OF CHAR;
		cur: LONGINT;
		c: B.Compiler;
		f: Files.File;
		d: Directory;
	
	PROCEDURE (d: Directory) ReadInt (VAR i: LONGINT);
		
		BEGIN (*ReadInt*)
			Files.ReadLInt(d.rd, i);
		END ReadInt;

	PROCEDURE (c: Compilation) Read (VAR ch: CHAR);

		BEGIN (*Read*)
			ch:= exp[cur];
			IF ch= eOS THEN
				ch:= B.eOF1;
			END;
			INC(cur);
		END Read;
	
	PROCEDURE (c: Compilation) Pos (): LONGINT;
		
		BEGIN (*Pos*)
			RETURN cur;
		END Pos;
	
	PROCEDURE (c: Compilation) SetPos (pos: LONGINT);
		
		BEGIN (*SetPos*)
			cur:= pos;
		END SetPos;
	
	PROCEDURE (c: Compilation) Map (index: ARRAY OF CHAR): B.Chaine;
		
		VAR
			
			c1: M.Chaine;
			c2: B.Chaine;
		
		BEGIN (*Map*)
			NEW(c2, Strings.Length(index)+ 8);
			COPY("#Babel:", c2^);
			Strings.Append(c2^, index);
			c1:= M.Map(c2^, "", "", "");
			NEW(c2, Strings.Length(c1^)+ 1);
			COPY(c1^, c2^);
			RETURN c2;
		END Map;

	PROCEDURE (c: Compilation) Execution (n, nb: LONGINT; l: B.ObjectsList; VAR o: B.Object; VAR a: B.ANYPTR): BOOLEAN;
		
		CONST
			
			display= 1;
			sup= 2;
			plus= 3;
			value= 4;

		VAR

			ok: BOOLEAN;
			s: ARRAY 7 OF CHAR;
			p, p1, p2: PC;
			o2: B.Object;
			res: LONGINT;

		BEGIN (*Execution*)
			o:= B.Parameter(l,1);
			CASE n OF
				|display:
					 IF o.ObjType()# B.nulObj THEN
						 a:= o.ObjUser();
						 p:= a(PC);
						 Out.Int(p.v, 1);
						 Out.Ln;
					 END;
					 RETURN TRUE;
				|sup:
					 NEW(p);
					 o2:= B.Parameter(l, 2);
					 IF o.ObjType()= B.nulObj THEN
						 IF o2.ObjType()= B.nulObj THEN
							 p.v:= 0;
						 ELSE
							 a:= o2.ObjUser();
							 p2:= a(PC);
							 p.v:= p2.v;
						 END;
					 ELSIF o2.ObjType()= B.nulObj THEN
						 a:= o.ObjUser();
						 p1:= a(PC);
						 p.v:= p1.v;
					 ELSE
						 a:= o.ObjUser();
						 p1:= a(PC);
						 a:= o2.ObjUser();
						 p2:= a(PC);
						 IF p1.v> p2.v THEN
							 p.v:= p1.v;
						 ELSE
							 p.v:= p2.v;
						 END;
					 END;
					 a:= p;
					 RETURN TRUE;
				|plus:
					 NEW(p);
					 IF o.ObjType()=B. nulObj THEN
						 p.v:= 0;
					 ELSE
						 a:= o.ObjUser();
						 p1:= a(PC);
						 p.v:= p1.v;
					 END;
					 o2:= B.Parameter(l, 2);
					 IF o2.ObjType()# B.nulObj THEN
						 a:= o2.ObjUser();
						 p2:= a(PC);
						 p.v:= p.v+p2.v;
					 END;
					 a:= p;
					 RETURN TRUE;
				|value:
					 NEW(p);
					 IF o.ObjType()= B.nulObj THEN
						 p.v:= 0;
						 ok:= TRUE;
					 ELSE
						 o.ObjString(s);
						 Strings.StrToInt(s, p.v);
						ok:= res= 0;
					 END;
					 a:= p;
					 RETURN ok;
			END;
		END Execution;

	PROCEDURE (comp: Compilation) Error*(p, li, co: LONGINT; mes: ARRAY OF CHAR);

		VAR

			s: ARRAY 256 OF CHAR;
			i: LONGINT;

		BEGIN (*Error*)
			Out.Ln;
			COPY("", s);
			FOR i:= 0 TO p- 2 DO
				Strings.AppendCh(s, exp[i]);
			END;
			Strings.AppendCh(s, "@");
			FOR i:= p- 1 TO Strings.Length(exp)- 1 DO
				Strings.AppendCh(s, exp[i]);
			END;
			Out.String(s); Out.Ln;
			Out.String(mes);
			Out.Ln;
		END Error;
	
	PROCEDURE Do*;

		VAR

			co: Compilation;

		BEGIN (*Do*)
			In.Open;
			ASSERT(In.Done, 22);
			In.String(exp);
			ASSERT(In.Done, 23);
			cur:= 0;
			NEW(co);
			IF co.Compile(c, FALSE) THEN
				Out.String("Ok");
			ELSE
				Out.Ln;
				Out.String("Problems");
			END;
			Out.Ln;
		END Do;
		
	BEGIN (*BabelTest2*)
		f:= Files.Old("BabelTest2.Tbl");
		NEW(d);
		Files.Set(d.rd, f, 0);
		c:= d.ReadCompiler();
	END BabelTest2.
	
Open BabelTest2.Bab, mark it by pressing F1 and compile it with:

BabelBabel.Compile *

Then try:

BabelTest2.Do "1,5,2,6, 7,2; 5,0,2,1."
BabelTest2.Do "1,5,2,6, 7,2; 5,0,,2,1."
BabelTest2.Do "1,3,2,6, 2; 5,0, 0, 0, 2,1."
BIER     c    <       f 
     C  Oberon10.Scn.Fnt 30.03.2002  20:24:48  TimeStamps.New  