TextDocs.NewDoc     UF   CColor     Flat  Locked  Controls  Org F   BIER`   b        3  1   Oberon12.Scn.Fnt               (* 
Babel: a compiler compiler.

 c Grard MEUNIER 1990

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)
MODULE BabelInit;
	
	(* *)
	
	(** The module BabelInit is part of the Babel subsystem, a compiler compiler. BabelInit loads a hard coded version of the tbl file corresponding to the definition document Babel.Bab. This hard code is produced by the module BabelBinText. *)
	
	IMPORT
		
		C:= BabelCompil, Modules, Oberon, Objects, Texts;
	
	CONST
		
		taTbl= 5458;
	
	TYPE
		
		Directory= POINTER TO RECORD (C.Directory)
			pos: LONGINT;
		END;
	
	VAR
		
		a*: POINTER TO ARRAY OF LONGINT;
	
	PROCEDURE (d: Directory) ReadInt (VAR i: LONGINT);
		
		BEGIN (*ReadInt*)
			i:= a[d.pos];
			INC(d.pos);
		END ReadInt;
	
	PROCEDURE (d: Directory) Init;
		
		VAR
			
			par: Oberon.ParList;
			res: INTEGER;
		
		BEGIN (*Init*)
			NEW(a, taTbl);
			NEW(par);
			par.vwr:= NIL; par.frame:= NIL; par.obj:= NIL;
			Texts.New;
			par.text:= Objects.NewObj(Texts.Text);
			par.pos:= 0;
			Oberon.Call("BabelInit1.RemplisA", par, FALSE, res);
			ASSERT(res= 0);
			Modules.Free("BabelInit1", FALSE);
			ASSERT(Modules.res= 0);
			Oberon.Call("BabelInit2.RemplisA", par, FALSE, res);
			ASSERT(res= 0);
			Modules.Free("BabelInit2", FALSE);
			ASSERT(Modules.res= 0);
			Oberon.Call("BabelInit3.RemplisA", par, FALSE, res);
			ASSERT(res= 0);
			Modules.Free("BabelInit3", FALSE);
			ASSERT(Modules.res= 0);
			d.pos:= 0;
		END Init;
	
	PROCEDURE InitBabel*(): C.Compiler;
		
		VAR
			
			d: Directory;
			c: C.Compiler;
		
		BEGIN (*InitBabel*)
			NEW(d);
			d.Init;
			c:= d.ReadCompiler();
			a:= NIL;
			RETURN c;
		END InitBabel;
	
	END BabelInit.
BIER	  	   	    <       f 
     C  Oberon10.Scn.Fnt 21.04.2002  12:52:14  TimeStamps.New  