TextDocs.NewDoc     F   CColor     Flat  Locked  Controls  Org J   BIER`   b        3  1   Oberon12.Scn.Fnt          ZL   VO  (* 
Babel: a compiler compiler.

 c Grard MEUNIER 1990

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

MODULE BabelExtract;
	
	(* *)
	
	(** The module BabelExtract is part of the Babel subsystem, a compiler compiler. BabelExtract provides a converter which may be used to read the contents of Tbl files. *)
	
	IMPORT
		
		Files, M:= TBoxMapping, Oberon, Objects, Strings, Texts;

	TYPE
		
		Chaine= POINTER TO ARRAY OF CHAR;
		
		(* Definitions for the lexical analyzer *)
		
		TokLex= RECORD (* A token *)
			nom: Chaine;
			utile,
			valUt: BOOLEAN;
		END;
		
		ToksLex= POINTER TO ARRAY OF TokLex;
		
		GotoLex= POINTER TO RECORD
			goto: LONGINT;
		END;
		
		GotoLexC= POINTER TO RECORD (GotoLex)
			premCar,
			derCar :CHAR;
		END;
		
		GotoLexT= POINTER TO RECORD (GotoLex)
			transit: LONGINT;
		END;
		
		TransLex= POINTER TO ARRAY OF GotoLex;
		
		Card= POINTER TO ARRAY OF LONGINT;
		
		EtatLex= RECORD
			recon,
			nbTrans,
			nbEps: LONGINT;
			transL: TransLex;
		END;
		
		EtatsLex= POINTER TO ARRAY OF EtatLex;
		
	(* Definitions for the parser *)
	
	CONST
		
		deplaceS= 0;
		reduitS= 1;
		accepteS= 2;
		erreurS= 3;
	
	TYPE
		
		ActionS= RECORD
			quoi: SHORTINT;
			premTerm,
			derTerm ,
			aux: LONGINT;
		END;
		
		ActSynt= POINTER TO ARRAY OF ActionS;
		
		ActionSynt= RECORD
			nbT: LONGINT;
			actions: ActSynt;
		END;
		
		ActionsSynt=POINTER TO ARRAY OF ActionSynt;
		
		GtS= RECORD
			depart ,
			arrivee: LONGINT;
		END;
		
		GotoS= POINTER TO ARRAY OF GtS;
		
		GotoSynt= RECORD
			nbAtts: LONGINT;
			typsAt: Card;
			nbE: LONGINT;
			gotos: GotoS;
		END;
		
		GotosSynt= POINTER TO ARRAY OF GotoSynt;
		
		(* Definitions for the semantic analyser *)
		
		Param= RECORD
			profD,
			attD: LONGINT;
		END;
		
		Params= POINTER TO ARRAY OF Param;
		
		ActionSem= RECORD
			sOrH: BOOLEAN;
			profG,
			attG,
			fonc,
			nbPars: LONGINT;
			pars: Params;
		END;
		
		ActionsSem= POINTER TO ARRAY OF ActionSem;
		
		RegleSynt= RECORD
			longueur,
			nonTerm ,
			nbAct: LONGINT;
			act: ActionsSem;
		END;
		
		ReglesSynt= POINTER TO ARRAY OF RegleSynt;
		
		RecEtat= RECORD
			etatDep,
			nTGoto: LONGINT;
		END;
		
		RecEtats= POINTER TO ARRAY OF RecEtat;
		
		RecTerm= RECORD
			numTerm,
			nbEtats: LONGINT;
			recEtat: RecEtats;
		END;
		
		RecTerms= POINTER TO ARRAY OF RecTerm;
		
		Compilateur= POINTER TO RECORD (* A compiler *)
			nbToksLex: LONGINT;
			toksLex: ToksLex;
			nbEtatsLex,
			profEtatsL: LONGINT;
			etatsLex: EtatsLex;
			nbEtatsCom,
			profEtatsC: LONGINT;
			etatsCom: EtatsLex;
			nbEtatsSynt: LONGINT;
			actionSynt: ActionsSynt;
			nbNonTSynt: LONGINT;
			gotoSynt: GotosSynt;
			nbRegleSynt: LONGINT;
			regleSynt: ReglesSynt;
			nbRecTerms: LONGINT;
			recTerms: RecTerms;
		END;
	
	PROCEDURE LisCompilateur (rd: Files.Rider): Compilateur;
		
		(* Reading of compiler tables in the f '.tbl' file *)
		
		CONST
			
			eOS= 0X;
		
		VAR
			
			c: Compilateur;
			t: ToksLex;
			a: ActSynt;
			ca: Card;
			g: GotoS;
			aS: ActionsSem;
			p: Params;
			r: RecEtats;
			i, j, m, k: LONGINT;
		
		PROCEDURE ReadInt (VAR i: LONGINT);
			
			BEGIN (*ReadInt*)
				Files.ReadLInt(rd, i);
			END ReadInt;
		
		PROCEDURE ReadByte (VAR b: SHORTINT);
			
			VAR
				
				i: LONGINT;
			
			BEGIN (*ReadByte*)
				ReadInt(i);
				b:= SHORT(SHORT(i));
			END ReadByte;
		
		PROCEDURE ReadBool (VAR b: BOOLEAN);
			
			VAR
				
				i: LONGINT;
			
			BEGIN (*ReadBool*)
				ReadInt(i);
				ASSERT((i= 0) OR (i= 1));
				b:= i= 1;
			END ReadBool;
		
		PROCEDURE ReadChar (VAR c: CHAR);
			
			VAR
				
				i: LONGINT;
			
			BEGIN (*ReadChar*)
				ReadInt(i);
				c:= CHR(i);
			END ReadChar;
	
	PROCEDURE ReadString (VAR s: ARRAY OF CHAR);
		
		VAR
			
			n: LONGINT;
			c: CHAR;
		
		BEGIN (*ReadString*)
			n:= 0;
			ReadChar(c);
			WHILE c# eOS DO
				s[n]:= c;
				INC(n);
				ReadChar(c);
			END;
		END ReadString;
	
		PROCEDURE LisEtatsRedLex(nE: LONGINT; VAR eL: EtatsLex);
			
			VAR
				
				i, j: LONGINT;
				t: TransLex;
				gC: GotoLexC;
				gT: GotoLexT;
			
			BEGIN (*LisEtatsRedLex*)
				NEW(eL, nE);
				FOR i:= 0 TO nE-1 DO
					ReadInt(eL[i].recon);
					ReadInt(eL[i].nbTrans);
					ReadInt(eL[i].nbEps);
				END;
				FOR i:= 0 TO nE-1 DO
					IF eL[i].nbTrans> 0 THEN
						NEW(t, eL[i].nbTrans);
						FOR j:= 0 TO eL[i].nbEps-1 DO
							NEW(gT);
							ReadInt(gT.goto);
							ReadInt(gT.transit);
							t[j]:= gT;
						END;
						FOR j:= eL[i].nbEps TO eL[i].nbTrans-1 DO
							NEW(gC);
							ReadInt(gC.goto);
							ReadChar(gC.premCar);
							ReadChar(gC.derCar);
							t[j]:= gC;
						END;
						eL[i].transL:= t;
					END;
				END;
			END LisEtatsRedLex;
		
		BEGIN (*LisCompilateur*)
			NEW(c);
			ReadInt(c.nbToksLex);
			ReadInt(c.nbEtatsLex);
			ReadInt(c.profEtatsL);
			ReadInt(c.nbEtatsCom);
			ReadInt(c.profEtatsC);
			ReadInt(c.nbEtatsSynt);
			ReadInt(c.nbNonTSynt);
			ReadInt(c.nbRegleSynt);
			ReadInt(c.nbRecTerms);
			NEW(t, c.nbToksLex);
			FOR i:= 0 TO c.nbToksLex- 1 DO
				ReadBool(t[i].utile);
				ReadBool(t[i].valUt);
			END;
			FOR i:= 0 TO c.nbToksLex- 1 DO
				ReadInt(k);
				IF k# 0 THEN
					NEW(t[i].nom, k);
					ReadString(t[i].nom^);
				END;
			END;
			c.toksLex:= t;
			LisEtatsRedLex(c.nbEtatsLex, c.etatsLex);
			LisEtatsRedLex(c.nbEtatsCom, c.etatsCom);
			NEW(c.actionSynt, c.nbEtatsSynt);
			FOR i:=0 TO c.nbEtatsSynt-1 DO
				ReadInt(c.actionSynt[i].nbT);
			END;
			FOR i:=0 TO c.nbEtatsSynt-1 DO
				NEW(a, c.actionSynt[i].nbT);
				FOR j:= 0 TO c.actionSynt[i].nbT-1 DO
					ReadByte(a[j].quoi);
					ReadInt(a[j].premTerm);
					ReadInt(a[j].derTerm);
					ReadInt(a[j].aux);
				END;
				c.actionSynt[i].actions:=a;
			END;
			NEW(c.gotoSynt, c.nbNonTSynt);
			FOR i:= 0 TO c.nbNonTSynt-1 DO
				ReadInt(c.gotoSynt[i].nbAtts);
				ReadInt(c.gotoSynt[i].nbE);
			END;
			FOR i:= 0 TO c.nbNonTSynt-1 DO
				IF c.gotoSynt[i].nbAtts> 0 THEN
					NEW(ca, c.gotoSynt[i].nbAtts);
					FOR j:= 0 TO c.gotoSynt[i].nbAtts-1 DO
						ReadInt(ca[j]);
					END;
					c.gotoSynt[i].typsAt:=ca;
				END;
				IF c.gotoSynt[i].nbE> 0 THEN
					NEW(g, c.gotoSynt[i].nbE);
					FOR j:=0 TO c.gotoSynt[i].nbE-1 DO
						ReadInt(g[j].depart);
						ReadInt(g[j].arrivee);
					END;
					c.gotoSynt[i].gotos:= g;
				END;
			END;
			NEW(c.regleSynt, c.nbRegleSynt);
			FOR i:=0 TO c.nbRegleSynt-1 DO
				ReadInt(c.regleSynt[i].longueur);
				ReadInt(c.regleSynt[i].nonTerm);
				ReadInt(c.regleSynt[i].nbAct);
			END;
			FOR i:=0 TO c.nbRegleSynt-1 DO
				IF c.regleSynt[i].nbAct> 0 THEN
					NEW(aS, c.regleSynt[i].nbAct);
					FOR j:=0 TO c.regleSynt[i].nbAct-1 DO
						ReadBool(aS[j].sOrH);
						ReadInt(aS[j].profG);
						ReadInt(aS[j].attG);
						ReadInt(aS[j].fonc);
						ReadInt(aS[j].nbPars);
					END;
					FOR j:=0 TO c.regleSynt[i].nbAct-1 DO
						IF aS[j].nbPars> 0 THEN
							NEW(p, aS[j].nbPars);
							FOR m:=0 TO aS[j].nbPars-1 DO
								ReadInt(p[m].profD);
								ReadInt(p[m].attD);
							END;
							aS[j].pars:= p;
						END;
					END;
					c.regleSynt[i].act:= aS;
				END;
			END;
			IF c.nbRecTerms> 0 THEN
				NEW(c.recTerms, c.nbRecTerms);
				FOR i:= 0 TO c.nbRecTerms-1 DO
					ReadInt(c.recTerms[i].numTerm);
					ReadInt(c.recTerms[i].nbEtats);
				END;
				FOR i:= 0 TO c.nbRecTerms-1 DO
					NEW(r, c.recTerms[i].nbEtats);
					FOR j:= 0 TO c.recTerms[i].nbEtats-1 DO
						ReadInt(r[j].etatDep);
						ReadInt(r[j].nTGoto);
					END;
					c.recTerms[i].recEtat:= r;
				END;
			END;
			RETURN c;
		END LisCompilateur;
	
	PROCEDURE EcrisCompilateur (c: Compilateur; f: Texts.Writer);
		
		VAR
			
			i, j, k: LONGINT;
			
			rien,
			sansNom,
			utile,
			inutile,
			valeurU,
			valeurNonU,
			copie,
			douce,
			dure: M.Chaine;
		
		PROCEDURE EcrisEtatsRedLex (nT, nE, pE: LONGINT; eL:EtatsLex; nN, pN, lN: ARRAY OF CHAR);
			
			VAR
				
				i, j: LONGINT;
			
			BEGIN (*EcrisEtatsRedLex*)
				Texts.WriteString(f, nN); Texts.WriteString(f, ' = '); Texts.WriteInt(f, nE, 0); Texts.WriteLn(f);
				Texts.WriteString(f, pN); Texts.WriteString(f, ' = '); Texts.WriteInt(f, pE, 0); Texts.WriteLn(f);
				FOR i:=0 TO nE-1 DO
					Texts.Write(f, " "); Texts.WriteString(f, lN); Texts.WriteString(f, ' '); Texts.WriteInt(f, i, 0); Texts.WriteLn(f);
					Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'recon = ');
					IF eL[i].recon< nT THEN
						Texts.WriteInt(f, eL[i].recon, 0);
					ELSE
						Texts.WriteString(f, rien^);
					END;
					Texts.WriteLn(f);
					Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'nbTrans = '); Texts.WriteInt(f, eL[i].nbTrans, 0); Texts.WriteLn(f);
					Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'nbEps = '); Texts.WriteInt(f, eL[i].nbEps, 0); Texts.WriteLn(f);
					FOR j:=1 TO eL[i].nbEps DO
						Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'transL '); Texts.WriteInt(f, j-1, 0); Texts.WriteLn(f);
						Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'goto = '); Texts.WriteInt(f, eL[i].transL[j-1].goto, 0); Texts.WriteLn(f);
						Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'transit = '); Texts.WriteInt(f, eL[i].transL[j-1](GotoLexT).transit, 0); Texts.WriteLn(f);
					END;
					FOR j:= eL[i].nbEps+ 1 TO eL[i].nbTrans DO
						Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'transL '); Texts.WriteInt(f, j- 1, 0); Texts.WriteLn(f);
						Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'goto = '); Texts.WriteInt(f, eL[i].transL[j-1].goto, 0); Texts.WriteLn(f);
						Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'premCar = '); Texts.WriteInt(f, ORD(eL[i].transL[j- 1](GotoLexC).premCar), 0); Texts.WriteLn(f);
						Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'derCar = '); Texts.WriteInt(f, ORD(eL[i].transL[j- 1](GotoLexC).derCar), 0); Texts.WriteLn(f);
					END;
				END;
			END EcrisEtatsRedLex;
		
		BEGIN (*EcrisCompilateur*)
			rien:= M.Map("#Babel:ENothing", "", "", "");
			sansNom:= M.Map("#Babel:Eunnamed", "", "", "");
			utile:= M.Map("#Babel:Eused", "", "", "");
			inutile:= M.Map("#Babel:Eunused", "", "", "");
			valeurU:= M.Map("#Babel:EusedVal", "", "", "");
			valeurNonU:= M.Map("#Babel:EunusedVal", "", "", "");
			copie:= M.Map("#Babel:Ecopy", "", "", "");
			douce:= M.Map("#Babel:Esoft", "", "", "");
			dure:= M.Map("#Babel:Ehard", "", "", "");
			Texts.WriteString(f, 'nbToksLex = '); Texts.WriteInt(f, c.nbToksLex, 0); Texts.WriteLn(f);
			FOR i:= 0 TO c.nbToksLex- 1 DO
				Texts.Write(f, " "); Texts.WriteString(f, 'toksLex '); Texts.WriteInt(f, i, 0); Texts.WriteLn(f);
				Texts.Write(f, " "); Texts.Write(f, " "); 
				IF c.toksLex[i].nom= NIL THEN
					Texts.WriteString(f, sansNom^);
				ELSE
					Texts.WriteString(f, c.toksLex[i].nom^);
				END;
				Texts.WriteLn(f);
				Texts.Write(f, " "); Texts.Write(f, " "); 
				IF c.toksLex[i].utile THEN
					Texts.WriteString(f, utile^);
				ELSE
					Texts.WriteString(f, inutile^);
				END;
				 Texts.WriteLn(f);
				Texts.Write(f, " "); Texts.Write(f, " "); 
				IF c.toksLex[i].valUt THEN
					Texts.WriteString(f, valeurU^);
				ELSE
					Texts.WriteString(f, valeurNonU^);
				END;
				Texts.WriteLn(f);
			END;
			EcrisEtatsRedLex(c.nbToksLex, c.nbEtatsLex, c.profEtatsL, c.etatsLex, 'nbEtatsLex', 'profEtatsL', 'etatsLex');
			EcrisEtatsRedLex(3, c.nbEtatsCom, c.profEtatsC, c.etatsCom, 'nbEtatsCom', 'profEtatsC', 'etatsCom');
			Texts.WriteString(f, 'nbEtatsSynt = '); Texts.WriteInt(f, c.nbEtatsSynt, 0); Texts.WriteLn(f);
			FOR i:= 0 TO c.nbEtatsSynt- 1 DO
				Texts.Write(f, " "); Texts.WriteString(f, 'actionSynt '); Texts.WriteInt(f, i, 0); Texts.WriteLn(f);
				Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'nbT = '); Texts.WriteInt(f, c.actionSynt[i].nbT, 0); Texts.WriteLn(f);
				FOR j:= 0 TO c.actionSynt[i].nbT- 1 DO
					Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'actions '); Texts.WriteInt(f, j+ 1, 0); Texts.WriteLn(f);
					Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'quoi = ');
					CASE c.actionSynt[i].actions[j].quoi OF
						|deplaceS:
							 Texts.WriteString(f, 'deplaceS'); Texts.WriteLn(f);
							 Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'aux = '); Texts.WriteInt(f, c.actionSynt[i].actions[j].aux, 0); Texts.WriteLn(f);
						|reduitS :
							 Texts.WriteString(f, 'reduitS'); Texts.WriteLn(f);
							 Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'aux = '); Texts.WriteInt(f, c.actionSynt[i].actions[j].aux, 0); Texts.WriteLn(f);
						|accepteS:
							 Texts.WriteString(f, 'accepteS'); Texts.WriteLn(f);
						|erreurS :
							 Texts.WriteString(f, 'erreurS'); Texts.WriteLn(f);
					END;
					IF j< c.actionSynt[i].nbT- 1 THEN
						Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'premTerm = '); Texts.WriteInt(f, c.actionSynt[i].actions[j].premTerm, 0); Texts.WriteLn(f);
						Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'derTerm = '); Texts.WriteInt(f, c.actionSynt[i].actions[j].derTerm, 0); Texts.WriteLn(f);
					END;
				END;
			END;
			Texts.WriteString(f, 'nbNonTSynt = '); Texts.WriteInt(f, c.nbNonTSynt, 0); Texts.WriteLn(f);
			FOR i:= 0 TO c.nbNonTSynt- 1 DO
				Texts.Write(f, " "); Texts.WriteString(f, 'gotoSynt '); Texts.WriteInt(f, i, 0); Texts.WriteLn(f);
				Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'nbAtts = '); Texts.WriteInt(f, c.gotoSynt[i].nbAtts, 0); Texts.WriteLn(f);
				FOR j:= 0 TO c.gotoSynt[i].nbAtts- 1 DO
					Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'typsAt '); Texts.WriteInt(f, j+1, 0); Texts.WriteString(f, ' = '); Texts.WriteInt(f, c.gotoSynt[i].typsAt[j], 0); Texts.WriteLn(f);
				END;
				Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'nbE = '); Texts.WriteInt(f, c.gotoSynt[i].nbE, 0); Texts.WriteLn(f);
				FOR j:= 0 TO c.gotoSynt[i].nbE- 1 DO
					Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'gotos '); Texts.WriteInt(f, j+ 1, 0); Texts.WriteLn(f);
					Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'depart = '); Texts.WriteInt(f, c.gotoSynt[i].gotos[j].depart, 0); Texts.WriteLn(f);
					Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'arrivee = '); Texts.WriteInt(f, c.gotoSynt[i].gotos[j].arrivee, 0); Texts.WriteLn(f);
				END;
			END;
			Texts.WriteString(f, 'nbRegleSynt = '); Texts.WriteInt(f, c.nbRegleSynt, 0); Texts.WriteLn(f);
			FOR i:= 0 TO c.nbRegleSynt- 1 DO
				Texts.Write(f, " "); Texts.WriteString(f, 'regleSynt '); Texts.WriteInt(f, i, 0); Texts.WriteLn(f);
				Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'longueur = '); Texts.WriteInt(f, c.regleSynt[i].longueur, 0); Texts.WriteLn(f);
				Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'nonTerm = '); Texts.WriteInt(f, c.regleSynt[i].nonTerm, 0); Texts.WriteLn(f);
				Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'nbAct = '); Texts.WriteInt(f, c.regleSynt[i].nbAct, 0); Texts.WriteLn(f);
				FOR j:= 0 TO c.regleSynt[i].nbAct- 1 DO
					Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'act '); Texts.WriteInt(f, j+1, 0); Texts.WriteLn(f);
					Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); 
					IF c.regleSynt[i].act[j].sOrH THEN
						IF c.regleSynt[i].act[j].fonc= 0 THEN
							Texts.WriteString(f, copie^);
						ELSE
							Texts.WriteString(f, douce^);
						END;
					ELSE
						Texts.WriteString(f, dure^);
					END;
					Texts.WriteLn(f);
					Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'profG = '); Texts.WriteInt(f, c.regleSynt[i].act[j].profG, 0); Texts.WriteLn(f);
					Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'attG = '); Texts.WriteInt(f, c.regleSynt[i].act[j].attG, 0); Texts.WriteLn(f);
					IF c.regleSynt[i].act[j].fonc> 0 THEN
						Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'fonc = '); Texts.WriteInt(f, c.regleSynt[i].act[j].fonc, 0); Texts.WriteLn(f);
					END;
					Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'nbPars = '); Texts.WriteInt(f, c.regleSynt[i].act[j].nbPars, 0); Texts.WriteLn(f);
					FOR k:= 0 TO c.regleSynt[i].act[j].nbPars- 1 DO
						Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'pars '); Texts.WriteInt(f, k+ 1, 0); Texts.WriteLn(f);
						Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'profD = '); Texts.WriteInt(f, c.regleSynt[i].act[j].pars[k].profD, 0); Texts.WriteLn(f);
						Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'attD = '); Texts.WriteInt(f, c.regleSynt[i].act[j].pars[k].attD, 0); Texts.WriteLn(f);
					END;
				END;
			END;
			Texts.WriteString(f, 'nbRecTerms = '); Texts.WriteInt(f, c.nbRecTerms, 0); Texts.WriteLn(f);
			FOR i:= 0 TO c.nbRecTerms- 1 DO
				Texts.Write(f, " "); Texts.WriteString(f, 'recTerms '); Texts.WriteInt(f, i+1, 0); Texts.WriteLn(f);
				Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'numTerm = '); Texts.WriteInt(f, c.recTerms[i].numTerm, 0); Texts.WriteLn(f);
				Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'nbEtats = '); Texts.WriteInt(f, c.recTerms[i].nbEtats, 0); Texts.WriteLn(f);
				FOR j:= 0 TO c.recTerms[i].nbEtats- 1 DO
					Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'recEtat '); Texts.WriteInt(f, j+ 1, 0); Texts.WriteLn(f);
					Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'etatDep = '); Texts.WriteInt(f, c.recTerms[i].recEtat[j].etatDep, 0); Texts.WriteLn(f);
					Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.Write(f, " "); Texts.WriteString(f, 'nTGoto = '); Texts.WriteInt(f, c.recTerms[i].recEtat[j].nTGoto, 0); Texts.WriteLn(f);
				END;
			END;
		END EcrisCompilateur;
	
	(** Extracts the content of a tbl file *)
	PROCEDURE Do*;
		
		VAR
			
			name: ARRAY 64 OF CHAR;
			fi: Files.File;
			c: Compilateur;
			t: Texts.Text;
			f: Texts.Writer;
			s: Texts.Scanner;
			rd: Files.Rider;
		
		BEGIN (*Do*)
			Texts.OpenScanner(s, Oberon.Par.text, Oberon.Par.pos);  Texts.Scan(s);
			IF s.class = Texts.Name THEN
				COPY(s.s, name);
				fi:= Files.Old(name);
				IF fi# NIL THEN
					Files.Set(rd, fi, 0);
					c:= LisCompilateur(rd);
					Files.Close(fi);
					Texts.New; t:= Objects.NewObj(Texts.Text);
					Texts.OpenWriter(f);
					EcrisCompilateur(c, f);
					Texts.Append(t, f.buf);
					Strings.ChangeSuffix(name, "Comp");
					Oberon.OpenText(name, t, 500, 200);
				END;
			END;
		END Do;

	END BabelExtract.

BabelExtract.Do Babel.Tbl
System.Free BabelExtract ~
BIERBP  SP    P    <       f 
     C  Oberon10.Scn.Fnt 30.03.2002  20:18:46  TimeStamps.New  