TextDocs.NewDoc     F   CColor     Flat  Locked  Controls  Org      BIER`   b        3    Oberon12.Scn.Fnt          N  Oberon10.Scn.Fnt              V        ;                S        X                R                u                        ~        f        ~        8        :        +        /        ,        -                              4       /               "        x            ~  (* 
Babel: a compiler compiler.

 c Grard MEUNIER 1990

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

MODULE BabelDef;
	
	(* *)
	
	(** The module BabelDef is part of the Babel subsystem, a compiler compiler. BabelDef holds general definitions and methods. *)
	
	IMPORT
		
		C:= BabelCompil, Strings;
	
	CONST
		
		eOS*= 0X; (** End of string *)

		eOF1*= C.eOF1;
		eOF2*=C.eOF2; (** End of file = eOF1 or eOF2 *)

		eOL1*= C.eOL1;
		eOL2*= C.eOL2; (** End of line = eOL1, or eOL2, or eOL1 followed by eOL2 *)
		
		inf*= -1; ega*= 0; sup*= +1; (** less than, equal, more than *)
		
		indexLong*= 20;
	
	TYPE
		
		Index*= ARRAY indexLong OF CHAR;
		
		(** The following definitions are the same than those found in BabelCompil. See BabelCompil for further explanations *)
		
		Chaine*= C.Chaine;
		
		TokLex*= RECORD (* A token *)
			nom*: Chaine;
			utile*,
			valUt*: BOOLEAN;
		END;
		
		ToksLex*= POINTER TO ARRAY OF TokLex;
		
		GotoLex*= POINTER TO  RECORD
			goto*: LONGINT;
		END;
		
		GotoLexC*= POINTER TO RECORD (GotoLex)
			premCar*,
			derCar*: CHAR;
		END;
		
		GotoLexT*= POINTER TO RECORD (GotoLex)
			transit*: LONGINT;
		END;
		
		TransLex*= POINTER TO ARRAY OF GotoLex;
		
		Card*= POINTER TO ARRAY OF LONGINT;
		
		EtatLex*= RECORD
			recon*,
			nbTrans*,
			nbEps*: LONGINT;
			transL*: TransLex;
		END;
		
		EtatsLex*= POINTER TO ARRAY OF EtatLex;
	
	CONST
		
		deplaceS*= 0;
		reduitS*= 1;
		accepteS*= 2;
		erreurS*= 3;
	
	TYPE
		
		ActionS*=RECORD
			quoi*: SHORTINT; (* deplaceS, reduitS, accepteS ou erreurS *)
			premTerm*,
			derTerm*,
			aux*: LONGINT;
		END;
		
		ActSynt*= POINTER TO ARRAY OF ActionS;
		
		ActionSynt*= RECORD
			 nbT*: LONGINT;
			 actions*: ActSynt;
		 END;
		
		ActionsSynt*= POINTER TO ARRAY OF ActionSynt;
		
		GtS*= RECORD
			depart*,
			arrivee*: LONGINT;
		END;
		
		GotoS*=POINTER TO ARRAY OF GtS;
		
		GotoSynt*= RECORD
			 nbAtts*: LONGINT;
			 typsAt*: Card;
			 nbE*: LONGINT;
			 gotos*: GotoS;
		 END;
		
		GotosSynt*= POINTER TO ARRAY OF GotoSynt;
		
		Param*= RECORD
			profD*,
			attD*: LONGINT;
		END;
		
		Params*= POINTER TO ARRAY OF Param;
		
		ActionSem*= RECORD
			sOrH*: BOOLEAN;
			profG*,
			attG*,
			fonc*,
			nbPars*: LONGINT;
			pars*: Params;
		END;
		
		ActionsSem*= POINTER TO ARRAY OF ActionSem;
		
		RegleSynt*= RECORD
			longueur*,
			nonTerm*,
			nbAct*: LONGINT;
			act*: ActionsSem;
		END;
		
		ReglesSynt*= POINTER TO ARRAY OF RegleSynt;
		
		RecEtat*= RECORD
			etatDep*,
			nTGoto*: LONGINT;
		END;
		
		RecEtats*= POINTER TO ARRAY OF RecEtat;
		
		RecTerm*= RECORD
			numTerm*,
			nbEtats*: LONGINT;
			recEtat*: RecEtats;
		END;
		
		RecTerms*= POINTER TO ARRAY OF RecTerm;
		
		Compiler*= POINTER TO RECORD
			nbToksLex*: LONGINT;
			toksLex*: ToksLex;
			nbEtatsLex*,
			profEtatsL*: LONGINT;
			etatsLex*: EtatsLex;
			nbEtatsCom*,
			profEtatsC*: LONGINT;
			etatsCom*: EtatsLex;
			nbEtatsSynt*: LONGINT;
			actionSynt*: ActionsSynt;
			nbNonTSynt*: LONGINT;
			gotoSynt*: GotosSynt;
			nbRegleSynt*: LONGINT;
			regleSynt*: ReglesSynt;
			nbRecTerms*: LONGINT;
			recTerms*: RecTerms;
		END;
		
		Sorties*= POINTER TO  RECORD
		END;
			
			(** A collection of inout user defined methods. *)
	
	(** Writes a string *)
	PROCEDURE (so: Sorties) String*(s: ARRAY OF CHAR);
		
		BEGIN (*String*)
			HALT(20);
		END String;
	
	(** Writes a carriage return. *)
	PROCEDURE (so: Sorties) Ln* ;
		
		BEGIN (*Ln*)
			HALT(20);
		END Ln;
	
	(** Maps an index text to a more lengthy one. p0, p1, p2 replaces, without mapping, instances of , respectively, ^0, ^1 and ^2 appearing in the replacement text. *)
	PROCEDURE (so: Sorties) Map*(index, p0, p1, p2: ARRAY OF CHAR): Chaine;
		
		BEGIN (*Map*)
			HALT(20);
		END Map;
	
	(** Compares alphabetically s1 and s2. Returns inf (s1< s2), ega or sup. *)
	PROCEDURE CompStr*(s1, s2: Chaine): SHORTINT;
		
		BEGIN (*CompStr*)
			IF s1^< s2^ THEN
				RETURN inf;
			ELSIF s1^> s2^ THEN
				RETURN sup;
			ELSE
				RETURN ega;
			END;
		END CompStr;
	
	(** Returns in sB a slice of sS, beginning at p and of lenth l. *)
	PROCEDURE Slice*(VAR sB: ARRAY OF CHAR; sS:ARRAY OF CHAR; p, l: LONGINT);
		
		VAR
			
			i, m: LONGINT;
		
		BEGIN (*Slice*)
			ASSERT(p>= 0);
			IF l>= LEN(sB) THEN
				l:= LEN(sB)- 1;
			END;
			m:= Strings.Length(sS);
			i:= 0;
			WHILE (i< l) & (p< m) DO
				sB[i]:= sS[p];
				INC(i); INC(p);
			END;
			sB[i]:= eOS;
		END Slice;
	
	(** Writes the integer n into the string s. *)
	PROCEDURE CardToStr*(n: LONGINT; VAR s: ARRAY OF CHAR);
		
		VAR
			
			i, m: LONGINT;
			c: CHAR;
		
		BEGIN (*CardToStr*)
			ASSERT(n>= 0);
			m:= LEN(s)- 1;
			i:= 0;
			WHILE (n> 0) & (i< m) DO
				s[i]:= CHR(n MOD 10+ ORD('0'));
				n:= n DIV 10;
				INC(i);
			END;
			IF (i= 0) & (0< m) THEN
				s[0]:= '0';
				i:= 1;
			END;
			s[i]:= eOS;
			DEC(i); n:=0;
			WHILE i> n DO
				c:= s[i];
				s[i]:= s[n];
				s[n]:= c;
				INC(n); DEC(i);
			END;
		END CardToStr;
	
	(** Returns in n the value of the integer read from s. Result= TRUE if all is ok. *)
	PROCEDURE StrToCard*(s: ARRAY OF CHAR; VAR n: LONGINT): BOOLEAN;
		
		VAR
			
			i, m: LONGINT;
		
		BEGIN (*StrToCard*)
			m:= LEN(s)- 1;
			i:= 0; n:= 0;
			WHILE (i< m) & (s[i]>= '0') & (s[i]<= '9') & (n<= (MAX(LONGINT)- ORD(s[i])+ ORD('0')) DIV 10) DO
				n:= n* 10+ (ORD(s[i])- ORD('0'));
				INC(i);
			END;
			RETURN (i> 0) & (s[i]= eOS);
		END StrToCard;
	
	END BabelDef.
BIER  0       <       f 
     C  Oberon10.Scn.Fnt 30.03.2002  20:16:10  TimeStamps.New  