TextDocs.NewDoc     F   CColor     Flat  Locked  Controls  Org M   BIER`   b        3  8        Oberon12.Scn.Fnt          @   <   (* 
Babel: a compiler compiler.

 c Grard MEUNIER 1990

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

MODULE BabelCompil;
	
	(**)
	
	(** The module BabelCompil (Compil for short) is the online part of the Babel subsystem, a compiler compiler. The module BabelBabel converts a grammar written in a text definition document into tables written into a binary file (.Tbl extension). Compil is able to read this .Tbl file and to parse texts in accordance with provided grammar rules. There are three objects defined in Compil:
		-	Compiler (a compiler, which represents the content of a .Tbl file);
		-	Compilation (a compilation instance, that one must provide with a compiler and several methods (Read for the reading of text, Execution for the implementation of hard functions ---see below---, Map, optional, for translations of messages, and Error, optional, for errors handling);
		-	Object (objects produced by the compilation process: strings extracted from text; results of hard functions; trees of Object, recursively produced by soft functions ---see below).
	Hard and soft functions are defined in grammar grammar definition documents. A hard function is implemented in the Compilation.Execution method and produces an userObj result; a soft function doesn't require any method: it produces a tree (termObj) whose root is the function and whose subtrees are its arguments. TermeObj trees may be used later by hard functions. *)
	
	IMPORT
	
		(*
		StdLog,
		*)
		
		Strings;

	CONST
		
		eOS= 0X; (* End of string *)

		eOF1*= 0X;
		eOF2*=1AX; (** End of file = eOF1 or eOF2 *)

		eOL1*=0DX;
		eOL2*=0AX; (** End of line = eOL1, or eOL2, or eOL1 followed by eOL2 *)
		
		stringObj*= 0; (** Points out an Object containing a terminal string of the parsed text,... *)
		userObj*= 1; (** ... the result of a hard function,... *)
		termObj*= 2; (** ... a tree of Object, result of a soft function,... *)
		nulObj*= 3; (** ... or an empty Object, when an syntax error has occurred. *)
		
		tBS= MAX(SET)-MIN(SET)+1;
		
		deplaceS= 0;	(* Shift action *)
		reduitS= 1;	(* Reduce action *)
		accepteS= 2; (* Accepts action *)
		erreurS= 3;	(* Error *)
		
		lexFin= 0;
		debComment= 1;
		finComment= 2;
	
	TYPE
		
		ANYPTR*= POINTER TO RECORD
		END;
		
		Chaine*= POINTER TO ARRAY OF CHAR;
		
		(* Definitions for the lexical analyzer *)
		
		TokLex= RECORD (* A token *)
			nom: Chaine;
			utile,
			valUt: BOOLEAN;
		END;
		
		ToksLex= POINTER TO ARRAY OF TokLex;
		
		GotoLex= POINTER TO RECORD
			goto: LONGINT;
		END;
		
		GotoLexC= POINTER TO RECORD (GotoLex)
			premCar,
			derCar :CHAR;
		END;
		
		GotoLexT= POINTER TO RECORD (GotoLex)
			transit: LONGINT;
		END;
		
		TransLex= POINTER TO ARRAY OF GotoLex;
		
		Card= POINTER TO ARRAY OF LONGINT;
		
		EtatLex= RECORD
			recon,
			nbTrans,
			nbEps: LONGINT;
			transL: TransLex;
		END;
		
		EtatsLex= POINTER TO ARRAY OF EtatLex;
		
	(* Definitions for the parser *)
		
		ActionS= RECORD
			quoi: SHORTINT;
			premTerm,
			derTerm ,
			aux: LONGINT;
		END;
		
		ActSynt= POINTER TO ARRAY OF ActionS;
		
		ActionSynt= RECORD
			nbT: LONGINT;
			actions: ActSynt;
		END;
		
		ActionsSynt=POINTER TO ARRAY OF ActionSynt;
		
		GtS= RECORD
			depart ,
			arrivee: LONGINT;
		END;
		
		GotoS= POINTER TO ARRAY OF GtS;
		
		GotoSynt= RECORD
			nbAtts: LONGINT;
			typsAt: Card;
			nbE: LONGINT;
			gotos: GotoS;
		END;
		
		GotosSynt= POINTER TO ARRAY OF GotoSynt;
		
		(* Definitions for the semantic analyser *)
		
		Param= RECORD
			profD,
			attD: LONGINT;
		END;
		
		Params= POINTER TO ARRAY OF Param;
		
		ActionSem= RECORD
			sOrH: BOOLEAN;
			profG,
			attG,
			fonc,
			nbPars: LONGINT;
			pars: Params;
		END;
		
		ActionsSem= POINTER TO ARRAY OF ActionSem;
		
		RegleSynt= RECORD
			longueur,
			nonTerm ,
			nbAct: LONGINT;
			act: ActionsSem;
		END;
		
		ReglesSynt= POINTER TO ARRAY OF RegleSynt;
		
		RecEtat= RECORD
			etatDep,
			nTGoto: LONGINT;
		END;
		
		RecEtats= POINTER TO ARRAY OF RecEtat;
		
		RecTerm= RECORD
			numTerm,
			nbEtats: LONGINT;
			recEtat: RecEtats;
		END;
		
		RecTerms= POINTER TO ARRAY OF RecTerm;
		
		Compiler*= POINTER TO RECORD (** A compiler *)
			nbToksLex: LONGINT;
			toksLex: ToksLex;
			nbEtatsLex,
			profEtatsL: LONGINT;
			etatsLex: EtatsLex;
			nbEtatsCom,
			profEtatsC: LONGINT;
			etatsCom: EtatsLex;
			nbEtatsSynt: LONGINT;
			actionSynt: ActionsSynt;
			nbNonTSynt: LONGINT;
			gotoSynt: GotosSynt;
			nbRegleSynt: LONGINT;
			regleSynt: ReglesSynt;
			nbRecTerms: LONGINT;
			recTerms: RecTerms;
		END;
		
		ObjectsList*= POINTER TO ARRAY OF Object; (** A list of Object, hard function parameters *)
		
		SuiteObjets= POINTER TO RECORD
			suivant: SuiteObjets;
			obj: Object;
		END;
		
		Object*= POINTER TO RECORD (** An Object, string extracted from the text or result of a hard or soft function *)
			o: ObjetRef;
		END;
		
		ObjetRef= POINTER TO RECORD
			ligO,
			colO,
			posO: LONGINT;
		END;
		
		ObjetNC= POINTER TO RECORD (ObjetRef)
			numRSynt,
			numRSem ,
			numNC: LONGINT;
			params: ObjectsList;
			declic: SuiteObjets;
		END;
		
		ObjetC= POINTER TO RECORD (ObjetRef)
		END;
		
		ObjetCC= POINTER TO RECORD (ObjetC)
			subst: Object;
		END;

		ObjetCO= POINTER TO RECORD (ObjetC)
			errO: BOOLEAN;
		END;
		
		ObjetCOChaineObj= POINTER TO RECORD (ObjetCO)
			valC: Chaine;
		END;
		
		ObjetCOUtilObj= POINTER TO RECORD (ObjetCO)
			numU,
			foncU: LONGINT;
			valU: ANYPTR;
		END;
		
		ObjetCOTermeObj= POINTER TO RECORD (ObjetCO)
			numT,
			foncT: LONGINT;
			filsT: ObjectsList;
		 END;
		
		ObjetCONulObj= POINTER TO RECORD (ObjetCO)
		END;
		
		Pile= POINTER TO RECORD (** Stack *)
			suivant: Pile;
			etat: LONGINT;
			attrib: ObjectsList;
		END;
		
		EnsBS= POINTER TO ARRAY OF SET;
		
		EnsEtat= RECORD
			pEtat: Card;
			sommet: LONGINT;
			ensemble: EnsBS;
		END;
		
		EnsEtats= ARRAY 2 OF EnsEtat;
		
		EnsEtatsTab= POINTER TO ARRAY OF EnsEtats;
		
		Compilation*= POINTER TO RECORD (** A compilation *)
			compil: Compiler;
			ensEtatLex,
			ensEtatCom: EnsEtatsTab;
			bSE,
			yAErreurI,
			yAErreurE,
			yAEuErreur,
			stopCompil,
			arret: BOOLEAN;
			etatEOL,
			pos,
			ligne,
			colonne,
			forward: LONGINT;
			cCour: CHAR;
			pile: Pile;
		END;
		
		Directory*= POINTER TO RECORD (** Compiler factory *)
		END;
	
	PROCEDURE^ (o: Object) Subst (): Object;
	
	(*
	PROCEDURE (o: Object) Affiche;
		
		(* For debugging purposes *)
		
		VAR
			
			oo: ObjetRef;
		
		BEGIN (*Affiche*)
			StdLog.Ln;
			oo:= o.o;
			IF oo= NIL THEN
				StdLog.String("Objet de contenu nil"); StdLog.Ln;
			ELSE
				StdLog.String("ligO= "); StdLog.Int(oo.ligO); StdLog.Ln;
				StdLog.String("colO= "); StdLog.Int(oo.colO); StdLog.Ln;
				StdLog.String("posO= "); StdLog.Int(oo.posO); StdLog.Ln;
				WITH
					|oo: ObjetNC DO
						StdLog.String("Objet non calcul"); StdLog.Ln;
						StdLog.String("numRSynt= "); StdLog.Int(oo.numRSynt); StdLog.Ln;
						StdLog.String("numRSem= "); StdLog.Int(oo.numRSem); StdLog.Ln;
						StdLog.String("numNC= "); StdLog.Int(oo.numNC); StdLog.Ln;
					|oo: ObjetCC DO
						StdLog.String("Objet copi de :"); StdLog.Ln;
						o.Subst().Affiche;
					|oo: ObjetCO DO
						StdLog.String("Objet original ... ");
						IF oo.errO THEN
							StdLog.String("en erreur")
						ELSE
							StdLog.String("sans erreur")
						END;
						WITH
							|oo: ObjetCOChaineObj DO
								StdLog.String(" ... chane"); StdLog.Ln;
								StdLog.String("valC= "); StdLog.String(oo.valC); StdLog.Ln;
							|oo: ObjetCOUtilObj DO
								StdLog.String(" ... utilisateur"); StdLog.Ln;
								StdLog.String("numU= "); StdLog.Int(oo.numU); StdLog.Ln;
								StdLog.String("foncU= "); StdLog.Int(oo.foncU); StdLog.Ln;
							|oo: ObjetCOTermeObj DO
								StdLog.String(" ... terme"); StdLog.Ln;
								StdLog.String("numT= "); StdLog.Int(oo.numT); StdLog.Ln;
								StdLog.String("foncT= "); StdLog.Int(oo.foncT); StdLog.Ln;
							|oo: ObjetCONulObj DO
								StdLog.String(" ... nul"); StdLog.Ln;
						END;
				END;
			END;
			StdLog.Ln;
		END Affiche;
	
	PROCEDURE  Affiche (l: ObjectsList);
		
		(* For debugging *)
		
		VAR
			
			i: LONGINT;
		
		BEGIN (*Affiche*)
			StdLog.Ln; StdLog.String("Liste : ");
			IF l= NIL THEN
				StdLog.String("vide"); StdLog.Ln;
			ELSE
				FOR i:= 0 TO LEN(l)- 1 DO
					StdLog.Ln; StdLog.String("Objet "); StdLog.Int(i);
					l[i].Affiche;
				END;
			END;
		END Affiche;
	*)
	
	(** Text reading method: ch is the next character read. When reading after the end of text, ch must return eOF1 or eOF2. *)
	PROCEDURE (c: Compilation) Read-(VAR ch: CHAR);
		
		BEGIN (*Read*)
			HALT(20);
		END Read;
	
	(** Returns the current position in the input stream of chars (origin can have any value). *)
	PROCEDURE (c: Compilation) Pos-(): LONGINT;
		
		BEGIN (*Pos*)
			HALT(20);
		END Pos;
	
	(** Moves the current position in the input stream of chars to pos (origin must be the same than for Pos(). pos may extend until the position which follows the end of the text. *)
	PROCEDURE (c: Compilation) SetPos-(pos: LONGINT);
		
		BEGIN (*SetPos*)
			HALT(20);
		END SetPos;
	
	(** Execution of hard functions: fNum is the index of the hard function, parsNb is the number of input parameters; pars is the list of input parameters; objPos is an Object whose position in text will be the position of res; res is the result of the hard function (objUtil); the boolean result indicates whether all is OK or not; if not, the resulting Object will contain an error. *)
	PROCEDURE (c: Compilation) Execution-(fNum, parsNb: LONGINT; pars: ObjectsList; VAR objPos: Object; VAR res: ANYPTR): BOOLEAN;
		
		BEGIN (*Execution*)
			HALT(20);
		END Execution;
	
	(** Lexical and syntactic errors notification: pos position, line line number and col column number of the error; msg is the error message. *)
	PROCEDURE (c: Compilation) Error*(pos, line, col: LONGINT; msg: ARRAY OF CHAR);
		
		BEGIN (*Error*)
		END Error;
 	
	(** Maps an index text to a more lengthy one. Used to make explicit or to translate error messages. *)
	PROCEDURE (c: Compilation) Map-(index: ARRAY OF CHAR): Chaine;

		
		VAR
			
			ch: Chaine;
		
		BEGIN (*Map*)
			NEW(ch, Strings.Length(index)+ 1);
			COPY(index, ch);
			RETURN ch;
		END Map;

	(* Beginning of Errors handling *)

	PROCEDURE (c: Compilation) ErreurLex (n, li, co, p: LONGINT);
		
		(* Handling of lexical errors *)
		
		VAR
			
			ind: ARRAY 20 OF CHAR;
			mes: Chaine;

		PROCEDURE Err (mes: ARRAY OF CHAR);

			BEGIN (*Err*)
				IF ~c.stopCompil THEN
					c.Error(p, li, co, mes);
					c.yAErreurI:= TRUE;
				END;
			END Err;

		BEGIN (*ErreurLex*)
			CASE n OF
				|1:
					ind:= "CForbidden";
				|2:
					ind:= "COpenedComment";
				|3:
					ind:= "CNoComment";
			END;
			mes:= c.Map(ind);
			Err(mes^);
		END ErreurLex;

	PROCEDURE (c:Compilation) ErreurSynt (li, co, p: LONGINT);
		
		(* Handling of syntactic errors *)

		VAR

			s0, s1, mes: Chaine;
			l, n, i, j, k: LONGINT;
			b, cont: BOOLEAN;
			com: Compiler;
			aSy: ActionSynt;
			aS: ActionS;

		BEGIN (*ErreurSynt*)
			IF ~c.stopCompil THEN
				s0:= c.Map("Cor");
				s1:= c.Map("Cexpected");
				l:=Strings.Length(s0^)+ 2;
				n:=Strings.Length(s1^)+2- l;
				com:= c.compil;
				aSy:= com.actionSynt[c.pile.etat];
				b:= aSy.actions[aSy.nbT-1].quoi#erreurS;
				j:= 1;
				FOR i:= 0 TO aSy.nbT-2 DO
					aS:= aSy.actions[i];
					IF b THEN
						FOR k:= j TO aS.premTerm DO
							INC(n, l+ Strings.Length(com.toksLex[k-1].nom^));
						END;
					END;
					IF aS.quoi# erreurS THEN
						FOR k:= aS.premTerm TO aS.derTerm DO
							INC(n, l+ Strings.Length(com.toksLex[k].nom^));
						END;
					END;
					j:= aS.derTerm+2;
				END;
				IF b THEN
					FOR k:=j TO com.nbToksLex DO
						INC(n, l+ Strings.Length(com.toksLex[k-1].nom^));
					END;
				END;
				NEW(mes, n);
				mes[0]:= eOS;
				cont:= FALSE;
				j:= 1;
				FOR i:= 0 TO aSy.nbT-2 DO
					aS:= aSy.actions[i];
					IF b THEN
						FOR k:=j TO aS.premTerm DO
							IF cont THEN
								Strings.AppendCh(mes^, " ");
								Strings.Append(mes^, s0^);
								Strings.AppendCh(mes^, " ");
							ELSE
								cont:= TRUE;
							END;
							Strings.Append(mes^ , com.toksLex[k-1].nom^);
						END;
					END;
					IF aS.quoi# erreurS THEN
						FOR k:= aS.premTerm TO aS.derTerm DO
							IF cont THEN
								Strings.AppendCh(mes^, " ");
								Strings.Append(mes^, s0^);
								Strings.AppendCh(mes^, " ");
							ELSE
								cont:= TRUE;
							END;
							Strings.Append(mes^, com.toksLex[k].nom^);
						END;
					END;
					j:= aS.derTerm+2;
				END;
				IF b THEN
					FOR k:= j TO com.nbToksLex DO
						IF cont THEN
							Strings.AppendCh(mes^, " ");
							Strings.Append(mes^, s0^);
							Strings.AppendCh(mes^, " ");
						ELSE
							cont:= TRUE;
						END;
						Strings.Append(mes^, com.toksLex[k-1].nom^);
					END;
				END;
				Strings.AppendCh(mes^, " ");
				Strings.Append(mes^, s1^);
				IF (mes[0]>= 'a') & (mes[0]<= 'z') THEN
					mes[0]:= CAP(mes[0]);
				END;
				c.Error(p, li, co, mes^);
				c.yAErreurI:= TRUE;
			END;
		END ErreurSynt;

	(* End of Errors handling *)

	(* Beginning of lexical part *)
	
	PROCEDURE (c:Compilation) AutoEOL;
		
		(* DFA which detects ends of lines *)
		
		BEGIN (*AutoEOL*)
			INC(c.pos);
			INC(c.colonne);
			LOOP
				CASE c.etatEOL OF
					|0:
						CASE c.cCour OF
							|eOL2:
									c.etatEOL:= 1;
							|eOL1:
									c.etatEOL:= 2;
							ELSE
						END;
						EXIT;
					|1:
						c.etatEOL:= 0;
						INC(c.ligne);
						c.colonne:=1;
					|2:
						IF c.cCour= eOL2 THEN
							c.etatEOL:= 1;
							EXIT;
						ELSE
							c.etatEOL:= 0;
							INC(c.ligne);
							c.colonne:= 1;
						END;
				END;
			END;
		END AutoEOL;
	
	PROCEDURE (c:Compilation) InitLex;
		
		BEGIN (*InitLex*)
			c.arret:= FALSE;
			c.forward:= c.Pos();
			c.ligne:= 1; c.colonne:= 0; c.pos:= 0;
			c.etatEOL:= 0;
			c.Read(c.cCour);
			c.AutoEOL;
		END InitLex;
	
	PROCEDURE (c: Compilation) Lex (VAR p, li, co: LONGINT; VAR lVal: LONGINT; VAR valStr: Chaine; VAR err: BOOLEAN): LONGINT;
		
		(* Lexical analyzer *)
		
		VAR
			
			tok, lexBegin: LONGINT;
			err1: BOOLEAN;
			
			j: LONGINT;
		
		PROCEDURE Avance;
			
			BEGIN (*Avance*)
				err1:= FALSE;
				c.arret:= (c.cCour= eOF1) OR (c.cCour= eOF2);
				INC(c.forward);
				IF ~c.arret THEN
					c.Read(c.cCour);
					c.AutoEOL;
				END;
			END Avance;
		
		PROCEDURE Corrige;
			
			BEGIN (*Corrige*)
				IF ~c.arret & (c.forward= lexBegin) THEN
					Avance;
				END;
			END Corrige;
		
		PROCEDURE ^InComment;
		
		PROCEDURE Tourne (nT: LONGINT; eL: EtatsLex; VAR ensEtat: EnsEtats; ensTab: EnsEtatsTab; inC: BOOLEAN);
			
			VAR
				
				i, j, k, n, lexEnd, liE, coE, etatCour, pE, eEE: LONGINT;
				arrE: BOOLEAN;
				chE: CHAR;
			
			PROCEDURE Pousse (VAR e: EnsEtat; etat: LONGINT);
				
				BEGIN (*Pousse*)
					IF ~((etat MOD tBS) IN e.ensemble[etat DIV tBS]) THEN
						INCL(e.ensemble[etat DIV tBS], etat MOD tBS);
						INC(e.sommet);
						e.pEtat[e.sommet]:=etat;
					END;
				END Pousse;
			
			PROCEDURE ValEtat (e: EnsEtat; n: LONGINT; VAR etat: LONGINT): BOOLEAN;
				
				BEGIN (*ValEtat*)
					IF n> e.sommet THEN
						RETURN FALSE;
					ELSE
						etat:= e.pEtat[n];
						RETURN TRUE;
					END;
				END ValEtat;
			
			PROCEDURE EstDans (e: EnsEtat; etat: LONGINT): BOOLEAN;
				
				BEGIN (*EstDans*)
					RETURN (etat MOD tBS) IN e.ensemble[etat DIV tBS];
				END EstDans;
			
			PROCEDURE Tire (VAR e: EnsEtat; VAR etat: LONGINT): BOOLEAN;
				
				BEGIN (*Tire*)
					IF e.sommet< 0 THEN
						RETURN FALSE;
					ELSE
						etat:= e.pEtat[e.sommet];
						DEC(e.sommet);
						EXCL(e.ensemble[etat DIV tBS], etat MOD tBS);
						RETURN TRUE;
					END;
				END Tire;
			
			PROCEDURE Vide (VAR e: EnsEtat);
			
				VAR
					
					n: LONGINT;
				
				BEGIN (*Vide*)
					WHILE Tire(e, n) DO
					END;
				END Vide;
			
			PROCEDURE Complete (VAR e: EnsEtat; prof, position: LONGINT; ch: CHAR; stop: BOOLEAN);
				
				VAR
					
					i, j, n: LONGINT;
				
				PROCEDURE Suit (VAR ensEtat: EnsEtats; depart, position: LONGINT; ch: CHAR): BOOLEAN;
					
					VAR
						
						i, j, k, n, etatCour: LONGINT;
						b, arrete: BOOLEAN;
					
					BEGIN (*Suit*)
						b:= FALSE;
						arrete:= stop;
						etatCour:= 0;
						Pousse(ensEtat[etatCour], depart);
						LOOP
							Complete(ensEtat[etatCour], prof+1, position, ch, arrete);
							j:= 0;
							WHILE ValEtat(ensEtat[etatCour], j, k) DO
								IF eL[k].recon= 0 THEN
									b:=TRUE;
									EXIT;
								END;
								INC(j);
							END;
							IF arrete THEN
								EXIT;
							END;
							WHILE Tire(ensEtat[etatCour], n) DO
								i:= eL[n].nbEps; j:= eL[n].nbTrans;
								WHILE i< j DO
									k:= (i+j) DIV 2;
									IF eL[n].transL[k](GotoLexC).derCar< ch THEN
										i:= k+1;
									ELSE
										j:= k;
									END;
								END;
								IF (j< eL[n].nbTrans) & (eL[n].transL[j](GotoLexC).premCar<= ch) THEN
									Pousse(ensEtat[1-etatCour], eL[n].transL[j].goto);
								END;
							END;
							etatCour:=1-etatCour;
							IF ~ValEtat(ensEtat[etatCour], 0, n) THEN
								EXIT;
							END;
							arrete:=(ch= eOF1) OR (ch= eOF2);
							INC(position); 
							IF ~arrete THEN
								c.Read(ch);
							END;
						END;
						Vide(ensEtat[etatCour]);
						RETURN b;
					END Suit;
				
				BEGIN (*Complete*)
					i:= 0;
					WHILE ValEtat(e, i, n) DO
						FOR j:= 0 TO eL[n].nbEps- 1 DO
							IF ~EstDans(e, eL[n].transL[j].goto) & Suit(ensTab[prof], eL[n].transL[j](GotoLexT).transit, position, ch) THEN
								IF ~stop THEN
									c.SetPos(position+ 1);
									c.cCour:= ch;
								END;
								Pousse(e, eL[n].transL[j].goto);
							END;
						END;
						INC(i);
					END;
				END Complete;
			
			BEGIN (*Tourne*)
				etatCour:= 0;
				LOOP
					err:= FALSE;
					IF ~inC THEN
						li:= c.ligne; co:= c.colonne; p:= c.pos;
					END;
					lexBegin:= c.forward;
					IF c.arret THEN
						tok:= lexFin;
						DEC(lexBegin);
					ELSE
						tok:= nT;
						Pousse(ensEtat[etatCour], 0);
						LOOP
							Complete(ensEtat[etatCour], 1, c.forward, c.cCour, c.arret);
							i:= nT;
							j:= 0;
							WHILE ValEtat(ensEtat[etatCour], j, k) DO
								IF eL[k].recon< i THEN
									i:= eL[k].recon;
								END;
								INC(j);
							END;
							IF i< nT THEN
								tok:= i;
								lexEnd:= c.forward;
								chE:= c.cCour;
								arrE:= c.arret;
								liE:= c.ligne;
								coE:= c.colonne;
								pE:= c.pos;
								eEE:= c.etatEOL;
							END;
							IF c.arret THEN
								EXIT;
							END;
							WHILE Tire(ensEtat[etatCour], n) DO
								i:= eL[n].nbEps; j:= eL[n].nbTrans;
								WHILE i< j DO
									k:= (i+ j) DIV 2;
									IF eL[n].transL[k](GotoLexC).derCar< c.cCour THEN
										i:= k+ 1;
									ELSE
										j:= k;
									END;
								END;
								IF (j< eL[n].nbTrans) & (eL[n].transL[j](GotoLexC).premCar<= c.cCour) THEN
									Pousse(ensEtat[1- etatCour], eL[n].transL[j].goto);
								END;
							END;
							etatCour:= 1- etatCour;
							IF ~ValEtat(ensEtat[etatCour], 0, n) THEN
								EXIT;
							END;
							Avance;
						END;
						Vide(ensEtat[etatCour]);
						IF tok< nT THEN
							c.forward:= lexEnd;
							c.arret:= arrE;
							IF ~arrE THEN
								c.SetPos(lexEnd+ 1);
								c.cCour:= chE;
							END;
							c.ligne:= liE;
							c.colonne:= coE;
							c.pos:= pE;
							c.etatEOL:= eEE;
						END;
					END;
					IF inC THEN
						IF tok= lexFin THEN
							c.ErreurLex(2, li, co, p);
							err:= TRUE;
						END;
						IF tok< nT THEN
							EXIT;
						END;
					ELSE
						IF c.forward= lexBegin THEN
							IF ~err1 THEN
								c.ErreurLex(1, c.ligne, c.colonne, c.pos);
								err1:= TRUE;
							END;
							err:= TRUE;
						END;
						CASE tok OF
							|lexFin:
								 EXIT;
							|debComment:
								 InComment;
								 IF tok= lexFin THEN
									 EXIT;
								 END;
							|finComment:
								 c.ErreurLex(3, li, co, p);
								 err:= TRUE;
							ELSE
								 IF tok= nT THEN
									 IF ~err1 THEN
										 c.ErreurLex(1, c.ligne, c.colonne, c.pos);
										 err1:= TRUE;
									 END;
									 err:= TRUE;
								 ELSIF c.compil.toksLex[tok].utile THEN
									 EXIT;
								 END;
						END;
					END;
					Corrige;
				END;
			END Tourne;
		
		PROCEDURE InComment;
			
			CONST
				
				nbToksCom= 3;
			
			VAR
				
				profComment: LONGINT;
			
			BEGIN (*InComment*)
				profComment:= 1;
				REPEAT
					Tourne(nbToksCom, c.compil.etatsCom, c.ensEtatCom[0], c.ensEtatCom, TRUE);
					IF tok= debComment THEN
						INC(profComment);
					ELSIF tok= finComment THEN
						DEC(profComment);
					END;
				UNTIL (tok= lexFin) OR (profComment= 0);
				IF tok# lexFin THEN
					Corrige;
				END;
			END InComment;
		
		BEGIN (*Lex*)
			err1:= FALSE;
			Tourne(c.compil.nbToksLex, c.compil.etatsLex, c.ensEtatLex[0], c.ensEtatLex, FALSE);
			IF c.compil.toksLex[tok].valUt THEN
				IF c.forward= lexBegin THEN
					lVal:= 1;
					valStr:= NIL;
				ELSE
					lVal:= c.forward- lexBegin+ 1;
					NEW(valStr, lVal);
					c.SetPos(lexBegin);
					FOR j:= 0 TO lVal- 2 DO
						c.Read(valStr[j]);
					END;
					valStr[lVal- 1]:= eOS;
					IF ~c.arret THEN
						c.SetPos(c.forward+ 1);
					END;
				END;
			ELSE
				lVal:= 0;
				valStr:= NIL;
			END;
			Corrige;
			RETURN tok;
		END Lex;
	
	(* End of lexical part *)

	(* Beginning of syntaxic part *)
	
	PROCEDURE (o: Object) Subst (): Object;
		
		BEGIN (*Subst*)
			WHILE o.o IS ObjetCC DO
				o:= o.o(ObjetCC).subst;
			END;
			RETURN o;
		END Subst;
	
	PROCEDURE Pousse (VAR pile: Pile; x: LONGINT; a: ObjectsList);
		
		VAR
			
			p: Pile;
		
		BEGIN (*Pousse*)
			NEW(p);
			p.suivant:= pile;
			p.etat:= x;
			p.attrib:= a;
			pile:= p;
		END Pousse;
	
	PROCEDURE Tire (VAR pile: Pile);
		
		BEGIN (*Tire*)
			pile:= pile.suivant;
		END Tire;
	
	PROCEDURE VidePile (VAR pile: Pile);
		
		BEGIN (*VidePile*)
			pile:= NIL;
		END VidePile;
	
	PROCEDURE (c: Compilation) InitSynt;
		
		BEGIN (*InitSynt*)
			NEW(c.pile);
			c.pile.etat:= 0;
		END InitSynt;
	
	PROCEDURE InitT (p, li, co: LONGINT; s: Chaine; err: BOOLEAN; VAR attrib: ObjectsList);
		
		VAR
			
			o: ObjetCOChaineObj;
		
		BEGIN (*InitT*)
			NEW(attrib, 1);
			NEW(o);
			o.ligO:= li;
			o.colO:= co;
			o.posO:= p;
			o.errO:= err;
			o.valC:= s;
			NEW(attrib[0]);
			attrib[0].o:= o;
		END InitT;
	
	PROCEDURE InitNT (nbA: LONGINT; typesA: Card; VAR a: ObjectsList);
		
		VAR
			
			i: LONGINT;
			o: ObjetNC;
		
		BEGIN (*InitNT*)
			NEW(a, nbA);
			FOR i:= 0 TO nbA- 1 DO
				NEW(o);
				o.ligO:= 0;
				o.colO:= 0;
				o.posO:= 0;
				o.numNC:= typesA[i];
				NEW(a[i]);
				a[i].o:= o;
			END;
		END InitNT;
	
	PROCEDURE InitErr(nbA:LONGINT;VAR a:ObjectsList);
		
		VAR
			
			i: LONGINT;
			o: ObjetCONulObj;
		
		BEGIN (*InitErr*)
			NEW(a, nbA);
			FOR i:= 0 TO nbA- 1 DO
				NEW(o);
				o.ligO:= 0;
				o.colO:= 0;
				o.posO:= 0;
				o.errO:= TRUE;
				NEW(a[i]);
				a[i].o:= o;
			END;
		END InitErr;
	
	PROCEDURE (c: Compilation) Agit (o: Object);
		
		VAR
			
			ok: BOOLEAN;
			i: LONGINT;
			p: ObjectsList;
			obj: Object;
			oo: ObjetNC;
			a: ANYPTR;
			oT: ObjetCOTermeObj;
			oU: ObjetCOUtilObj;
			co: Compiler;
			aS: ActionSem;
		
		PROCEDURE AgitRec;
			
			VAR
				
				d: SuiteObjets;
			
			BEGIN (*AgitRec*)
				LOOP
					IF o.o IS ObjetC THEN
						EXIT;
					ELSE
						oo:= o.o(ObjetNC);
						aS:= co.regleSynt[oo.numRSynt].act[oo.numRSem];
						ok:= TRUE;
						i:= 0;
						WHILE ok & (i< aS.nbPars) DO
							obj:= oo.params[i].Subst();
							ok:= obj.o IS ObjetC;
							INC(i);
						END;
						IF ok THEN
							d:= oo.declic;
							IF aS.sOrH THEN
								p:= oo.params;
								NEW(oT);
								oT.ligO:= oo.ligO; oT.colO:= oo.colO; oT.posO:= oo.posO; 
								oT.numT:= oo.numNC;
								oT.foncT:= aS.fonc;
								oT.filsT:= p;
								oT.errO:=FALSE;
								i:= 0;
								WHILE ~oT.errO & (i< aS.nbPars) DO
									obj:= p[i].Subst();
									oT.errO:= obj.o(ObjetCO).errO;
									INC(i);
								END;
								o.o:= oT;
							ELSE
								obj:= NIL; a:= NIL;
								ok:= ~c.yAErreurE & c.Execution(aS.fonc, aS.nbPars, oo.params, obj, a);
								NEW(oU);
								IF obj# NIL THEN
									oU.ligO:= obj.o.ligO;
									oU.colO:= obj.o.colO;
									oU.posO:= obj.o.posO;
								ELSE
									oU.ligO:= oo.ligO; oU.colO:= oo.colO; oU.posO:= oo.posO; 
								END;
								oU.numU:= oo.numNC;
								oU.foncU:= aS.fonc;
								oU.valU:= a;
								oU.errO:= ~ok;
								c.yAEuErreur:= c.yAEuErreur OR oU.errO;
								o.o:= oU;
							END;
							IF d= NIL THEN
								EXIT;
							END;
							LOOP
								o:= d.obj;
								d:= d.suivant;
								IF d= NIL THEN
									EXIT;
								END;
								AgitRec;
							END;
						ELSE
							EXIT;
						END;
					END;
				END;
			END AgitRec;
		
		BEGIN (*Agit*)
			co:= c.compil;
			AgitRec;
		END Agit;
	
	PROCEDURE (c: Compilation) Execute (nSynt: LONGINT; gauche: ObjectsList);
		
		VAR
			
			i, j: LONGINT;
			o, oS: Object;
			e: SuiteObjets;
			oC: ObjetCC;
			rS: RegleSynt;
			aS: ActionSem;
			oo: ObjetNC;
			p: Param;
		
		PROCEDURE Trouve (prof: LONGINT): ObjectsList;
			
			VAR
				
				p: Pile;
				i: LONGINT;
			
			BEGIN (*Trouve*)
				IF prof= 0 THEN
					RETURN gauche;
				ELSE
					p:= c.pile;
					FOR i:= 2 TO prof DO
						p:= p.suivant;
					END;
					RETURN p.attrib;
				END;
			END Trouve;
		
		PROCEDURE Extrait (prof, att: LONGINT): Object;
			
			VAR
				
				l: ObjectsList;

			BEGIN (*Extrait*)
				l:= Trouve(prof);
				RETURN l[att- 1].Subst();
			END Extrait;
		
		PROCEDURE InsereDeclic (VAR decl: SuiteObjets; o: Object);
			
			VAR
				
				s: SuiteObjets;
			
			BEGIN (*InsereDeclic*)
				s:= decl;
				WHILE (s# NIL) & (s.obj# o) DO
					s:= s.suivant;
				END;
				IF s= NIL THEN
					NEW(s);
					s.suivant:= decl;
					s.obj:= o;
					decl:= s;
				END;
			END InsereDeclic;
		
		BEGIN (*Execute*)
			rS:= c.compil.regleSynt[nSynt];
			FOR i:= 0 TO rS.nbAct-1 DO
				aS:= rS.act[i];
				o:= Extrait(aS.profG, aS.attG);
				IF o.o IS ObjetNC THEN (* Dans le cas contraire, o.o IS ObjetCONulObj *)
					oo:= o.o(ObjetNC);
					IF aS.sOrH & (aS.fonc= 0) THEN
						NEW(oC);
						p:= aS.pars[0];
						oC.subst:= Extrait(p.profD, p.attD);
						o.o:= oC;
						e:= oo.declic;
						IF oC.subst.o IS ObjetC THEN
							WHILE e# NIL DO
								c.Agit(e.obj);
								e:= e.suivant;
							END;
						ELSE
							WHILE e# NIL DO
								InsereDeclic(oC.subst.o(ObjetNC).declic, e.obj);
								e:=e.suivant;
							END;
						END;
					ELSE
						oo.numRSynt:= nSynt;
						oo.numRSem:= i;
						IF aS.nbPars> 0 THEN
							NEW(oo.params, aS.nbPars);
							FOR j:= 0 TO aS.nbPars- 1 DO
								p:= aS.pars[j];
								oS:= Extrait(p.profD, p.attD);
								oo.params[j]:= oS;
								IF oS.o IS ObjetNC THEN
									InsereDeclic(oS.o(ObjetNC).declic, o);
								END;
							END;
						END;
						c.Agit(o);
					END;
				END;
			END;
		END Execute;
	
	PROCEDURE (c:Compilation) Synt;
		
		(* Parser *)
		
		VAR
			
			tok, li, co, l, p: LONGINT;
			s: Chaine;
			err: BOOLEAN;
			com: Compiler;
			
			i, j, k, m: LONGINT;
			a: ObjectsList;
			aSy: ActionSynt;
			aS: ActionS;
			rS: RegleSynt;
			gS: GotoSynt;
		
		PROCEDURE Recupere;
			
			(* Errors recovery *)
			
			VAR
				
				i, j, k, ll, m: LONGINT;
				q: Pile;
				a: ObjectsList;
				rT: RecTerm;
				rE: RecEtat;
				gS: GotoSynt;
			
			BEGIN (*Recupere*)
				IF (com.nbRecTerms= 0) OR (tok= lexFin) THEN
					VidePile(c.pile);
				ELSE
					LOOP
						tok:= c.Lex(p, li, co, l, s, err);
						i:= -1;
						REPEAT
							INC(i);
						UNTIL (i>= com.nbRecTerms) OR (com.recTerms[i].numTerm= tok);
						IF i< com.nbRecTerms THEN
							rT:= com.recTerms[i];
							q:= c.pile;
							WHILE q# NIL DO
								FOR j:= 0 TO rT.nbEtats-1 DO
									rE:= rT.recEtat[j];
									IF q.etat= rE.etatDep THEN
										WHILE c.pile# q DO
											Tire(c.pile);
										END;
										gS:= com.gotoSynt[rE.nTGoto];
										k:= 0;
										ll:= gS.nbE-1;
										WHILE k< ll DO
											m:= (k+ll) DIV 2;
											IF gS.gotos[m].depart< c.pile.etat THEN
												k:= m+1;
											ELSE
												ll:= m;
											END;
										END;
										IF gS.gotos[ll].depart# c.pile.etat THEN
											ll:= gS.nbE-1;
										END;
										IF gS.nbAtts= 0 THEN
											a:= NIL;
										ELSE
											InitErr(gS.nbAtts, a);
										END;
										Pousse(c.pile, gS.gotos[ll].arrivee, a);
										EXIT;
									END;
								END;
								q:=q.suivant;
							END;
						ELSIF tok= lexFin THEN
							VidePile(c.pile);
							EXIT;
						END;
					END;
				END;
			END Recupere;
		
		BEGIN (*Synt*)
			c.InitSynt;
			com:= c.compil;
			tok:= c.Lex(p, li, co, l, s, err);
			LOOP
				aSy:= com.actionSynt[c.pile.etat];
				i:= 0; j:= aSy.nbT-1;
				WHILE i< j DO
					k:= (i+j) DIV 2;
					IF aSy.actions[k].derTerm< tok THEN
						i:= k+1;
					ELSE
						j:= k;
					END;
				END;
				IF aSy.actions[j].premTerm> tok THEN
					j:= aSy.nbT-1;
				END;
				aS:= aSy.actions[j];
				CASE aS.quoi OF
					|deplaceS:
						IF l= 0 THEN
							a:= NIL;
						ELSE
							InitT (p,li,co,s,err,a);
						END;
						Pousse(c.pile, aS.aux, a);
						tok:= c.Lex(p, li, co, l, s, err);
					|reduitS :
						rS:= com.regleSynt[aS.aux];
						gS:= com.gotoSynt[rS.nonTerm];
						IF gS.nbAtts= 0 THEN
							a:= NIL;
						ELSE
							 InitNT(gS.nbAtts, gS.typsAt, a);
						END;
						IF ~(c.yAErreurI & c.bSE OR c.yAErreurE) THEN
							c.Execute(aS.aux, a);
						END;
						FOR i:= 1 TO rS.longueur DO
							Tire(c.pile);
						END;
						i:= 0; m:= gS.nbE-1;
						WHILE i< m DO
							k:= (i+m) DIV 2;
							IF gS.gotos[k].depart< c.pile.etat THEN
								i:= k+1;
							ELSE
								m:= k;
							END;
						END;
						IF gS.gotos[m].depart# c.pile.etat THEN
							m:= gS.nbE-1;
						END;
						Pousse(c.pile, gS.gotos[m].arrivee, a);
					|accepteS:
						VidePile(c.pile);
						EXIT;
					|erreurS :
						c.ErreurSynt(li, co, p);
						IF ~c.stopCompil THEN
							Recupere;
							IF c.pile= NIL THEN
								EXIT;
							END;
						END;
				END;
				IF c.stopCompil THEN
					VidePile(c.pile);
					EXIT;
				END;
			END;
		END Synt;
	
	(* End of syntaxic part *)
	
	(** Reads next integer in the binary file built by module BabelBabel. *)
	PROCEDURE (d: Directory) ReadInt-(VAR i: LONGINT);
		
		BEGIN (*ReadInt*)
			HALT(20);
		END ReadInt;
	
	PROCEDURE (d: Directory) ReadByte (VAR b: SHORTINT);
		
		VAR
			
			i: LONGINT;
		
		BEGIN (*ReadByte*)
			d.ReadInt(i);
			b:= SHORT(SHORT(i));
		END ReadByte;
	
	PROCEDURE (d: Directory) ReadBool (VAR b: BOOLEAN);
		
		VAR
			
			i: LONGINT;
		
		BEGIN (*ReadBool*)
			d.ReadInt(i);
			ASSERT((i= 0) OR (i= 1));
			b:= i= 1;
		END ReadBool;
	
	PROCEDURE (d: Directory) ReadChar (VAR c: CHAR);
		
		VAR
			
			i: LONGINT;
		
		BEGIN (*ReadChar*)
			d.ReadInt(i);
			c:= CHR(i);
		END ReadChar;
	
	PROCEDURE (d: Directory) ReadString (VAR s: ARRAY OF CHAR);
		
		VAR
			
			n: LONGINT;
			c: CHAR;
		
		BEGIN (*ReadString*)
			n:= 0;
			d.ReadChar(c);
			WHILE c# eOS DO
				s[n]:= c;
				INC(n);
				d.ReadChar(c);
			END;
		END ReadString;
	
	(** Reads a compiler, i.e. the binary file built by module BabelBabel. *)
	PROCEDURE (d: Directory) ReadCompiler*(): Compiler;
		
		VAR
			
			c: Compiler;
			t: ToksLex;
			a: ActSynt;
			ca: Card;
			g: GotoS;
			aS: ActionsSem;
			p: Params;
			r: RecEtats;
			i, j, m, k: LONGINT;
	
		PROCEDURE LisEtatsRedLex(nE: LONGINT; VAR eL: EtatsLex);
			
			VAR
				
				i, j: LONGINT;
				t: TransLex;
				gC: GotoLexC;
				gT: GotoLexT;
			
			BEGIN (*LisEtatsRedLex*)
				NEW(eL, nE);
				FOR i:= 0 TO nE-1 DO
					d.ReadInt(eL[i].recon);
					d.ReadInt(eL[i].nbTrans);
					d.ReadInt(eL[i].nbEps);
				END;
				FOR i:= 0 TO nE-1 DO
					IF eL[i].nbTrans> 0 THEN
						NEW(t, eL[i].nbTrans);
						FOR j:= 0 TO eL[i].nbEps-1 DO
							NEW(gT);
							d.ReadInt(gT.goto);
							d.ReadInt(gT.transit);
							t[j]:= gT;
						END;
						FOR j:= eL[i].nbEps TO eL[i].nbTrans-1 DO
							NEW(gC);
							d.ReadInt(gC.goto);
							d.ReadChar(gC.premCar);
							d.ReadChar(gC.derCar);
							ASSERT(gC.premCar<= gC.derCar);
							t[j]:= gC;
						END;
						eL[i].transL:= t;
					END;
				END;
			END LisEtatsRedLex;
		
		BEGIN (*ReadCompiler*)
			NEW(c);
			d.ReadInt(c.nbToksLex);
			d.ReadInt(c.nbEtatsLex);
			d.ReadInt(c.profEtatsL);
			d.ReadInt(c.nbEtatsCom);
			d.ReadInt(c.profEtatsC);
			d.ReadInt(c.nbEtatsSynt);
			d.ReadInt(c.nbNonTSynt);
			d.ReadInt(c.nbRegleSynt);
			d.ReadInt(c.nbRecTerms);
			NEW(t, c.nbToksLex);
			FOR i:= 0 TO c.nbToksLex- 1 DO
				d.ReadBool(t[i].utile);
				d.ReadBool(t[i].valUt);
			END;
			FOR i:= 0 TO c.nbToksLex- 1 DO
				d.ReadInt(k);
				IF k# 0 THEN
					NEW(t[i].nom, k);
					d.ReadString(t[i].nom^);
				END;
			END;
			c.toksLex:= t;
			LisEtatsRedLex(c.nbEtatsLex, c.etatsLex);
			LisEtatsRedLex(c.nbEtatsCom, c.etatsCom);
			NEW(c.actionSynt, c.nbEtatsSynt);
			FOR i:=0 TO c.nbEtatsSynt-1 DO
				d.ReadInt(c.actionSynt[i].nbT);
			END;
			FOR i:=0 TO c.nbEtatsSynt-1 DO
				NEW(a, c.actionSynt[i].nbT);
				FOR j:= 0 TO c.actionSynt[i].nbT-1 DO
					d.ReadByte(a[j].quoi);
					d.ReadInt(a[j].premTerm);
					d.ReadInt(a[j].derTerm);
					d.ReadInt(a[j].aux);
				END;
				c.actionSynt[i].actions:=a;
			END;
			NEW(c.gotoSynt, c.nbNonTSynt);
			FOR i:= 0 TO c.nbNonTSynt-1 DO
				d.ReadInt(c.gotoSynt[i].nbAtts);
				d.ReadInt(c.gotoSynt[i].nbE);
			END;
			FOR i:= 0 TO c.nbNonTSynt-1 DO
				IF c.gotoSynt[i].nbAtts> 0 THEN
					NEW(ca, c.gotoSynt[i].nbAtts);
					FOR j:= 0 TO c.gotoSynt[i].nbAtts-1 DO
						d.ReadInt(ca[j]);
					END;
					c.gotoSynt[i].typsAt:=ca;
				END;
				IF c.gotoSynt[i].nbE> 0 THEN
					NEW(g, c.gotoSynt[i].nbE);
					FOR j:=0 TO c.gotoSynt[i].nbE-1 DO
						d.ReadInt(g[j].depart);
						d.ReadInt(g[j].arrivee);
					END;
					c.gotoSynt[i].gotos:= g;
				END;
			END;
			NEW(c.regleSynt, c.nbRegleSynt);
			FOR i:=0 TO c.nbRegleSynt-1 DO
				d.ReadInt(c.regleSynt[i].longueur);
				d.ReadInt(c.regleSynt[i].nonTerm);
				d.ReadInt(c.regleSynt[i].nbAct);
			END;
			FOR i:=0 TO c.nbRegleSynt-1 DO
				IF c.regleSynt[i].nbAct> 0 THEN
					NEW(aS, c.regleSynt[i].nbAct);
					FOR j:=0 TO c.regleSynt[i].nbAct-1 DO
						d.ReadBool(aS[j].sOrH);
						d.ReadInt(aS[j].profG);
						d.ReadInt(aS[j].attG);
						d.ReadInt(aS[j].fonc);
						d.ReadInt(aS[j].nbPars);
					END;
					FOR j:=0 TO c.regleSynt[i].nbAct-1 DO
						IF aS[j].nbPars> 0 THEN
							NEW(p, aS[j].nbPars);
							FOR m:=0 TO aS[j].nbPars-1 DO
								d.ReadInt(p[m].profD);
								d.ReadInt(p[m].attD);
							END;
							aS[j].pars:= p;
						END;
					END;
					c.regleSynt[i].act:= aS;
				END;
			END;
			IF c.nbRecTerms> 0 THEN
				NEW(c.recTerms, c.nbRecTerms);
				FOR i:= 0 TO c.nbRecTerms-1 DO
					d.ReadInt(c.recTerms[i].numTerm);
					d.ReadInt(c.recTerms[i].nbEtats);
				END;
				FOR i:= 0 TO c.nbRecTerms-1 DO
					NEW(r, c.recTerms[i].nbEtats);
					FOR j:= 0 TO c.recTerms[i].nbEtats-1 DO
						d.ReadInt(r[j].etatDep);
						d.ReadInt(r[j].nTGoto);
					END;
					c.recTerms[i].recEtat:= r;
				END;
			END;
			RETURN c;
		END ReadCompiler;
	
	(** Start of a compilation; co is the compiler used (must be loaded before); lockIfError: if true, inhibits the later calls of the Execution method when a lexical or syntactic error has occurred; the boolean result indicates whether all is OK or not. *)
	PROCEDURE (c: Compilation) Compile*(co: Compiler; lockIfError: BOOLEAN): BOOLEAN;
		
		PROCEDURE InitEns (VAR e: EnsEtatsTab; nbEtats, prof: LONGINT);
			
			VAR
				
				b, i, j, nbBS: LONGINT;

			BEGIN (*InitEns*)
				nbBS:= (nbEtats-1) DIV tBS+1;
				NEW(e, prof);
				FOR j:= 0 TO prof-1 DO
					FOR b:= 0 TO 1 DO
						IF j= prof-1 THEN
							NEW(e[j, b].pEtat, 1);
						ELSE
							NEW(e[j, b].pEtat, nbEtats);
						END;
						e[j, b].sommet:= -1;
						NEW(e[j, b].ensemble, nbBS);
						FOR i:= 0 TO nbBS-1 DO
							e[j, b].ensemble[i]:= {};
						END;
					END;
				END;
			END InitEns;
		
		BEGIN (*Compile*)
			ASSERT(co# NIL, 100);
			c.compil:= co;
			InitEns(c.ensEtatLex, co.nbEtatsLex, co.profEtatsL);
			InitEns(c.ensEtatCom, co.nbEtatsCom, co.profEtatsC);
			c.bSE:= lockIfError;
			c.yAErreurI:= FALSE; c.yAErreurE:= FALSE; c.yAEuErreur:= FALSE; c.stopCompil:= FALSE;
			c.InitLex;
			c.Synt;
			RETURN ~(c.yAErreurI OR c.yAEuErreur);
		END Compile;
	
	(** Extracts an Object of an ObjectsList: l: the list; num: the index in the list (1 first). num must be strictly positive and not greater than the number of Objects in l. *)
	PROCEDURE Parameter*(l: ObjectsList; num: LONGINT): Object;
		
		BEGIN (*Parameter*)
			ASSERT(l# NIL, 100);
			ASSERT(num> 0, 101);
			ASSERT(num<= LEN(l), 102);
			RETURN l[num- 1].Subst();
		END Parameter;
	
	(** Gives the type of content of an Object: stringObj, userObj, termObj or nulObj. *)
	PROCEDURE (o: Object) ObjType*(): SHORTINT;
		
		VAR
			
			oo: ObjetRef;

		BEGIN (*ObjType*)
			oo:= o.o;
			WITH
				oo: ObjetCOChaineObj DO
					RETURN stringObj;
				|oo: ObjetCOUtilObj DO
					RETURN userObj;
				|oo: ObjetCOTermeObj DO
					RETURN termObj;
				|oo: ObjetCONulObj DO
					RETURN nulObj;
			END;
		END ObjType;
	
	(** Gives the number of an userObj or termObj Object. *)
	PROCEDURE (o:Object) ObjNum*(): LONGINT;
		
		VAR
			
			oo: ObjetRef;
		
		BEGIN (*ObjNum*)
			ASSERT((o.o IS ObjetCOUtilObj) OR (o.o IS ObjetCOTermeObj), 100);
			oo:= o.o;
			WITH 
				oo: ObjetCOUtilObj DO
					RETURN oo.numU;
				|oo: ObjetCOTermeObj DO
					RETURN oo.numT;
			END;
		END ObjNum;
	
	(** Gives the number of the hard or soft function which created the userObj or termObj Object. *)
	PROCEDURE (o: Object) ObjFunc*(): LONGINT;
		
		VAR
			
			oo: ObjetRef;
		
		BEGIN (*ObjFunc*)
			ASSERT((o.o IS ObjetCOUtilObj) OR (o.o IS ObjetCOTermeObj), 100);
			oo:= o.o;
			WITH 
				oo: ObjetCOUtilObj DO
					RETURN oo.foncU;
				|oo: ObjetCOTermeObj DO
					RETURN oo.foncT;
			END;
		END ObjFunc;
	
	(** Gives the length of the string contained in a stringObj Object. *)
	PROCEDURE (o: Object) ObjStringLen*(): LONGINT;
		
		BEGIN (*ObjStringLen*)
			ASSERT(o.o IS ObjetCOChaineObj, 100);
			IF o.o(ObjetCOChaineObj).valC# NIL THEN
				RETURN LEN(o.o(ObjetCOChaineObj).valC)- 1;
			ELSE
				RETURN 0;
			END;
		END ObjStringLen;
	
	(** Gives the string contained in a stringObj Object or, else, the value parameter is not changed. *)
	PROCEDURE (o: Object) ObjString*(VAR value: ARRAY OF CHAR);
			
			VAR
				
				i: LONGINT;
				oo: ObjetCOChaineObj;
		
		BEGIN (*ObjString*)
			ASSERT(o.o IS ObjetCOChaineObj, 100);
			IF o.o(ObjetCOChaineObj).valC= NIL THEN
				value[0]:= eOS;
			ELSE (* Copy by hand to avoid problems with embedded eOS chars *)
				i:= LEN(o.o(ObjetCOChaineObj).valC);
				IF LEN(value)< i THEN
					i:= LEN(value);
				END;
				DEC(i);
				value[i]:= eOS; DEC(i);
				WHILE i>= 0 DO
					oo:= o.o(ObjetCOChaineObj);
					value[i]:= oo.valC[i];
					DEC(i);
				END;
			END;
		END ObjString;
	
	(** Gives the data contained in an userObj Object. *)
	PROCEDURE (o: Object) ObjUser*(): ANYPTR;
		
		BEGIN (*ObjUser*)
			ASSERT(o.o IS ObjetCOUtilObj, 100);
			RETURN o.o(ObjetCOUtilObj).valU;
		END ObjUser;
	
	(** Gives the number of subtrees of a termObj Object. *)
	PROCEDURE (o: Object) ObjTermSonsNb*(): LONGINT;
		
		BEGIN (*ObjTermSonsNb*)
			ASSERT(o.o IS ObjetCOTermeObj, 100);
			RETURN LEN(o.o(ObjetCOTermeObj).filsT);
		END ObjTermSonsNb;
	
	(** Gives a subtree of a termObj Object: sonNum is the index of the subtree (1 first). sonNum must be strictly positive and not greater than the number of subtrees of o. *)
	PROCEDURE (o: Object) ObjTermSon*(sonNum: LONGINT): Object;
		
		VAR
			
			oo: ObjetCOTermeObj;
		
		BEGIN (*ObjTermSon*)
			ASSERT(o.o IS ObjetCOTermeObj, 100);
			ASSERT(sonNum> 0, 101);
			ASSERT(sonNum<= LEN(o.o(ObjetCOTermeObj).filsT), 102);
			oo:= o.o(ObjetCOTermeObj);
			RETURN oo.filsT[sonNum-1].Subst();
		END ObjTermSon;
	
	(** During a compilation, modifies the value of the lockIfError parameter of the Compile method. *)
	PROCEDURE (c: Compilation) LockIfError*(lock: BOOLEAN);
		
		BEGIN (*LockIfError*)
			c.bSE:= lock;
		END LockIfError;
	
	(** Activates a serious semantic error: hard functions are no more called. *)
	PROCEDURE (c: Compilation) Lock*;
		
		BEGIN (*Lock*)
			c.yAErreurE:= TRUE;
			c.yAEuErreur:= TRUE;
		END Lock;
	
	(** Stops compilation at once. *)
	PROCEDURE (c: Compilation) StopCompil*;
		
		BEGIN (*StopCompil*)
			c.Lock;
			c.stopCompil:= TRUE;
		END StopCompil;
	
		
	(** Tests whether o has the type nulObj, or the type userObj with error, or the type termObj with error or with a descendant in error. *)
	PROCEDURE (o: Object) ErrorIn*():BOOLEAN;
		
		BEGIN (*ErrorIn*)
			RETURN (o.o IS ObjetCONulObj) OR o.o(ObjetCO).errO;
		END ErrorIn;
	
	(** Position, numbered from 1, in the parsed text, of a stringObj or userObj Object. *)
	PROCEDURE (o: Object) Position*(): LONGINT;
		
		BEGIN (*Position*)
			ASSERT((o.o IS ObjetCOChaineObj) OR (o.o IS ObjetCOUtilObj), 100);
			RETURN o.o.posO;
		END Position;
	
	(** Line number, numbered from 1, in the parsed text, of a stringObj or userObj Object, 0 otherwise. *)
	PROCEDURE (o: Object) Line*():LONGINT;
		
		BEGIN (*Line*)
			ASSERT((o.o IS ObjetCOChaineObj) OR (o.o IS ObjetCOUtilObj), 100);
			RETURN o.o.ligO;
		END Line;
	
	(** Column number, numbered from 1, in the parsed text, of a stringObj or userObj Object. *)
	PROCEDURE (o: Object) Column*():LONGINT;
		
		BEGIN (*Column*)
			ASSERT((o.o IS ObjetCOChaineObj) OR (o.o IS ObjetCOUtilObj), 100);
			RETURN o.o.colO;
		END Column;
	
	END BabelCompil.
BIER[           "         d      d
     C  <       s      C  Oberon12.Scn.Fnt 30.03.2002  20:10:31  TextGadgets.NewStyleProc TimeStamps.New  