TextDocs.NewDoc     F   CColor     Flat  Locked  Controls  Org T   BIER`   b        3  l   Syntax12.Scn.Fnt             Oberon12.Scn.Fnt          	    #-           3  (* 
Babel: a compiler compiler.

 c Grard MEUNIER 1990

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

MODULE BabelBinText;
	
	 
	
	(** The module BabelBinText is part of the Babel subsystem, a compiler compiler. BabelBinText is an auxiliary module used in writing module BabelInit from the definition document Babel.Bab *)
	
	IMPORT
		
		Files, Oberon, Objects, Strings, Texts;

	TYPE
		
		Chaine= POINTER TO ARRAY OF CHAR;
		
		(* Definitions for the lexical analyzer *)
		
		TokLex= RECORD (* A token *)
			nom: Chaine;
			utile,
			valUt: BOOLEAN;
		END;
		
		ToksLex= POINTER TO ARRAY OF TokLex;
		
		GotoLex= POINTER TO RECORD
			goto: LONGINT;
		END;
		
		GotoLexC= POINTER TO RECORD (GotoLex)
			premCar,
			derCar :CHAR;
		END;
		
		GotoLexT= POINTER TO RECORD (GotoLex)
			transit: LONGINT;
		END;
		
		TransLex= POINTER TO ARRAY OF GotoLex;
		
		Card= POINTER TO ARRAY OF LONGINT;
		
		EtatLex= RECORD
			recon,
			nbTrans,
			nbEps: LONGINT;
			transL: TransLex;
		END;
		
		EtatsLex= POINTER TO ARRAY OF EtatLex;
		
	(* Definitions for the parser *)
	
	CONST
		
		deplaceS= 0;
		reduitS= 1;
		accepteS= 2;
		erreurS= 3;
	
	TYPE
		
		ActionS= RECORD
			quoi: SHORTINT;
			premTerm,
			derTerm ,
			aux: LONGINT;
		END;
		
		ActSynt= POINTER TO ARRAY OF ActionS;
		
		ActionSynt= RECORD
			nbT: LONGINT;
			actions: ActSynt;
		END;
		
		ActionsSynt=POINTER TO ARRAY OF ActionSynt;
		
		GtS= RECORD
			depart ,
			arrivee: LONGINT;
		END;
		
		GotoS= POINTER TO ARRAY OF GtS;
		
		GotoSynt= RECORD
			nbAtts: LONGINT;
			typsAt: Card;
			nbE: LONGINT;
			gotos: GotoS;
		END;
		
		GotosSynt= POINTER TO ARRAY OF GotoSynt;
		
		(* Definitions for the semantic analyser *)
		
		Param= RECORD
			profD,
			attD: LONGINT;
		END;
		
		Params= POINTER TO ARRAY OF Param;
		
		ActionSem= RECORD
			sOrH: BOOLEAN;
			profG,
			attG,
			fonc,
			nbPars: LONGINT;
			pars: Params;
		END;
		
		ActionsSem= POINTER TO ARRAY OF ActionSem;
		
		RegleSynt= RECORD
			longueur,
			nonTerm ,
			nbAct: LONGINT;
			act: ActionsSem;
		END;
		
		ReglesSynt= POINTER TO ARRAY OF RegleSynt;
		
		RecEtat= RECORD
			etatDep,
			nTGoto: LONGINT;
		END;
		
		RecEtats= POINTER TO ARRAY OF RecEtat;
		
		RecTerm= RECORD
			numTerm,
			nbEtats: LONGINT;
			recEtat: RecEtats;
		END;
		
		RecTerms= POINTER TO ARRAY OF RecTerm;
		
		Compilateur = POINTER TO RECORD (* A compiler *)
			nbToksLex: LONGINT;
			toksLex: ToksLex;
			nbEtatsLex,
			profEtatsL: LONGINT;
			etatsLex: EtatsLex;
			nbEtatsCom,
			profEtatsC: LONGINT;
			etatsCom: EtatsLex;
			nbEtatsSynt: LONGINT;
			actionSynt: ActionsSynt;
			nbNonTSynt: LONGINT;
			gotoSynt: GotosSynt;
			nbRegleSynt: LONGINT;
			regleSynt: ReglesSynt;
			nbRecTerms: LONGINT;
			recTerms: RecTerms;
		END;
	
	PROCEDURE LisCompilateur (f: Files.File): Compilateur;
		
		(* Reading of compiler tables in the f '.tbl' file *)
		
		CONST
			
			eOS= 0X;
		
		VAR
			
			rd: Files.Rider;
			c: Compilateur;
			t: ToksLex;
			a: ActSynt;
			ca: Card;
			g: GotoS;
			aS: ActionsSem;
			p: Params;
			r: RecEtats;
			i, j, m, k: LONGINT;
		
		PROCEDURE ReadInt (VAR i: LONGINT);
			
			BEGIN (*ReadInt*)
				Files.ReadLInt(rd, i);
			END ReadInt;
		
		PROCEDURE ReadByte (VAR b: SHORTINT);
			
			VAR
				
				i: LONGINT;
			
			BEGIN (*ReadByte*)
				ReadInt(i);
				b:= SHORT(SHORT(i));
			END ReadByte;
		
		PROCEDURE ReadBool (VAR b: BOOLEAN);
			
			VAR
				
				i: LONGINT;
			
			BEGIN (*ReadBool*)
				ReadInt(i);
				ASSERT((i= 0) OR (i= 1));
				b:= i= 1;
			END ReadBool;
		
		PROCEDURE ReadChar (VAR c: CHAR);
			
			VAR
				
				i: LONGINT;
			
			BEGIN (*ReadChar*)
				ReadInt(i);
				c:= CHR(i);
			END ReadChar;
	
	PROCEDURE ReadString (VAR s: ARRAY OF CHAR);
		
		VAR
			
			n: LONGINT;
			c: CHAR;
		
		BEGIN (*ReadString*)
			n:= 0;
			ReadChar(c);
			WHILE c# eOS DO
				s[n]:= c;
				INC(n);
				ReadChar(c);
			END;
		END ReadString;
	
		PROCEDURE LisEtatsRedLex(nE: LONGINT; VAR eL: EtatsLex);
			
			VAR
				
				i, j: LONGINT;
				t: TransLex;
				gC: GotoLexC;
				gT: GotoLexT;
			
			BEGIN (*LisEtatsRedLex*)
				NEW(eL, nE);
				FOR i:= 0 TO nE-1 DO
					ReadInt(eL[i].recon);
					ReadInt(eL[i].nbTrans);
					ReadInt(eL[i].nbEps);
				END;
				FOR i:= 0 TO nE-1 DO
					IF eL[i].nbTrans> 0 THEN
						NEW(t, eL[i].nbTrans);
						FOR j:= 0 TO eL[i].nbEps-1 DO
							NEW(gT);
							ReadInt(gT.goto);
							ReadInt(gT.transit);
							t[j]:= gT;
						END;
						FOR j:= eL[i].nbEps TO eL[i].nbTrans-1 DO
							NEW(gC);
							ReadInt(gC.goto);
							ReadChar(gC.premCar);
							ReadChar(gC.derCar);
							t[j]:= gC;
						END;
						eL[i].transL:= t;
					END;
				END;
			END LisEtatsRedLex;
		
		BEGIN (*LisCompilateur*)
			ASSERT(f# NIL);
			Files.Set(rd, f, 0);
			NEW(c);
			ReadInt(c.nbToksLex);
			ReadInt(c.nbEtatsLex);
			ReadInt(c.profEtatsL);
			ReadInt(c.nbEtatsCom);
			ReadInt(c.profEtatsC);
			ReadInt(c.nbEtatsSynt);
			ReadInt(c.nbNonTSynt);
			ReadInt(c.nbRegleSynt);
			ReadInt(c.nbRecTerms);
			NEW(t, c.nbToksLex);
			FOR i:= 0 TO c.nbToksLex- 1 DO
				ReadBool(t[i].utile);
				ReadBool(t[i].valUt);
			END;
			FOR i:= 0 TO c.nbToksLex- 1 DO
				ReadInt(k);
				IF k# 0 THEN
					NEW(t[i].nom, k);
					ReadString(t[i].nom^);
				END;
			END;
			c.toksLex:= t;
			LisEtatsRedLex(c.nbEtatsLex, c.etatsLex);
			LisEtatsRedLex(c.nbEtatsCom, c.etatsCom);
			NEW(c.actionSynt, c.nbEtatsSynt);
			FOR i:=0 TO c.nbEtatsSynt-1 DO
				ReadInt(c.actionSynt[i].nbT);
			END;
			FOR i:=0 TO c.nbEtatsSynt-1 DO
				NEW(a, c.actionSynt[i].nbT);
				FOR j:= 0 TO c.actionSynt[i].nbT-1 DO
					ReadByte(a[j].quoi);
					ReadInt(a[j].premTerm);
					ReadInt(a[j].derTerm);
					ReadInt(a[j].aux);
				END;
				c.actionSynt[i].actions:=a;
			END;
			NEW(c.gotoSynt, c.nbNonTSynt);
			FOR i:= 0 TO c.nbNonTSynt-1 DO
				ReadInt(c.gotoSynt[i].nbAtts);
				ReadInt(c.gotoSynt[i].nbE);
			END;
			FOR i:= 0 TO c.nbNonTSynt-1 DO
				IF c.gotoSynt[i].nbAtts> 0 THEN
					NEW(ca, c.gotoSynt[i].nbAtts);
					FOR j:= 0 TO c.gotoSynt[i].nbAtts-1 DO
						ReadInt(ca[j]);
					END;
					c.gotoSynt[i].typsAt:=ca;
				END;
				IF c.gotoSynt[i].nbE> 0 THEN
					NEW(g, c.gotoSynt[i].nbE);
					FOR j:=0 TO c.gotoSynt[i].nbE-1 DO
						ReadInt(g[j].depart);
						ReadInt(g[j].arrivee);
					END;
					c.gotoSynt[i].gotos:= g;
				END;
			END;
			NEW(c.regleSynt, c.nbRegleSynt);
			FOR i:=0 TO c.nbRegleSynt-1 DO
				ReadInt(c.regleSynt[i].longueur);
				ReadInt(c.regleSynt[i].nonTerm);
				ReadInt(c.regleSynt[i].nbAct);
			END;
			FOR i:=0 TO c.nbRegleSynt-1 DO
				IF c.regleSynt[i].nbAct> 0 THEN
					NEW(aS, c.regleSynt[i].nbAct);
					FOR j:=0 TO c.regleSynt[i].nbAct-1 DO
						ReadBool(aS[j].sOrH);
						ReadInt(aS[j].profG);
						ReadInt(aS[j].attG);
						ReadInt(aS[j].fonc);
						ReadInt(aS[j].nbPars);
					END;
					FOR j:=0 TO c.regleSynt[i].nbAct-1 DO
						IF aS[j].nbPars> 0 THEN
							NEW(p, aS[j].nbPars);
							FOR m:=0 TO aS[j].nbPars-1 DO
								ReadInt(p[m].profD);
								ReadInt(p[m].attD);
							END;
							aS[j].pars:= p;
						END;
					END;
					c.regleSynt[i].act:= aS;
				END;
			END;
			IF c.nbRecTerms> 0 THEN
				NEW(c.recTerms, c.nbRecTerms);
				FOR i:= 0 TO c.nbRecTerms-1 DO
					ReadInt(c.recTerms[i].numTerm);
					ReadInt(c.recTerms[i].nbEtats);
				END;
				FOR i:= 0 TO c.nbRecTerms-1 DO
					NEW(r, c.recTerms[i].nbEtats);
					FOR j:= 0 TO c.recTerms[i].nbEtats-1 DO
						ReadInt(r[j].etatDep);
						ReadInt(r[j].nTGoto);
					END;
					c.recTerms[i].recEtat:= r;
				END;
			END;
			RETURN c;
		END LisCompilateur;
	
	PROCEDURE Sortie (c:Compilateur; f: Texts.Writer);
		
		CONST
			
			taLigne= 5;
			taIndex=4;
			taVal= 5;
		
		VAR
			
			t: ToksLex;
			a: ActSynt;
			ca: Card;
			g: GotoS;
			aS: ActionsSem;
			p: Params;
			r: RecEtats;
			i, j, k: LONGINT;
			
			pos: LONGINT;
		
		PROCEDURE BinInt (i: LONGINT);
			
			BEGIN (*BinInt*)
				Texts.WriteString(f, 'a['); Texts.WriteInt(f, pos, taIndex); Texts.WriteString(f, ']:= ');
				Texts.WriteInt(f, i, taVal); Texts.WriteString(f, '; ');
				INC(pos);
				IF pos MOD taLigne= 0 THEN
					Texts.WriteLn(f);
				END;
			END BinInt;
		
		PROCEDURE BinByte (b: SHORTINT);
			
			BEGIN (*BinByte*)
				BinInt(b);
			END BinByte;
		
		PROCEDURE BinBool (b: BOOLEAN);
			
			BEGIN (*BinBool*)
				IF b THEN
					BinInt(1);
				ELSE
					BinInt(0);
				END;
			END BinBool;
		
		PROCEDURE BinChar (c: CHAR);
			
			BEGIN (*BinChar*)
				BinInt(ORD(c));
			END BinChar;
		
		PROCEDURE BinStr (s: ARRAY OF CHAR);
			
			VAR
				
				i: LONGINT;
			
			BEGIN (*BinStr*)
				FOR i:= 0 TO Strings.Length(s) DO
					BinChar(s[i]);
				END;
			END BinStr;
		
		PROCEDURE EcrisEtatsRedLex (nE: LONGINT; eL: EtatsLex);
			
			VAR
				
				i, j: LONGINT;
				t: TransLex;
			
			BEGIN (*EcrisEtatsRedLex*)
				FOR i:= 0 TO nE-1 DO
					BinInt(eL[i].recon);
					BinInt(eL[i].nbTrans);
					BinInt(eL[i].nbEps);
				END;
				FOR i:= 0 TO nE-1 DO
					t:= eL[i].transL;
					FOR j:= 0 TO eL[i].nbEps-1 DO
						BinInt(t[j].goto);
						BinInt(t[j](GotoLexT).transit);
					END;
					FOR j:= eL[i].nbEps TO eL[i].nbTrans-1 DO
						BinInt(t[j].goto);
						BinChar(t[j](GotoLexC).premCar);
						BinChar(t[j](GotoLexC).derCar);
					END;
				END;
			END EcrisEtatsRedLex;
		
		BEGIN (*Sortie*)
			pos:= 0;
			BinInt(c.nbToksLex);
			BinInt(c.nbEtatsLex);
			BinInt(c.profEtatsL);
			BinInt(c.nbEtatsCom);
			BinInt(c.profEtatsC);
			BinInt(c.nbEtatsSynt);
			BinInt(c.nbNonTSynt);
			BinInt(c.nbRegleSynt);
			BinInt(c.nbRecTerms);
			t:= c.toksLex;
			FOR i:= 0 TO c.nbToksLex- 1 DO
				BinBool(t[i].utile);
				BinBool(t[i].valUt);
			END;
			FOR i:= 0 TO c.nbToksLex-1 DO
				IF t[i].nom= NIL THEN
					k:= 0;
				ELSE
					k:= LEN(t[i].nom);
				END;
				BinInt(k);
				IF k# 0 THEN
					BinStr(t[i].nom^);
				END;
			END;
			EcrisEtatsRedLex(c.nbEtatsLex, c.etatsLex);
			EcrisEtatsRedLex(c.nbEtatsCom, c.etatsCom);
			FOR i:= 0 TO c.nbEtatsSynt- 1 DO
				BinInt(c.actionSynt[i].nbT);
			END;
			FOR i:= 0 TO c.nbEtatsSynt- 1 DO
				a:= c.actionSynt[i].actions;
				FOR j:= 0 TO c.actionSynt[i].nbT- 1 DO
					BinByte(a[j].quoi);
					BinInt(a[j].premTerm);
					BinInt(a[j].derTerm);
					BinInt(a[j].aux);
				END;
			END;
			FOR i:= 0 TO c.nbNonTSynt- 1 DO
				BinInt(c.gotoSynt[i].nbAtts);
				BinInt(c.gotoSynt[i].nbE);
			END;
			FOR i:= 0 TO c.nbNonTSynt-1 DO
				IF c.gotoSynt[i].nbAtts> 0 THEN
					ca:= c.gotoSynt[i].typsAt;
					FOR j:= 0 TO c.gotoSynt[i].nbAtts- 1 DO
						BinInt(ca[j]);
					END;
				END;
				IF c.gotoSynt[i].nbE> 0 THEN
					g:= c.gotoSynt[i].gotos;
					FOR j:= 0 TO c.gotoSynt[i].nbE- 1 DO
						BinInt(g[j].depart);
						BinInt(g[j].arrivee);
					END;
				END;
			END;
			FOR i:= 0 TO c.nbRegleSynt- 1 DO
				BinInt(c.regleSynt[i].longueur);
				BinInt(c.regleSynt[i].nonTerm);
				BinInt(c.regleSynt[i].nbAct);
			END;
			FOR i:= 0 TO c.nbRegleSynt- 1 DO
				IF c.regleSynt[i].nbAct> 0 THEN
					aS:= c.regleSynt[i].act;
					FOR j:= 0 TO c.regleSynt[i].nbAct- 1 DO
						BinBool(aS[j].sOrH);
						BinInt(aS[j].profG);
						BinInt(aS[j].attG);
						BinInt(aS[j].fonc);
						BinInt(aS[j].nbPars);
					END;
					FOR j:= 0 TO c.regleSynt[i].nbAct- 1 DO
						IF aS[j].nbPars> 0 THEN
							p:= aS[j].pars;
							FOR k:= 0 TO aS[j].nbPars- 1 DO
								BinInt(p[k].profD);
								BinInt(p[k].attD);
							END;
						END;
					END;
				END;
			END;
			FOR i:= 0 TO c.nbRecTerms- 1 DO
				BinInt(c.recTerms[i].numTerm);
				BinInt(c.recTerms[i].nbEtats);
			END;
			FOR i:= 0 TO c.nbRecTerms-1 DO
				r:= c.recTerms[i].recEtat;
				FOR j:= 0 TO c.recTerms[i].nbEtats- 1 DO
					BinInt(r[j].etatDep);
					BinInt(r[j].nTGoto);
				END;
			END;
			Texts.WriteLn(f); Texts.WriteLn(f);
			Texts.WriteInt(f, pos, 0);
			Texts.WriteLn(f);
		END Sortie;
	
	PROCEDURE Do*;
		
		VAR
			
			name: ARRAY 64 OF CHAR;
			fi: Files.File;
			c: Compilateur;
			t: Texts.Text;
			f: Texts.Writer;
			s: Texts.Scanner;
		
		BEGIN (*Do*)
			Texts.OpenScanner(s, Oberon.Par.text, Oberon.Par.pos);  Texts.Scan(s);
			IF s.class = Texts.Name THEN
				COPY(s.s, name);
				fi:= Files.Old(name);
				IF fi# NIL THEN
					c:= LisCompilateur(fi);
					Files.Close(fi);
					Texts.New; t:= Objects.NewObj(Texts.Text);
					Texts.OpenWriter(f);
					Sortie(c, f);
					Texts.Append(t, f.buf);
					Strings.ChangeSuffix(name, "Comp");
					Oberon.OpenText(name, t, 500, 200);
				END;
			END;
		END Do;

	END BabelBinText.

BabelBinText.Do Babel.Tbl

System.Free BabelBinText

BIERG4  X4   4    <       g 
     C  Syntax10.Scn.Fnt 30.03.2002  20:00:08  TimeStamps.New  