TextDocs.NewDoc     F   CColor     Flat  Locked  Controls  Org    BIER`   b        3  8        Oberon12.Scn.Fnt                (* 
Babel: a compiler compiler.

 c Grard MEUNIER 1990

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

MODULE BabelBabel;
	
	(**)
	
	(** The module BabelBabel is part of the Babel subsystem, a compiler compiler. BabelBabel is the user interface which calls the programming interface module BabelInterface to build a Tbl file from a definition document *)
	
	IMPORT
		
		I:= BabelInterface, Files, Fonts, M:= TBoxMapping, Oberon, Objects, Strings, Texts;
	
	CONST
		
		viewCode= 2X;
	
	TYPE
		
		Face= POINTER TO RECORD (I.Face)
			f: Texts.Writer;
			w: Files.Rider;
			r: Texts.Reader;
			t: Texts.Text;
		END;
	
	PROCEDURE (f: Face) Ln;
		
		BEGIN (*Ln*)
			Texts.WriteLn(f.f);
		END Ln;
	
	PROCEDURE (f: Face) String (s: ARRAY OF CHAR);
		
		BEGIN (*String*)
			Texts.WriteString(f.f, s);
		END String;
	
	PROCEDURE (f: Face) BinInt (i: LONGINT);
		
		BEGIN (*BinInt*)
			Files.WriteLInt(f.w, i);
		END BinInt;
		
	PROCEDURE (f: Face) Read (VAR ch: CHAR);
		
		BEGIN (*Read*)
			Texts.Read(f.r, ch);
			IF f.r.eot THEN
				ch:= I.eOF1;
			ELSIF ~(f.r.lib IS Fonts.Font) THEN
				ch:= viewCode;
			END;
		END Read;
	
	PROCEDURE (f: Face) Pos (): LONGINT;
		
		BEGIN (*Pos*)
			RETURN Texts.Pos(f.r);
		END Pos;
	
	PROCEDURE (f: Face) SetPos (pos: LONGINT);
		
		BEGIN (*SetPos*)
			Texts.OpenReader(f.r, f.t, pos);
		END SetPos;
	
	PROCEDURE Map (index, p0, p1, p2: ARRAY OF CHAR): I.Chaine;
		
		CONST
			
			base= "#Babel:";
		
		VAR
			
			c: I.Chaine;
			ch: M.Chaine;
		
		BEGIN (*Map*)
			NEW(c, Strings.Length(index)+ 8);
			COPY(base, c^);
			Strings.Append(c^, index);
			ch:= M.Map(c^, p0, p1, p2);
			NEW(c, Strings.Length(ch^)+ 1);
			COPY(ch^, c^);
			RETURN c;
		END Map;
	
	PROCEDURE (f: Face) Map (index, p0, p1, p2: ARRAY OF CHAR): I.Chaine;
		
		CONST
			
			base= "#Babel:";
		
		VAR
			
			c: I.Chaine;
			ch: M.Chaine;
		
		BEGIN (*Map*)
			RETURN Map (index, p0, p1, p2);
		END Map;
	
	PROCEDURE Compile*;
		
		VAR
			
			t: Texts.Text;
			s: Texts.Scanner;
			beg, end, time: LONGINT;
			w: Texts.Writer;
			mes: I.Chaine;
		
		PROCEDURE Compile1Text (t: Texts.Text);
			
			CONST
				
				tablesType= '.Tbl';
				listType= '.Lst';
			
			VAR
				
				f: Face;
				w: Texts.Writer;
				res: SHORTINT;
				fi: Files.File;
				name, nomL, nomB, mes: I.Chaine;
				len: LONGINT;
			
			BEGIN (*Compile1Text*)
				NEW(f);
				f.t:= t;
				Texts.OpenReader(f.r, t, 0);
				Texts.OpenWriter(f.f);
				res:= f.CompComp(name);
				IF res# I.withoutDisp THEN
					IF name= NIL THEN
						Texts.OpenWriter(w); Texts.WriteLn(w); Texts.Append(Oberon.Log, w.buf);
						Texts.Append(Oberon.Log, f.f.buf);
					ELSE
						Texts.New; t:= Objects.NewObj(Texts.Text);
						Texts.Append(t, f.f.buf);
						NEW(nomL, Strings.Length(name^)+ 5);
						COPY(name^, nomL^);
						Strings.Append(nomL^, listType);
						fi:= Files.New(nomL^);
						Texts.Store(t, fi, 0, len);
						Files.Register(fi);
					END;
				END;
				IF res# I.errors THEN
					NEW(nomB, Strings.Length(name^)+ 5);
					COPY(name^, nomB^);
					Strings.Append(nomB^, tablesType);
					fi:= Files.New(nomB^);
					Files.Set(f.w, fi, 0);
					f.OutComp;
					Files.Register(fi);
				END;
				CASE res OF
					|I.withoutDisp:
						mes:= f.Map("BOk", "", "", "");
					|I.remarks:
						mes:= f.Map("BRem", "", "", "");
					|I.warnings:
						mes:= f.Map("BWarning", "", "", "");
					|I.errors:
						mes:= f.Map("BError", "", "", "");
				END;
				Texts.WriteString(f.f, mes^);
				IF nomL# NIL THEN
					mes:= f.Map("BSee", nomL^, "", "");
					Texts.WriteString(f.f, mes^);
				END;
				Texts.WriteLn(f.f);
				Texts.Append(Oberon.Log, f.f.buf);
			END Compile1Text;
		
		BEGIN (*Compile*)
			Texts.OpenWriter(w);
			Texts.OpenScanner(s, Oberon.Par.text, Oberon.Par.pos);  Texts.Scan(s);
			IF (s.class = Texts.Char) & (s.c= "*") THEN
				t:= Oberon.MarkedText();
				IF t# NIL THEN
					mes:= Map("BBabel", "", "", "");
					Texts.WriteString(w, mes^); Texts.Write(w, " ");
					Texts.Append(Oberon.Log, w.buf);
					Compile1Text(t);
				END;
			ELSE
				IF (s.class = Texts.Char) & (s.c = "^") THEN
					Oberon.GetSelection(t, beg, end, time);
					IF time>= 0 THEN
						Texts.OpenScanner(s, t, beg);
						Texts.Scan(s);
					END
				END;
				WHILE s.class= Texts.Name DO
					Texts.WriteString(w, s.s); Texts.WriteString(w, ": ");
					Texts.Append(Oberon.Log, w.buf);
					NEW(t);
					Texts.Open(t, s.s);
					IF t.len= 0 THEN
						mes:= Map("BNotFound", "", "", "");
						Texts.WriteString(w, mes^); Texts.WriteLn(w);
						Texts.Append(Oberon.Log, w.buf);
					ELSE
						Compile1Text(t);
					END;
					Texts.Scan(s);
				END;
			END;
		END Compile;
	
	END BabelBabel.

BabelBabel.Compile *
BabelBabel.Compile ^

System.Free BabelExtract BabelTest1 BabelTest2 BabelTest3 BabelTest4 BabelBabel BabelInterface BabelInit1 BabelInit2 BabelInit3 BabelInit BabelInit1 BabelInit2 BabelInit3 BabelAnaSem BabelSyntaxe BabelLexique BabelCars BabelDef BabelCompil ~

Builder.Compile \2s BabelCompil.Mod BabelDef.Mod BabelCars.Mod BabelLexique.Mod BabelSyntaxe.Mod BabelAnaSem.Mod BabelInit3.Mod BabelInit2.Mod BabelInit1.Mod BabelInit.Mod BabelInterface.Mod BabelBabel.Mod BabelTest1.Mod BabelTest2.Mod BabelTest3.Mod BabelExtract.Mod  ~BIER  &         "         d      d
     C  <             C  Oberon14.Scn.Fnt 30.03.2002  19:58:29  TextGadgets.NewStyleProc TimeStamps.New  