TextDocs.NewDoc     F   CColor     Flat  Locked  Controls  Org    BIER`   b        3  1   Syntax12.Scn.Fnt          \B   WE  (* 
Babel: a compiler compiler.

 c Grard MEUNIER 1990

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

MODULE BabelAnaSem;
	
	(* *)
	
	(** The module BabelAnaSem is part of the Babel subsystem, a compiler compiler. BabelAnaSem interprets the definition document and uses modules BabelLexique and BabelSyntaxe to build the Tbl file *)
	
	IMPORT
		
		A:= BabelCars, C:= BabelCompil, D:= BabelDef, L:= BabelLexique, S:= BabelSyntaxe, Strings;
	
	CONST
		
		true= 3;
		cons= 13;
	
	TYPE
		
		PCard=POINTER TO RECORD (C.ANYPTR)
			i: LONGINT;
		END;
		
		PCarEns= POINTER TO RECORD (C.ANYPTR)
			c: A.CarEns;
		END;
		
		PCardBool= POINTER TO RECORD (C.ANYPTR)
			c: LONGINT;
			b: BOOLEAN;
		 END;
		
		PChaine= POINTER TO RECORD (C.ANYPTR)
			s: D.Chaine;
		END;
		
		Sem*= POINTER TO RECORD (C.Compilation)
			ls*: S.Syntaxical;
			nom-: D.Chaine;
			yAPasErreur: BOOLEAN;
		END;
	
	PROCEDURE (s: Sem) ErreurSem (numErr: LONGINT; o: C.Object);
		
		VAR
			
			p, li, co: LONGINT;
			mes: D.Chaine;
			ind: D.Index;

		BEGIN (*ErreurSem*)
			p:= o.Position();
			li:= o.Line();
			co:= o.Column();
			CASE numErr OF
				 | 0 : ind:= "AAlreadyDef";
				 | 1 : ind:= "AIncreasing";
				 | 2 : ind:= "AUnknownIdent";
				 | 3 : ind:= "AOneOnly";
				 | 4 : ind:= "ANonTTwiceDef";
				 | 5 : ind:= "AUnknownTerm";
				 | 6 : ind:= "AWrong";
				 | 7 : ind:= "AUnknownAtt";
				 | 8 : ind:= "ANoAttrib";
				 | 9 : ind:= "AMandatoryAtt";
				 |10 : ind:= "AUnknownNonT";
				 |11 : ind:= "AHFuncTwiceDef";
				 |12 : ind:= "ASFuncTwiceDef";
				 |13 : ind:= "AUnknownFunc";
				 |14 : ind:= "ANullFuncNumber";
				 |15 : ind:= "AAttTwiceDef";
				 |16 : ind:= "ATwoBig";
				 ELSE  ind:= "AUnknownErr";
			END;
			mes:= s.ls.lx.so.Map(ind, "", "", "");
			s.Error(p, li, co, mes^);
			s.yAPasErreur:= FALSE;
		END ErreurSem;
	
	PROCEDURE (se: Sem) CreeChaine (o: C.Object): D.Chaine;
		
		VAR
			
			s: D.Chaine;
		
		BEGIN (*CreeChaine*)
			IF o.ErrorIn() THEN
				se.yAPasErreur:= FALSE;
				RETURN NIL;
			ELSE
				NEW(s, o.ObjStringLen()+ 1);
				o.ObjString(s^);
				RETURN s;
			END;
		END CreeChaine;
	
	PROCEDURE (se: Sem) CreeNTChaine (o: C.Object): D.Chaine;
		
		VAR
			
			s, t: D.Chaine;
			l: LONGINT;
		
		BEGIN (*CreeNTChaine*)
			s:= se.CreeChaine(o);
			IF s= NIL THEN
				RETURN NIL;
			ELSE
				l:= Strings.Length(s^);
				NEW(t, l);
				D.Slice(t^, s^, 1, l- 1);
				RETURN t;
			END;
		END CreeNTChaine;
	
	PROCEDURE (se: Sem) ExtraitChaine (o: C.Object): D.Chaine;
		
		VAR
			
			s, t: D.Chaine;
			l: LONGINT;
		
		BEGIN (*ExtraitChaine*)
			s:= se.CreeChaine(o);
			IF s= NIL THEN
				RETURN NIL;
			ELSE
				l:= Strings.Length(s^)- 2;
				IF l= 0 THEN
					RETURN NIL;
				ELSE
					NEW(t, l+ 1);
				END;
				D.Slice(t^, s^, 1, l);
				RETURN t;
			END;
		END ExtraitChaine;
	
	PROCEDURE (se: Sem) Valeur (o: C.Object): PCard;
		
		VAR
			
			s: D.Chaine;
			card: PCard;
		
		BEGIN (*Valeur*)
			IF o.ErrorIn() THEN
				se.yAPasErreur:= FALSE;
				RETURN NIL;
			ELSE
				s:= se.CreeChaine(o);
				NEW(card);
				IF ~D.StrToCard(s^, card.i) THEN
					se.ErreurSem(16, o);
				END;
				RETURN card;
			END;
		END Valeur;
	
	PROCEDURE (se: Sem) CreeLAtt (o: C.Object): S.ListeNN;
		
		VAR
			
			l: S.ListeNN;
			s: D.Chaine;
			a: C.ANYPTR;
			n: PCard;
			obj, oo: C.Object;
		
		BEGIN (*CreeLAtt*)
			IF o.ErrorIn() THEN
				se.yAPasErreur:= FALSE;
				RETURN NIL;
			ELSE
				WHILE o.ObjFunc()= cons DO
					obj:= o.ObjTermSon(1);
					s:= se.CreeChaine(obj);
					oo:= o.ObjTermSon(2);
					a:= oo.ObjUser();
					n:= a(PCard);
					IF ~S.InsereNN(l, s, n.i) THEN
						se.ErreurSem(15, obj);
					END;
					o:= o.ObjTermSon(3);
				END;
				RETURN l;
			END;
		END CreeLAtt;
	
	PROCEDURE (se: Sem) CreeGram (o: C.Object): S.Gram;
		
		VAR
			
			g, gExp: S.Gram;
			n: PCard;
			oo: C.Object;
			a: C.ANYPTR;
		
		BEGIN (*CreeGram*)
			IF o.ErrorIn() THEN
				se.yAPasErreur:= FALSE;
				RETURN NIL;
			ELSE
				WHILE o.ObjFunc()= cons DO
					oo:= o.ObjTermSon(1);
					a:= oo.ObjUser();
					n:= a(PCard);
					NEW(g);
					g.suivant:= gExp;
					oo:= o.ObjTermSon(2);
					g.tOuNT:= oo.ObjFunc()= true;
					g.num:= n.i;
					gExp:= g;
					o:= o.ObjTermSon(3);
				END;
				RETURN gExp;
			END;
		END CreeGram;
	
	PROCEDURE (se: Sem) CreeLAct (o: C.Object): S.ListeAction;
		
		VAR
			
			l, lAct: S.ListeAction;
		
		PROCEDURE CreeAct (o: C.Object): S.Action;
			
			VAR
				
				obj: C.Object;
				i: PCard;
				j, k: LONGINT;
				s: D.Chaine;
				act: S.Action;
				tOuNT: BOOLEAN;
				a: C.ANYPTR;
			
			PROCEDURE CreeFonct (o: C.Object): S.Action;
				
				VAR
					
					cB: PCardBool;
					act: S.Action;
					oo: C.Object;
					a: C.ANYPTR;
				
				PROCEDURE CreeParams (o: C.Object): S.ListeAttribs;
					
					VAR
						
						l, lPar: S.ListeAttribs;
					
					PROCEDURE CreeAtt (o: C.Object): S.ListeAttribs;
						
						VAR
							
							obj: C.Object;
							i: PCard;
							j, k: LONGINT;
							tOuNT: BOOLEAN;
							lPar: S.ListeAttribs;
							s: D.Chaine;
							a: C.ANYPTR;
						
						BEGIN (*CreeAtt*)
							obj:= o.ObjTermSon(1);
							a:= obj.ObjUser();
							i:= a(PCard);
							IF se.ls.ChercheGramCour(i.i, j, tOuNT) THEN
								IF o.ObjTermSonsNb()= 1 THEN
									IF tOuNT THEN
										NEW(lPar);
										lPar.numTNT:= i.i;
										lPar.numAttrib:= 1;
									ELSE
										se.ErreurSem(9, obj);
									END;
								ELSE
									IF tOuNT THEN
										se.ErreurSem(8,obj);
									ELSE
										obj:= o.ObjTermSon(2);
										s:= se.CreeChaine(obj);
										IF se.ls.ChercheAtt(j, s, k) THEN
											NEW(lPar);
											lPar.numTNT:= i.i;
											lPar.numAttrib:= k;
										ELSE
											se.ErreurSem(7, obj);
										END;
									END;
								END;
							ELSE
								se.ErreurSem(6, obj);
							END;
							RETURN lPar;
						END CreeAtt;
					
					BEGIN (*CreeParams*)
						WHILE o.ObjFunc()= cons DO
							l:= CreeAtt(o.ObjTermSon(1));
							IF l# NIL THEN
								l.suivant:= lPar;
								lPar:= l;
							END;
							o:= o.ObjTermSon(2);
						END;
						RETURN lPar;
					END CreeParams;
				
				BEGIN (*CreeFonct*)
					oo:= o.ObjTermSon(1);
					a:= oo.ObjUser();
					cB:= a(PCardBool);
					NEW(act);
					act.numFct:= cB.c;
					act.softOrHard:= cB.b;
					act.params:= CreeParams(o.ObjTermSon(2));
					RETURN act;
				END CreeFonct;
			
			BEGIN (*CreeAct*)
				IF o.ErrorIn() THEN
					se.yAPasErreur:= FALSE;
					RETURN NIL;
				ELSE
					obj:= o.ObjTermSon(1);
					a:= obj.ObjUser();
					i:= a(PCard);
					IF se.ls.ChercheGramCour(i.i, j, tOuNT) THEN
						IF tOuNT THEN
							se.ErreurSem(8, obj);
						ELSE
							obj:= o.ObjTermSon(2);
							s:= se.CreeChaine(obj);
							IF se.ls.ChercheAtt(j, s, k) THEN
								act:= CreeFonct(o.ObjTermSon(3));
								act.numNT:= i.i;
								act.numAtt:= k;
							ELSE
								se.ErreurSem(7, obj);
							END;
						END;
					ELSE
						se.ErreurSem(6, obj);
					END;
					RETURN act;
				END;
			END CreeAct;
		
		BEGIN (*CreeLAct*)
			WHILE o.ObjFunc()= cons DO
				NEW(l);
				l.suivant:= lAct;
				l.action:= CreeAct(o.ObjTermSon(1));
				lAct:= l;
				o:= o.ObjTermSon(2);
			END;
			RETURN lAct;
		END CreeLAct;
	
	PROCEDURE (se: Sem) Execution-(numFct, nbPars: LONGINT; params: C.ObjectsList; VAR o: C.Object; VAR a: C.ANYPTR): BOOLEAN;
		
		VAR
			
			s: D.Chaine;
			cha1, cha2: PChaine;
			lExp: L.LexExp;
			card: PCard;
			cE, cE1, cE2: PCarEns;
			lAtt: S.ListeNN;
			n: LONGINT;
			b: BOOLEAN;
			cB: PCardBool;
			lce: A.CarEns;
			p1, p2: C.ANYPTR;
			oo: C.Object;
		
		PROCEDURE CreeTokL (o: C.Object): L.LexExp;
			
			VAR
				
				s: D.Chaine;
				e: L.LexExp;
			
			BEGIN (*CreeTokL*)
				s:= se.CreeChaine(o);
				IF s# NIL THEN
					IF se.ls.lx.ChercheTokL(s,e) THEN
						e:= L.CopieLexExp(e);
					ELSE
						se.ErreurSem(2, o);
					END;
				END;
				RETURN e;
			END CreeTokL;
		
		PROCEDURE CreeLExp (o: C.Object): L.LexExp;
			
			CONST
				
				slash = 4;
				ou= 5;
				cat= 6;
				star= 7;
				eps= 8;
				mult= 9;
				catCha= 10;
				eOL= 11;
				creeCarL= 12;
			
			VAR
				
				p: C.ANYPTR;
				oo: C.Object;
				c1, c2: PCard;
			
			PROCEDURE CreeMultL (lExp: L.LexExp; x, y: PCard; o: C.Object): L.LexExp;
				
				VAR
					
					i: LONGINT;
					e: L.LexExp;
				
				PROCEDURE Mult (e: L.LexExp; n: LONGINT): L.LexExp;
					
					VAR
						
						i: LONGINT;
						f: L.LexExp;
					
					BEGIN (*Mult*)
						IF n= 0 THEN
							f:= L.CreeEpsL();
						ELSE
							f:= L.CopieLexExp(e);
							FOR i:= 2 TO n DO
								f:= L.CreeCatL(f, L.CopieLexExp(e));
							END;
						END;
						RETURN f;
					END Mult;
				
				BEGIN (*CreeMultL*)
					IF x.i> y.i THEN
						se.ErreurSem(1, o);
						RETURN NIL;
					ELSE
						e:= Mult( lExp, x.i);
						FOR i:= x.i+ 1 TO y.i DO
							e:= L.CreeCatL(e, L.CreeOrL(L.CreeEpsL(), L.CopieLexExp(lExp)));
						END;
						RETURN e;
					END;
				END CreeMultL;
			
			PROCEDURE CreeCatChaL (s: D.Chaine): L.LexExp;
				
				VAR
					
					i: LONGINT;
					c: A.CarEns;
					e: L.LexExp;
				
				BEGIN (*CreeCatChaL*)
					IF (s= NIL) OR (LEN(s)= 1) THEN (* There may be a eOS in the string. *)
						e:= L.CreeEpsL();
					ELSE
						A.NewCarEns(c);
						c.Incl(ORD(s[0]));
						e:= L.CreeCarL(c);
						FOR i:= 1 TO LEN(s)- 2 DO
							A.NewCarEns(c);
							c.Incl(ORD(s[i]));
							e:= L.CreeCatL(e, L.CreeCarL(c));
						END;
					END;
					RETURN e;
				END CreeCatChaL;
			
			PROCEDURE CreeCaracL (cE: PCarEns): L.LexExp;
				
				BEGIN (*CreeCaracL*)
					RETURN L.CreeCarL(cE.c);
				END CreeCaracL;
			
			BEGIN (*CreeLExp*)
				IF o.ErrorIn() THEN
					se.yAPasErreur:= FALSE;
					RETURN NIL;
				ELSIF o.ObjType()= C.userObj THEN
					p:=o.ObjUser();
					IF p=NIL THEN
						RETURN NIL;
					END;
					RETURN L.CopieLexExp(p(L.LexExp));
				ELSE
					CASE o.ObjFunc() OF
						|slash:
							RETURN L.CreeSuiviL(CreeLExp(o.ObjTermSon(1)), CreeLExp(o.ObjTermSon(2)));
						|ou:
							RETURN L.CreeOrL(CreeLExp(o.ObjTermSon(1)), CreeLExp(o.ObjTermSon(2)));
						|cat:
							RETURN L.CreeCatL(CreeLExp(o.ObjTermSon(1)), CreeLExp(o.ObjTermSon(2)));
						|star:
							RETURN L.CreeStarL(CreeLExp(o.ObjTermSon(1)));
						|eps:
							RETURN L.CreeEpsL();
						|mult:
							oo:= o.ObjTermSon(2);
							p:= oo.ObjUser();
							c1:= p(PCard);
							oo:= o.ObjTermSon(3);
							p:= oo.ObjUser();
							c2:= p(PCard);
							RETURN CreeMultL(CreeLExp(o.ObjTermSon(1)), c1, c2, oo);
						|catCha:
							oo:= o.ObjTermSon(1);
							p:= oo.ObjUser();
							RETURN CreeCatChaL(p(PChaine).s);
						|eOL:
							RETURN L.CreeEOLL();
						|creeCarL:
							oo:= o.ObjTermSon(1);
							p:= oo.ObjUser();
							RETURN CreeCaracL(p(PCarEns));
					END;
				END;
			END CreeLExp;
		
		BEGIN (*Execution*)
			se.yAPasErreur:= TRUE;
			CASE numFct OF
				| 1:(*InsereDefL*)
					o:= C.Parameter(params, 1);
					s:= se.CreeChaine(o);
					lExp:= CreeLExp(C.Parameter(params, 2));
					IF (s# NIL) & ~se.ls.lx.InsereDefL(s, lExp) THEN
						se.ErreurSem(0, o);
					END;
				| 2:(*DefComment*)
					o:= C.Parameter(params, 1);
					se.ls.lx.DefComment(CreeLExp(o), CreeLExp(C.Parameter(params, 2)));
				| 3:(*InitSynt*)
					se.ls.lx.EffaceDef;
					se.ls.DebutSynt;
				| 4:(*InsereTokL*)
					o:= C.Parameter(params, 1);
					s:= se.CreeChaine(o);
					lExp:= CreeLExp(C.Parameter(params, 4));
					IF s# NIL THEN
						o:= C.Parameter(params, 2);
						IF o.ErrorIn() THEN
							n:= 0;
						ELSE
							p1:= o.ObjUser();
							card:= p1(PCard);
							n:= card.i;
						END;
						oo:= C.Parameter(params, 3);
						IF ~se.ls.lx.InsereTokL(s, n, oo.ObjFunc()= true, lExp) THEN
							se.ErreurSem(0, C.Parameter(params, 1));
						END;
					END;
				| 5:(*ZERO*)
					NEW(card);
					card.i:= 0;
					a:= card;
				| 6:(*Valeur*)
					o:= C.Parameter(params, 1);
					a:= se.Valeur(o);
				| 7:(*ToutCar*)
					NEW(cE);
					A.NewCarEns(cE.c); cE.c.Full;
					A.NewCarEns(lce); lce.Small({ORD(D.eOF1), ORD(D.eOF2), ORD(D.eOL1), ORD(D.eOL2)});
					cE.c.Diff(cE.c, lce);
					a:= cE;
				| 8:(*Union*)
					o:= C.Parameter(params, 1);
					p1:= o.ObjUser();
					oo:= C.Parameter(params, 2);
					p2:= oo.ObjUser();
					IF (p1= NIL) OR (p2= NIL) THEN
						se.yAPasErreur:= FALSE;
					ELSE
						cE1:= p1(PCarEns);
						cE2:= p2(PCarEns);
						cE1.c.Union(cE1.c, cE2.c);
						a:= cE1;
					END;
				| 9:(*Difference*)
					o:= C.Parameter(params, 1);
					p1:= o.ObjUser();
					oo:= C.Parameter(params, 2);
					p2:= oo.ObjUser();
					IF (p1= NIL) OR (p2= NIL) THEN
						se.yAPasErreur:=  FALSE;
					ELSE
						cE1:= p1(PCarEns);
						cE2:= p2(PCarEns);
						cE1.c.Diff(cE1.c, cE2.c);
						a:= cE1;
					END;
				|10:(*Vide*)
					NEW(cE);
					A.NewCarEns(cE.c);
					a:= cE;
				|11:(*Intervalle*)
					o:= C.Parameter(params, 1);
					IF o.ErrorIn() THEN
						se.yAPasErreur:= FALSE;
					ELSE
						p1:= o.ObjUser();
						cha1:= p1(PChaine);
						IF LEN(cha1.s)= 2 THEN
							o:= C.Parameter(params, 2);
							IF o.ErrorIn() THEN
								se.yAPasErreur:= FALSE;
							ELSE
								p1:= o.ObjUser();
								cha2:= p1(PChaine);
								IF LEN(cha2.s)= 2 THEN
									NEW(cE);
									A.NewCarEns(cE.c);
									cE.c.Interval(ORD(cha1.s[0]), ORD(cha2.s[0]));
									a:= cE;
								ELSE
									se.ErreurSem(3, o);
								END;
							END;
						ELSE
							se.ErreurSem(3, o);
						END;
					END;
				|12:(*ExtraitChaine*)
					o:= C.Parameter(params, 1);
					NEW(cha1);
					cha1.s:= se.ExtraitChaine(o);
					a:= cha1;
				|13:(*NombreChaine*)
					o:= C.Parameter(params, 1);
					IF o.ErrorIn() THEN
						se.yAPasErreur:= FALSE;
					ELSE
						p1:= o.ObjUser();
						card:= p1(PCard);
						IF card.i> ORD(MAX(CHAR)) THEN
							se.ErreurSem(16, o);
						ELSE
							NEW(cha1);
							NEW(cha1.s, 2);
							cha1.s[0]:= CHR(card.i);
							cha1.s[1]:= D.eOS;
							a:= cha1;
						END;
					END;
				|14:(*FinDeclaration*)
					se.ls.FinDeclaration;
				|15:(*InsereNonTerm*)
					o:= C.Parameter(params, 1);
					s:= se.CreeNTChaine(o);
					lAtt:= se.CreeLAtt(C.Parameter(params, 3));
					oo:= C.Parameter(params, 2);
					IF (s# NIL) & ~se.ls.InsereNonTerm(s, oo.ObjFunc()= true, lAtt) THEN
						se.ErreurSem(4, o);
					END;
				|16:(*InsereFonctionHard*)
					s:= se.CreeChaine(C.Parameter(params, 1));
					o:= C.Parameter(params, 2);
					IF o.ErrorIn() THEN
						se.yAPasErreur:= FALSE;
						n:= 1;
					ELSE
						p1:= o.ObjUser();
						card:= p1(PCard);
						n:= card.i;
						IF n= 0 THEN
							se.ErreurSem(14, o);
						END;
					END;
					IF (s# NIL) & ~se.ls.InsereFonctionHard(s, n) THEN
						se.ErreurSem(11, o);
					END;
				|17:(*InsereFonctionSoft*)
					s:= se.CreeChaine(C.Parameter(params, 1));
					o:= C.Parameter(params, 2);
					IF o.ErrorIn() THEN
						se.yAPasErreur:= FALSE;
						n:= 1;
					ELSE
						p1:= o.ObjUser();
						card:= p1(PCard);
						n:= card.i;
						IF n= 0 THEN
							se.ErreurSem(14, o);
						END;
					END;
					IF (s# NIL) & ~se.ls.InsereFonctionSoft(s, n) THEN
						se.ErreurSem(12, o);
					END;
				|18:(*InsereSem*)
					o:= C.Parameter(params, 1);
					se.ls.InsereSem(se.CreeLAct(o));
				|19:(*ChercheNT*)
					o:= C.Parameter(params, 1);
					s:= se.CreeNTChaine(o);
					NEW(card);
					IF se.yAPasErreur & ~se.ls.ChercheNT(s, card.i) THEN
						se.ErreurSem(10, o);
					END;
					a:= card;
				|20:(*InsereRegle*)
					o:= C.Parameter(params, 1);
					IF o.ErrorIn() THEN
						se.yAPasErreur:= FALSE;
						n:= 0;
					ELSE
						p1:= o.ObjUser();
						card:= p1(PCard);
						n:= card.i;
					END;
					o:= C.Parameter(params, 2);
					se.ls.InsereRegle(n, se.CreeGram(o));
				|21:(*ChercheTerm*)
					o:= C.Parameter(params, 1);
					s:= se.CreeChaine(o);
					NEW(card);
					IF se.yAPasErreur & ~se.ls.lx.ChercheTerm(s, card.i) THEN
						se.ErreurSem(5, o);
					END;
					a:= card;
				|22:(*ChercheFixePrec*)
					o:= C.Parameter(params, 1);
					s:= se.CreeChaine(o);
					IF se.yAPasErreur THEN
						IF se.ls.lx.CherchePrec(s, n, b) THEN
							se.ls.FixeRegleCourPrec(n, b);
						ELSE
							se.ErreurSem(5, o);
						END;
					END;
				|23:(*ChercheFonction*)
					o:= C.Parameter(params, 1);
					s:= se.CreeChaine(o);
					NEW(cB);
					IF se.yAPasErreur & ~se.ls.ChercheFonction(s, cB.c, cB.b) THEN
						se.ErreurSem(13, o);
					END;
					a:= cB;
				|24:(*COPIE*)
					NEW(cB);
					cB.c:= 0;
					cB.b:= TRUE;
					a:= cB;
				|25:(*FixeTerminaison*)
					o:= C.Parameter(params, 1);
					IF o.ErrorIn() THEN
						se.yAPasErreur:= FALSE;
					ELSE
						p1:= o.ObjUser();
						card:= p1(PCard);
						se.ls.FixeTerminaison(card.i);
					END;
				|26:(*FixeAxiome*)
					o:= C.Parameter(params, 1);
					IF o.ErrorIn() THEN
						se.yAPasErreur:= FALSE;
					ELSE
						p1:= o.ObjUser();
						card:= p1(PCard);
						se.ls.FixeAxiome(card.i);
					END;
				|27:(*ChercheTokL*)
					o:= C.Parameter(params, 1);
					a:= CreeTokL(o);
				|28:(*Nomme*)
					o:= C.Parameter(params, 1);
					se.nom:= se.CreeChaine(o);
			END;
			RETURN se.yAPasErreur;
		END Execution;
	
	END BabelAnaSem.
BIERCF  TF   F    <       g 
     C  Syntax10.Scn.Fnt 30.03.2002  19:58:43  TimeStamps.New  