TextDocs.NewDoc        Syntax10.Scn.Fnt    Syntax10m.Scn.Fnt             g    9    w       Z       M        ~       >                               ;           (  Format a text document to a PostScript file ready for publication, and direct it to the default Windows printer.

			Publisher.Print formatdata | *

	The Publisher reads a good looking WYSIWYG Oberon text with chapter headings, section headings and
	paragraphs, including tables and gadgets (Panels, RembrandtFrames, etc) and transforms it to a PS file.
	The formatting instructions and the name of the text files to print are contained in the formatdata,
	or else, the marked text is printed. In the latter case, no formatting instructions can be supplied:
	default formatting instructions are used instead, e.g. AdjustBaseFont cannot apply.
	The formatdata contains a mixture of formatting instructions and of names of text files to format.
	Each text file is treated as a chapter of a book. The program automatically collects index information,
	a table of figures and a table of contents. These are saved in internal text objects which may be
	assimilated to pseudo-files.
	
	Default Page Layout:
	Quite a few page layout values are hard-coded in the SetDefaultPageLayout procedure.
	Variables with their default values are:
		PageWidth	170mm	PageHeight	240mm
		TextWidth	125mm	 TextHeight	180mm
		LineSpacing	25 pixels
		TopMargin	19mm
		HeaderHeight	5mm
		HeaderSeparator	10mm
		FooterSeparator	10mm
		DoubleSided	TRUE
		RomanPageNo	FALSE
	Markers in the four corners of pages, useful for cutting the paper correctly, are controlled
	by the MarkersOn/MarkersOff switch.
	When DoubleSided is TRUE, each chapter starts on an odd numbered page,
	possibly leaving an empty even numbered page.
	RomanPageNo must be set to TRUE for the second run of Publisher.Print to print
	the Preface, the table of contents and the list of figures with roman numbers.

	Pages to print:
		PrintPageNos begin => end.		Begin and end page numbers.
		Default 1 => 1000 (i.e. eot hopefully).

	Text hyphenation and text format control with TextStyles:
	Formatting is essentially hyphenating the text lines with the help of the Hyphen module. A line
	is a text stretch ending with a carrier return.
	A "-" character in a word, e.g. "object-based" is accepted as hyphen.
	This version uses the HyphenES.Text file, for english texts. Use HyphenDS.Text for German.
	Otherwise, formatting is controlled by TextStyle gadgets having tabs or not, with or without
	PageBreak. The first TextStyle in the first"chapter" is used as reference.
	Words made exclusiveley of capital letters are not hyphenated.
	Oberon names (command name, type name, etc.) in Arial typeface are not hyphenated.
	
	Fonts:
	Use the PrinterFontSubstitution value in the [System] section of the Registry to control the fonts.
	To produce a document ready for printing use a Times font for instance:
		PrinterFontSubstitution=Syntax Times
	
	Oberon cannot represent odd size fonts in their true size: the default system font is used instead,
	which is typically Syntax10.Scn.Fnt. However, for printing on a printer with a larger font palette
	is made possible with the AdjustBaseFont oldsize => newsize format instruction. It can adjust the
	base font size from say 12, to 13 without altering the look of the original text. Refer to the
		EditTools.ChangeSize command.

	For the Oberon Companion, the base font size is 12. Printing in Times12 is too small and Times14
	is too large. Therefore, the size is changed from 12 to 13. However, Arial12 is the correct size
	for printing.

	Colors:
	Printout of colored text is controlled by the ColorsOn/ColorsOff switch.

	Revision marks:
	Revised text may be highlighted in red or blue (in principle colors 1 to 8 could be used, but
	a useable pattern is provided by the values 2 to 7 only). The text color is mapped onto a pattern
	provided in module Printer3 which is used for drawing a vertical line alongside the revised text.
	Printout of the revision marks is controlled by the RevisionsOn/RevisionsOff switch.

	Index:
	Information destined for the construction of an index in hidden in the text itself which contains
	TextHyperlinks at strategical locations. The Name attribute of a TextHyperlink is used as hiding place
	for the information to be placed in the alphabetical index. This information is associated
	with the CurrentPage value at which the TextHyperlink is detected.
	The Cmd attribute may be assigned the value "B" to indicate that the page number should appear in
	bold face. Meaning: this entry is best explained there.
	The internal object name is "index" (pseudo-file).

	List of Figures:
	Formatting instructions destined to format a table of figures which is constructed
	with the lines starting with "Figure". The internal object name is "lof" (pseudo-file).

	Table of Contents:
	Formatting instructions destined to format a table of contents which is constructed
	with the lines having a first character in bold style. The internal object name is "toc" (pseudo-file).

	Printer:
	The DefaultPrinter value is ignored. The WinPrinter will be installed automatically.
	
	The DoubleSided variable is used to control the formatting of odd/even pages only. Double side
	printing is controlled by the printer setup.
	
	Debug:
	A debugging facility is integrated: set debug := TRUE.

	Sample formatdata:

Publisher.Print
	MarkersOff
	PrintPageNos 1 => 1000
	AdjustBaseFont 12 => 13
	HeadersOn	FootersOn
	RevisionsOn	ColorsOff

	EvenHeader "Chapter 1"
	OddHeader "Introduction and Design Principles"
		Chapter1.Text

	EvenHeader "Chapter 2"
	OddHeader "The Basic System"
		Chapter2.Text

	EvenHeader "Chapter 3"
	OddHeader "The Gadgets User Interface"
		Chapter3.Text

	EvenHeader "Chapter 4"
	OddHeader "The Standard Gadgets Reference"
		Chapter4.Text

	EvenHeader "Chapter 5"
	OddHeader "The Programmer's Guide"
		Chapter5.Text

	EvenHeader "Chapter 6"
	OddHeader "Applications and Examples"
		Chapter6.Text

	EvenHeader "Appendix A"
	OddHeader "Configuring the System"
		AppendA.Text

	EvenHeader "Appendix B"
	OddHeader "Extended Language and Compiler for PC Native Oberon"
		AppendB.Text

	EvenHeader "Appendix C"
	OddHeader "How to get Oberon System 3"
		AppendC.Text

	EvenHeader "Bibliography"
	OddHeader "The Oberon Companion"
		Biblio.Text

	EvenHeader "Index            "
	OddHeader "The Oberon Companion"
		index

	EvenHeader "List of Figures and Tables"
	OddHeader "The Oberon Companion"
		lof

	EvenHeader "Contents"
	OddHeader "The Oberon Companion"
		toc
~
==================
Formatting instructions for the front incl. Preface, toc.Text and lof.Text

Publisher.Print
	AdjustBaseFont 12 => 13
	MarkersOff
	RomanPageNo

	HeadersOn	FootersOff

	EvenHeader ""
	OddHeader ""
		Front.Text

	EvenHeader ""
	OddHeader ""
		toc.Text

	EvenHeader ""
	OddHeader ""
		lof.Text
~
