#   Oberon10.Scn.Fnt  D   D  (* ETH Oberon, Copyright 2001 ETH Zuerich Institut fuer Computersysteme, ETH Zentrum, CH-8092 Zuerich.
Refer to the "General ETH Oberon System Source License" contract available at: http://www.oberon.ethz.ch/ *)


(*
Native Oberon UsbSystem (User frontend, Hub poller)

Reference: http://www.usb.org

17.11.2000 cp first release
*)

MODULE UsbSystem; (** non-portable **)  (** cp **)

IMPORT Kernel, Oberon, Input, Usb, UsbUhci;

VAR

	UsbTask : Oberon.Task;

PROCEDURE OberonHandler(me : Oberon.Task);
BEGIN

	me.time := Oberon.Time() + Input.TimeUnit DIV 3; (* 3 times a second *)
	Usb.Connect();

END OberonHandler;

PROCEDURE Cleanup();
BEGIN
	IF UsbTask # NIL THEN
		Oberon.Remove(UsbTask);
		UsbTask := NIL;
	END;
END Cleanup;

PROCEDURE Start*();
BEGIN
	(* dummy *)
END Start;

BEGIN

	UsbUhci.Init;

	(* future improvement: add UsbOhci.Init here :) *)

	Usb.Connect;

	Kernel.InstallTermHandler(Cleanup);

	NEW(UsbTask);
	UsbTask.time := Oberon.Time();
	UsbTask.safe := FALSE;
	UsbTask.handle := OberonHandler;
	Oberon.Install(UsbTask);

END UsbSystem.

(** Init: UsbSystem.Start **)
