TextDocs.NewDoc      WF   CColor    Flat  Locked  Controls  Org      BIER`   b        3 #   Syntax10.Scn.Fnt       MODULE XMLRPC;
	IMPORT
		AosIO, XML, HTTPDocs0, DS := DynamicStrings, AosTCP, AosIP, AosDNS, Input, Strings;
		
	CONST
		buffersize = 256;
		delay = 30;

	TYPE
		Parameters* = OBJECT(XML.Element)
			PROCEDURE &Init();
			BEGIN
				Init^();
				SELF.SetName("params");
			END Init;
			
			PROCEDURE AddInt*(i : LONGINT);
			VAR
				str : ARRAY 20 OF CHAR;
				p, v, t : XML.Element;
				xstr : XML.ArrayChars;
			BEGIN
				DS.IntToStr(i, str); NEW(xstr); xstr.SetStr(str);
				NEW(p); p.SetName("param");
				NEW(v); v.SetName("value");
				NEW(t); t.SetName("i4");
				t.AddContent(xstr);
				v.AddContent(t);
				p.AddContent(v);
				SELF.AddContent(p);
			END AddInt;			
		END;
		
		Method* = OBJECT
			VAR
				xml- : XML.Element;
				params : Parameters;
				wr : AosIO.Writer;
				dynstr : DS.DynamicString;
			
			PROCEDURE &Init(name : ARRAY OF CHAR);
			VAR
				e : XML.Element;
				xstr : XML.ArrayChars;
				str : ARRAY 50 OF CHAR;
				
			BEGIN
				NEW(xml); NEW(params); NEW(e); NEW(xstr);
				xml.SetName("methodCall");
				e.SetName("methodName");
				xstr.SetStr(name);
				
				e.AddContent(xstr);
				xml.AddContent(e);				
				xml.AddContent(params);				
				
				NEW(dynstr);
				str := '<?xml version="1.0"?>';
				dynstr.Append(str);
				NEW(wr, SendToString, 1024);
			END Init;
			
			PROCEDURE SetParams*(p : Parameters);
			BEGIN
				xml.RemoveContent(params);
				xml.AddContent(p);
				params := p;
			END SetParams;
			
			PROCEDURE SendToString(VAR buf: ARRAY OF CHAR; ofs, len : LONGINT; propagate : BOOLEAN; VAR res : LONGINT);
			BEGIN
				dynstr.Append(buf);
			END SendToString;
			
			PROCEDURE ToString*():DS.DynamicString;
			BEGIN
				xml.Write(wr);
				wr.Update;
				RETURN dynstr;
			END ToString;
		END;
				
		Client* = OBJECT
			VAR
				conn- : AosTCP.Connection;
				host-, url-, path- , label : ARRAY 256 OF CHAR;
				ip- : AosIP.Adr;
				wr- : AosIO.Writer;
				res-, bytesavailable, time : LONGINT;
				port : INTEGER;
			
			PROCEDURE &Init(serverurl : ARRAY OF CHAR);
			VAR
				key : LONGINT;
				
			BEGIN
				key := HTTPDocs0.SplitHTTPAdr(serverurl, host, path, label, port);			
				AosDNS.HostByName(host, ip, res);
				IF (res = AosDNS.Ok) THEN
					NEW(conn);
					conn.Open(AosIP.NilPort, ip, 80, res);			
					AosIO.OpenWriter(wr, conn.Send);
				END;
			END Init;

																								
			PROCEDURE Call*(m : Method):DS.DynamicString;
			VAR
				len, n, received : LONGINT;
				xmlstring, retstring : DS.DynamicString;
				dstr : DS.String;
				str : ARRAY 50 OF CHAR;
				header : ARRAY 256 OF CHAR;
				lenstr : ARRAY 20 OF CHAR;
				
			BEGIN			
				xmlstring := m.ToString(); 
				len := xmlstring.Length(); DS.IntToStr(len, lenstr);
				dstr := xmlstring.ToArrOfChar(); 
								
				header := "POST "; Strings.Append(header, path); Strings.Append(header, " HTTP/1.0 "); Strings.Append(header, Strings.CRLF);					
				Strings.Append(header, "User-Agent: Frontier/5.1.2 (WinNT)"); Strings.Append(header, Strings.CRLF);			
				Strings.Append(header, "Host: "); Strings.Append(header, host); Strings.Append(header, Strings.CRLF);			
				Strings.Append(header, "Content-Type: text/xml "); Strings.Append(header, Strings.CRLF);			
				Strings.Append(header, "Content-Length: "); Strings.Append(header, lenstr); Strings.Append(header, Strings.CRLF); 
				
				conn.Send(header, 0, Strings.Length(header), TRUE, res); ASSERT(res = AosTCP.Ok);			
				conn.Send(Strings.CRLF, 0, 2, TRUE, res); ASSERT(res = AosTCP.Ok);
				
				conn.Send(dstr^, 0, len, TRUE, res); ASSERT(res = AosTCP.Ok);
				NEW(retstring);
				time := Input.Time() + Input.TimeUnit * delay;
				REPEAT
						bytesavailable := conn.Available();
				UNTIL (Input.Time() > time) OR (bytesavailable > 0);
				IF bytesavailable = 0 THEN
					str := "Timeout error ";
					retstring.Append(str);
				ELSE
					len := LEN(str);
					REPEAT
						IF len <= bytesavailable THEN n := len - 1 ELSE n := bytesavailable END;
						conn.Receive(str, 0, n, 1, received, res); str[n] := 0X;
						retstring.Append(str);
						bytesavailable := conn.Available();						
					UNTIL bytesavailable = 0;
				END;
				RETURN retstring;		
			END Call;
		END;
		
		PROCEDURE UserBreak():BOOLEAN;
		VAR
			ch : CHAR;
		BEGIN
			IF (Input.Available() > 0)THEN
				Input.Read(ch);
				IF ch = 01BX THEN 
					RETURN TRUE 
				ELSE 
					RETURN FALSE;
				END;
			ELSE
				RETURN FALSE
			END;
		END UserBreak;		
END XMLRPC.


					(*	
			PROCEDURE SplitURL(passedurl : ARRAY OF CHAR; host, path : ARRAY OF CHAR);
			VAR
				dsurl : DS.DynamicString;
				surl : DS.String;
				pos : LONGINT;
				
			BEGIN
				NEW(dsurl);
				NEW(surl, 1024);
				COPY(passedurl, surl^);
				dsurl.FromArrOfChar(surl);
				DS.Search("://", passedurl, pos);
				INC(pos, 3);
				startpos := pos;
				DS.Search("/", passedurl, pos);
				IF pos > startpos THEN				
					surl := dsurl.Extract(startpos, pos-startpos);
				lastpos := pos;
				
				REPEAT
					DS.Search("/", passedurl, lastpos);
				DS.Search(
			END SplitURL; *)

		