(**************************************************************************

Name:           Strings
Purpose:        obvious
Version:	0.0
Predecessor:    -
Changes:        -
Target platform:PC>=386
Compiler:	Oberon 3
Date:           February 1995
Author:		Frank Hrebabetzky

***************************************************************************)

MODULE Strings;

IMPORT Math0;


PROCEDURE Append* (VAR s1:ARRAY OF CHAR; s2:ARRAY OF CHAR);
(* append s2 to s1 *)
VAR p1, p2, l1: INTEGER;
    c         : CHAR;
BEGIN
  l1:= SHORT(LEN(s1)) - 1;
  p1:=0;   p2:=0;
  c:= s2[0];
  WHILE (p1<=l1) & (s1[p1]#0X) DO INC(p1) END;
  WHILE (p1<l1) & (c#0X) DO
    s1[p1]:=c;
    INC(p1);   INC(p2);
    c:= s2[p2];
  END;
  s1[p1]:=0X;  
END Append;


PROCEDURE IntToStr* (i:LONGINT; n:INTEGER; VAR str:ARRAY OF CHAR);
(* Convert i to a string with n places, eventually with leading blanks. *)
VAR neg: BOOLEAN;
    k, p, c0: INTEGER;
    i10: LONGINT;
BEGIN
  c0:= ORD("0");
  p:= Math0.mini (SHORT(LEN(str)) - 1, n);
  IF p<2 THEN RETURN END;
  neg:= i<0;
  i:= ABS(i);
  str[p]:= 0X;   DEC(p);
  IF i=0 THEN
    str[p]:="0";   DEC(p);
  ELSE
    WHILE (p>=0) & (i>0) DO
      i10:= i DIV 10;
      str[p]:= CHR (c0 + i - 10*i10);
      i:= i10;   DEC(p);
    END;
    IF neg & (p>=0) THEN
      str[p]:="-";   DEC(p);
    END;
  END;
  FOR k:=0 TO p DO str[k]:=" "; END;
END IntToStr;


END Strings.