(**************************************************************************

Name:           NumAeq1
Purpose:        Numerics: 1-dimensional, discrete, aequidistant functions
Version:	0.4
Predecessor:    0.3
Changes:        SineFit debugged
Target platform:PC>=386
Compiler:	Oberon 3
Date:           May  1995
Author:		Frank Hrebabetzky

***************************************************************************)

MODULE NumAeq1;

IMPORT Math, Math0;

CONST
  MNP* = 256;		(* maximum number of points	*)

TYPE
  VAL*	= ARRAY MNP OF REAL;
  Func*	= RECORD
              NP*			: INTEGER;	(* number of points *)
              ymin*, ymax*, x0*, dx*	: REAL;
              y*			: VAL
            END;

VAR
  ok*	: BOOLEAN;


PROCEDURE LinReg (VAR f:Func; ia,ib:INTEGER; VAR n,m:REAL);
(* Linear regression: fit of m*x+n to f in [ia,ib].
   f is VAR for storage economy only. *)
VAR i, N		: INTEGER;
    x, X1, X2, Y0, Y1, den	: REAL;
BEGIN
  x:= f.x0 + ia*f.dx;
  X1:= 0.0;   X2:= 0.0;   Y0:=0.0;   Y1:= 0.0;
  FOR i:=ia TO ib DO
    X1:= X1 + x;   X2:= X2 + x*x;   Y0:= Y0 + f.y[i];   Y1:= Y1 + x*f.y[i];
    x:= x + f.dx;
  END;
  N:= ib - ia + 1;
  den:= N*X2 - X1*X1;
  n:= (Y0*X2 - X1*Y1) / den;
  m:= (N*Y1 - Y0*X1) / den;
END LinReg;  


PROCEDURE Extremum* (VAR f:Func; ia,ib:INTEGER; VAR xe,ye:REAL);
(* Search extremum (xe,ye) of f in [ia,ib].
   f is VAR for storage economy only. *)
VAR i	: INTEGER;
    a, b, c, c0, c1, x, X1, X2, Y0	: REAL;
    m	: Func;
BEGIN
  (* create function m of slopes *)
  m.x0:= f.x0;
  m.dx:= f.dx;
  FOR i:=ia TO ib-1 DO m.y[i]:= (f.y[i+1]-f.y[i]) / f.dx END;
  (* get linear regression coefficients c0, c1 *)
  LinReg (m, ia, ib-1, c0, c1);
  (* coefficients a, b, c of quadratic function y = a + b*x + c*x^2 *)
  c:= c1/2;
  b:= c0 - c1*f.dx/2;
  X1:= 0.0;   X2:= 0.0;   Y0:= 0.0;
  x:= f.x0 + ia*f.dx;
  FOR i:=ia TO ib DO
    X1:= X1 + x;   X2:= X2 + x*x;   Y0:= Y0 + f.y[i];
    x:= x + f.dx;
  END;
  a:= (Y0-b*X1-c*X2) / (ib-ia+1);
  (* calcultate extremum coordinates *)
  xe:= (f.dx - b/c) / 2;
  ye:= a + b*xe + c*xe*xe;
END Extremum;


PROCEDURE SineFit* (VAR f:Func; ia,ib,p:INTEGER; VAR offs,ampl,phi:REAL);
(* Fit offs+ampl*sin(2*pi*x/per+phi) in [ia,ib] to f.
   p is the number of complete periods in [ia, ib). n>0, ib-ia>1 ! *)
VAR i, N	: INTEGER;
    a, b, k, x, y	: REAL;
BEGIN
  N:= ib - ia;
  (* wave number k *)
  k:= 2 * Math.pi * p / (N * f.dx);
  (* approximation coefficients offs, a (cos), b (sin) *)
  x:= f.x0 + ia*f.dx;
  offs:=0;   a:=0;   b:=0;
  FOR i:=ia TO ib-1 DO
    y:= f.y[i];
    offs:= offs + y;
    a:= a + y*Math.cos(k*x);
    b:= b + y*Math.sin(k*x);
    x:= x + f.dx;
  END;
  offs:= offs / N;
  ampl:= 2 * Math.sqrt (a*a + b*b) / N;
  IF ABS(b)<Math0.eps THEN
    IF a>0 THEN phi:=Math.pi/2 ELSE phi:= -Math.pi/2 END
  ELSIF b>0 THEN phi:= Math.arctan(a/b)
  ELSE phi:= Math.arctan(a/b) - Math.pi
  END;
END SineFit;


END NumAeq1.
