(**************************************************************************

Name:           MathL0.Mod 
Purpose:        simple mathematical utilities
Version:	0.3
Predecessor:    0.2
Changes:        Frac, Entier added
Target platform:PC>=386
Compiler:	Oberon 3
Date:           July 1995
Author:		Frank Hrebabetzky

***************************************************************************)

MODULE MathL0;

IMPORT MathL;

VAR
  eps*, min*	: LONGREAL;
  ln10, x, y	: LONGREAL;
  
  
PROCEDURE mini* (a,b:LONGINT):LONGINT;
BEGIN IF a<b THEN RETURN a ELSE RETURN b END
END mini;


PROCEDURE maxi* (a,b:LONGINT):LONGINT;
BEGIN IF a>b THEN RETURN a ELSE RETURN b END
END maxi;


PROCEDURE minr* (a,b:LONGREAL):LONGREAL;
BEGIN IF a<b THEN RETURN a ELSE RETURN b END
END minr;


PROCEDURE maxr* (a,b:LONGREAL):LONGREAL;
BEGIN IF a>b THEN RETURN a ELSE RETURN b END
END maxr;


PROCEDURE Polar* (x,y:LONGREAL; VAR r,phi:LONGREAL);
BEGIN
  r:= MathL.sqrt(x*x + y*y);
  IF ABS(x)<eps THEN IF y>0 THEN phi:=MathL.pi/2 ELSE phi:=-MathL.pi/2 END
  ELSIF x>0 THEN phi:= MathL.arctan(y/x)
  ELSE phi:= MathL.arctan(y/x) + MathL.pi
  END
END Polar;


PROCEDURE Cart* (r,phi:LONGREAL; VAR x,y:LONGREAL);
BEGIN
  x:= r * MathL.cos(phi);
  y:= r * MathL.sin(phi);
END Cart;


PROCEDURE lg* (x:LONGREAL):LONGREAL;
BEGIN RETURN MathL.ln(x) / ln10
END lg;


PROCEDURE exp10* (x:LONGREAL):LONGREAL;
BEGIN RETURN MathL.exp(x*ln10)
END exp10;


PROCEDURE Frac* (x:LONGREAL):LONGREAL;
(* Attempt to realize without integer arthmetics because of range *)
VAR f10:	LONGREAL;
BEGIN
  x:= ABS(x);
  IF x<1.0 THEN RETURN x END;
  f10:= exp10(ENTIER(lg(x)));
  WHILE f10>0.9 DO
    WHILE x>=f10 DO x:= x - f10 END;
    f10:= 0.1 * f10;
  END;
  RETURN x;
END Frac;


PROCEDURE Entier* (x:LONGREAL):LONGREAL;
(* Attempt to realize without integer arthmetics because of range *)
BEGIN
  IF x>=0.0 THEN RETURN x-Frac(x) ELSE RETURN x+Frac(x) END;
END Entier;


PROCEDURE round* (x:LONGREAL; n:INTEGER):LONGREAL;
(* Round x to n digits, x<=9 (MAX(LONGREAL)=2.15E+9), otherwise no rounding *)
VAR pos	: BOOLEAN;
    f10	:LONGREAL;
BEGIN
  IF n>9 THEN RETURN x END;
  IF x=0.0 THEN RETURN 0.0 END;
  pos:= x>0.0;   x:= ABS(x);
  (* divide x by an integral power of 10, so that x in [0.1, 1.0) *)
  f10:= exp10(ENTIER(lg(x))+1);
  x:= x / f10;
  (* shift n times to the left, round by truncation and shift back *)
  x:= ENTIER(x*exp10(n)+0.5) * exp10(-n);
  (* restore original decimal point position and sign *)
  x:= x * f10;
  IF pos THEN RETURN x ELSE RETURN -x END;
END round;


PROCEDURE roundp* (x:LONGREAL; n:INTEGER):LONGREAL;
(* Round x to n digits behind the decimal point *)
VAR f10: LONGREAL;
BEGIN
  f10:= exp10(n);
  RETURN Entier(f10*x+0.5)/f10;
END roundp;


BEGIN
  min:= 4 / MAX(LONGREAL);	(* 4 is a guess only. Perhaps 1 yields 0.	*)
  ln10:= MathL.ln(10.0);
  eps:=1.0;
  x:= 2.0;
  y:= 1.0;
  WHILE y<x DO
    eps:= 0.5 * eps;   x:= 1.0 + eps;
  END;
  eps:= eps * 2.0;
END MathL0.
