(**************************************************************************

Name:           Graphs
Purpose:        New model gadget
Version:	1.1
Predecessor:    1.0
Changes:        Concat simplified, Load, Store omitted
Target platform:PC>=386
Compiler:	Oberon 3
Date:           October 1995
Author:		Frank Hrebabetzky

***************************************************************************)

MODULE Graphs;

IMPORT
  Objects, Display, Gadgets, Files,
  Num1;

CONST
  EOG = TRUE; (*end of graph*)   CONT = FALSE;
  FUNCGEN = TRUE;			FUNC = FALSE;

TYPE
  Graph*	= POINTER TO GraphDesc;
  GraphDesc*	= RECORD (Gadgets.ObjDesc)
                   f*		: Num1.Func;
                   col*		: INTEGER;
                   line*	: LONGINT;
                   next*	: Graph;
                 END;


PROCEDURE Concat* (list1,list2:Graph);
(* list1 -> list1 + list2 *)
BEGIN
  WHILE list1.next#NIL DO list1:= list1.next END;
  list1.next:= list2;
END Concat;


PROCEDURE Attributes (G:Graph; VAR M:Objects.AttrMsg);
BEGIN
  IF M.id=Objects.get THEN
    IF M.name="Gen" THEN
      M.class:= Objects.String;
      COPY ("Graphs.New", M.s);
      M.res:= 0
    ELSIF M.name="Color" THEN
      M.class:= Objects.Int;
      M.i:= G.col;
      M.res:= 0
    ELSIF M.name = "Line" THEN
      M.class:= Objects.Int;
      M.i:= G.line;
      M.res:= 0
    ELSE Gadgets.objecthandle(G, M)
    END
  ELSIF M.id=Objects.set THEN
    IF (M.name="Color") & (M.class=Objects.Int) THEN
      G.col:= SHORT(M.i);   M.res := 0
    ELSIF (M.name="Line") & (M.class = Objects.Int) THEN
      G.line:= SHORT(M.i);   M.res := 0
    ELSIF M.name = "Value" THEN (* cannot be set *)
    ELSE Gadgets.objecthandle(G, M)
    END
  ELSIF M.id = Objects.enum THEN
    M.Enum("Color"); M.Enum("Line");
    Gadgets.objecthandle(G, M)
  END
END Attributes;


PROCEDURE Copy (orig:Graph; M:Objects.CopyMsg);
(* Attention! orig.f^ will not be copied! *)
VAR go, gn: Graph;
BEGIN
  go:= orig;	NEW(gn);   M.obj:= gn;
  LOOP
    gn.stamp := M.stamp;	gn.handle:= orig.handle;
    gn.f 	:= go.f;
    gn.col 	:= go.col;		gn.line:= go.line;
    IF go.next=NIL THEN EXIT;
    ELSE
      NEW(gn.next);   gn.dlink:= gn.next;  gn:= gn.next;
      go:= go.next;
    END;
  END;
  go.dlink:= M.obj;
END Copy;


PROCEDURE Handler* (obj:Objects.Object; VAR M:Objects.ObjMsg);
BEGIN
  WITH obj:Graph DO
    IF M IS Objects.AttrMsg THEN Attributes (obj, M(Objects.AttrMsg))
    ELSIF M IS Objects.CopyMsg THEN
      WITH M:Objects.CopyMsg DO
        IF M.stamp=obj.stamp THEN M.obj:= obj.dlink (*copy msg arrives again*)
        ELSE (* first time copy message arrives *)
          Copy (obj, M);
        END
      END
    ELSE Gadgets.objecthandle(obj, M)
    END
  END
END Handler;


PROCEDURE New*;
(* The Graph.f^ component is NOT allocated by this procedure because here it
is not
   yet known if it should be NumAeq1.Func or Num1.FuncGenDesc. *)
VAR obj: Graph;
BEGIN
  NEW(obj);
  obj.handle	:= Handler;
  obj.col	:= Display.FG;
  obj.line	:= Display.solid;
  Objects.NewObj := obj;
END New;


END Graphs.

