(**************************************************************************

Name:           Diagr
Purpose:        Test of Diagrams
Version:	0.1
Predecessor:    0.0
Changes:        Strings and graphic elements added
Target platform:PC>=386
Compiler:	Oberon 3
Date:           September 1995
Author:		Frank Hrebabetzky

***************************************************************************)

MODULE Diagr;

IMPORT
  Fonts, Objects, Display, Display3, Gadgets, Num1, Graphs, Diagrams, Timer;

CONST
  RED = 1;	BLUE = 3;	BLACK = 15;

VAR
  i	: INTEGER;
  pat	: ARRAY 15 OF SET;


PROCEDURE Test*;
VAR i, w, h, dsr	: INTEGER;
    x			: REAL;
    obj			: Objects.Object;
    f			: Display.Frame;
    fg			: Num1.FuncGen;
    g1,g2		: Graphs.Graph;
    par, min, max	: Diagrams.String;
    cross1, cross2	: Diagrams.Pattern;
BEGIN
  (* create model-view pair, integrate in display *)
  f:= Gadgets.CreateViewModel ("Diagrams.New", "Graphs.New");
  Gadgets.Integrate (f);

  (* init first graph *)
  g1:= Objects.NewObj(Graphs.Graph);
  NEW(fg);
  fg.NP	:= 5;
  fg.ymin:= -1;
  fg.ymax:= 1;
  fg.x[0]:= -1.0;	fg.y[0]:= -1.0;
  fg.x[1]:=  0.0;	fg.y[1]:= 0.0;
  fg.x[2]:=  0.5;	fg.y[2]:= -0.5;
  fg.x[3]:=  0.8;	fg.y[3]:= 1.0;
  fg.x[4]:=  1.0;	fg.y[4]:= 0.5;
  g1.f	:= fg;

  (* init second graph *)
  obj:= Gadgets.CreateObject ("Graphs.New");
  g2:= Objects.NewObj(Graphs.Graph);
  NEW(g2.f);
  Graphs.Concat (g1,g2);
  g2.f.NP	:= 0;
  g2.f.ymin	:= -1;
  g2.f.ymax	:= +1;
  g2.f.x0	:= -1;
  g2.f.dx	:= 0.02;
  g2.col:= BLUE;

  (* first string *)
  NEW(par);
  par.col	:= BLUE;
  par.x		:=-0.8;			par.y	:= 0.4;
  par.hor	:= Diagrams.left;	par.vert:= Diagrams.bottom;
  COPY ("Parabola", par.string);
  par.font	:= Fonts.Default;
  Display3.StringSize (par.string, par.font, w, h, dsr);
  par.W		:= w;			par.H	:= h;
  par.visible	:= TRUE;
  Diagrams.AddGraphEl (f(Diagrams.Frame), par);

  (* second string *)
  NEW(min);
  min.col	:= BLACK;
  min.x		:= 0.45;		min.y	:=-0.5;
  min.hor	:= Diagrams.right;	min.vert:= Diagrams.top;
  COPY ("Minimum", min.string);
  min.font	:= Fonts.Default;
  Display3.StringSize (min.string, min.font, w, h, dsr);
  min.W		:= w;			min.H	:= h;
  min.visible	:= TRUE;
  Diagrams.AddGraphEl (f(Diagrams.Frame), min);

  (* third string *)
  NEW(max);
  max.col	:= BLACK;
  max.x		:= 0.0;			max.y	:= 0;
  max.hor	:= Diagrams.center;	max.vert:= Diagrams.bottom;
  COPY ("Maximum", max.string);
  max.font	:= Fonts.Default;
  Display3.StringSize (max.string, max.font, w, h, dsr);
  max.W		:= w;			max.H	:= h;
  max.visible	:= TRUE;
  Diagrams.AddGraphEl (f(Diagrams.Frame), max);

  (* first cross *)
  NEW(cross1);
  cross1.col	:= RED;
  cross1.x	:=-0.8;			cross1.y	:=-0.8;
  cross1.hor	:= Diagrams.center;	cross1.vert	:= Diagrams.center;
  cross1.W	:= 15;	  		cross1.H	:= 15;
  cross1.visible	:= TRUE;
  cross1.pat	:= Display.NewPattern (15, 15, pat);
  Diagrams.AddGraphEl (f(Diagrams.Frame), cross1);

  (* second cross *)
  NEW(cross2);
  cross2.col	:= RED;
  cross2.x	:=-0.2;			cross2.y	:=-0.2;
  cross2.hor	:= Diagrams.center;	cross2.vert	:= Diagrams.center;
  cross2.W	:= 15;	  		cross2.H	:= 15;
  cross2.visible	:= TRUE;
  cross2.pat	:= Display.NewPattern (15, 15, pat);
  Diagrams.AddGraphEl (f(Diagrams.Frame), cross2);

  (* display plot *)
  Gadgets.Update (g1);

  (* test Diagrams.PlotPoints *)
  g2.f.NP:= 101;
  g2.f.y[0]:= 1;   x:= -1 + g2.f.dx;
  FOR i:=1 TO g2.f.NP-1 DO
    g2.f.y[i]:= 2*x*x - 1;   x:= x + g2.f.dx;
    Diagrams.PlotPoints (f(Diagrams.Frame), g2, i-1, i);
    Timer.Delay (0.05);
  END;
END Test;

BEGIN
  FOR i:=0 TO 14 DO pat[i]:= {7} END;
  pat[7]:= {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14};
END Diagr.

Place the caret with the left mouse button, then click on the command below
with
the middle mouse button.
 
Diagr.Test
