(*************************************************************************

Name:            Conversion.Mod
Purpose:         number <--> string and other conversions
Version:	 0.3
Predecessor:     0.2
Changes:         RealToStr debugged
Target platform: PC>=386
Compiler:	 Oberon 3
Date:		 July 1995
Author:		 Frank Hrebabetzky

***************************************************************************)

MODULE Conversion;

IMPORT SYSTEM, Out, Math0, MathL0;

VAR
  tenM	: LONGREAL;


PROCEDURE ConvToBits* (VAR data:ARRAY OF SYSTEM.BYTE; VAR str:ARRAY OF CHAR);
VAR ib, id, is: INTEGER; (* data: ...| || | | | | | | | || | | | | | | | || *)
    l, adr    : LONGINT; (*                  ^          ^                   *)
                         (*                ib=5       id=1                  *)
BEGIN			        (* is: string index                                *)
  l:= LEN(str)-1;
  is:= 0;
  FOR id:=SYSTEM.VAL(INTEGER,LEN(data))-1 TO 0 BY -1 DO
    adr:= SYSTEM.ADR(data[id]);
    FOR ib:=7 TO 0 BY -1 DO
      IF is=l THEN
        str[is]:= 0X;
        RETURN;
      END;
      IF SYSTEM.BIT(adr,ib) THEN str[is]:="1" ELSE str[is]:="0";
      END;
      INC(is);
    END;
    IF is<l THEN str[is]:=" ";   INC(is);
    END;
  END;
  str[is]:= 0X;
END ConvToBits;


PROCEDURE ToLongint* (VAR b:ARRAY OF SYSTEM.BYTE): LONGINT;
(* If 8 or 16 bit hardware registers with a '1' as MSB is read into a SHORTINT
   or INTEGER variable, it will have a negative value. With this procedure
such a
   variable can be converted to a nonnegative one.
   Example: a SHORTINT of -1 is represented by the Byte 1111 1111
(1-complement).
   After conversion with ToLongint it becomes 255. *)
BEGIN
  IF LEN(b)=1 THEN
    RETURN ORD(SYSTEM.VAL(CHAR,b[0]))
  ELSIF LEN(b)=2 THEN
    RETURN 256*LONG(ORD(SYSTEM.VAL(CHAR,b[1]))) + ORD(SYSTEM.VAL(CHAR,b[0]))
  END;
END ToLongint;



PROCEDURE RealToStr* (x:LONGREAL; n:INTEGER; VAR s:ARRAY OF CHAR);
(* n is the total number of characters.
   n>0: floating point, else exponential.
   IF s might be smaller than n, in which case it will be filled.
   IF n or s don't allow a reasonable display, then stars will be written to
s.
   BUG: not handled correctly, if rounding of floating point increases nI. *)
VAR neg, exp			: BOOLEAN;
    nI, nP, o, p, pmax, p10, z	: INTEGER;
		(* nI, nP: # of digits before/after decimal point	*)
BEGIN
  o:= ORD("0");
  pmax:= SHORT(LEN(s)) - 1; (* max. s index = space for chars (without 0C) *)
  neg:= x<0;   x:= ABS(x);
  exp:= n<0;   n:= ABS(n);
  (* effective n *)
  n:= Math0.mini (n, pmax);
  (* n reasonable ? *)
  IF (exp & (n<9)) OR (~exp & (n<4)) THEN
    COPY ("****", s);   RETURN;
  END;
  (* sign *)
  IF neg THEN s[0]:="-" ELSE s[0]:=" " END;
  IF exp THEN  (* exponential form *)
    (* mantisse *)
    nP:= n - 8;
    x:= MathL0.round (x, nP+1);
    IF x<10.0*MathL0.eps THEN p10:=0 ELSE
      p10:= SHORT(ENTIER(MathL0.lg(x)+10*MathL0.eps));
    END;
    x:= x * MathL0.exp10(-p10) + 10*MathL0.eps;
    z:= SHORT(ENTIER(x));
    s[1]:= CHR (o + z);
    s[2]:= ".";
    FOR p:=3 TO 2+nP DO
      x:= 10 * (x-z);
      z:= SHORT(ENTIER(x));
      s[p]:= CHR (o + z);
    END;
    (* exponent *)
    s[3+nP]:= "E";
    IF p10<0 THEN s[4+nP]:="-" ELSE s[4+nP]:="+" END;
    p10:= ABS(p10);
    s[5+nP]:= CHR (o + p10 DIV 100);
    p10:= p10 MOD 100;
    s[6+nP]:= CHR (o + p10 DIV 10);
    p10:= p10 MOD 10;
    s[7+nP]:= CHR (o + p10);
    s[8+nP]:= 0X;
  ELSE (* floating point *)
    IF x<1 THEN x:= MathL0.roundp (x, n-3) ELSE x:= MathL0.round (x, n-2) END;
    IF x<tenM THEN nI:=1 ELSE nI:= SHORT(ENTIER(MathL0.lg(x)+10*MathL0.eps))+1
END;
    IF nI>n-3 THEN (* not displayable *)
      COPY ("****", s);   RETURN;
    END;
    nP:= n - 2 - nI;
    x:= x * (MathL0.exp10(1-nI) + 10*MathL0.eps);
    FOR p:=1 TO nI DO
      z:= SHORT(ENTIER(x));
      x:= 10 * (x-z);
      s[p]:= CHR (o + z);
    END;
    s[nI+1]:=".";
    FOR p:=nI+2 TO nI+1+nP DO
      z:= SHORT(ENTIER(x));
      x:= 10 * (x-z);
      s[p]:= CHR (o + z);
    END;
    s[2+nI+nP]:=0X;
  END;
END RealToStr;


PROCEDURE OutReal* (x:LONGREAL; n:INTEGER);
VAR s: ARRAY 32 OF CHAR;
BEGIN
  RealToStr (x, n, s);
  Out.String (s);
END OutReal;



BEGIN
  tenM:= 10.0 - 100*MathL0.eps;
END Conversion.
