TextDocs.NewDoc     XF   CColor     Flat  Locked  Controls  Org [   BIER`   b        3  1   Oberon12.Scn.Fnt          N   Q  (*
Where: Indexer of Symbol files.

Copyright (C) 2001 Grard Meunier

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License  for more details.

You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*)

MODULE Where;
	
	 
	
	(* Structure of the database:
		- an index ("indexPref") with suffixes of identifiers as its keys (strings); its values point to linked lists (of type "ListeId") containing pointers ("id") to the corresponding identifiers stored as data of type "Ident".
		- an indexe ("indexId") with identifiers as keys (strings); "indexId" contains definition occurrences of identifiers; its values point to linked lists (of type "ListeId") containing pointers ("id") to the paths, stored as data of type "Ident", of the files in which the identifiers occur.
	*)
	
	IMPORT
		
		Attributes, B:= BabelCompil, Desktops, Display, Documents, Files, Fonts, Gadgets, Oberon, Objects, Strings, NPTBoxDir, TBoxStrings,
		Texts, A:= TBoxAvl, BA:= TBoxBArbre, OA:= TBoxOBArbre, M:= TBoxMapping, TextGadgets, TextGadgets0;
	
	CONST
		
		viewCode= 2X;
		
		base= "Where.Data";
		memFactor= 300;
		
		compNom= "Where.Tbl";
		
		memNom= "WhereMem.Data";
		
		linkColor= 9;
		
		exported= 1;
	
	TYPE
		
		Directory= POINTER TO RECORD (B. Directory)
			r: Files.Rider;
		END;
		
		Compilation= POINTER TO RECORD (B.Compilation)
			t: Texts.Text;
			r: Texts.Reader;
		END;
		
		CompilMake= POINTER TO RECORD (Compilation)
			indexPref, indexId: BA.Index;
			iG, lG: BA.GesData;
			path: ListeId;
		END;
		
		CompilPos= POINTER TO RECORD (Compilation)
			pos, nouv, len: LONGINT;
			voisSuiv, voisMeme: BOOLEAN;
			id: B.Chaine;
		END;
		
		GesCles= POINTER TO RECORD (BA.GesClesString)
		END;
		
		Ident= BA.String;
		
		IdentFab= BA.StringFab;
		
		ListeId= POINTER TO RECORD (BA.Data)
			next, id: LONGINT;
		END;
		
		ListeIdFab= POINTER TO RECORD (BA.DataFab)
		END;
		
		String= POINTER TO RECORD (A.Elem)
			s: B.Chaine;
		END;
	
	VAR
		
		comp: B.Compiler;
		nbPages, searchTime: LONGINT;
		searchIdent: B.Chaine;
	
	PROCEDURE (d: Directory) ReadInt (VAR i: LONGINT);
		
		BEGIN (*ReadInt*)
			Files.ReadLInt(d.r, i);
		END ReadInt;
	
	PROCEDURE (c: Compilation) Read (VAR ch: CHAR);
		
		BEGIN (*Read*)
			Texts.Read(c.r, ch);
			IF c.r.eot THEN
				ch:= B.eOF1;
			ELSIF ~(c.r.lib IS Fonts.Font) THEN
				ch:= viewCode;
			END;
		END Read;
	
	PROCEDURE (c: Compilation) Pos (): LONGINT;
		
		BEGIN (*Pos*)
			RETURN Texts.Pos(c.r);
		END Pos;
	
	PROCEDURE (c: Compilation) SetPos (pos: LONGINT);
		
		BEGIN (*SetPos*)
			Texts.OpenReader(c.r, c.t, pos);
		END SetPos;
	
	PROCEDURE (s: ListeId) Read (VAR r: BA.Reader);
		
		BEGIN (*Read*)
			s.next:= r.InInt();
			s.id:= r.InInt();
		END Read;
	
	PROCEDURE (s: ListeId) Write (VAR w: BA.Writer);
		
		BEGIN (*Write*)
			w.OutInt(s.next);
			w.OutInt(s.id);
		END Write;
	
	PROCEDURE (f: ListeIdFab) New (ta: LONGINT): BA.Data;
		
		VAR
			
			s: ListeId;
		
		BEGIN (*New*)
			ASSERT(ta= 2* SIZE(LONGINT));
			NEW(s);
			RETURN s;
		END New;
	
	PROCEDURE (c: CompilMake) Execution (fNum, parsNb: LONGINT; pars: B.ObjectsList; VAR o: B.Object; VAR res: B.ANYPTR): BOOLEAN;
		
		CONST
			
			exported= 1;
		
		VAR
			
			n, l, m, p: LONGINT;
			nouv, new: BOOLEAN;
			id1, id2: Ident;
			suff: ListeId;
			d: BA.Data;
		
		BEGIN (*Execution*)
			o:= B.Parameter(pars, 2);
			IF o.ErrorIn() OR (o.ObjFunc()# exported) THEN
				RETURN TRUE;
			END;
			o:= B.Parameter(pars, 1);
			l:= o.ObjStringLen()+ 1;
			NEW(id1);
			NEW(id1.c, l);
			o.ObjString(id1.c^);
			new:= ~c.indexId.RechIns(id1);
			IF new THEN
				n:= BA.bNil;
				nouv:= TRUE;
			ELSE
				n:= c.indexId.LisVal();
				d:= c.lG.LisDon(n);
				nouv:= d(ListeId).id# c.path.id;
			END;
			IF nouv THEN
				c.path.next:= n;
				n:= c.lG.ReserveDon(2* SIZE(LONGINT));
				c.indexId.EcrisVal(n);
				c.lG.EcrisDon(n, c.path);
			END;
			p:= c.iG.ReserveDon(l* SIZE(CHAR));
			c.iG.EcrisDon(p, id1);
			NEW(suff); suff.id:= p;
			NEW(id2);
			NEW(id2.c, l);
			COPY(id1.c^, id2.c^);
			m:= l;
			REPEAT
				IF c.indexPref.RechIns(id2) THEN
					n:= c.indexPref.LisVal()
				ELSE
					n:= BA.bNil;
				END;
				suff.next:= n;
				n:= c.lG.ReserveDon(2* SIZE(LONGINT));
				c.indexPref.EcrisVal(n);
				c.lG.EcrisDon(n, suff);
				TBoxStrings.Extract(id2.c^, 1, MAX(LONGINT), id2.c^);
				DEC(m);
			UNTIL m= 1;
			RETURN TRUE;
		END Execution;
	
	PROCEDURE LettreOuChiffre (c: CHAR): BOOLEAN;
		
		BEGIN (*LettreOuChiffre*)
			RETURN (c>= 'A') & (c<= 'Z') OR (c>= 'a') & (c<= 'z') OR (c>= '0') & (c<= '9') OR (c>= 'A') & (c<= '') OR (c>= 'O') & (c<= '') OR (c>= 'o') & (c<= 'y');
		END LettreOuChiffre;
	
	PROCEDURE CompP (s1, s2: ARRAY OF CHAR): BA.Comp;
		
		VAR
			
			i1, i2: LONGINT;
			c1, c2: CHAR;
		
		BEGIN (*CompP*)
			i1:= 0; i2:= 0;
			REPEAT
				LOOP
					c1:= s1[i1];
					IF c1= 0X THEN
						EXIT;
					END;
					INC(i1);
					IF LettreOuChiffre(c1) THEN
						c1:= Strings.UpperCh(c1);
						EXIT;
					END;
				END;
				LOOP
					c2:= s2[i2];
					IF c2= 0X THEN
						EXIT;
					END;
					INC(i2);
					IF LettreOuChiffre(c2) THEN
						c2:= Strings.UpperCh(c2);
						EXIT;
					END;
				END;
			UNTIL (c1# c2) OR (c1= 0X);
			IF c1< c2 THEN
				RETURN BA.inf;
			ELSIF c1> c2 THEN
				RETURN BA.sup;
			ELSE
				i1:= 0;
				WHILE (s1[i1]= s2[i1]) & (s1[i1]# 0X) DO
					INC(i1);
				END;
				IF s1[i1]< s2[i1] THEN
					RETURN BA.inf;
				ELSIF s1[i1]> s2[i1] THEN
					RETURN BA.sup;
				ELSE
					RETURN BA.ega;
				END;
			END;
		END CompP;
	
	PROCEDURE (g: GesCles) CompP (s1, s2: BA.Data): BA.Comp;
		
		BEGIN (*CompP*)
			RETURN CompP(s1(Ident).c^, s2(Ident).c^);
		END CompP;
	
	PROCEDURE Make*;
		
		VAR
			
			b: BA.BaseDon;
			fab: IdentFab;
			sf: ListeIdFab;
			g: GesCles;
			indexPref, indexId: BA.Index;
			iG, lG: BA.GesData;
			fInf: NPTBoxDir.FileInfo;
			c: CompilMake;
			bool: BOOLEAN;
			n, len: LONGINT;
			id: Ident;
			w: Texts.Writer;
		
		BEGIN (*Make*)
			NEW(g);
			NEW(fab); NEW(sf);
			OA.fab.CreeBase(base, 2);
			b:= OA.fab.OuvreBase(base, nbPages);
			n:= b.IndCree(0);
			b.EcrisPlace(0, n);
			indexPref:= b.IndOuvre(n, g, fab);
			n:= b.IndCree(0);
			b.EcrisPlace(1, n);
			indexId:= b.IndOuvre(n, g, fab);
			iG:= b.GesDataCree(fab);
			lG:= b.GesDataCree(sf);
			Texts.OpenWriter(w);
			fInf:= NPTBoxDir.FileList("*.Mod");
			WHILE fInf# NIL DO
				NEW(c);
				NEW(c.t);
				Texts.Open(c.t, fInf.name);
				Texts.OpenReader(c.r, c.t, 0);
				c.indexPref:= indexPref;
				c.indexId:= indexId;
				c.iG:= iG;
				c.lG:= lG;
				len:= Strings.Length(fInf.name)+ 1;
				NEW(id); NEW(id.c, len);
				COPY(fInf.name, id.c);
				Texts.WriteString(w, fInf.name);
				Texts.Append(Oberon.Log, w.buf);
				n:= iG.ReserveDon(len* SIZE(CHAR));
				iG.EcrisDon(n, id);
				NEW(c.path);
				c.path.id:= n;
				IF ~c.Compile(comp, FALSE) THEN
					Texts.WriteString(w, " Error");
				END;
				Texts.WriteLn(w);
				Texts.Append(Oberon.Log, w.buf);
				fInf:= fInf.next;
			END;
			b.FermeBase;
		END Make;
	
	PROCEDURE (c: CompilPos) Execution (fNum, parsNb: LONGINT; pars: B.ObjectsList; VAR o: B.Object; VAR res: B.ANYPTR): BOOLEAN;
		
		VAR
			
			n, l: LONGINT;
			id: B.Chaine;
		
		BEGIN (*Execution*)
			o:= B.Parameter(pars, 2);
			IF o.ObjFunc()# exported THEN
				RETURN TRUE;
			END;
			o:= B.Parameter(pars, 1);
			n:= o.Position();
			IF ~c.voisSuiv & (n>= c.pos) THEN
				c.StopCompil;
			END;
			l:= o.ObjStringLen();
			IF c.voisMeme THEN
				NEW(id, l+ 1);
				o.ObjString(id^);
				IF id^# c.id^ THEN
					RETURN TRUE;
				END;
			END;
			IF c.voisSuiv THEN
				IF n> c.pos THEN
					c.nouv:= n;
					c.len:= l;
					c.StopCompil;
				END;
			ELSIF n< c.pos THEN
				c.nouv:= n;
				c.len:= l;
			END;
			RETURN TRUE;
		END Execution;
	
	PROCEDURE NextI (doc: Documents.Document; suivant, same: BOOLEAN; VAR ident: ARRAY OF CHAR);
		
		VAR
			
			tF: TextGadgets.Frame;
			c: CompilPos;
			bool: BOOLEAN;
		
		BEGIN (*NextI*)
			IF same THEN
				NEW(searchIdent, Strings.Length(ident)+ 1);
				COPY(ident, searchIdent^);
				searchTime:= Oberon.Time();
			END;
			IF (doc# NIL) & (doc.dsc# NIL) & (doc.dsc IS TextGadgets.Frame) THEN
				NEW(c);
				tF := doc.dsc(TextGadgets.Frame);
				IF tF.car THEN
					c.pos:= tF.carpos.pos;
				ELSIF suivant THEN
					c.pos:= 0;
				ELSE
					c.pos:= MAX(LONGINT);
				END;
				c.t:= tF.text;
				Texts.OpenReader(c.r, c.t, 0);
				c.voisSuiv:= suivant;
				c.voisMeme:= same;
				c.nouv:= 0;
				IF same THEN
					NEW(c.id, Strings.Length(ident)+ 1);
					COPY(ident, c.id^);
				END;
				bool:= c.Compile(comp, TRUE);
				IF c.nouv= 0 THEN
					TextGadgets0.RemoveSelection(tF); TextGadgets0.RemoveCaret(tF);
				ELSE
					Oberon.Defocus;
					DEC(c.nouv);
					IF suivant THEN
						TextGadgets0.Locate(tF, c.nouv+ c.len);
					ELSE
						TextGadgets0.Locate(tF, c.nouv);
					END;
					TextGadgets0.SetSelection(tF, c.nouv, c.nouv+ c.len);
				END;
			END;
		END NextI;
	
	PROCEDURE Next*;
		
		VAR
			
			doc: Documents.Document;
			ident: ARRAY 1 OF CHAR;
		
		BEGIN (*Next*)
			doc:= Documents.MarkedDoc();
			NextI(doc, TRUE, FALSE, ident);
		END Next;
	
	PROCEDURE Previous*;
		
		VAR
			
			doc: Documents.Document;
			ident: ARRAY 1 OF CHAR;
		
		BEGIN (*Previous*)
			doc:= Documents.MarkedDoc();
			NextI(doc, FALSE, FALSE, ident);
		END Previous;
	
	PROCEDURE InitSearch (VAR doc: Documents.Document; VAR ident: B.Chaine);
		
		VAR
			
			beg, end, time, i: LONGINT;
			t: Texts.Text;
			r: Texts.Reader;
		
		BEGIN (*InitSearch*)
			doc:= Documents.MarkedDoc();
			Oberon.GetSelection(t, beg, end, time);
			IF time< searchTime THEN
				ident:= searchIdent;
				RETURN;
			END;
			Texts.OpenReader(r, t, beg);
			NEW(ident, end- beg+ 1);
			FOR i:= 0 TO end- beg- 1 DO
				Texts.Read(r, ident[i]);
			END;
			ident[end- beg]:= 0X;
		END InitSearch;
	
	PROCEDURE NextSame*;
		
		VAR
			
			doc: Documents.Document;
			ident: B.Chaine;
		
		BEGIN (*NextSame*)
			InitSearch(doc, ident);
			IF ident# NIL THEN
				NextI(doc, TRUE, TRUE, ident^);
			END;
		END NextSame;
	
	PROCEDURE PreviousSame*;
		
		VAR
			
			doc: Documents.Document;
			ident: B.Chaine;
		
		BEGIN (*PreviousSame*)
			InitSearch(doc, ident);
			IF ident# NIL THEN
				NextI(doc, FALSE, TRUE, ident^);
			END;
		END PreviousSame;
	
	PROCEDURE Ouvre*;
		
		VAR
			
			s: Texts.Scanner;
			tF: TextGadgets.Frame;
			d: Documents.Document;
			par: Oberon.ParList;
			res: INTEGER;
			w: Texts.Writer;
			m: Oberon.CaretMsg;
		
		BEGIN (*Ouvre*)
			Texts.OpenScanner(s, Oberon.Par.text, Oberon.Par.pos);
			Texts.Scan(s);
			ASSERT(s.class= Texts.Name, 100);
			d:= Documents.Open(s.s);
			IF (d# NIL) & (d.dsc# NIL) & (d.dsc IS TextGadgets0.Frame) THEN
				Texts.Scan(s);
				ASSERT(s.class= Texts.Name, 101);
				Desktops.ShowDoc(d);
				tF := d.dsc(TextGadgets.Frame);
				TextGadgets0.RemoveSelection(tF); TextGadgets0.RemoveCaret(tF);
				NextI(d, TRUE, TRUE, s.s);
				m.F:= tF; m.id:= Oberon.get; Display.Broadcast(m);
				ASSERT(m.car= tF);
				NEW(par);
				par.vwr:= NIL; par.frame:= NIL; par.obj:= NIL;
				Texts.New; par.text:= Objects.NewObj(Texts.Text);
				Texts.OpenWriter(w);
				Texts.WriteString(w, "set ");
				Texts.WriteInt(w, m.x+ tF.X+ tF.W DIV 2, 0);
				Texts.Write(w, ' ');
				Texts.WriteInt(w, m.y+ tF.Y+ tF.H DIV 2, 0);
				Texts.Append(par.text, w.buf);
				par.pos:= 0;
				Oberon.Call("Configuration.Marker", par, FALSE, res);
				ASSERT(res= 0);
			END;
		END Ouvre;
	
	PROCEDURE TrouveI (name: ARRAY OF CHAR);
		
		VAR
			
			b: BA.BaseDon;
			fab: IdentFab;
			sf: ListeIdFab;
			id: Ident;
			s: String;
			e: A.Elem;
			t: A.Tree;
			text: Texts.Text;
			g: GesCles;
			iG, lG: BA.GesData;
			w: Texts.Writer;
			indexId: BA.Index;
			bool: BOOLEAN;
			paths: ListeId;
			d: BA.Data;
			n: LONGINT;
			col: SHORTINT;
			str: B.Chaine;
			o: Objects.Object;
		
		BEGIN (*TrouveI*)
			IF name# "" THEN
				Texts.New;
				text:= Objects.NewObj(Texts.Text);
				Texts.OpenWriter(w);
				Texts.WriteString(w, name); Texts.WriteString(w, ' :'); Texts.WriteLn(w);
				NEW(g);
				NEW(fab);
				b:= OA.fab.OuvreBase(base, nbPages);
				NEW(id); NEW(id.c, Strings.Length(name)+ 1);
				COPY(name, id.c^);
				A.New(t);
				NEW(sf);
				iG:= b.GesDataCree(fab);
				lG:= b.GesDataCree(sf);
				n:= b.LisPlace(1);
				indexId:= b.IndOuvre(n, g, fab);
				IF indexId.Cherche(id) THEN
					n:= indexId.LisVal();
					WHILE n# BA.bNil DO
						d:= lG.LisDon(n);
						paths:= d(ListeId);
						d:= iG.LisDon(paths.id);
						id:= d(Ident);
						NEW(s); NEW(s.s, Strings.Length(id.c^)+ 1);
						COPY(id.c, s.s);
						e:= s;
						bool:= t.SearchIns(e, n);
						n:= paths.next;
					END;
				END;
				n:= Strings.Length(name)+ 14;
				col:= w.col;
				e:= t.Next(NIL);
				WHILE e# NIL DO
					s:= e(String);
					Texts.SetColor(w, linkColor);
					Texts.WriteString(w, s.s^);
					Texts.SetColor(w, col);
					NEW(str, Strings.Length(s.s^)+ n);
					COPY('Where.Ouvre ', str^);
					Strings.Append(str^, s.s^);
					Strings.Append(str^, " ");
					Strings.Append(str^, name);
					o:= Gadgets.CreateObject("TextGadgets.NewControl");
					Attributes.SetString(o, "Cmd", str^);
					Texts.WriteObj(w, o);
					Texts.WriteLn(w);
					e:= t.Next(e);
				END;
				b.FermeBase;
				Texts.Append(text, w.buf);
				Oberon.OpenText("Find", text, 500, 400);
			END;
		END TrouveI;
	
	PROCEDURE Find*;
		
		VAR
			
			s: Texts.Scanner;
			r: Texts.Reader;
			t: Texts.Text;
			beg, end, time, i: LONGINT;
			ch: CHAR;
		
		BEGIN (*Find*)
			Texts.OpenScanner(s, Oberon.Par.text, Oberon.Par.pos);
			Texts.Scan(s);
			IF (s.class = Texts.Char) & (s.c = "^") THEN
				Oberon.GetSelection(t, beg, end, time);
				IF time>= 0 THEN
					Texts.OpenReader(r, t, beg);
					i:= 0;
					REPEAT
						Texts.Read(r, ch);
						s.s[i]:= ch;
						INC(i); INC(beg);
					UNTIL (beg= end) OR (i= LEN(s.s)- 1);
					s.s[i]:= 0X;
					s.class:= Texts.Name
				END
			END;
			IF s.class= Texts.Name THEN
				TrouveI(s.s);
			END;
		END Find;
	
	PROCEDURE (s1: String) Compare (s2: A.Elem): SHORTINT;
		
		VAR
			
			i1, i2, l1, l2: LONGINT;
			c1, c2: CHAR;
		
		BEGIN (*Compare*)
			WITH s2: String DO
				i1:= 0; i2:= 0; l1:= Strings.Length(s1.s^); l2:= Strings.Length(s2.s^);
				REPEAT
					LOOP
						IF i1>= l1 THEN
							c1:= 0X;
							EXIT;
						END;
						c1:= s1.s[i1];
						INC(i1);
						IF LettreOuChiffre(c1) THEN
							c1:= Strings.UpperCh(c1);
							EXIT;
						END;
					END;
					LOOP
						IF i2>= l2 THEN
							c2:= 0X;
							EXIT;
						END;
						c2:= s2.s[i2];
						INC(i2);
						IF LettreOuChiffre(c2) THEN
							c2:= Strings.UpperCh(c2);
							EXIT;
						END;
					END;
				UNTIL (c1# c2) OR (c1= 0X);
				IF c1< c2 THEN
					RETURN A.inf;
				ELSIF c1> c2 THEN
					RETURN A.sup;
				ELSE
					i1:= 0; i2:= 0;
					REPEAT
						IF i1>= l1 THEN
							c1:= 0X;
						ELSE
							c1:= s1.s[i1];
							INC(i1);
						END;
						IF i2>= l2 THEN
							c2:= 0X;
						ELSE
							c2:= s2.s[i2];
							INC(i2);
						END;
					UNTIL (c1# c2) OR (c1= 0X);
					IF c1< c2 THEN
						RETURN A.inf;
					ELSIF c1> c2 THEN
						RETURN A.sup;
					ELSE
						RETURN A.ega;
					END;
				END;
			END;
		END Compare;
	
	PROCEDURE ListeI (name: ARRAY OF CHAR; strict: BOOLEAN);
		
		VAR
			
			b: BA.BaseDon;
			fab: IdentFab;
			sf: ListeIdFab;
			n: LONGINT;
			s: String;
			e: A.Elem;
			bool: BOOLEAN;
			t: A.Tree;
			id: Ident;
			suff: ListeId;
			text: Texts.Text;
			f: Texts.Writer;
			g: GesCles;
			indexPref: BA.Index;
			iG, lG: BA.GesData;
			d: BA.Data;
			col: SHORTINT;
			str: B.Chaine;
			o: Objects.Object;
		
		PROCEDURE Prefixe (a, b: ARRAY OF CHAR; strict: BOOLEAN): BOOLEAN;
			
			VAR
				
				c1, c2: CHAR;
				i1, i2, n1, n2: LONGINT;
			
			BEGIN (*Prefixe*)
				i1:= 0; i2:= 0; n1:= Strings.Length(a); n2:= Strings.Length(b);
				REPEAT
					LOOP
						IF i1>= n1 THEN
							c1:= 0X;
							EXIT;
						END;
						c1:= a[i1];
						INC(i1);
						IF strict THEN
							EXIT;
						ELSIF LettreOuChiffre(c1) THEN
							c1:= Strings.UpperCh(c1);
							EXIT;
						END;
					END;
					LOOP
						IF i2>= n2 THEN
							c2:= 0X;
							EXIT;
						END;
						c2:= b[i2];
						INC(i2);
						IF strict THEN
							EXIT;
						ELSIF LettreOuChiffre(c2) THEN
							c2:= Strings.UpperCh(c2);
							EXIT;
						END;
					END;
				UNTIL (c1# c2) OR (c1= 0X);
				RETURN c1= 0X;
			END Prefixe;
		
		BEGIN (*ListeI*)
			Texts.New;
			text:= Objects.NewObj(Texts.Text);
			Texts.OpenWriter(f);
			Texts.WriteString(f, name); Texts.WriteString(f, ' :'); Texts.WriteLn(f);
			IF name# "" THEN
				NEW(g);
				NEW(fab); NEW(sf);
				A.New(t);
				b:= OA.fab.OuvreBase(base, nbPages);
				n:= b.LisPlace(0);
				indexPref:= b.IndOuvre(n, g, fab);
				iG:= b.GesDataCree(fab);
				lG:= b.GesDataCree(sf);
				NEW(id); NEW(id.c, Strings.Length(name)+ 1);
				IF strict THEN
					COPY(name, id.c^);
				ELSE
					Strings.Upper(name, id.c^);
				END;
				bool:= indexPref.Cherche(id);
				LOOP
					IF ~indexPref.YACour() THEN
						EXIT;
					END;
					d:= indexPref.CleCour();
					id:= d(Ident);
					IF ~Prefixe(name, id.c^, FALSE) THEN
						EXIT;
					END;
					IF ~strict OR Prefixe(name, id.c^, TRUE) THEN
						n:= indexPref.LisVal();
						WHILE n# BA.bNil DO
							d:= lG.LisDon(n);
							suff:= d(ListeId);
							d:= iG.LisDon(suff.id);
							id:= d(Ident);
							NEW(s); NEW(s.s, Strings.Length(id.c^)+ 1);
							COPY(id.c^, s.s^);
							e:= s;
							bool:= t.SearchIns(e, n);
							n:= suff.next;
						END;
					END;
					indexPref.Suivant;
				END;
				b.FermeBase;
				col:= f.col;
				e:= t.Next(NIL);
				WHILE e# NIL DO
					s:= e(String);
					Texts.SetColor(f, linkColor);
					Texts.WriteString(f, s.s^);
					Texts.SetColor(f, col);
					NEW(str, Strings.Length(s.s^)+ 14);
					COPY('Where.Find ', str^);
					Strings.Append(str^, s.s^);
					o:= Gadgets.CreateObject("TextGadgets.NewControl");
					Attributes.SetString(o, "Cmd", str^);
					Texts.WriteObj(f, o);
					Texts.WriteLn(f);
					e:= t.Next(e);
				END;
				Texts.Append(text, f.buf);
				Oberon.OpenText("Find", text, 500, 400);
			END;
		END ListeI;
	
	PROCEDURE Liste (strict: BOOLEAN);
		
		VAR
			
			s: Texts.Scanner;
			r: Texts.Reader;
			t: Texts.Text;
			beg, end, time, i: LONGINT;
			ch: CHAR;
		
		BEGIN (*Liste*)
			Texts.OpenScanner(s, Oberon.Par.text, Oberon.Par.pos);
			Texts.Scan(s);
			IF (s.class = Texts.Char) & (s.c = "^") THEN
				Oberon.GetSelection(t, beg, end, time);
				IF time>= 0 THEN
					Texts.OpenReader(r, t, beg);
					i:= 0;
					REPEAT
						Texts.Read(r, ch);
						s.s[i]:= ch;
						INC(i); INC(beg);
					UNTIL (beg= end) OR (i= LEN(s.s)- 1);
					s.s[i]:= 0X;
					s.class:= Texts.Name
				END
			END;
			IF s.class= Texts.Name THEN
				ListeI(s.s, strict);
			END;
		END Liste;
	
	PROCEDURE ListStrict*;
		
		BEGIN (*ListStrict*)
			Liste(TRUE);
		END ListStrict;
	
	PROCEDURE ListBroad*;
		
		BEGIN (*ListBroad*)
			Liste(FALSE);
		END ListBroad;
	
	PROCEDURE Init;
		
		VAR
			
			b: BA.BaseDon;
			f: Files.File;
			t: Texts.Text;
			s: Texts.Scanner;
			d: Directory;
		
		BEGIN (*Init*)
			searchIdent:= NIL;
			f:= Files.Old(compNom);
			ASSERT(f# NIL, 21);
			NEW(d);
			Files.Set(d.r, f, 0);
			comp:= d.ReadCompiler();
			NEW(t);
			Texts.Open(t, memNom);
			Texts.OpenScanner(s, t, 0);
			Texts.Scan(s);
			ASSERT((s.class= Texts.Int) & (s.i> 0), 24);
			nbPages:= s.i DIV memFactor;
			OA.fab.FermeBase(base);
			b:= OA.fab.OuvreBase(base, nbPages);
			IF b= NIL THEN
				Make;
			ELSE
				b.FermeBase;
			END;
		END Init;
	
	(*
	PROCEDURE (c: CompilMake) Error (pos, line, col: LONGINT; msg: ARRAY OF CHAR);
		
		VAR
			
			w: Texts.Writer;
		
		BEGIN (*Error*)
			Texts.OpenWriter(w);
			Texts.Write(w, 9X); Texts.WriteInt(w, pos- 1, 0); Texts.WriteString(w, " Erreur."); Texts.WriteLn(w);
			Texts.Write(w, 9X); Texts.WriteString(w, msg); Texts.WriteLn(w);
			Texts.Append(Oberon.Log, w.buf);
		END Error;
	
	PROCEDURE (co: CompilMake) Map (index: ARRAY OF CHAR): B.Chaine;
		
		CONST
			
			base= "#Babel:";
		
		VAR
			
			c: B.Chaine;
			ch: M.Chaine;
		
		BEGIN (*Map*)
			NEW(c, Strings.Length(index)+ 8);
			COPY(base, c^);
			Strings.Append(c^, index);
			ch:= M.Map(c^, "", "", "");
			NEW(c, Strings.Length(ch^)+ 1);
			COPY(ch^, c^);
			RETURN c;
		END Map;
	*)
	
	BEGIN (*Where*)
		Init;
	END Where.

Where.ListBroad ^
Where.ListStrict ^
Where.Find ^
Where.Next
Where.Previous
Where.NextSame
Where.PreviousSame

!Where.MakeBIERR  R   R    :       g 
     C  Oberon10.Scn.Fnt 06.06.02  00:49:23  TimeStamps.New  