/* PLATFORM for Code Warrior */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <SIOUX.h>

# ifdef THINK_C
# include <console.h>
# endif

# define main(x,y) MAIN(x,y)

extern int main(int argc, char ** argv);

extern void SetSIOUXBufferMode(short bufferMode);

#define	MAX_ARGS					 50

#ifndef	true
#define	true						  1
#define false						  0
#endif

static	int			argc			= 1;		/* final argument count  */
static	char		*argv[MAX_ARGS]	= { "" };	/* array of pointers	 */
static	char		command[256];				/* input line buffer	 */
static	int			filename 		= false;	/* TRUE iff file name	 */

void punt(void);
void openfile(FILE *file, char *mode);

/*************************************************************************
 *																		 *
 *  Local routine to make a "beep" and exit to the shell.				 *
 *																		 *
 *************************************************************************/

static void punt(void)
	{
	SysBeep( 5L );
	ExitToShell();
	}


/*************************************************************************
 *																		 *
 *  Local routine to open a file in argv[--argc] after closing its		 *
 *  previous existence.													 *
 *																		 *
 *************************************************************************/


void openfile( FILE *file, char *mode)
	{

	if ( (file = freopen( argv[--argc], mode, file ) ) == NULL)
		punt();
	filename = false;
	}


/*************************************************************************
 *																		 *
 *  New main routine.  Prompts for command line then calls user's main   *
 *  now called "MAIN" with the argument list and redirected I/O.		 *
 *																		 *
 *************************************************************************/

void (main)(void)
	{
	char			c;							/* temp for EOLN check	 */
	register char	*cp;						/* index in command line */
	char			*mode;						/* local file mode		 */
	FILE			*file;						/* file to change		 */

	SetSIOUXBufferMode(	SIOUXFullBuffering );	//	Use full buffering

	puts(	"PD M4 Macro Processor");
	puts(	"Enter: infile > outfile");

	gets( command );							/* allow user to edit	 */
	cp = &command[0];							/* start of buffer		 */
	argv[0] = "pdm4";							/* program name is M4  */
	while (argc < MAX_ARGS)
		{ /* up to MAX_ARGS entries */
		while (isspace( *cp++ )) ;
		if ( !*--cp )
			break;
		else if ( *cp == '<' )
			{ /* redirect stdin */
			cp++;
			file = stdin;
			mode = "r";
			filename = true;
			}
		else if ( *cp == '>' )
			{
			mode = "w";
			filename = true;
			if (*++cp == '>')
				{
				mode = "a";
				cp++;
				}
			file = stdout;
			}
		else
			{ /* either an argument or a filename */
			argv[argc++] = cp;
			while ( *++cp && !isspace( *cp ) ) ;
			c = *cp;
			*cp++ = '\0';
			if (filename)
				openfile( file, mode );
			if (!c)
				break;
			}
		}
	if (main( argc, argv ) == EXIT_SUCCESS)
		fflush(NULL);
	else
		{
		puts("Failed.");
		puts("Press Return.");
		gets( command );
		}
	ExitToShell();
	}
