package jacob.tool;

import java.util.*;
import java.awt.*;
import java.io.*;

import ccl.util.*;
import ccl.awt.AWTUtil;

import jacob.*;

/**
 * A tool that uses unzip to show the content of an archive of
 * the classpath. In order to use this tool, info zip's unzip
 * binary must be located somewhere in your PATH environment.
 *
 * @author  <a href="http://mats.gmd.de/clemens/">Chr. Clemens Lahme</a> (<a href="mailto:clemens.lahme@mailexcite.com"><i>Clemens.Lahme@mailexcite.com</i></a>)
 * @version $Id: ListArchive.java,v 1.2 1998/06/01 19:47:48 clemens Exp clemens $
 * @see JavancssAll
 */
public class ListArchive implements JacobRunnable {
	protected JacobInterface _pJacobInterface = null;

	public ListArchive() {
		super();
	}

	public void set(JacobInterface pJacobInterface_) {
		Util.panicIf(pJacobInterface_ == null);
		_pJacobInterface = pJacobInterface_;
	}

	public void run() {
		
		// extract archives out of the classpath
		String sClasspath = Package.getClassPath();

		Vector vPaths = Util.stringToLines
				 (sClasspath, File.pathSeparatorChar);
		Predicate pFilter = new Predicate() {
			public boolean test(Object pObject_) {
				return(Util.endsWith((String)pObject_, ".zip") ||
						 Util.endsWith((String)pObject_, ".jar"));
			}
		};
		Vector vArchives = Util.filter(vPaths, pFilter);

		// Let User select which one to view or cancel
		Frame frmMain = _pJacobInterface.getMainFrame();
		if (vArchives.size() < 1) {
			AWTUtil.showMessage(frmMain, "There are no archive files in the classpath!");
			frmMain.requestFocus();
			_pJacobInterface.stopped(this);

			return;
		}

		String sArchive = AWTUtil.inputListCancel("Please select an archive for which you want the content to get listed!",
																vArchives);
		frmMain.requestFocus();
		if (Util.isEmpty(sArchive)) {
			_pJacobInterface.stopped(this);

			return;
		}

		
		// create absolute file name
		// maybe not necessary

		// system unzip -l
		String sOutputFile = FileUtil.concatPath
				 (_pJacobInterface.getInit().getApplicationPath(),
				  "ListArchive.txt");
		StringBuffer sbList = new StringBuffer();
		try {
			Vector vArgs = new Vector();
			vArgs.addElement("unzip");
			vArgs.addElement("-l");
			vArgs.addElement(sArchive);
			Process pProcess = Util.system(vArgs);
			BufferedReader pBufferedReader = new BufferedReader
					 (new InputStreamReader
					  (pProcess.getInputStream()));
			String s = null;
			while ((s = pBufferedReader.readLine()) != null) {
				sbList.append(s).append('\n');
			}
			FileUtil.writeFile(sOutputFile, sbList.toString());
		} catch(Exception e) {
			Util.debug("ListArchive.run().e: " + e);
		}
		
		// editFile
		_pJacobInterface.getEditor().editFile(sOutputFile);

		_pJacobInterface.stopped(this);
	}

	public String toString() {
		String sRetVal = getClass().getName();
		sRetVal = sRetVal.substring(sRetVal.lastIndexOf('.') + 1);

		return sRetVal;
	}
}
